/*
 * Decompiled with CFR 0.152.
 */
package com.extendedclip.deluxemenus.persistentmeta;

import com.extendedclip.deluxemenus.DeluxeMenus;
import com.extendedclip.deluxemenus.persistentmeta.DataAction;
import com.extendedclip.deluxemenus.persistentmeta.DataType;
import com.extendedclip.deluxemenus.utils.DebugLevel;
import com.extendedclip.deluxemenus.utils.Pair;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Longs;
import java.util.Map;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PersistentMetaHandler {
    private final DeluxeMenus plugin;

    public PersistentMetaHandler(@NotNull DeluxeMenus plugin) {
        this.plugin = plugin;
    }

    public boolean hasMetaValue(@NotNull Player player, @NotNull NamespacedKey key) {
        return DataType.getSupportedTypes().stream().distinct().anyMatch(type -> this.hasMetaValue(player, key, (DataType<?, ?>)type));
    }

    public boolean hasMetaValue(@NotNull Player player, @NotNull NamespacedKey key, @NotNull DataType<?, ?> type) {
        return player.getPersistentDataContainer().has(key, type.getPDType()) && type.isSupported(player.getPersistentDataContainer().get(key, type.getPDType()));
    }

    @Nullable
    public <T> T getMetaValue(@NotNull Player player, @NotNull NamespacedKey key, @NotNull DataType<?, T> type) {
        if (!player.getPersistentDataContainer().has(key, type.getPDType())) {
            return null;
        }
        Object value = player.getPersistentDataContainer().get(key, type.getPDType());
        if (value == null || !type.isSupported(value)) {
            return null;
        }
        return (T)value;
    }

    @NotNull
    public <T> T getMetaValueOrDefault(@NotNull Player player, @NotNull NamespacedKey key, @NotNull DataType<?, T> type, @NotNull T defaultValue) {
        T value = this.getMetaValue(player, key, type);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public <T> Map<String, T> getMetaValues(@NotNull Player player, @NotNull DataType<?, T> type) {
        return player.getPersistentDataContainer().getKeys().stream().filter(key -> player.getPersistentDataContainer().has(key, type.getPDType())).map(key -> Pair.of(key.toString(), player.getPersistentDataContainer().get(key, type.getPDType()))).filter(entry -> entry.getValue() != null).filter(entry -> type.isSupported(entry.getValue())).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    }

    @NotNull
    public OperationResult setMetaValue(@NotNull Player player, @NotNull NamespacedKey key, @NotNull DataType type, @NotNull Object value) {
        if (!type.isSupported(value)) {
            return OperationResult.NEW_VALUE_IS_DIFFERENT_TYPE;
        }
        if (!(!player.getPersistentDataContainer().has(key) || player.getPersistentDataContainer().has(key, type.getPDType()) && type.isSupported(player.getPersistentDataContainer().get(key, type.getPDType())))) {
            return OperationResult.EXISTENT_VALUE_IS_DIFFERENT_TYPE;
        }
        player.getPersistentDataContainer().set(key, type.getPDType(), value);
        return OperationResult.SUCCESS;
    }

    @NotNull
    public OperationResult removeMetaValue(@NotNull Player player, @NotNull NamespacedKey key, @NotNull DataType<?, ?> type) {
        if (!(!player.getPersistentDataContainer().has(key) || player.getPersistentDataContainer().has(key, type.getPDType()) && type.isSupported(player.getPersistentDataContainer().get(key, type.getPDType())))) {
            return OperationResult.EXISTENT_VALUE_IS_DIFFERENT_TYPE;
        }
        if (!player.getPersistentDataContainer().has(key, type.getPDType())) {
            return OperationResult.VALUE_NOT_FOUND;
        }
        player.getPersistentDataContainer().remove(key);
        return OperationResult.SUCCESS;
    }

    @NotNull
    public OperationResult removeMetaValue(@NotNull Player player, @NotNull NamespacedKey key) {
        if (!player.getPersistentDataContainer().has(key)) {
            return OperationResult.VALUE_NOT_FOUND;
        }
        player.getPersistentDataContainer().remove(key);
        return OperationResult.SUCCESS;
    }

    @NotNull
    public OperationResult switchMetaValue(@NotNull Player player, @NotNull NamespacedKey key) {
        if (player.getPersistentDataContainer().has(key) && !player.getPersistentDataContainer().has(key, DataType.BOOLEAN.getPDType())) {
            return OperationResult.EXISTENT_VALUE_IS_DIFFERENT_TYPE;
        }
        String currentValue = (String)player.getPersistentDataContainer().getOrDefault(key, DataType.BOOLEAN.getPDType(), (Object)"false");
        if (!DataType.BOOLEAN.isSupported(currentValue)) {
            return OperationResult.EXISTENT_VALUE_IS_DIFFERENT_TYPE;
        }
        player.getPersistentDataContainer().set(key, DataType.BOOLEAN.getPDType(), (Object)(currentValue.equalsIgnoreCase("true") ? "false" : "true"));
        return OperationResult.SUCCESS;
    }

    @NotNull
    public OperationResult addMetaValue(@NotNull Player player, @NotNull NamespacedKey key, @NotNull DataType type, @NotNull Number value) {
        if (type != DataType.DOUBLE && type != DataType.LONG && type != DataType.INTEGER) {
            return OperationResult.INVALID_TYPE;
        }
        if (!(!player.getPersistentDataContainer().has(key) || player.getPersistentDataContainer().has(key, type.getPDType()) && type.isSupported(player.getPersistentDataContainer().get(key, type.getPDType())))) {
            return OperationResult.EXISTENT_VALUE_IS_DIFFERENT_TYPE;
        }
        Object currentValue = player.getPersistentDataContainer().get(key, type.getPDType());
        if (type == DataType.DOUBLE) {
            double newValue = (Double)(currentValue == null ? Double.valueOf(0.0) : currentValue) + value.doubleValue();
            player.getPersistentDataContainer().set(key, type.getPDType(), (Object)newValue);
            return OperationResult.SUCCESS;
        }
        long newValue = ((Number)(currentValue == null ? Integer.valueOf(0) : currentValue)).longValue() + value.longValue();
        player.getPersistentDataContainer().set(key, type.getPDType(), (Object)newValue);
        return OperationResult.SUCCESS;
    }

    @NotNull
    public OperationResult subtractMetaValue(@NotNull Player player, @NotNull NamespacedKey key, @NotNull DataType type, @NotNull Number value) {
        if (type != DataType.DOUBLE && type != DataType.LONG && type != DataType.INTEGER) {
            return OperationResult.INVALID_TYPE;
        }
        if (!(!player.getPersistentDataContainer().has(key) || player.getPersistentDataContainer().has(key, type.getPDType()) && type.isSupported(player.getPersistentDataContainer().get(key, type.getPDType())))) {
            return OperationResult.EXISTENT_VALUE_IS_DIFFERENT_TYPE;
        }
        Object currentValue = player.getPersistentDataContainer().get(key, type.getPDType());
        if (type == DataType.DOUBLE) {
            double newValue = (Double)(currentValue == null ? Double.valueOf(0.0) : currentValue) - value.doubleValue();
            player.getPersistentDataContainer().set(key, type.getPDType(), (Object)newValue);
            return OperationResult.SUCCESS;
        }
        long newValue = ((Number)(currentValue == null ? Integer.valueOf(0) : currentValue)).longValue() - value.longValue();
        player.getPersistentDataContainer().set(key, type.getPDType(), (Object)newValue);
        return OperationResult.SUCCESS;
    }

    @NotNull
    public OperationResult parseAndExecuteMetaActionFromString(@NotNull Player player, @NotNull String input) {
        String[] args = input.split(" ", 4);
        if (args.length < 2) {
            return OperationResult.INVALID_SYNTAX;
        }
        DataAction action = DataAction.getActionByName(args[0]);
        if (action == null) {
            return OperationResult.INVALID_SYNTAX;
        }
        NamespacedKey key = this.getKey(args[1]);
        if (key == null) {
            return OperationResult.INVALID_SYNTAX;
        }
        if (action == DataAction.SWITCH) {
            return this.switchMetaValue(player, key);
        }
        if (args.length < 3) {
            return OperationResult.INVALID_SYNTAX;
        }
        DataType<?, ?> type = DataType.getSupportedTypeByName(args[2]);
        if (type == null) {
            return OperationResult.INVALID_SYNTAX;
        }
        Object parsedValue = this.parseValueByType(type, args.length >= 4 ? args[3] : null);
        switch (action) {
            case SET: {
                if (parsedValue == null) {
                    return OperationResult.NEW_VALUE_IS_DIFFERENT_TYPE;
                }
                return this.setMetaValue(player, key, type, parsedValue);
            }
            case REMOVE: {
                return this.removeMetaValue(player, key, type);
            }
            case ADD: {
                if (!(parsedValue instanceof Number)) {
                    return OperationResult.NEW_VALUE_IS_DIFFERENT_TYPE;
                }
                return this.addMetaValue(player, key, type, (Number)parsedValue);
            }
            case SUBTRACT: {
                if (!(parsedValue instanceof Number)) {
                    return OperationResult.NEW_VALUE_IS_DIFFERENT_TYPE;
                }
                return this.subtractMetaValue(player, key, type, (Number)parsedValue);
            }
        }
        return OperationResult.INVALID_SYNTAX;
    }

    @Nullable
    public Object parseValueByType(@NotNull DataType<?, ?> type, @Nullable String value) {
        if (value == null) {
            return null;
        }
        if (type == DataType.BOOLEAN) {
            if (!value.equalsIgnoreCase("true") && !value.equalsIgnoreCase("false")) {
                return null;
            }
            return value;
        }
        if (type == DataType.STRING) {
            return value;
        }
        if (type == DataType.DOUBLE) {
            return Doubles.tryParse((String)value);
        }
        if (type == DataType.LONG || type == DataType.INTEGER) {
            return Longs.tryParse((String)value);
        }
        return null;
    }

    @Nullable
    public NamespacedKey getKey(@NotNull String key) {
        NamespacedKey namespacedKey;
        try {
            if (key.contains(":")) {
                String[] split = key.split(":", 2);
                namespacedKey = new NamespacedKey(split[0], split[1]);
            } else {
                namespacedKey = new NamespacedKey((Plugin)this.plugin, key);
            }
        }
        catch (IllegalArgumentException e) {
            this.plugin.debug(DebugLevel.HIGHEST, Level.WARNING, "Failed to parse meta key with value: '" + key + "'. Reason: " + e.getMessage());
            return null;
        }
        return namespacedKey;
    }

    public static enum OperationResult {
        SUCCESS,
        INVALID_SYNTAX,
        INVALID_TYPE,
        VALUE_NOT_FOUND,
        EXISTENT_VALUE_IS_DIFFERENT_TYPE,
        NEW_VALUE_IS_DIFFERENT_TYPE;

    }
}

