/*
 * Decompiled with CFR 0.152.
 */
package com.extendedclip.deluxemenus.requirement;

import com.extendedclip.deluxemenus.DeluxeMenus;
import com.extendedclip.deluxemenus.menu.MenuHolder;
import com.extendedclip.deluxemenus.requirement.Requirement;
import com.extendedclip.deluxemenus.utils.ExpUtils;
import org.jetbrains.annotations.NotNull;

public class HasExpRequirement
extends Requirement {
    private final DeluxeMenus plugin;
    private final boolean invert;
    private final boolean level;
    private final String amt;

    public HasExpRequirement(@NotNull DeluxeMenus plugin, String amt, boolean invert, boolean level) {
        this.plugin = plugin;
        this.amt = amt;
        this.invert = invert;
        this.level = level;
    }

    @Override
    public boolean evaluate(MenuHolder holder) {
        int amount;
        int has = this.level ? holder.getViewer().getLevel() : ExpUtils.getTotalExperience(holder.getViewer());
        try {
            amount = Integer.parseInt(holder.setPlaceholdersAndArguments(this.amt));
        }
        catch (Exception exception) {
            this.plugin.printStacktrace("Invalid amount found for has exp requirement: " + holder.setPlaceholdersAndArguments(this.amt), exception);
            return false;
        }
        if (has < amount) {
            return this.invert;
        }
        return !this.invert;
    }
}

