/*
 * Decompiled with CFR 0.152.
 */
package com.extendedclip.deluxemenus.requirement;

import com.extendedclip.deluxemenus.DeluxeMenus;
import com.extendedclip.deluxemenus.menu.MenuHolder;
import com.extendedclip.deluxemenus.persistentmeta.DataType;
import com.extendedclip.deluxemenus.requirement.Requirement;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class HasMetaRequirement
extends Requirement {
    private final DeluxeMenus plugin;
    private final String key;
    private final String value;
    private final String typeName;
    private final boolean invert;

    public HasMetaRequirement(@NotNull DeluxeMenus plugin, String key, String typeName, String value, boolean invert) {
        this.plugin = plugin;
        this.key = key;
        this.typeName = typeName.toUpperCase();
        this.value = value;
        this.invert = invert;
    }

    @Override
    public boolean evaluate(MenuHolder holder) {
        Player player = holder.getViewer();
        if (player == null) {
            return false;
        }
        String parsedKey = holder.setPlaceholdersAndArguments(this.key);
        NamespacedKey namespacedKey = this.plugin.getPersistentMetaHandler().getKey(parsedKey);
        if (namespacedKey == null) {
            return this.invert;
        }
        DataType<?, ?> type = DataType.getSupportedTypeByName(this.typeName);
        if (type == null) {
            return this.invert;
        }
        Object metaValue = this.plugin.getPersistentMetaHandler().getMetaValue(player, namespacedKey, type);
        if (metaValue == null) {
            return this.invert;
        }
        String expectedValue = holder.setPlaceholdersAndArguments(this.value);
        String actualValue = holder.setPlaceholdersAndArguments(String.valueOf(metaValue));
        if (type.equals(DataType.STRING) || type.equals(DataType.BOOLEAN)) {
            return this.invert != actualValue.equalsIgnoreCase(expectedValue);
        }
        if (type.equals(DataType.LONG) || type.equals(DataType.INTEGER)) {
            try {
                long metaNum = Long.parseLong(actualValue);
                long toCheck = Long.parseLong(expectedValue);
                boolean pass = metaNum >= toCheck;
                return this.invert != pass;
            }
            catch (Exception ex) {
                return this.invert;
            }
        }
        if (type.equals(DataType.DOUBLE)) {
            try {
                double metaNum = Double.parseDouble(actualValue);
                double toCheck = Double.parseDouble(expectedValue);
                boolean pass = metaNum >= toCheck;
                return this.invert != pass;
            }
            catch (Exception ex) {
                return this.invert;
            }
        }
        return this.invert;
    }
}

