/*
 * Decompiled with CFR 0.152.
 */
package com.extendedclip.deluxemenus.requirement;

import com.extendedclip.deluxemenus.DeluxeMenus;
import com.extendedclip.deluxemenus.menu.MenuHolder;
import com.extendedclip.deluxemenus.requirement.Requirement;
import org.jetbrains.annotations.NotNull;

public class HasMoneyRequirement
extends Requirement {
    private final DeluxeMenus plugin;
    private final boolean invert;
    private final String placeholder;
    private double amount;

    public HasMoneyRequirement(@NotNull DeluxeMenus plugin, double amount, boolean invert, String placeholder) {
        this.plugin = plugin;
        this.amount = amount;
        this.invert = invert;
        this.placeholder = placeholder;
    }

    @Override
    public boolean evaluate(MenuHolder holder) {
        if (this.plugin.getVault() == null) {
            return false;
        }
        if (this.placeholder != null) {
            try {
                String expected = holder.setPlaceholdersAndArguments(this.placeholder);
                this.amount = Double.parseDouble(expected);
            }
            catch (NumberFormatException exception) {
                this.plugin.printStacktrace("Invalid amount found for has money requirement: " + holder.setPlaceholdersAndArguments(this.placeholder), exception);
            }
        }
        if (this.invert) {
            return !this.plugin.getVault().hasEnough(holder.getViewer(), this.amount);
        }
        return this.plugin.getVault().hasEnough(holder.getViewer(), this.amount);
    }
}

