/*
 * Decompiled with CFR 0.152.
 */
package com.extendedclip.deluxemenus.utils;

import com.google.common.primitives.Ints;
import org.jetbrains.annotations.Nullable;

public class PaginationUtils {
    private PaginationUtils() {
        throw new AssertionError((Object)"Util classes should not be initialized");
    }

    public static int parsePage(int itemsPerPage, int itemsCount, @Nullable Integer pages, @Nullable String argument) {
        int maxPages;
        if (itemsCount <= itemsPerPage || argument == null) {
            return 1;
        }
        Integer page = Ints.tryParse((String)argument);
        if (page == null || page < 1) {
            return 1;
        }
        int n = maxPages = pages != null ? pages : PaginationUtils.getPagesCount(itemsPerPage, itemsCount);
        if (page > maxPages) {
            return maxPages;
        }
        return page;
    }

    public static int getPagesCount(int itemsPerPage, int itemsCount) {
        return (int)Math.ceil((double)itemsCount / (double)itemsPerPage);
    }
}

