/*
 * Decompiled with CFR 0.152.
 */
package com.extendedclip.deluxemenus.utils;

import com.extendedclip.deluxemenus.DeluxeMenus;
import com.extendedclip.deluxemenus.utils.VersionHelper;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Base64;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.profile.PlayerProfile;
import org.bukkit.profile.PlayerTextures;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SkullUtils {
    private static final Gson GSON = new Gson();

    @NotNull
    public static String getEncoded(@NotNull String url) {
        byte[] encodedData = Base64.getEncoder().encode(String.format("{textures:{SKIN:{url:\"%s\"}}}", "https://textures.minecraft.net/texture/" + url).getBytes());
        return new String(encodedData);
    }

    @NotNull
    public static ItemStack getSkullByBase64EncodedTextureUrl(@NotNull DeluxeMenus plugin, @NotNull String base64Url) {
        ItemStack head = plugin.getHead().clone();
        if (base64Url.isEmpty()) {
            return head;
        }
        SkullMeta headMeta = (SkullMeta)head.getItemMeta();
        if (headMeta == null) {
            return head;
        }
        if (VersionHelper.HAS_PLAYER_PROFILES) {
            PlayerProfile profile = SkullUtils.getPlayerProfile(plugin, base64Url);
            headMeta.setOwnerProfile(profile);
            head.setItemMeta((ItemMeta)headMeta);
            return head;
        }
        GameProfile profile = SkullUtils.getGameProfile(base64Url);
        try {
            Field profileField = headMeta.getClass().getDeclaredField("profile");
            profileField.setAccessible(true);
            profileField.set(headMeta, profile);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException exception) {
            plugin.printStacktrace("Failed to get head item from base64 texture url", exception);
        }
        head.setItemMeta((ItemMeta)headMeta);
        return head;
    }

    public static String getTextureFromSkull(DeluxeMenus plugin, ItemStack item) {
        GameProfile profile;
        if (!(item.getItemMeta() instanceof SkullMeta)) {
            return null;
        }
        SkullMeta meta = (SkullMeta)item.getItemMeta();
        if (VersionHelper.HAS_PLAYER_PROFILES) {
            PlayerProfile profile2 = meta.getOwnerProfile();
            if (profile2 == null) {
                return null;
            }
            URL url = profile2.getTextures().getSkin();
            if (url == null) {
                return null;
            }
            return url.toString().substring("https://textures.minecraft.net/texture/".length() - 1);
        }
        try {
            Field profileField = meta.getClass().getDeclaredField("profile");
            profileField.setAccessible(true);
            profile = (GameProfile)profileField.get(meta);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException exception) {
            plugin.printStacktrace("Failed to get base64 texture url from head item", exception);
            return null;
        }
        for (Property property : profile.getProperties().get((Object)"textures")) {
            if (!property.getName().equals("textures")) continue;
            return SkullUtils.decodeSkinUrl(property.getValue());
        }
        return null;
    }

    @NotNull
    public static ItemStack getSkullByName(@NotNull DeluxeMenus plugin, @NotNull String playerName) {
        ItemStack head = plugin.getHead().clone();
        if (playerName.isEmpty()) {
            return head;
        }
        SkullMeta headMeta = (SkullMeta)head.getItemMeta();
        if (headMeta == null) {
            return head;
        }
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)playerName);
        if (!VersionHelper.IS_SKULL_OWNER_LEGACY) {
            headMeta.setOwningPlayer(offlinePlayer);
        } else {
            headMeta.setOwner(offlinePlayer.getName());
        }
        head.setItemMeta((ItemMeta)headMeta);
        return head;
    }

    public static String getSkullOwner(ItemStack skull) {
        if (skull == null || !(skull.getItemMeta() instanceof SkullMeta)) {
            return null;
        }
        SkullMeta meta = (SkullMeta)skull.getItemMeta();
        if (!VersionHelper.IS_SKULL_OWNER_LEGACY) {
            if (meta.getOwningPlayer() == null) {
                return null;
            }
            return meta.getOwningPlayer().getName();
        }
        return meta.getOwner();
    }

    @NotNull
    private static GameProfile getGameProfile(@NotNull String base64Url) {
        GameProfile profile = new GameProfile(UUID.randomUUID(), "");
        profile.getProperties().put((Object)"textures", (Object)new Property("textures", base64Url));
        return profile;
    }

    @NotNull
    private static PlayerProfile getPlayerProfile(@NotNull DeluxeMenus plugin, @NotNull String base64Url) {
        PlayerProfile profile = Bukkit.createPlayerProfile((UUID)UUID.randomUUID());
        String decodedBase64 = SkullUtils.decodeSkinUrl(base64Url);
        if (decodedBase64 == null) {
            return profile;
        }
        PlayerTextures textures = profile.getTextures();
        try {
            textures.setSkin(new URL(decodedBase64));
        }
        catch (MalformedURLException exception) {
            plugin.printStacktrace("Something went horribly wrong trying to create basehead URL", exception);
        }
        profile.setTextures(textures);
        return profile;
    }

    @Nullable
    public static String decodeSkinUrl(@NotNull String base64Texture) {
        String decoded = new String(Base64.getDecoder().decode(base64Texture));
        JsonObject object = (JsonObject)GSON.fromJson(decoded, JsonObject.class);
        JsonElement textures = object.get("textures");
        if (textures == null) {
            return null;
        }
        JsonElement skin = textures.getAsJsonObject().get("SKIN");
        if (skin == null) {
            return null;
        }
        JsonElement url = skin.getAsJsonObject().get("url");
        return url == null ? null : url.getAsString();
    }
}

