package org.bukkit.craftbukkit.attribute;

import static org.junit.jupiter.api.Assertions.*;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import org.bukkit.attribute.Attribute;
import org.bukkit.support.environment.AllFeatures;
import org.junit.jupiter.api.Test;

@AllFeatures
public class AttributeTest {

    @Test
    public void testToBukkit() {
        for (AttributeBase nms : BuiltInRegistries.ATTRIBUTE) {
            Attribute bukkit = CraftAttribute.minecraftToBukkit(nms);

            assertNotNull(bukkit, nms.toString());
        }
    }

    @Test
    public void testToNMS() {
        for (Attribute attribute : Attribute.values()) {
            Holder<AttributeBase> nms = CraftAttribute.bukkitToMinecraftHolder(attribute);

            assertNotNull(nms, attribute.name());
        }
    }
}
