Bukkit
======
A plugin API for [Minecraft](https://minecraft.net/) servers, currently maintained by [SpigotMC](https://www.spigotmc.org/).

#### Index
* [Bug Reporting](#bug-reporting)
* [Compilation](#compilation)
* [Contributing](#contributing)
* [Bukkit's Goals](#bukkits-goals)
* [Code Requirements](#code-requirements)

Bug Reporting
-------------
<a name="bug-reporting"></a>
The development team is very open to both bug and feature requests / suggestions. You can submit these on the [JIRA Issue Tracker](https://hub.spigotmc.org/jira/).

Compilation
-----------
<a name="compilation"></a>
Bukkit is a Java program which uses [Maven 3](https://maven.apache.org/) for compilation. To compile fresh from Git, simply perform the following steps:

* Install Maven and Git using your preferred installation methods.
* `git clone https://hub.spigotmc.org/stash/scm/spigot/bukkit.git`.
* `mvn -P development clean install`.
 
Some IDEs such as [NetBeans](https://netbeans.org/) can perform these steps for you. Any Maven capable Java IDE can be used to develop with Bukkit, however the current team's personal preference is to use NetBeans.

Contributing
------------
<a name="contributing"></a>
Contributions of all sorts are welcome. To manage community contributions, we use the pull request functionality of Stash. In to gain access to Stash and create a pull request, you will first need to perform the following steps:

* Create an account on [JIRA](https://hub.spigotmc.org/jira/).
* Fill in the [SpigotMC CLA](https://www.spigotmc.org/go/cla) and wait up to 24 hours for your Stash account to be activated. Please ensure that your username and email addresses match.
* Log into Stash using your JIRA credentials.

Once you have performed these steps you can create a fork, push your code changes, and then submit it for review.

If you submit a PR involving both Bukkit and CraftBukkit, each PR should link the other.

Although the minimum requirement for compilation & usage is Java 8, we prefer all contributions to be written in Java 7 style code unless there is a compelling reason otherwise.

Bukkit's Goals
--------------
<a name="bukkits-goals"></a>
As a rough guideline, ask yourself the following questions to determine if the proposed change fits the Bukkit project's goals. Please remember that this is only a rough guideline
and it may or may not reflect the definitive answer to this question.
Discussions about proposed changes are held in the [Spigot Discord](https://www.spigotmc.org/go/discord).

* Does it expose an implementation detail of the server software, or the protocol or file formats?

    1. If your change revolves around an implementation detail then it is not proper API design. Examples of bad API design would be along the lines of
    a packet API or an NBT storage API.
* Does it result in unexpected behaviour as defined by the Vanilla specification?
    1. One of the goals of the Bukkit project is to be an extended Minecraft Server. Meaning if you choose to run the Bukkit server without any plugin, it should function
    exactly as the Minecraft Server would with some rare exceptions. If your change alters the behaviour of the server in such a way that you would not have the same experience as you
    would in Vanilla, your change does not fit with the Bukkit project's goals.
* Does it expose an issue or vulnerability when operating within the Vanilla environment?
    1. One of the goals of the Bukkit project is to be able to operate within the limitations of the Vanilla environment. If your change results in, or exposes, the ability to, for example,
    crash the client invalid data is set, it does not fit the Bukkit project's needs.

If you answered yes to any of these questions, chances are high your change does not fit within the Bukkit project's goals and will likely not be accepted.
Regardless, there are a few other important questions that need to be asked before you start working on a change:
* Is this change reasonably supportable and maintainable?
    1. *Are there tests for this change? Does this change rely on magic numbers?*
* Is this change reasonably future proof?

Code Requirements
-----------------
<a name="code-requirements"></a>
* For the most part, CraftBukkit and Bukkit use the [Sun/Oracle coding standards](https://www.oracle.com/technetwork/java/javase/documentation/codeconvtoc-136057.html).
* No tabs; use 4 spaces instead.
    * Empty lines should contain no spaces.
* No trailing whitespaces.
* No 80 character column limit, or 'weird' mid-statement newlines unless absolutely necessary.
    * The 80 character column limit still applies to documentation.
* No one-line methods.
* All major additions should have documentation.
* Try to follow test driven development where available.
* All code should be free of magic values. If this is not possible, it should be marked with a TODO comment indicating it should be addressed in the future.
  * If magic values are absolutely necessary for your change, what those values represent should be documented in the code as well as an explanation in the Pull Request description on why those values are necessary.
* No unnecessary code changes. Look through all your changes before you submit it.
* Do not attempt to fix multiple problems with a single patch or pull request.
* Avoid moving or renaming classes.
* All non-private methods and constructors must have specified nullability through [annotations](https://github.com/JetBrains/java-annotations)
* All classes/methods/fields related to a [Minecraft Experimental Feature](https://minecraft.wiki/w/Experimental_Gameplay) must be marked with [`@MinecraftExperimental`](https://hub.spigotmc.org/javadocs/spigot/org/bukkit/MinecraftExperimental.html)
* If necessary, you may consider the use of one of the following [ApiStatus Annotations](https://javadoc.io/doc/org.jetbrains/annotations-java5/23.0.0/org/jetbrains/annotations/ApiStatus.html):
  * [`@ApiStatus.Experimental`](https://javadoc.io/doc/org.jetbrains/annotations-java5/23.0.0/org/jetbrains/annotations/ApiStatus.Experimental.html) for API that is subject to change
  * [`@ApiStatus.Internal`](https://javadoc.io/doc/org.jetbrains/annotations-java5/23.0.0/org/jetbrains/annotations/ApiStatus.Internal.html) for API that is intended only for internal use in the Bukkit project and will not adhere to Bukkit's API contract

Bukkit/CraftBukkit employs [JUnit 5](https://www.vogella.com/tutorials/JUnit/article.html) for testing. Pull Requests(PR) should attempt to integrate within that framework as appropriate.
Bukkit is a large project and what seems simple to a PR author at the time of writing may easily be overlooked by other authors and updates. Including unit tests with your PR
will help to ensure the PR can be easily maintained over time and encourage the Spigot team to pull the PR.

* There needs to be a new line at the end of every file.
* Imports should be organised in a logical manner.
    * Do not group packages
    * __Absolutely no wildcard imports outside of tests.__

Any questions about these requirements can be asked in [#help-development](https://www.spigotmc.org/go/discord) in Discord.
