package net.minecraft.data.worldgen;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockCampfire;
import net.minecraft.world.level.block.BlockIronBars;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CopperBulbBlock;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.structure.templatesystem.CappedProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessorPredicates;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessorRotation;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessorRule;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureTestBlock;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureTestBlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureTestRandomBlock;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureTestTag;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureTestTrue;
import net.minecraft.world.level.levelgen.structure.templatesystem.PosRuleTestAxisAlignedLinear;
import net.minecraft.world.level.levelgen.structure.templatesystem.PosRuleTestTrue;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProtectedBlockProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.rule.blockentity.AppendLoot;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;

public class ProcessorLists {

    private static final ResourceKey<ProcessorList> EMPTY = createKey("empty");
    public static final ResourceKey<ProcessorList> ZOMBIE_PLAINS = createKey("zombie_plains");
    public static final ResourceKey<ProcessorList> ZOMBIE_SAVANNA = createKey("zombie_savanna");
    public static final ResourceKey<ProcessorList> ZOMBIE_SNOWY = createKey("zombie_snowy");
    public static final ResourceKey<ProcessorList> ZOMBIE_TAIGA = createKey("zombie_taiga");
    public static final ResourceKey<ProcessorList> ZOMBIE_DESERT = createKey("zombie_desert");
    public static final ResourceKey<ProcessorList> MOSSIFY_10_PERCENT = createKey("mossify_10_percent");
    public static final ResourceKey<ProcessorList> MOSSIFY_20_PERCENT = createKey("mossify_20_percent");
    public static final ResourceKey<ProcessorList> MOSSIFY_70_PERCENT = createKey("mossify_70_percent");
    public static final ResourceKey<ProcessorList> STREET_PLAINS = createKey("street_plains");
    public static final ResourceKey<ProcessorList> STREET_SAVANNA = createKey("street_savanna");
    public static final ResourceKey<ProcessorList> STREET_SNOWY_OR_TAIGA = createKey("street_snowy_or_taiga");
    public static final ResourceKey<ProcessorList> FARM_PLAINS = createKey("farm_plains");
    public static final ResourceKey<ProcessorList> FARM_SAVANNA = createKey("farm_savanna");
    public static final ResourceKey<ProcessorList> FARM_SNOWY = createKey("farm_snowy");
    public static final ResourceKey<ProcessorList> FARM_TAIGA = createKey("farm_taiga");
    public static final ResourceKey<ProcessorList> FARM_DESERT = createKey("farm_desert");
    public static final ResourceKey<ProcessorList> OUTPOST_ROT = createKey("outpost_rot");
    public static final ResourceKey<ProcessorList> BOTTOM_RAMPART = createKey("bottom_rampart");
    public static final ResourceKey<ProcessorList> TREASURE_ROOMS = createKey("treasure_rooms");
    public static final ResourceKey<ProcessorList> HOUSING = createKey("housing");
    public static final ResourceKey<ProcessorList> SIDE_WALL_DEGRADATION = createKey("side_wall_degradation");
    public static final ResourceKey<ProcessorList> STABLE_DEGRADATION = createKey("stable_degradation");
    public static final ResourceKey<ProcessorList> BASTION_GENERIC_DEGRADATION = createKey("bastion_generic_degradation");
    public static final ResourceKey<ProcessorList> RAMPART_DEGRADATION = createKey("rampart_degradation");
    public static final ResourceKey<ProcessorList> ENTRANCE_REPLACEMENT = createKey("entrance_replacement");
    public static final ResourceKey<ProcessorList> BRIDGE = createKey("bridge");
    public static final ResourceKey<ProcessorList> ROOF = createKey("roof");
    public static final ResourceKey<ProcessorList> HIGH_WALL = createKey("high_wall");
    public static final ResourceKey<ProcessorList> HIGH_RAMPART = createKey("high_rampart");
    public static final ResourceKey<ProcessorList> FOSSIL_ROT = createKey("fossil_rot");
    public static final ResourceKey<ProcessorList> FOSSIL_COAL = createKey("fossil_coal");
    public static final ResourceKey<ProcessorList> FOSSIL_DIAMONDS = createKey("fossil_diamonds");
    public static final ResourceKey<ProcessorList> ANCIENT_CITY_START_DEGRADATION = createKey("ancient_city_start_degradation");
    public static final ResourceKey<ProcessorList> ANCIENT_CITY_GENERIC_DEGRADATION = createKey("ancient_city_generic_degradation");
    public static final ResourceKey<ProcessorList> ANCIENT_CITY_WALLS_DEGRADATION = createKey("ancient_city_walls_degradation");
    public static final ResourceKey<ProcessorList> TRAIL_RUINS_HOUSES_ARCHAEOLOGY = createKey("trail_ruins_houses_archaeology");
    public static final ResourceKey<ProcessorList> TRAIL_RUINS_ROADS_ARCHAEOLOGY = createKey("trail_ruins_roads_archaeology");
    public static final ResourceKey<ProcessorList> TRAIL_RUINS_TOWER_TOP_ARCHAEOLOGY = createKey("trail_ruins_tower_top_archaeology");
    public static final ResourceKey<ProcessorList> TRIAL_CHAMBERS_COPPER_BULB_DEGRADATION = createKey("trial_chambers_copper_bulb_degradation");

    public ProcessorLists() {}

    private static ResourceKey<ProcessorList> createKey(String s) {
        return ResourceKey.create(Registries.PROCESSOR_LIST, MinecraftKey.withDefaultNamespace(s));
    }

    private static void register(BootstrapContext<ProcessorList> bootstrapcontext, ResourceKey<ProcessorList> resourcekey, List<DefinedStructureProcessor> list) {
        bootstrapcontext.register(resourcekey, new ProcessorList(list));
    }

    public static void bootstrap(BootstrapContext<ProcessorList> bootstrapcontext) {
        HolderGetter<Block> holdergetter = bootstrapcontext.lookup(Registries.BLOCK);
        DefinedStructureProcessorPredicates definedstructureprocessorpredicates = new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.BLACKSTONE, 0.01F), DefinedStructureTestTrue.INSTANCE, Blocks.GILDED_BLACKSTONE.defaultBlockState());
        DefinedStructureProcessorPredicates definedstructureprocessorpredicates1 = new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.GILDED_BLACKSTONE, 0.5F), DefinedStructureTestTrue.INSTANCE, Blocks.BLACKSTONE.defaultBlockState());

        register(bootstrapcontext, ProcessorLists.EMPTY, ImmutableList.of());
        register(bootstrapcontext, ProcessorLists.ZOMBIE_PLAINS, ImmutableList.of(new DefinedStructureProcessorRule(ImmutableList.of(new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.COBBLESTONE, 0.8F), DefinedStructureTestTrue.INSTANCE, Blocks.MOSSY_COBBLESTONE.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestTag(TagsBlock.DOORS), DefinedStructureTestTrue.INSTANCE, Blocks.AIR.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestBlock(Blocks.TORCH), DefinedStructureTestTrue.INSTANCE, Blocks.AIR.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestBlock(Blocks.WALL_TORCH), DefinedStructureTestTrue.INSTANCE, Blocks.AIR.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.COBBLESTONE, 0.07F), DefinedStructureTestTrue.INSTANCE, Blocks.COBWEB.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.MOSSY_COBBLESTONE, 0.07F), DefinedStructureTestTrue.INSTANCE, Blocks.COBWEB.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.WHITE_TERRACOTTA, 0.07F), DefinedStructureTestTrue.INSTANCE, Blocks.COBWEB.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.OAK_LOG, 0.05F), DefinedStructureTestTrue.INSTANCE, Blocks.COBWEB.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.OAK_PLANKS, 0.1F), DefinedStructureTestTrue.INSTANCE, Blocks.COBWEB.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.OAK_STAIRS, 0.1F), DefinedStructureTestTrue.INSTANCE, Blocks.COBWEB.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.STRIPPED_OAK_LOG, 0.02F), DefinedStructureTestTrue.INSTANCE, Blocks.COBWEB.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.GLASS_PANE, 0.5F), DefinedStructureTestTrue.INSTANCE, Blocks.COBWEB.defaultBlockState()), new DefinedStructureProcessorPredicates[]{new DefinedStructureProcessorPredicates(new DefinedStructureTestBlockState((IBlockData) ((IBlockData) Blocks.GLASS_PANE.defaultBlockState().setValue(BlockIronBars.NORTH, true)).setValue(BlockIronBars.SOUTH, true)), DefinedStructureTestTrue.INSTANCE, (IBlockData) ((IBlockData) Blocks.BROWN_STAINED_GLASS_PANE.defaultBlockState().setValue(BlockIronBars.NORTH, true)).setValue(BlockIronBars.SOUTH, true)), new DefinedStructureProcessorPredicates(new DefinedStructureTestBlockState((IBlockData) ((IBlockData) Blocks.GLASS_PANE.defaultBlockState().setValue(BlockIronBars.EAST, true)).setValue(BlockIronBars.WEST, true)), DefinedStructureTestTrue.INSTANCE, (IBlockData) ((IBlockData) Blocks.BROWN_STAINED_GLASS_PANE.defaultBlockState().setValue(BlockIronBars.EAST, true)).setValue(BlockIronBars.WEST, true)), new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.WHEAT, 0.3F), DefinedStructureTestTrue.INSTANCE, Blocks.CARROTS.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.WHEAT, 0.2F), DefinedStructureTestTrue.INSTANCE, Blocks.POTATOES.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.WHEAT, 0.1F), DefinedStructureTestTrue.INSTANCE, Blocks.BEETROOTS.defaultBlockState())}))));
        register(bootstrapcontext, ProcessorLists.ZOMBIE_SAVANNA, ImmutableList.of(new DefinedStructureProcessorRule(ImmutableList.of(new DefinedStructureProcessorPredicates(new DefinedStructureTestTag(TagsBlock.DOORS), DefinedStructureTestTrue.INSTANCE, Blocks.AIR.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestBlock(Blocks.TORCH), DefinedStructureTestTrue.INSTANCE, Blocks.AIR.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestBlock(Blocks.WALL_TORCH), DefinedStructureTestTrue.INSTANCE, Blocks.AIR.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.ACACIA_PLANKS, 0.2F), DefinedStructureTestTrue.INSTANCE, Blocks.COBWEB.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.ACACIA_STAIRS, 0.2F), DefinedStructureTestTrue.INSTANCE, Blocks.COBWEB.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.ACACIA_LOG, 0.05F), DefinedStructureTestTrue.INSTANCE, Blocks.COBWEB.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.ACACIA_WOOD, 0.05F), DefinedStructureTestTrue.INSTANCE, Blocks.COBWEB.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.ORANGE_TERRACOTTA, 0.05F), DefinedStructureTestTrue.INSTANCE, Blocks.COBWEB.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.YELLOW_TERRACOTTA, 0.05F), DefinedStructureTestTrue.INSTANCE, Blocks.COBWEB.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.RED_TERRACOTTA, 0.05F), DefinedStructureTestTrue.INSTANCE, Blocks.COBWEB.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.GLASS_PANE, 0.5F), DefinedStructureTestTrue.INSTANCE, Blocks.COBWEB.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestBlockState((IBlockData) ((IBlockData) Blocks.GLASS_PANE.defaultBlockState().setValue(BlockIronBars.NORTH, true)).setValue(BlockIronBars.SOUTH, true)), DefinedStructureTestTrue.INSTANCE, (IBlockData) ((IBlockData) Blocks.BROWN_STAINED_GLASS_PANE.defaultBlockState().setValue(BlockIronBars.NORTH, true)).setValue(BlockIronBars.SOUTH, true)), new DefinedStructureProcessorPredicates[]{new DefinedStructureProcessorPredicates(new DefinedStructureTestBlockState((IBlockData) ((IBlockData) Blocks.GLASS_PANE.defaultBlockState().setValue(BlockIronBars.EAST, true)).setValue(BlockIronBars.WEST, true)), DefinedStructureTestTrue.INSTANCE, (IBlockData) ((IBlockData) Blocks.BROWN_STAINED_GLASS_PANE.defaultBlockState().setValue(BlockIronBars.EAST, true)).setValue(BlockIronBars.WEST, true)), new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.WHEAT, 0.1F), DefinedStructureTestTrue.INSTANCE, Blocks.MELON_STEM.defaultBlockState())}))));
        register(bootstrapcontext, ProcessorLists.ZOMBIE_SNOWY, ImmutableList.of(new DefinedStructureProcessorRule(ImmutableList.of(new DefinedStructureProcessorPredicates(new DefinedStructureTestTag(TagsBlock.DOORS), DefinedStructureTestTrue.INSTANCE, Blocks.AIR.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestBlock(Blocks.TORCH), DefinedStructureTestTrue.INSTANCE, Blocks.AIR.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestBlock(Blocks.WALL_TORCH), DefinedStructureTestTrue.INSTANCE, Blocks.AIR.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestBlock(Blocks.LANTERN), DefinedStructureTestTrue.INSTANCE, Blocks.AIR.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.SPRUCE_PLANKS, 0.2F), DefinedStructureTestTrue.INSTANCE, Blocks.COBWEB.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.SPRUCE_SLAB, 0.4F), DefinedStructureTestTrue.INSTANCE, Blocks.COBWEB.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.STRIPPED_SPRUCE_LOG, 0.05F), DefinedStructureTestTrue.INSTANCE, Blocks.COBWEB.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.STRIPPED_SPRUCE_WOOD, 0.05F), DefinedStructureTestTrue.INSTANCE, Blocks.COBWEB.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.GLASS_PANE, 0.5F), DefinedStructureTestTrue.INSTANCE, Blocks.COBWEB.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestBlockState((IBlockData) ((IBlockData) Blocks.GLASS_PANE.defaultBlockState().setValue(BlockIronBars.NORTH, true)).setValue(BlockIronBars.SOUTH, true)), DefinedStructureTestTrue.INSTANCE, (IBlockData) ((IBlockData) Blocks.BROWN_STAINED_GLASS_PANE.defaultBlockState().setValue(BlockIronBars.NORTH, true)).setValue(BlockIronBars.SOUTH, true)), new DefinedStructureProcessorPredicates(new DefinedStructureTestBlockState((IBlockData) ((IBlockData) Blocks.GLASS_PANE.defaultBlockState().setValue(BlockIronBars.EAST, true)).setValue(BlockIronBars.WEST, true)), DefinedStructureTestTrue.INSTANCE, (IBlockData) ((IBlockData) Blocks.BROWN_STAINED_GLASS_PANE.defaultBlockState().setValue(BlockIronBars.EAST, true)).setValue(BlockIronBars.WEST, true)), new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.WHEAT, 0.1F), DefinedStructureTestTrue.INSTANCE, Blocks.CARROTS.defaultBlockState()), new DefinedStructureProcessorPredicates[]{new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.WHEAT, 0.8F), DefinedStructureTestTrue.INSTANCE, Blocks.POTATOES.defaultBlockState())}))));
        register(bootstrapcontext, ProcessorLists.ZOMBIE_TAIGA, ImmutableList.of(new DefinedStructureProcessorRule(ImmutableList.of(new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.COBBLESTONE, 0.8F), DefinedStructureTestTrue.INSTANCE, Blocks.MOSSY_COBBLESTONE.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestTag(TagsBlock.DOORS), DefinedStructureTestTrue.INSTANCE, Blocks.AIR.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestBlock(Blocks.TORCH), DefinedStructureTestTrue.INSTANCE, Blocks.AIR.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestBlock(Blocks.WALL_TORCH), DefinedStructureTestTrue.INSTANCE, Blocks.AIR.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestBlock(Blocks.CAMPFIRE), DefinedStructureTestTrue.INSTANCE, (IBlockData) Blocks.CAMPFIRE.defaultBlockState().setValue(BlockCampfire.LIT, false)), new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.COBBLESTONE, 0.08F), DefinedStructureTestTrue.INSTANCE, Blocks.COBWEB.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.SPRUCE_LOG, 0.08F), DefinedStructureTestTrue.INSTANCE, Blocks.COBWEB.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.GLASS_PANE, 0.5F), DefinedStructureTestTrue.INSTANCE, Blocks.COBWEB.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestBlockState((IBlockData) ((IBlockData) Blocks.GLASS_PANE.defaultBlockState().setValue(BlockIronBars.NORTH, true)).setValue(BlockIronBars.SOUTH, true)), DefinedStructureTestTrue.INSTANCE, (IBlockData) ((IBlockData) Blocks.BROWN_STAINED_GLASS_PANE.defaultBlockState().setValue(BlockIronBars.NORTH, true)).setValue(BlockIronBars.SOUTH, true)), new DefinedStructureProcessorPredicates(new DefinedStructureTestBlockState((IBlockData) ((IBlockData) Blocks.GLASS_PANE.defaultBlockState().setValue(BlockIronBars.EAST, true)).setValue(BlockIronBars.WEST, true)), DefinedStructureTestTrue.INSTANCE, (IBlockData) ((IBlockData) Blocks.BROWN_STAINED_GLASS_PANE.defaultBlockState().setValue(BlockIronBars.EAST, true)).setValue(BlockIronBars.WEST, true)), new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.WHEAT, 0.3F), DefinedStructureTestTrue.INSTANCE, Blocks.PUMPKIN_STEM.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.WHEAT, 0.2F), DefinedStructureTestTrue.INSTANCE, Blocks.POTATOES.defaultBlockState()), new DefinedStructureProcessorPredicates[0]))));
        register(bootstrapcontext, ProcessorLists.ZOMBIE_DESERT, ImmutableList.of(new DefinedStructureProcessorRule(ImmutableList.of(new DefinedStructureProcessorPredicates(new DefinedStructureTestTag(TagsBlock.DOORS), DefinedStructureTestTrue.INSTANCE, Blocks.AIR.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestBlock(Blocks.TORCH), DefinedStructureTestTrue.INSTANCE, Blocks.AIR.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestBlock(Blocks.WALL_TORCH), DefinedStructureTestTrue.INSTANCE, Blocks.AIR.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.SMOOTH_SANDSTONE, 0.08F), DefinedStructureTestTrue.INSTANCE, Blocks.COBWEB.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.CUT_SANDSTONE, 0.1F), DefinedStructureTestTrue.INSTANCE, Blocks.COBWEB.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.TERRACOTTA, 0.08F), DefinedStructureTestTrue.INSTANCE, Blocks.COBWEB.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.SMOOTH_SANDSTONE_STAIRS, 0.08F), DefinedStructureTestTrue.INSTANCE, Blocks.COBWEB.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.SMOOTH_SANDSTONE_SLAB, 0.08F), DefinedStructureTestTrue.INSTANCE, Blocks.COBWEB.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.WHEAT, 0.2F), DefinedStructureTestTrue.INSTANCE, Blocks.BEETROOTS.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.WHEAT, 0.1F), DefinedStructureTestTrue.INSTANCE, Blocks.MELON_STEM.defaultBlockState())))));
        register(bootstrapcontext, ProcessorLists.MOSSIFY_10_PERCENT, ImmutableList.of(new DefinedStructureProcessorRule(ImmutableList.of(new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.COBBLESTONE, 0.1F), DefinedStructureTestTrue.INSTANCE, Blocks.MOSSY_COBBLESTONE.defaultBlockState())))));
        register(bootstrapcontext, ProcessorLists.MOSSIFY_20_PERCENT, ImmutableList.of(new DefinedStructureProcessorRule(ImmutableList.of(new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.COBBLESTONE, 0.2F), DefinedStructureTestTrue.INSTANCE, Blocks.MOSSY_COBBLESTONE.defaultBlockState())))));
        register(bootstrapcontext, ProcessorLists.MOSSIFY_70_PERCENT, ImmutableList.of(new DefinedStructureProcessorRule(ImmutableList.of(new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.COBBLESTONE, 0.7F), DefinedStructureTestTrue.INSTANCE, Blocks.MOSSY_COBBLESTONE.defaultBlockState())))));
        register(bootstrapcontext, ProcessorLists.STREET_PLAINS, ImmutableList.of(new DefinedStructureProcessorRule(ImmutableList.of(new DefinedStructureProcessorPredicates(new DefinedStructureTestBlock(Blocks.DIRT_PATH), new DefinedStructureTestBlock(Blocks.WATER), Blocks.OAK_PLANKS.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.DIRT_PATH, 0.1F), DefinedStructureTestTrue.INSTANCE, Blocks.GRASS_BLOCK.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestBlock(Blocks.GRASS_BLOCK), new DefinedStructureTestBlock(Blocks.WATER), Blocks.WATER.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestBlock(Blocks.DIRT), new DefinedStructureTestBlock(Blocks.WATER), Blocks.WATER.defaultBlockState())))));
        register(bootstrapcontext, ProcessorLists.STREET_SAVANNA, ImmutableList.of(new DefinedStructureProcessorRule(ImmutableList.of(new DefinedStructureProcessorPredicates(new DefinedStructureTestBlock(Blocks.DIRT_PATH), new DefinedStructureTestBlock(Blocks.WATER), Blocks.ACACIA_PLANKS.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.DIRT_PATH, 0.2F), DefinedStructureTestTrue.INSTANCE, Blocks.GRASS_BLOCK.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestBlock(Blocks.GRASS_BLOCK), new DefinedStructureTestBlock(Blocks.WATER), Blocks.WATER.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestBlock(Blocks.DIRT), new DefinedStructureTestBlock(Blocks.WATER), Blocks.WATER.defaultBlockState())))));
        register(bootstrapcontext, ProcessorLists.STREET_SNOWY_OR_TAIGA, ImmutableList.of(new DefinedStructureProcessorRule(ImmutableList.of(new DefinedStructureProcessorPredicates(new DefinedStructureTestBlock(Blocks.DIRT_PATH), new DefinedStructureTestBlock(Blocks.WATER), Blocks.SPRUCE_PLANKS.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestBlock(Blocks.DIRT_PATH), new DefinedStructureTestBlock(Blocks.ICE), Blocks.SPRUCE_PLANKS.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.DIRT_PATH, 0.2F), DefinedStructureTestTrue.INSTANCE, Blocks.GRASS_BLOCK.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestBlock(Blocks.GRASS_BLOCK), new DefinedStructureTestBlock(Blocks.WATER), Blocks.WATER.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestBlock(Blocks.DIRT), new DefinedStructureTestBlock(Blocks.WATER), Blocks.WATER.defaultBlockState())))));
        register(bootstrapcontext, ProcessorLists.FARM_PLAINS, ImmutableList.of(new DefinedStructureProcessorRule(ImmutableList.of(new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.WHEAT, 0.3F), DefinedStructureTestTrue.INSTANCE, Blocks.CARROTS.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.WHEAT, 0.2F), DefinedStructureTestTrue.INSTANCE, Blocks.POTATOES.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.WHEAT, 0.1F), DefinedStructureTestTrue.INSTANCE, Blocks.BEETROOTS.defaultBlockState())))));
        register(bootstrapcontext, ProcessorLists.FARM_SAVANNA, ImmutableList.of(new DefinedStructureProcessorRule(ImmutableList.of(new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.WHEAT, 0.1F), DefinedStructureTestTrue.INSTANCE, Blocks.MELON_STEM.defaultBlockState())))));
        register(bootstrapcontext, ProcessorLists.FARM_SNOWY, ImmutableList.of(new DefinedStructureProcessorRule(ImmutableList.of(new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.WHEAT, 0.1F), DefinedStructureTestTrue.INSTANCE, Blocks.CARROTS.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.WHEAT, 0.8F), DefinedStructureTestTrue.INSTANCE, Blocks.POTATOES.defaultBlockState())))));
        register(bootstrapcontext, ProcessorLists.FARM_TAIGA, ImmutableList.of(new DefinedStructureProcessorRule(ImmutableList.of(new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.WHEAT, 0.3F), DefinedStructureTestTrue.INSTANCE, Blocks.PUMPKIN_STEM.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.WHEAT, 0.2F), DefinedStructureTestTrue.INSTANCE, Blocks.POTATOES.defaultBlockState())))));
        register(bootstrapcontext, ProcessorLists.FARM_DESERT, ImmutableList.of(new DefinedStructureProcessorRule(ImmutableList.of(new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.WHEAT, 0.2F), DefinedStructureTestTrue.INSTANCE, Blocks.BEETROOTS.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.WHEAT, 0.1F), DefinedStructureTestTrue.INSTANCE, Blocks.MELON_STEM.defaultBlockState())))));
        register(bootstrapcontext, ProcessorLists.OUTPOST_ROT, ImmutableList.of(new DefinedStructureProcessorRotation(0.05F)));
        register(bootstrapcontext, ProcessorLists.BOTTOM_RAMPART, ImmutableList.of(new DefinedStructureProcessorRule(ImmutableList.of(new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.MAGMA_BLOCK, 0.75F), DefinedStructureTestTrue.INSTANCE, Blocks.CRACKED_POLISHED_BLACKSTONE_BRICKS.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.CRACKED_POLISHED_BLACKSTONE_BRICKS, 0.15F), DefinedStructureTestTrue.INSTANCE, Blocks.POLISHED_BLACKSTONE_BRICKS.defaultBlockState()), definedstructureprocessorpredicates1, definedstructureprocessorpredicates))));
        register(bootstrapcontext, ProcessorLists.TREASURE_ROOMS, ImmutableList.of(new DefinedStructureProcessorRule(ImmutableList.of(new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.POLISHED_BLACKSTONE_BRICKS, 0.35F), DefinedStructureTestTrue.INSTANCE, Blocks.CRACKED_POLISHED_BLACKSTONE_BRICKS.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.CHISELED_POLISHED_BLACKSTONE, 0.1F), DefinedStructureTestTrue.INSTANCE, Blocks.CRACKED_POLISHED_BLACKSTONE_BRICKS.defaultBlockState()), definedstructureprocessorpredicates1, definedstructureprocessorpredicates))));
        register(bootstrapcontext, ProcessorLists.HOUSING, ImmutableList.of(new DefinedStructureProcessorRule(ImmutableList.of(new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.POLISHED_BLACKSTONE_BRICKS, 0.3F), DefinedStructureTestTrue.INSTANCE, Blocks.CRACKED_POLISHED_BLACKSTONE_BRICKS.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.BLACKSTONE, 1.0E-4F), DefinedStructureTestTrue.INSTANCE, Blocks.AIR.defaultBlockState()), definedstructureprocessorpredicates1, definedstructureprocessorpredicates))));
        register(bootstrapcontext, ProcessorLists.SIDE_WALL_DEGRADATION, ImmutableList.of(new DefinedStructureProcessorRule(ImmutableList.of(new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.CHISELED_POLISHED_BLACKSTONE, 0.5F), DefinedStructureTestTrue.INSTANCE, Blocks.AIR.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.GOLD_BLOCK, 0.1F), DefinedStructureTestTrue.INSTANCE, Blocks.CRACKED_POLISHED_BLACKSTONE_BRICKS.defaultBlockState()), definedstructureprocessorpredicates1, definedstructureprocessorpredicates))));
        register(bootstrapcontext, ProcessorLists.STABLE_DEGRADATION, ImmutableList.of(new DefinedStructureProcessorRule(ImmutableList.of(new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.POLISHED_BLACKSTONE_BRICKS, 0.1F), DefinedStructureTestTrue.INSTANCE, Blocks.CRACKED_POLISHED_BLACKSTONE_BRICKS.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.BLACKSTONE, 1.0E-4F), DefinedStructureTestTrue.INSTANCE, Blocks.AIR.defaultBlockState()), definedstructureprocessorpredicates1, definedstructureprocessorpredicates))));
        register(bootstrapcontext, ProcessorLists.BASTION_GENERIC_DEGRADATION, ImmutableList.of(new DefinedStructureProcessorRule(ImmutableList.of(new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.POLISHED_BLACKSTONE_BRICKS, 0.3F), DefinedStructureTestTrue.INSTANCE, Blocks.CRACKED_POLISHED_BLACKSTONE_BRICKS.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.BLACKSTONE, 1.0E-4F), DefinedStructureTestTrue.INSTANCE, Blocks.AIR.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.GOLD_BLOCK, 0.3F), DefinedStructureTestTrue.INSTANCE, Blocks.CRACKED_POLISHED_BLACKSTONE_BRICKS.defaultBlockState()), definedstructureprocessorpredicates1, definedstructureprocessorpredicates))));
        register(bootstrapcontext, ProcessorLists.RAMPART_DEGRADATION, ImmutableList.of(new DefinedStructureProcessorRule(ImmutableList.of(new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.POLISHED_BLACKSTONE_BRICKS, 0.4F), DefinedStructureTestTrue.INSTANCE, Blocks.CRACKED_POLISHED_BLACKSTONE_BRICKS.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.BLACKSTONE, 0.01F), DefinedStructureTestTrue.INSTANCE, Blocks.CRACKED_POLISHED_BLACKSTONE_BRICKS.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.POLISHED_BLACKSTONE_BRICKS, 1.0E-4F), DefinedStructureTestTrue.INSTANCE, Blocks.AIR.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.BLACKSTONE, 1.0E-4F), DefinedStructureTestTrue.INSTANCE, Blocks.AIR.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.GOLD_BLOCK, 0.3F), DefinedStructureTestTrue.INSTANCE, Blocks.CRACKED_POLISHED_BLACKSTONE_BRICKS.defaultBlockState()), definedstructureprocessorpredicates1, definedstructureprocessorpredicates))));
        register(bootstrapcontext, ProcessorLists.ENTRANCE_REPLACEMENT, ImmutableList.of(new DefinedStructureProcessorRule(ImmutableList.of(new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.CHISELED_POLISHED_BLACKSTONE, 0.5F), DefinedStructureTestTrue.INSTANCE, Blocks.AIR.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.GOLD_BLOCK, 0.6F), DefinedStructureTestTrue.INSTANCE, Blocks.CRACKED_POLISHED_BLACKSTONE_BRICKS.defaultBlockState()), definedstructureprocessorpredicates1, definedstructureprocessorpredicates))));
        register(bootstrapcontext, ProcessorLists.BRIDGE, ImmutableList.of(new DefinedStructureProcessorRule(ImmutableList.of(new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.POLISHED_BLACKSTONE_BRICKS, 0.3F), DefinedStructureTestTrue.INSTANCE, Blocks.CRACKED_POLISHED_BLACKSTONE_BRICKS.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.BLACKSTONE, 1.0E-4F), DefinedStructureTestTrue.INSTANCE, Blocks.AIR.defaultBlockState())))));
        register(bootstrapcontext, ProcessorLists.ROOF, ImmutableList.of(new DefinedStructureProcessorRule(ImmutableList.of(new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.POLISHED_BLACKSTONE_BRICKS, 0.3F), DefinedStructureTestTrue.INSTANCE, Blocks.CRACKED_POLISHED_BLACKSTONE_BRICKS.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.POLISHED_BLACKSTONE_BRICKS, 0.15F), DefinedStructureTestTrue.INSTANCE, Blocks.AIR.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.POLISHED_BLACKSTONE_BRICKS, 0.3F), DefinedStructureTestTrue.INSTANCE, Blocks.BLACKSTONE.defaultBlockState())))));
        register(bootstrapcontext, ProcessorLists.HIGH_WALL, ImmutableList.of(new DefinedStructureProcessorRule(ImmutableList.of(new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.POLISHED_BLACKSTONE_BRICKS, 0.01F), DefinedStructureTestTrue.INSTANCE, Blocks.AIR.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.POLISHED_BLACKSTONE_BRICKS, 0.5F), DefinedStructureTestTrue.INSTANCE, Blocks.CRACKED_POLISHED_BLACKSTONE_BRICKS.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.POLISHED_BLACKSTONE_BRICKS, 0.3F), DefinedStructureTestTrue.INSTANCE, Blocks.BLACKSTONE.defaultBlockState()), definedstructureprocessorpredicates1))));
        register(bootstrapcontext, ProcessorLists.HIGH_RAMPART, ImmutableList.of(new DefinedStructureProcessorRule(ImmutableList.of(new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.GOLD_BLOCK, 0.3F), DefinedStructureTestTrue.INSTANCE, Blocks.CRACKED_POLISHED_BLACKSTONE_BRICKS.defaultBlockState()), new DefinedStructureProcessorPredicates(DefinedStructureTestTrue.INSTANCE, DefinedStructureTestTrue.INSTANCE, new PosRuleTestAxisAlignedLinear(0.0F, 0.05F, 0, 100, EnumDirection.EnumAxis.Y), Blocks.AIR.defaultBlockState()), definedstructureprocessorpredicates1))));
        register(bootstrapcontext, ProcessorLists.FOSSIL_ROT, ImmutableList.of(new DefinedStructureProcessorRotation(0.9F), new ProtectedBlockProcessor(TagsBlock.FEATURES_CANNOT_REPLACE)));
        register(bootstrapcontext, ProcessorLists.FOSSIL_COAL, ImmutableList.of(new DefinedStructureProcessorRotation(0.1F), new ProtectedBlockProcessor(TagsBlock.FEATURES_CANNOT_REPLACE)));
        register(bootstrapcontext, ProcessorLists.FOSSIL_DIAMONDS, ImmutableList.of(new DefinedStructureProcessorRotation(0.1F), new DefinedStructureProcessorRule(ImmutableList.of(new DefinedStructureProcessorPredicates(new DefinedStructureTestBlock(Blocks.COAL_ORE), DefinedStructureTestTrue.INSTANCE, Blocks.DEEPSLATE_DIAMOND_ORE.defaultBlockState()))), new ProtectedBlockProcessor(TagsBlock.FEATURES_CANNOT_REPLACE)));
        register(bootstrapcontext, ProcessorLists.ANCIENT_CITY_START_DEGRADATION, ImmutableList.of(new DefinedStructureProcessorRule(ImmutableList.of(new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.DEEPSLATE_BRICKS, 0.3F), DefinedStructureTestTrue.INSTANCE, Blocks.CRACKED_DEEPSLATE_BRICKS.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.DEEPSLATE_TILES, 0.3F), DefinedStructureTestTrue.INSTANCE, Blocks.CRACKED_DEEPSLATE_TILES.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.SOUL_LANTERN, 0.05F), DefinedStructureTestTrue.INSTANCE, Blocks.AIR.defaultBlockState()))), new ProtectedBlockProcessor(TagsBlock.FEATURES_CANNOT_REPLACE)));
        register(bootstrapcontext, ProcessorLists.ANCIENT_CITY_GENERIC_DEGRADATION, ImmutableList.of(new DefinedStructureProcessorRotation(holdergetter.getOrThrow(TagsBlock.ANCIENT_CITY_REPLACEABLE), 0.95F), new DefinedStructureProcessorRule(ImmutableList.of(new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.DEEPSLATE_BRICKS, 0.3F), DefinedStructureTestTrue.INSTANCE, Blocks.CRACKED_DEEPSLATE_BRICKS.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.DEEPSLATE_TILES, 0.3F), DefinedStructureTestTrue.INSTANCE, Blocks.CRACKED_DEEPSLATE_TILES.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.SOUL_LANTERN, 0.05F), DefinedStructureTestTrue.INSTANCE, Blocks.AIR.defaultBlockState()))), new ProtectedBlockProcessor(TagsBlock.FEATURES_CANNOT_REPLACE)));
        register(bootstrapcontext, ProcessorLists.ANCIENT_CITY_WALLS_DEGRADATION, ImmutableList.of(new DefinedStructureProcessorRotation(holdergetter.getOrThrow(TagsBlock.ANCIENT_CITY_REPLACEABLE), 0.95F), new DefinedStructureProcessorRule(ImmutableList.of(new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.DEEPSLATE_BRICKS, 0.3F), DefinedStructureTestTrue.INSTANCE, Blocks.CRACKED_DEEPSLATE_BRICKS.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.DEEPSLATE_TILES, 0.3F), DefinedStructureTestTrue.INSTANCE, Blocks.CRACKED_DEEPSLATE_TILES.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.DEEPSLATE_TILE_SLAB, 0.3F), DefinedStructureTestTrue.INSTANCE, Blocks.AIR.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.SOUL_LANTERN, 0.05F), DefinedStructureTestTrue.INSTANCE, Blocks.AIR.defaultBlockState()))), new ProtectedBlockProcessor(TagsBlock.FEATURES_CANNOT_REPLACE)));
        register(bootstrapcontext, ProcessorLists.TRAIL_RUINS_HOUSES_ARCHAEOLOGY, List.of(new DefinedStructureProcessorRule(List.of(new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.GRAVEL, 0.2F), DefinedStructureTestTrue.INSTANCE, Blocks.DIRT.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.GRAVEL, 0.1F), DefinedStructureTestTrue.INSTANCE, Blocks.COARSE_DIRT.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.MUD_BRICKS, 0.1F), DefinedStructureTestTrue.INSTANCE, Blocks.PACKED_MUD.defaultBlockState()))), trailsArchyLootProcessor(LootTables.TRAIL_RUINS_ARCHAEOLOGY_COMMON, 6), trailsArchyLootProcessor(LootTables.TRAIL_RUINS_ARCHAEOLOGY_RARE, 3)));
        register(bootstrapcontext, ProcessorLists.TRAIL_RUINS_ROADS_ARCHAEOLOGY, List.of(new DefinedStructureProcessorRule(List.of(new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.GRAVEL, 0.2F), DefinedStructureTestTrue.INSTANCE, Blocks.DIRT.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.GRAVEL, 0.1F), DefinedStructureTestTrue.INSTANCE, Blocks.COARSE_DIRT.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.MUD_BRICKS, 0.1F), DefinedStructureTestTrue.INSTANCE, Blocks.PACKED_MUD.defaultBlockState()))), trailsArchyLootProcessor(LootTables.TRAIL_RUINS_ARCHAEOLOGY_COMMON, 2)));
        register(bootstrapcontext, ProcessorLists.TRAIL_RUINS_TOWER_TOP_ARCHAEOLOGY, List.of(trailsArchyLootProcessor(LootTables.TRAIL_RUINS_ARCHAEOLOGY_COMMON, 2)));
        register(bootstrapcontext, ProcessorLists.TRIAL_CHAMBERS_COPPER_BULB_DEGRADATION, List.of(new DefinedStructureProcessorRule(List.of(new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.WAXED_COPPER_BULB, 0.1F), DefinedStructureTestTrue.INSTANCE, (IBlockData) Blocks.WAXED_OXIDIZED_COPPER_BULB.defaultBlockState().setValue(CopperBulbBlock.LIT, true)), new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.WAXED_COPPER_BULB, 0.33333334F), DefinedStructureTestTrue.INSTANCE, (IBlockData) Blocks.WAXED_WEATHERED_COPPER_BULB.defaultBlockState().setValue(CopperBulbBlock.LIT, true)), new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.WAXED_COPPER_BULB, 0.5F), DefinedStructureTestTrue.INSTANCE, (IBlockData) Blocks.WAXED_EXPOSED_COPPER_BULB.defaultBlockState().setValue(CopperBulbBlock.LIT, true)))), new ProtectedBlockProcessor(TagsBlock.FEATURES_CANNOT_REPLACE)));
    }

    private static CappedProcessor trailsArchyLootProcessor(ResourceKey<LootTable> resourcekey, int i) {
        return new CappedProcessor(new DefinedStructureProcessorRule(List.of(new DefinedStructureProcessorPredicates(new DefinedStructureTestTag(TagsBlock.TRAIL_RUINS_REPLACEABLE), DefinedStructureTestTrue.INSTANCE, PosRuleTestTrue.INSTANCE, Blocks.SUSPICIOUS_GRAVEL.defaultBlockState(), new AppendLoot(resourcekey)))), ConstantInt.of(i));
    }
}
