package net.minecraft.data.worldgen;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolStructure;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProcessorList;

public class WorldGenFeatureBastionHoglinStable {

    public WorldGenFeatureBastionHoglinStable() {}

    public static void bootstrap(BootstrapContext<WorldGenFeatureDefinedStructurePoolTemplate> bootstrapcontext) {
        HolderGetter<ProcessorList> holdergetter = bootstrapcontext.lookup(Registries.PROCESSOR_LIST);
        Holder<ProcessorList> holder = holdergetter.getOrThrow(ProcessorLists.STABLE_DEGRADATION);
        Holder<ProcessorList> holder1 = holdergetter.getOrThrow(ProcessorLists.SIDE_WALL_DEGRADATION);
        HolderGetter<WorldGenFeatureDefinedStructurePoolTemplate> holdergetter1 = bootstrapcontext.lookup(Registries.TEMPLATE_POOL);
        Holder<WorldGenFeatureDefinedStructurePoolTemplate> holder2 = holdergetter1.getOrThrow(WorldGenFeaturePieces.EMPTY);

        WorldGenFeaturePieces.register(bootstrapcontext, "bastion/hoglin_stable/starting_pieces", new WorldGenFeatureDefinedStructurePoolTemplate(holder2, ImmutableList.of(Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/hoglin_stable/starting_pieces/starting_stairs_0", (Holder) holder), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/hoglin_stable/starting_pieces/starting_stairs_1", (Holder) holder), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/hoglin_stable/starting_pieces/starting_stairs_2", (Holder) holder), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/hoglin_stable/starting_pieces/starting_stairs_3", (Holder) holder), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/hoglin_stable/starting_pieces/starting_stairs_4", (Holder) holder), 1)), WorldGenFeatureDefinedStructurePoolTemplate.Matching.RIGID));
        WorldGenFeaturePieces.register(bootstrapcontext, "bastion/hoglin_stable/mirrored_starting_pieces", new WorldGenFeatureDefinedStructurePoolTemplate(holder2, ImmutableList.of(Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/hoglin_stable/starting_pieces/stairs_0_mirrored", (Holder) holder), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/hoglin_stable/starting_pieces/stairs_1_mirrored", (Holder) holder), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/hoglin_stable/starting_pieces/stairs_2_mirrored", (Holder) holder), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/hoglin_stable/starting_pieces/stairs_3_mirrored", (Holder) holder), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/hoglin_stable/starting_pieces/stairs_4_mirrored", (Holder) holder), 1)), WorldGenFeatureDefinedStructurePoolTemplate.Matching.RIGID));
        WorldGenFeaturePieces.register(bootstrapcontext, "bastion/hoglin_stable/wall_bases", new WorldGenFeatureDefinedStructurePoolTemplate(holder2, ImmutableList.of(Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/hoglin_stable/walls/wall_base", (Holder) holder), 1)), WorldGenFeatureDefinedStructurePoolTemplate.Matching.RIGID));
        WorldGenFeaturePieces.register(bootstrapcontext, "bastion/hoglin_stable/walls", new WorldGenFeatureDefinedStructurePoolTemplate(holder2, ImmutableList.of(Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/hoglin_stable/walls/side_wall_0", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/hoglin_stable/walls/side_wall_1", (Holder) holder1), 1)), WorldGenFeatureDefinedStructurePoolTemplate.Matching.RIGID));
        WorldGenFeaturePieces.register(bootstrapcontext, "bastion/hoglin_stable/stairs", new WorldGenFeatureDefinedStructurePoolTemplate(holder2, ImmutableList.of(Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/hoglin_stable/stairs/stairs_1_0", (Holder) holder), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/hoglin_stable/stairs/stairs_1_1", (Holder) holder), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/hoglin_stable/stairs/stairs_1_2", (Holder) holder), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/hoglin_stable/stairs/stairs_1_3", (Holder) holder), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/hoglin_stable/stairs/stairs_1_4", (Holder) holder), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/hoglin_stable/stairs/stairs_2_0", (Holder) holder), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/hoglin_stable/stairs/stairs_2_1", (Holder) holder), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/hoglin_stable/stairs/stairs_2_2", (Holder) holder), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/hoglin_stable/stairs/stairs_2_3", (Holder) holder), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/hoglin_stable/stairs/stairs_2_4", (Holder) holder), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/hoglin_stable/stairs/stairs_3_0", (Holder) holder), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/hoglin_stable/stairs/stairs_3_1", (Holder) holder), 1), new Pair[]{Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/hoglin_stable/stairs/stairs_3_2", (Holder) holder), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/hoglin_stable/stairs/stairs_3_3", (Holder) holder), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/hoglin_stable/stairs/stairs_3_4", (Holder) holder), 1)}), WorldGenFeatureDefinedStructurePoolTemplate.Matching.RIGID));
        WorldGenFeaturePieces.register(bootstrapcontext, "bastion/hoglin_stable/small_stables/inner", new WorldGenFeatureDefinedStructurePoolTemplate(holder2, ImmutableList.of(Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/hoglin_stable/small_stables/inner_0", (Holder) holder), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/hoglin_stable/small_stables/inner_1", (Holder) holder), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/hoglin_stable/small_stables/inner_2", (Holder) holder), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/hoglin_stable/small_stables/inner_3", (Holder) holder), 1)), WorldGenFeatureDefinedStructurePoolTemplate.Matching.RIGID));
        WorldGenFeaturePieces.register(bootstrapcontext, "bastion/hoglin_stable/small_stables/outer", new WorldGenFeatureDefinedStructurePoolTemplate(holder2, ImmutableList.of(Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/hoglin_stable/small_stables/outer_0", (Holder) holder), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/hoglin_stable/small_stables/outer_1", (Holder) holder), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/hoglin_stable/small_stables/outer_2", (Holder) holder), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/hoglin_stable/small_stables/outer_3", (Holder) holder), 1)), WorldGenFeatureDefinedStructurePoolTemplate.Matching.RIGID));
        WorldGenFeaturePieces.register(bootstrapcontext, "bastion/hoglin_stable/large_stables/inner", new WorldGenFeatureDefinedStructurePoolTemplate(holder2, ImmutableList.of(Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/hoglin_stable/large_stables/inner_0", (Holder) holder), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/hoglin_stable/large_stables/inner_1", (Holder) holder), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/hoglin_stable/large_stables/inner_2", (Holder) holder), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/hoglin_stable/large_stables/inner_3", (Holder) holder), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/hoglin_stable/large_stables/inner_4", (Holder) holder), 1)), WorldGenFeatureDefinedStructurePoolTemplate.Matching.RIGID));
        WorldGenFeaturePieces.register(bootstrapcontext, "bastion/hoglin_stable/large_stables/outer", new WorldGenFeatureDefinedStructurePoolTemplate(holder2, ImmutableList.of(Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/hoglin_stable/large_stables/outer_0", (Holder) holder), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/hoglin_stable/large_stables/outer_1", (Holder) holder), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/hoglin_stable/large_stables/outer_2", (Holder) holder), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/hoglin_stable/large_stables/outer_3", (Holder) holder), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/hoglin_stable/large_stables/outer_4", (Holder) holder), 1)), WorldGenFeatureDefinedStructurePoolTemplate.Matching.RIGID));
        WorldGenFeaturePieces.register(bootstrapcontext, "bastion/hoglin_stable/posts", new WorldGenFeatureDefinedStructurePoolTemplate(holder2, ImmutableList.of(Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/hoglin_stable/posts/stair_post", (Holder) holder), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/hoglin_stable/posts/end_post", (Holder) holder), 1)), WorldGenFeatureDefinedStructurePoolTemplate.Matching.RIGID));
        WorldGenFeaturePieces.register(bootstrapcontext, "bastion/hoglin_stable/ramparts", new WorldGenFeatureDefinedStructurePoolTemplate(holder2, ImmutableList.of(Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/hoglin_stable/ramparts/ramparts_1", (Holder) holder), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/hoglin_stable/ramparts/ramparts_2", (Holder) holder), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/hoglin_stable/ramparts/ramparts_3", (Holder) holder), 1)), WorldGenFeatureDefinedStructurePoolTemplate.Matching.RIGID));
        WorldGenFeaturePieces.register(bootstrapcontext, "bastion/hoglin_stable/rampart_plates", new WorldGenFeatureDefinedStructurePoolTemplate(holder2, ImmutableList.of(Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/hoglin_stable/rampart_plates/rampart_plate_1", (Holder) holder), 1)), WorldGenFeatureDefinedStructurePoolTemplate.Matching.RIGID));
        WorldGenFeaturePieces.register(bootstrapcontext, "bastion/hoglin_stable/connectors", new WorldGenFeatureDefinedStructurePoolTemplate(holder2, ImmutableList.of(Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/hoglin_stable/connectors/end_post_connector", (Holder) holder), 1)), WorldGenFeatureDefinedStructurePoolTemplate.Matching.RIGID));
    }
}
