package net.minecraft.data.worldgen;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolStructure;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProcessorList;

public class WorldGenFeatureBastionTreasure {

    public WorldGenFeatureBastionTreasure() {}

    public static void bootstrap(BootstrapContext<WorldGenFeatureDefinedStructurePoolTemplate> bootstrapcontext) {
        HolderGetter<ProcessorList> holdergetter = bootstrapcontext.lookup(Registries.PROCESSOR_LIST);
        Holder<ProcessorList> holder = holdergetter.getOrThrow(ProcessorLists.TREASURE_ROOMS);
        Holder<ProcessorList> holder1 = holdergetter.getOrThrow(ProcessorLists.HIGH_WALL);
        Holder<ProcessorList> holder2 = holdergetter.getOrThrow(ProcessorLists.BOTTOM_RAMPART);
        Holder<ProcessorList> holder3 = holdergetter.getOrThrow(ProcessorLists.HIGH_RAMPART);
        Holder<ProcessorList> holder4 = holdergetter.getOrThrow(ProcessorLists.ROOF);
        HolderGetter<WorldGenFeatureDefinedStructurePoolTemplate> holdergetter1 = bootstrapcontext.lookup(Registries.TEMPLATE_POOL);
        Holder<WorldGenFeatureDefinedStructurePoolTemplate> holder5 = holdergetter1.getOrThrow(WorldGenFeaturePieces.EMPTY);

        WorldGenFeaturePieces.register(bootstrapcontext, "bastion/treasure/bases", new WorldGenFeatureDefinedStructurePoolTemplate(holder5, ImmutableList.of(Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/treasure/bases/lava_basin", (Holder) holder), 1)), WorldGenFeatureDefinedStructurePoolTemplate.Matching.RIGID));
        WorldGenFeaturePieces.register(bootstrapcontext, "bastion/treasure/stairs", new WorldGenFeatureDefinedStructurePoolTemplate(holder5, ImmutableList.of(Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/treasure/stairs/lower_stairs", (Holder) holder), 1)), WorldGenFeatureDefinedStructurePoolTemplate.Matching.RIGID));
        WorldGenFeaturePieces.register(bootstrapcontext, "bastion/treasure/bases/centers", new WorldGenFeatureDefinedStructurePoolTemplate(holder5, ImmutableList.of(Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/treasure/bases/centers/center_0", (Holder) holder), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/treasure/bases/centers/center_1", (Holder) holder), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/treasure/bases/centers/center_2", (Holder) holder), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/treasure/bases/centers/center_3", (Holder) holder), 1)), WorldGenFeatureDefinedStructurePoolTemplate.Matching.RIGID));
        WorldGenFeaturePieces.register(bootstrapcontext, "bastion/treasure/brains", new WorldGenFeatureDefinedStructurePoolTemplate(holder5, ImmutableList.of(Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/treasure/brains/center_brain", (Holder) holder), 1)), WorldGenFeatureDefinedStructurePoolTemplate.Matching.RIGID));
        WorldGenFeaturePieces.register(bootstrapcontext, "bastion/treasure/walls", new WorldGenFeatureDefinedStructurePoolTemplate(holder5, ImmutableList.of(Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/treasure/walls/lava_wall", (Holder) holder), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/treasure/walls/entrance_wall", (Holder) holder1), 1)), WorldGenFeatureDefinedStructurePoolTemplate.Matching.RIGID));
        WorldGenFeaturePieces.register(bootstrapcontext, "bastion/treasure/walls/outer", new WorldGenFeatureDefinedStructurePoolTemplate(holder5, ImmutableList.of(Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/treasure/walls/outer/top_corner", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/treasure/walls/outer/mid_corner", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/treasure/walls/outer/bottom_corner", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/treasure/walls/outer/outer_wall", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/treasure/walls/outer/medium_outer_wall", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/treasure/walls/outer/tall_outer_wall", (Holder) holder1), 1)), WorldGenFeatureDefinedStructurePoolTemplate.Matching.RIGID));
        WorldGenFeaturePieces.register(bootstrapcontext, "bastion/treasure/walls/bottom", new WorldGenFeatureDefinedStructurePoolTemplate(holder5, ImmutableList.of(Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/treasure/walls/bottom/wall_0", (Holder) holder), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/treasure/walls/bottom/wall_1", (Holder) holder), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/treasure/walls/bottom/wall_2", (Holder) holder), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/treasure/walls/bottom/wall_3", (Holder) holder), 1)), WorldGenFeatureDefinedStructurePoolTemplate.Matching.RIGID));
        WorldGenFeaturePieces.register(bootstrapcontext, "bastion/treasure/walls/mid", new WorldGenFeatureDefinedStructurePoolTemplate(holder5, ImmutableList.of(Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/treasure/walls/mid/wall_0", (Holder) holder), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/treasure/walls/mid/wall_1", (Holder) holder), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/treasure/walls/mid/wall_2", (Holder) holder), 1)), WorldGenFeatureDefinedStructurePoolTemplate.Matching.RIGID));
        WorldGenFeaturePieces.register(bootstrapcontext, "bastion/treasure/walls/top", new WorldGenFeatureDefinedStructurePoolTemplate(holder5, ImmutableList.of(Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/treasure/walls/top/main_entrance", (Holder) holder), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/treasure/walls/top/wall_0", (Holder) holder), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/treasure/walls/top/wall_1", (Holder) holder), 1)), WorldGenFeatureDefinedStructurePoolTemplate.Matching.RIGID));
        WorldGenFeaturePieces.register(bootstrapcontext, "bastion/treasure/connectors", new WorldGenFeatureDefinedStructurePoolTemplate(holder5, ImmutableList.of(Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/treasure/connectors/center_to_wall_middle", (Holder) holder), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/treasure/connectors/center_to_wall_top", (Holder) holder), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/treasure/connectors/center_to_wall_top_entrance", (Holder) holder), 1)), WorldGenFeatureDefinedStructurePoolTemplate.Matching.RIGID));
        WorldGenFeaturePieces.register(bootstrapcontext, "bastion/treasure/entrances", new WorldGenFeatureDefinedStructurePoolTemplate(holder5, ImmutableList.of(Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/treasure/entrances/entrance_0", (Holder) holder), 1)), WorldGenFeatureDefinedStructurePoolTemplate.Matching.RIGID));
        WorldGenFeaturePieces.register(bootstrapcontext, "bastion/treasure/ramparts", new WorldGenFeatureDefinedStructurePoolTemplate(holder5, ImmutableList.of(Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/treasure/ramparts/mid_wall_main", (Holder) holder), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/treasure/ramparts/mid_wall_side", (Holder) holder), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/treasure/ramparts/bottom_wall_0", (Holder) holder2), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/treasure/ramparts/top_wall", (Holder) holder3), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/treasure/ramparts/lava_basin_side", (Holder) holder), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/treasure/ramparts/lava_basin_main", (Holder) holder), 1)), WorldGenFeatureDefinedStructurePoolTemplate.Matching.RIGID));
        WorldGenFeaturePieces.register(bootstrapcontext, "bastion/treasure/corners/bottom", new WorldGenFeatureDefinedStructurePoolTemplate(holder5, ImmutableList.of(Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/treasure/corners/bottom/corner_0", (Holder) holder), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/treasure/corners/bottom/corner_1", (Holder) holder), 1)), WorldGenFeatureDefinedStructurePoolTemplate.Matching.RIGID));
        WorldGenFeaturePieces.register(bootstrapcontext, "bastion/treasure/corners/edges", new WorldGenFeatureDefinedStructurePoolTemplate(holder5, ImmutableList.of(Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/treasure/corners/edges/bottom", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/treasure/corners/edges/middle", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/treasure/corners/edges/top", (Holder) holder1), 1)), WorldGenFeatureDefinedStructurePoolTemplate.Matching.RIGID));
        WorldGenFeaturePieces.register(bootstrapcontext, "bastion/treasure/corners/middle", new WorldGenFeatureDefinedStructurePoolTemplate(holder5, ImmutableList.of(Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/treasure/corners/middle/corner_0", (Holder) holder), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/treasure/corners/middle/corner_1", (Holder) holder), 1)), WorldGenFeatureDefinedStructurePoolTemplate.Matching.RIGID));
        WorldGenFeaturePieces.register(bootstrapcontext, "bastion/treasure/corners/top", new WorldGenFeatureDefinedStructurePoolTemplate(holder5, ImmutableList.of(Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/treasure/corners/top/corner_0", (Holder) holder), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/treasure/corners/top/corner_1", (Holder) holder), 1)), WorldGenFeatureDefinedStructurePoolTemplate.Matching.RIGID));
        WorldGenFeaturePieces.register(bootstrapcontext, "bastion/treasure/extensions/large_pool", new WorldGenFeatureDefinedStructurePoolTemplate(holder5, ImmutableList.of(Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/treasure/extensions/empty", (Holder) holder), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/treasure/extensions/empty", (Holder) holder), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/treasure/extensions/fire_room", (Holder) holder), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/treasure/extensions/large_bridge_0", (Holder) holder), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/treasure/extensions/large_bridge_1", (Holder) holder), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/treasure/extensions/large_bridge_2", (Holder) holder), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/treasure/extensions/large_bridge_3", (Holder) holder), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/treasure/extensions/roofed_bridge", (Holder) holder), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/treasure/extensions/empty", (Holder) holder), 1)), WorldGenFeatureDefinedStructurePoolTemplate.Matching.RIGID));
        WorldGenFeaturePieces.register(bootstrapcontext, "bastion/treasure/extensions/small_pool", new WorldGenFeatureDefinedStructurePoolTemplate(holder5, ImmutableList.of(Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/treasure/extensions/empty", (Holder) holder), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/treasure/extensions/fire_room", (Holder) holder), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/treasure/extensions/empty", (Holder) holder), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/treasure/extensions/small_bridge_0", (Holder) holder), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/treasure/extensions/small_bridge_1", (Holder) holder), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/treasure/extensions/small_bridge_2", (Holder) holder), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/treasure/extensions/small_bridge_3", (Holder) holder), 1)), WorldGenFeatureDefinedStructurePoolTemplate.Matching.RIGID));
        WorldGenFeaturePieces.register(bootstrapcontext, "bastion/treasure/extensions/houses", new WorldGenFeatureDefinedStructurePoolTemplate(holder5, ImmutableList.of(Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/treasure/extensions/house_0", (Holder) holder), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/treasure/extensions/house_1", (Holder) holder), 1)), WorldGenFeatureDefinedStructurePoolTemplate.Matching.RIGID));
        WorldGenFeaturePieces.register(bootstrapcontext, "bastion/treasure/roofs", new WorldGenFeatureDefinedStructurePoolTemplate(holder5, ImmutableList.of(Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/treasure/roofs/wall_roof", (Holder) holder4), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/treasure/roofs/corner_roof", (Holder) holder4), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/treasure/roofs/center_roof", (Holder) holder4), 1)), WorldGenFeatureDefinedStructurePoolTemplate.Matching.RIGID));
    }
}
