package net.minecraft.data.worldgen;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolStructure;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProcessorList;

public class WorldGenFeatureBastionUnits {

    public WorldGenFeatureBastionUnits() {}

    public static void bootstrap(BootstrapContext<WorldGenFeatureDefinedStructurePoolTemplate> bootstrapcontext) {
        HolderGetter<ProcessorList> holdergetter = bootstrapcontext.lookup(Registries.PROCESSOR_LIST);
        Holder<ProcessorList> holder = holdergetter.getOrThrow(ProcessorLists.HOUSING);
        HolderGetter<WorldGenFeatureDefinedStructurePoolTemplate> holdergetter1 = bootstrapcontext.lookup(Registries.TEMPLATE_POOL);
        Holder<WorldGenFeatureDefinedStructurePoolTemplate> holder1 = holdergetter1.getOrThrow(WorldGenFeaturePieces.EMPTY);

        WorldGenFeaturePieces.register(bootstrapcontext, "bastion/units/center_pieces", new WorldGenFeatureDefinedStructurePoolTemplate(holder1, ImmutableList.of(Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/units/center_pieces/center_0", (Holder) holder), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/units/center_pieces/center_1", (Holder) holder), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/units/center_pieces/center_2", (Holder) holder), 1)), WorldGenFeatureDefinedStructurePoolTemplate.Matching.RIGID));
        WorldGenFeaturePieces.register(bootstrapcontext, "bastion/units/pathways", new WorldGenFeatureDefinedStructurePoolTemplate(holder1, ImmutableList.of(Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/units/pathways/pathway_0", (Holder) holder), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/units/pathways/pathway_wall_0", (Holder) holder), 1)), WorldGenFeatureDefinedStructurePoolTemplate.Matching.RIGID));
        WorldGenFeaturePieces.register(bootstrapcontext, "bastion/units/walls/wall_bases", new WorldGenFeatureDefinedStructurePoolTemplate(holder1, ImmutableList.of(Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/units/walls/wall_base", (Holder) holder), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/units/walls/connected_wall", (Holder) holder), 1)), WorldGenFeatureDefinedStructurePoolTemplate.Matching.RIGID));
        WorldGenFeaturePieces.register(bootstrapcontext, "bastion/units/stages/stage_0", new WorldGenFeatureDefinedStructurePoolTemplate(holder1, ImmutableList.of(Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/units/stages/stage_0_0", (Holder) holder), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/units/stages/stage_0_1", (Holder) holder), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/units/stages/stage_0_2", (Holder) holder), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/units/stages/stage_0_3", (Holder) holder), 1)), WorldGenFeatureDefinedStructurePoolTemplate.Matching.RIGID));
        WorldGenFeaturePieces.register(bootstrapcontext, "bastion/units/stages/stage_1", new WorldGenFeatureDefinedStructurePoolTemplate(holder1, ImmutableList.of(Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/units/stages/stage_1_0", (Holder) holder), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/units/stages/stage_1_1", (Holder) holder), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/units/stages/stage_1_2", (Holder) holder), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/units/stages/stage_1_3", (Holder) holder), 1)), WorldGenFeatureDefinedStructurePoolTemplate.Matching.RIGID));
        WorldGenFeaturePieces.register(bootstrapcontext, "bastion/units/stages/rot/stage_1", new WorldGenFeatureDefinedStructurePoolTemplate(holder1, ImmutableList.of(Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/units/stages/rot/stage_1_0", (Holder) holder), 1)), WorldGenFeatureDefinedStructurePoolTemplate.Matching.RIGID));
        WorldGenFeaturePieces.register(bootstrapcontext, "bastion/units/stages/stage_2", new WorldGenFeatureDefinedStructurePoolTemplate(holder1, ImmutableList.of(Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/units/stages/stage_2_0", (Holder) holder), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/units/stages/stage_2_1", (Holder) holder), 1)), WorldGenFeatureDefinedStructurePoolTemplate.Matching.RIGID));
        WorldGenFeaturePieces.register(bootstrapcontext, "bastion/units/stages/stage_3", new WorldGenFeatureDefinedStructurePoolTemplate(holder1, ImmutableList.of(Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/units/stages/stage_3_0", (Holder) holder), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/units/stages/stage_3_1", (Holder) holder), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/units/stages/stage_3_2", (Holder) holder), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/units/stages/stage_3_3", (Holder) holder), 1)), WorldGenFeatureDefinedStructurePoolTemplate.Matching.RIGID));
        WorldGenFeaturePieces.register(bootstrapcontext, "bastion/units/fillers/stage_0", new WorldGenFeatureDefinedStructurePoolTemplate(holder1, ImmutableList.of(Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/units/fillers/stage_0", (Holder) holder), 1)), WorldGenFeatureDefinedStructurePoolTemplate.Matching.RIGID));
        WorldGenFeaturePieces.register(bootstrapcontext, "bastion/units/edges", new WorldGenFeatureDefinedStructurePoolTemplate(holder1, ImmutableList.of(Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/units/edges/edge_0", (Holder) holder), 1)), WorldGenFeatureDefinedStructurePoolTemplate.Matching.RIGID));
        WorldGenFeaturePieces.register(bootstrapcontext, "bastion/units/wall_units", new WorldGenFeatureDefinedStructurePoolTemplate(holder1, ImmutableList.of(Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/units/wall_units/unit_0", (Holder) holder), 1)), WorldGenFeatureDefinedStructurePoolTemplate.Matching.RIGID));
        WorldGenFeaturePieces.register(bootstrapcontext, "bastion/units/edge_wall_units", new WorldGenFeatureDefinedStructurePoolTemplate(holder1, ImmutableList.of(Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/units/wall_units/edge_0_large", (Holder) holder), 1)), WorldGenFeatureDefinedStructurePoolTemplate.Matching.RIGID));
        WorldGenFeaturePieces.register(bootstrapcontext, "bastion/units/ramparts", new WorldGenFeatureDefinedStructurePoolTemplate(holder1, ImmutableList.of(Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/units/ramparts/ramparts_0", (Holder) holder), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/units/ramparts/ramparts_1", (Holder) holder), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/units/ramparts/ramparts_2", (Holder) holder), 1)), WorldGenFeatureDefinedStructurePoolTemplate.Matching.RIGID));
        WorldGenFeaturePieces.register(bootstrapcontext, "bastion/units/large_ramparts", new WorldGenFeatureDefinedStructurePoolTemplate(holder1, ImmutableList.of(Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/units/ramparts/ramparts_0", (Holder) holder), 1)), WorldGenFeatureDefinedStructurePoolTemplate.Matching.RIGID));
        WorldGenFeaturePieces.register(bootstrapcontext, "bastion/units/rampart_plates", new WorldGenFeatureDefinedStructurePoolTemplate(holder1, ImmutableList.of(Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("bastion/units/rampart_plates/plate_0", (Holder) holder), 1)), WorldGenFeatureDefinedStructurePoolTemplate.Matching.RIGID));
    }
}
