package net.minecraft.data.worldgen;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.placement.VillagePlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolStructure;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProcessorList;

public class WorldGenFeatureDesertVillage {

    public static final ResourceKey<WorldGenFeatureDefinedStructurePoolTemplate> START = WorldGenFeaturePieces.createKey("village/desert/town_centers");
    private static final ResourceKey<WorldGenFeatureDefinedStructurePoolTemplate> TERMINATORS_KEY = WorldGenFeaturePieces.createKey("village/desert/terminators");
    private static final ResourceKey<WorldGenFeatureDefinedStructurePoolTemplate> ZOMBIE_TERMINATORS_KEY = WorldGenFeaturePieces.createKey("village/desert/zombie/terminators");

    public WorldGenFeatureDesertVillage() {}

    public static void bootstrap(BootstrapContext<WorldGenFeatureDefinedStructurePoolTemplate> bootstrapcontext) {
        HolderGetter<PlacedFeature> holdergetter = bootstrapcontext.lookup(Registries.PLACED_FEATURE);
        Holder<PlacedFeature> holder = holdergetter.getOrThrow(VillagePlacements.PATCH_CACTUS_VILLAGE);
        Holder<PlacedFeature> holder1 = holdergetter.getOrThrow(VillagePlacements.PILE_HAY_VILLAGE);
        HolderGetter<ProcessorList> holdergetter1 = bootstrapcontext.lookup(Registries.PROCESSOR_LIST);
        Holder<ProcessorList> holder2 = holdergetter1.getOrThrow(ProcessorLists.ZOMBIE_DESERT);
        Holder<ProcessorList> holder3 = holdergetter1.getOrThrow(ProcessorLists.FARM_DESERT);
        HolderGetter<WorldGenFeatureDefinedStructurePoolTemplate> holdergetter2 = bootstrapcontext.lookup(Registries.TEMPLATE_POOL);
        Holder<WorldGenFeatureDefinedStructurePoolTemplate> holder4 = holdergetter2.getOrThrow(WorldGenFeaturePieces.EMPTY);
        Holder<WorldGenFeatureDefinedStructurePoolTemplate> holder5 = holdergetter2.getOrThrow(WorldGenFeatureDesertVillage.TERMINATORS_KEY);
        Holder<WorldGenFeatureDefinedStructurePoolTemplate> holder6 = holdergetter2.getOrThrow(WorldGenFeatureDesertVillage.ZOMBIE_TERMINATORS_KEY);

        bootstrapcontext.register(WorldGenFeatureDesertVillage.START, new WorldGenFeatureDefinedStructurePoolTemplate(holder4, ImmutableList.of(Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/desert/town_centers/desert_meeting_point_1"), 98), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/desert/town_centers/desert_meeting_point_2"), 98), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/desert/town_centers/desert_meeting_point_3"), 49), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/desert/zombie/town_centers/desert_meeting_point_1", holder2), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/desert/zombie/town_centers/desert_meeting_point_2", holder2), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/desert/zombie/town_centers/desert_meeting_point_3", holder2), 1)), WorldGenFeatureDefinedStructurePoolTemplate.Matching.RIGID));
        WorldGenFeaturePieces.register(bootstrapcontext, "village/desert/streets", new WorldGenFeatureDefinedStructurePoolTemplate(holder5, ImmutableList.of(Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/desert/streets/corner_01"), 3), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/desert/streets/corner_02"), 3), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/desert/streets/straight_01"), 4), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/desert/streets/straight_02"), 4), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/desert/streets/straight_03"), 3), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/desert/streets/crossroad_01"), 3), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/desert/streets/crossroad_02"), 3), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/desert/streets/crossroad_03"), 3), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/desert/streets/square_01"), 3), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/desert/streets/square_02"), 3), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/desert/streets/turn_01"), 3)), WorldGenFeatureDefinedStructurePoolTemplate.Matching.TERRAIN_MATCHING));
        WorldGenFeaturePieces.register(bootstrapcontext, "village/desert/zombie/streets", new WorldGenFeatureDefinedStructurePoolTemplate(holder6, ImmutableList.of(Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/desert/zombie/streets/corner_01"), 3), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/desert/zombie/streets/corner_02"), 3), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/desert/zombie/streets/straight_01"), 4), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/desert/zombie/streets/straight_02"), 4), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/desert/zombie/streets/straight_03"), 3), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/desert/zombie/streets/crossroad_01"), 3), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/desert/zombie/streets/crossroad_02"), 3), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/desert/zombie/streets/crossroad_03"), 3), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/desert/zombie/streets/square_01"), 3), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/desert/zombie/streets/square_02"), 3), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/desert/zombie/streets/turn_01"), 3)), WorldGenFeatureDefinedStructurePoolTemplate.Matching.TERRAIN_MATCHING));
        WorldGenFeaturePieces.register(bootstrapcontext, "village/desert/houses", new WorldGenFeatureDefinedStructurePoolTemplate(holder5, ImmutableList.of(Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/desert/houses/desert_small_house_1"), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/desert/houses/desert_small_house_2"), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/desert/houses/desert_small_house_3"), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/desert/houses/desert_small_house_4"), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/desert/houses/desert_small_house_5"), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/desert/houses/desert_small_house_6"), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/desert/houses/desert_small_house_7"), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/desert/houses/desert_small_house_8"), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/desert/houses/desert_medium_house_1"), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/desert/houses/desert_medium_house_2"), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/desert/houses/desert_butcher_shop_1"), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/desert/houses/desert_tool_smith_1"), 2), new Pair[]{Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/desert/houses/desert_fletcher_house_1"), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/desert/houses/desert_shepherd_house_1"), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/desert/houses/desert_armorer_1"), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/desert/houses/desert_fisher_1"), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/desert/houses/desert_tannery_1"), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/desert/houses/desert_cartographer_house_1"), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/desert/houses/desert_library_1"), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/desert/houses/desert_mason_1"), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/desert/houses/desert_weaponsmith_1"), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/desert/houses/desert_temple_1"), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/desert/houses/desert_temple_2"), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/desert/houses/desert_large_farm_1", holder3), 11), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/desert/houses/desert_farm_1", holder3), 4), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/desert/houses/desert_farm_2", holder3), 4), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/desert/houses/desert_animal_pen_1"), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/desert/houses/desert_animal_pen_2"), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.empty(), 5)}), WorldGenFeatureDefinedStructurePoolTemplate.Matching.RIGID));
        WorldGenFeaturePieces.register(bootstrapcontext, "village/desert/zombie/houses", new WorldGenFeatureDefinedStructurePoolTemplate(holder6, ImmutableList.of(Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/desert/zombie/houses/desert_small_house_1", holder2), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/desert/zombie/houses/desert_small_house_2", holder2), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/desert/zombie/houses/desert_small_house_3", holder2), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/desert/zombie/houses/desert_small_house_4", holder2), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/desert/zombie/houses/desert_small_house_5", holder2), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/desert/zombie/houses/desert_small_house_6", holder2), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/desert/zombie/houses/desert_small_house_7", holder2), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/desert/zombie/houses/desert_small_house_8", holder2), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/desert/zombie/houses/desert_medium_house_1", holder2), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/desert/zombie/houses/desert_medium_house_2", holder2), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/desert/houses/desert_butcher_shop_1", holder2), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/desert/houses/desert_tool_smith_1", holder2), 2), new Pair[]{Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/desert/houses/desert_fletcher_house_1", holder2), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/desert/houses/desert_shepherd_house_1", holder2), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/desert/houses/desert_armorer_1", holder2), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/desert/houses/desert_fisher_1", holder2), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/desert/houses/desert_tannery_1", holder2), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/desert/houses/desert_cartographer_house_1", holder2), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/desert/houses/desert_library_1", holder2), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/desert/houses/desert_mason_1", holder2), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/desert/houses/desert_weaponsmith_1", holder2), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/desert/houses/desert_temple_1", holder2), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/desert/houses/desert_temple_2", holder2), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/desert/houses/desert_large_farm_1", holder2), 7), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/desert/houses/desert_farm_1", holder2), 4), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/desert/houses/desert_farm_2", holder2), 4), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/desert/houses/desert_animal_pen_1", holder2), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/desert/houses/desert_animal_pen_2", holder2), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.empty(), 5)}), WorldGenFeatureDefinedStructurePoolTemplate.Matching.RIGID));
        bootstrapcontext.register(WorldGenFeatureDesertVillage.TERMINATORS_KEY, new WorldGenFeatureDefinedStructurePoolTemplate(holder4, ImmutableList.of(Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/desert/terminators/terminator_01"), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/desert/terminators/terminator_02"), 1)), WorldGenFeatureDefinedStructurePoolTemplate.Matching.TERRAIN_MATCHING));
        bootstrapcontext.register(WorldGenFeatureDesertVillage.ZOMBIE_TERMINATORS_KEY, new WorldGenFeatureDefinedStructurePoolTemplate(holder4, ImmutableList.of(Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/desert/terminators/terminator_01"), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/desert/zombie/terminators/terminator_02"), 1)), WorldGenFeatureDefinedStructurePoolTemplate.Matching.TERRAIN_MATCHING));
        WorldGenFeaturePieces.register(bootstrapcontext, "village/desert/decor", new WorldGenFeatureDefinedStructurePoolTemplate(holder4, ImmutableList.of(Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/desert/desert_lamp_1"), 10), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.feature(holder), 4), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.feature(holder1), 4), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.empty(), 10)), WorldGenFeatureDefinedStructurePoolTemplate.Matching.RIGID));
        WorldGenFeaturePieces.register(bootstrapcontext, "village/desert/zombie/decor", new WorldGenFeatureDefinedStructurePoolTemplate(holder4, ImmutableList.of(Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/desert/desert_lamp_1", holder2), 10), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.feature(holder), 4), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.feature(holder1), 4), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.empty(), 10)), WorldGenFeatureDefinedStructurePoolTemplate.Matching.RIGID));
        WorldGenFeaturePieces.register(bootstrapcontext, "village/desert/villagers", new WorldGenFeatureDefinedStructurePoolTemplate(holder4, ImmutableList.of(Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/desert/villagers/nitwit"), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/desert/villagers/baby"), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/desert/villagers/unemployed"), 10)), WorldGenFeatureDefinedStructurePoolTemplate.Matching.RIGID));
        WorldGenFeaturePieces.register(bootstrapcontext, "village/desert/camel", new WorldGenFeatureDefinedStructurePoolTemplate(holder4, ImmutableList.of(Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/desert/camel_spawn"), 1)), WorldGenFeatureDefinedStructurePoolTemplate.Matching.RIGID));
        WorldGenFeaturePieces.register(bootstrapcontext, "village/desert/zombie/villagers", new WorldGenFeatureDefinedStructurePoolTemplate(holder4, ImmutableList.of(Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/desert/zombie/villagers/nitwit"), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/desert/zombie/villagers/unemployed"), 10)), WorldGenFeatureDefinedStructurePoolTemplate.Matching.RIGID));
    }
}
