package net.minecraft.tags;

import net.minecraft.core.registries.Registries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.level.block.Block;

public final class TagsBlock {

    public static final TagKey<Block> WOOL = create("wool");
    public static final TagKey<Block> PLANKS = create("planks");
    public static final TagKey<Block> STONE_BRICKS = create("stone_bricks");
    public static final TagKey<Block> WOODEN_BUTTONS = create("wooden_buttons");
    public static final TagKey<Block> STONE_BUTTONS = create("stone_buttons");
    public static final TagKey<Block> BUTTONS = create("buttons");
    public static final TagKey<Block> WOOL_CARPETS = create("wool_carpets");
    public static final TagKey<Block> WOODEN_DOORS = create("wooden_doors");
    public static final TagKey<Block> MOB_INTERACTABLE_DOORS = create("mob_interactable_doors");
    public static final TagKey<Block> WOODEN_STAIRS = create("wooden_stairs");
    public static final TagKey<Block> WOODEN_SLABS = create("wooden_slabs");
    public static final TagKey<Block> WOODEN_FENCES = create("wooden_fences");
    public static final TagKey<Block> PRESSURE_PLATES = create("pressure_plates");
    public static final TagKey<Block> WOODEN_PRESSURE_PLATES = create("wooden_pressure_plates");
    public static final TagKey<Block> STONE_PRESSURE_PLATES = create("stone_pressure_plates");
    public static final TagKey<Block> WOODEN_TRAPDOORS = create("wooden_trapdoors");
    public static final TagKey<Block> DOORS = create("doors");
    public static final TagKey<Block> SAPLINGS = create("saplings");
    public static final TagKey<Block> LOGS_THAT_BURN = create("logs_that_burn");
    public static final TagKey<Block> OVERWORLD_NATURAL_LOGS = create("overworld_natural_logs");
    public static final TagKey<Block> LOGS = create("logs");
    public static final TagKey<Block> DARK_OAK_LOGS = create("dark_oak_logs");
    public static final TagKey<Block> OAK_LOGS = create("oak_logs");
    public static final TagKey<Block> BIRCH_LOGS = create("birch_logs");
    public static final TagKey<Block> ACACIA_LOGS = create("acacia_logs");
    public static final TagKey<Block> CHERRY_LOGS = create("cherry_logs");
    public static final TagKey<Block> JUNGLE_LOGS = create("jungle_logs");
    public static final TagKey<Block> SPRUCE_LOGS = create("spruce_logs");
    public static final TagKey<Block> MANGROVE_LOGS = create("mangrove_logs");
    public static final TagKey<Block> CRIMSON_STEMS = create("crimson_stems");
    public static final TagKey<Block> WARPED_STEMS = create("warped_stems");
    public static final TagKey<Block> BAMBOO_BLOCKS = create("bamboo_blocks");
    public static final TagKey<Block> WART_BLOCKS = create("wart_blocks");
    public static final TagKey<Block> BANNERS = create("banners");
    public static final TagKey<Block> SAND = create("sand");
    public static final TagKey<Block> SMELTS_TO_GLASS = create("smelts_to_glass");
    public static final TagKey<Block> STAIRS = create("stairs");
    public static final TagKey<Block> SLABS = create("slabs");
    public static final TagKey<Block> WALLS = create("walls");
    public static final TagKey<Block> ANVIL = create("anvil");
    public static final TagKey<Block> RAILS = create("rails");
    public static final TagKey<Block> LEAVES = create("leaves");
    public static final TagKey<Block> TRAPDOORS = create("trapdoors");
    public static final TagKey<Block> SMALL_FLOWERS = create("small_flowers");
    public static final TagKey<Block> BEDS = create("beds");
    public static final TagKey<Block> FENCES = create("fences");
    public static final TagKey<Block> TALL_FLOWERS = create("tall_flowers");
    public static final TagKey<Block> FLOWERS = create("flowers");
    public static final TagKey<Block> PIGLIN_REPELLENTS = create("piglin_repellents");
    public static final TagKey<Block> GOLD_ORES = create("gold_ores");
    public static final TagKey<Block> IRON_ORES = create("iron_ores");
    public static final TagKey<Block> DIAMOND_ORES = create("diamond_ores");
    public static final TagKey<Block> REDSTONE_ORES = create("redstone_ores");
    public static final TagKey<Block> LAPIS_ORES = create("lapis_ores");
    public static final TagKey<Block> COAL_ORES = create("coal_ores");
    public static final TagKey<Block> EMERALD_ORES = create("emerald_ores");
    public static final TagKey<Block> COPPER_ORES = create("copper_ores");
    public static final TagKey<Block> CANDLES = create("candles");
    public static final TagKey<Block> DIRT = create("dirt");
    public static final TagKey<Block> TERRACOTTA = create("terracotta");
    public static final TagKey<Block> BADLANDS_TERRACOTTA = create("badlands_terracotta");
    public static final TagKey<Block> CONCRETE_POWDER = create("concrete_powder");
    public static final TagKey<Block> COMPLETES_FIND_TREE_TUTORIAL = create("completes_find_tree_tutorial");
    public static final TagKey<Block> FLOWER_POTS = create("flower_pots");
    public static final TagKey<Block> ENDERMAN_HOLDABLE = create("enderman_holdable");
    public static final TagKey<Block> ICE = create("ice");
    public static final TagKey<Block> VALID_SPAWN = create("valid_spawn");
    public static final TagKey<Block> IMPERMEABLE = create("impermeable");
    public static final TagKey<Block> UNDERWATER_BONEMEALS = create("underwater_bonemeals");
    public static final TagKey<Block> CORAL_BLOCKS = create("coral_blocks");
    public static final TagKey<Block> WALL_CORALS = create("wall_corals");
    public static final TagKey<Block> CORAL_PLANTS = create("coral_plants");
    public static final TagKey<Block> CORALS = create("corals");
    public static final TagKey<Block> BAMBOO_PLANTABLE_ON = create("bamboo_plantable_on");
    public static final TagKey<Block> STANDING_SIGNS = create("standing_signs");
    public static final TagKey<Block> WALL_SIGNS = create("wall_signs");
    public static final TagKey<Block> SIGNS = create("signs");
    public static final TagKey<Block> CEILING_HANGING_SIGNS = create("ceiling_hanging_signs");
    public static final TagKey<Block> WALL_HANGING_SIGNS = create("wall_hanging_signs");
    public static final TagKey<Block> ALL_HANGING_SIGNS = create("all_hanging_signs");
    public static final TagKey<Block> ALL_SIGNS = create("all_signs");
    public static final TagKey<Block> DRAGON_IMMUNE = create("dragon_immune");
    public static final TagKey<Block> DRAGON_TRANSPARENT = create("dragon_transparent");
    public static final TagKey<Block> WITHER_IMMUNE = create("wither_immune");
    public static final TagKey<Block> WITHER_SUMMON_BASE_BLOCKS = create("wither_summon_base_blocks");
    public static final TagKey<Block> BEEHIVES = create("beehives");
    public static final TagKey<Block> CROPS = create("crops");
    public static final TagKey<Block> BEE_GROWABLES = create("bee_growables");
    public static final TagKey<Block> PORTALS = create("portals");
    public static final TagKey<Block> FIRE = create("fire");
    public static final TagKey<Block> NYLIUM = create("nylium");
    public static final TagKey<Block> BEACON_BASE_BLOCKS = create("beacon_base_blocks");
    public static final TagKey<Block> SOUL_SPEED_BLOCKS = create("soul_speed_blocks");
    public static final TagKey<Block> WALL_POST_OVERRIDE = create("wall_post_override");
    public static final TagKey<Block> CLIMBABLE = create("climbable");
    public static final TagKey<Block> FALL_DAMAGE_RESETTING = create("fall_damage_resetting");
    public static final TagKey<Block> SHULKER_BOXES = create("shulker_boxes");
    public static final TagKey<Block> HOGLIN_REPELLENTS = create("hoglin_repellents");
    public static final TagKey<Block> SOUL_FIRE_BASE_BLOCKS = create("soul_fire_base_blocks");
    public static final TagKey<Block> STRIDER_WARM_BLOCKS = create("strider_warm_blocks");
    public static final TagKey<Block> CAMPFIRES = create("campfires");
    public static final TagKey<Block> GUARDED_BY_PIGLINS = create("guarded_by_piglins");
    public static final TagKey<Block> PREVENT_MOB_SPAWNING_INSIDE = create("prevent_mob_spawning_inside");
    public static final TagKey<Block> FENCE_GATES = create("fence_gates");
    public static final TagKey<Block> UNSTABLE_BOTTOM_CENTER = create("unstable_bottom_center");
    public static final TagKey<Block> MUSHROOM_GROW_BLOCK = create("mushroom_grow_block");
    public static final TagKey<Block> INFINIBURN_OVERWORLD = create("infiniburn_overworld");
    public static final TagKey<Block> INFINIBURN_NETHER = create("infiniburn_nether");
    public static final TagKey<Block> INFINIBURN_END = create("infiniburn_end");
    public static final TagKey<Block> BASE_STONE_OVERWORLD = create("base_stone_overworld");
    public static final TagKey<Block> STONE_ORE_REPLACEABLES = create("stone_ore_replaceables");
    public static final TagKey<Block> DEEPSLATE_ORE_REPLACEABLES = create("deepslate_ore_replaceables");
    public static final TagKey<Block> BASE_STONE_NETHER = create("base_stone_nether");
    public static final TagKey<Block> OVERWORLD_CARVER_REPLACEABLES = create("overworld_carver_replaceables");
    public static final TagKey<Block> NETHER_CARVER_REPLACEABLES = create("nether_carver_replaceables");
    public static final TagKey<Block> CANDLE_CAKES = create("candle_cakes");
    public static final TagKey<Block> CAULDRONS = create("cauldrons");
    public static final TagKey<Block> CRYSTAL_SOUND_BLOCKS = create("crystal_sound_blocks");
    public static final TagKey<Block> INSIDE_STEP_SOUND_BLOCKS = create("inside_step_sound_blocks");
    public static final TagKey<Block> COMBINATION_STEP_SOUND_BLOCKS = create("combination_step_sound_blocks");
    public static final TagKey<Block> CAMEL_SAND_STEP_SOUND_BLOCKS = create("camel_sand_step_sound_blocks");
    public static final TagKey<Block> OCCLUDES_VIBRATION_SIGNALS = create("occludes_vibration_signals");
    public static final TagKey<Block> DAMPENS_VIBRATIONS = create("dampens_vibrations");
    public static final TagKey<Block> DRIPSTONE_REPLACEABLE = create("dripstone_replaceable_blocks");
    public static final TagKey<Block> CAVE_VINES = create("cave_vines");
    public static final TagKey<Block> MOSS_REPLACEABLE = create("moss_replaceable");
    public static final TagKey<Block> LUSH_GROUND_REPLACEABLE = create("lush_ground_replaceable");
    public static final TagKey<Block> AZALEA_ROOT_REPLACEABLE = create("azalea_root_replaceable");
    public static final TagKey<Block> SMALL_DRIPLEAF_PLACEABLE = create("small_dripleaf_placeable");
    public static final TagKey<Block> BIG_DRIPLEAF_PLACEABLE = create("big_dripleaf_placeable");
    public static final TagKey<Block> SNOW = create("snow");
    public static final TagKey<Block> MINEABLE_WITH_AXE = create("mineable/axe");
    public static final TagKey<Block> MINEABLE_WITH_HOE = create("mineable/hoe");
    public static final TagKey<Block> MINEABLE_WITH_PICKAXE = create("mineable/pickaxe");
    public static final TagKey<Block> MINEABLE_WITH_SHOVEL = create("mineable/shovel");
    public static final TagKey<Block> SWORD_EFFICIENT = create("sword_efficient");
    public static final TagKey<Block> NEEDS_DIAMOND_TOOL = create("needs_diamond_tool");
    public static final TagKey<Block> NEEDS_IRON_TOOL = create("needs_iron_tool");
    public static final TagKey<Block> NEEDS_STONE_TOOL = create("needs_stone_tool");
    public static final TagKey<Block> INCORRECT_FOR_NETHERITE_TOOL = create("incorrect_for_netherite_tool");
    public static final TagKey<Block> INCORRECT_FOR_DIAMOND_TOOL = create("incorrect_for_diamond_tool");
    public static final TagKey<Block> INCORRECT_FOR_IRON_TOOL = create("incorrect_for_iron_tool");
    public static final TagKey<Block> INCORRECT_FOR_STONE_TOOL = create("incorrect_for_stone_tool");
    public static final TagKey<Block> INCORRECT_FOR_GOLD_TOOL = create("incorrect_for_gold_tool");
    public static final TagKey<Block> INCORRECT_FOR_WOODEN_TOOL = create("incorrect_for_wooden_tool");
    public static final TagKey<Block> FEATURES_CANNOT_REPLACE = create("features_cannot_replace");
    public static final TagKey<Block> LAVA_POOL_STONE_CANNOT_REPLACE = create("lava_pool_stone_cannot_replace");
    public static final TagKey<Block> GEODE_INVALID_BLOCKS = create("geode_invalid_blocks");
    public static final TagKey<Block> FROG_PREFER_JUMP_TO = create("frog_prefer_jump_to");
    public static final TagKey<Block> SCULK_REPLACEABLE = create("sculk_replaceable");
    public static final TagKey<Block> SCULK_REPLACEABLE_WORLD_GEN = create("sculk_replaceable_world_gen");
    public static final TagKey<Block> ANCIENT_CITY_REPLACEABLE = create("ancient_city_replaceable");
    public static final TagKey<Block> VIBRATION_RESONATORS = create("vibration_resonators");
    public static final TagKey<Block> ANIMALS_SPAWNABLE_ON = create("animals_spawnable_on");
    public static final TagKey<Block> ARMADILLO_SPAWNABLE_ON = create("armadillo_spawnable_on");
    public static final TagKey<Block> AXOLOTLS_SPAWNABLE_ON = create("axolotls_spawnable_on");
    public static final TagKey<Block> GOATS_SPAWNABLE_ON = create("goats_spawnable_on");
    public static final TagKey<Block> MOOSHROOMS_SPAWNABLE_ON = create("mooshrooms_spawnable_on");
    public static final TagKey<Block> PARROTS_SPAWNABLE_ON = create("parrots_spawnable_on");
    public static final TagKey<Block> POLAR_BEARS_SPAWNABLE_ON_ALTERNATE = create("polar_bears_spawnable_on_alternate");
    public static final TagKey<Block> RABBITS_SPAWNABLE_ON = create("rabbits_spawnable_on");
    public static final TagKey<Block> FOXES_SPAWNABLE_ON = create("foxes_spawnable_on");
    public static final TagKey<Block> WOLVES_SPAWNABLE_ON = create("wolves_spawnable_on");
    public static final TagKey<Block> FROGS_SPAWNABLE_ON = create("frogs_spawnable_on");
    public static final TagKey<Block> AZALEA_GROWS_ON = create("azalea_grows_on");
    public static final TagKey<Block> CONVERTABLE_TO_MUD = create("convertable_to_mud");
    public static final TagKey<Block> MANGROVE_LOGS_CAN_GROW_THROUGH = create("mangrove_logs_can_grow_through");
    public static final TagKey<Block> MANGROVE_ROOTS_CAN_GROW_THROUGH = create("mangrove_roots_can_grow_through");
    public static final TagKey<Block> DEAD_BUSH_MAY_PLACE_ON = create("dead_bush_may_place_on");
    public static final TagKey<Block> SNAPS_GOAT_HORN = create("snaps_goat_horn");
    public static final TagKey<Block> REPLACEABLE_BY_TREES = create("replaceable_by_trees");
    public static final TagKey<Block> SNOW_LAYER_CANNOT_SURVIVE_ON = create("snow_layer_cannot_survive_on");
    public static final TagKey<Block> SNOW_LAYER_CAN_SURVIVE_ON = create("snow_layer_can_survive_on");
    public static final TagKey<Block> INVALID_SPAWN_INSIDE = create("invalid_spawn_inside");
    public static final TagKey<Block> SNIFFER_DIGGABLE_BLOCK = create("sniffer_diggable_block");
    public static final TagKey<Block> SNIFFER_EGG_HATCH_BOOST = create("sniffer_egg_hatch_boost");
    public static final TagKey<Block> TRAIL_RUINS_REPLACEABLE = create("trail_ruins_replaceable");
    public static final TagKey<Block> REPLACEABLE = create("replaceable");
    public static final TagKey<Block> ENCHANTMENT_POWER_PROVIDER = create("enchantment_power_provider");
    public static final TagKey<Block> ENCHANTMENT_POWER_TRANSMITTER = create("enchantment_power_transmitter");
    public static final TagKey<Block> MAINTAINS_FARMLAND = create("maintains_farmland");
    public static final TagKey<Block> BLOCKS_WIND_CHARGE_EXPLOSIONS = create("blocks_wind_charge_explosions");
    public static final TagKey<Block> DOES_NOT_BLOCK_HOPPERS = create("does_not_block_hoppers");
    public static final TagKey<Block> AIR = create("air");

    private TagsBlock() {}

    private static TagKey<Block> create(String s) {
        return TagKey.create(Registries.BLOCK, MinecraftKey.withDefaultNamespace(s));
    }
}
