package net.minecraft.tags;

import net.minecraft.core.registries.Registries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.item.Item;

public final class TagsItem {

    public static final TagKey<Item> WOOL = bind("wool");
    public static final TagKey<Item> PLANKS = bind("planks");
    public static final TagKey<Item> STONE_BRICKS = bind("stone_bricks");
    public static final TagKey<Item> WOODEN_BUTTONS = bind("wooden_buttons");
    public static final TagKey<Item> STONE_BUTTONS = bind("stone_buttons");
    public static final TagKey<Item> BUTTONS = bind("buttons");
    public static final TagKey<Item> WOOL_CARPETS = bind("wool_carpets");
    public static final TagKey<Item> WOODEN_DOORS = bind("wooden_doors");
    public static final TagKey<Item> WOODEN_STAIRS = bind("wooden_stairs");
    public static final TagKey<Item> WOODEN_SLABS = bind("wooden_slabs");
    public static final TagKey<Item> WOODEN_FENCES = bind("wooden_fences");
    public static final TagKey<Item> FENCE_GATES = bind("fence_gates");
    public static final TagKey<Item> WOODEN_PRESSURE_PLATES = bind("wooden_pressure_plates");
    public static final TagKey<Item> WOODEN_TRAPDOORS = bind("wooden_trapdoors");
    public static final TagKey<Item> DOORS = bind("doors");
    public static final TagKey<Item> SAPLINGS = bind("saplings");
    public static final TagKey<Item> LOGS_THAT_BURN = bind("logs_that_burn");
    public static final TagKey<Item> LOGS = bind("logs");
    public static final TagKey<Item> DARK_OAK_LOGS = bind("dark_oak_logs");
    public static final TagKey<Item> OAK_LOGS = bind("oak_logs");
    public static final TagKey<Item> BIRCH_LOGS = bind("birch_logs");
    public static final TagKey<Item> ACACIA_LOGS = bind("acacia_logs");
    public static final TagKey<Item> CHERRY_LOGS = bind("cherry_logs");
    public static final TagKey<Item> JUNGLE_LOGS = bind("jungle_logs");
    public static final TagKey<Item> SPRUCE_LOGS = bind("spruce_logs");
    public static final TagKey<Item> MANGROVE_LOGS = bind("mangrove_logs");
    public static final TagKey<Item> CRIMSON_STEMS = bind("crimson_stems");
    public static final TagKey<Item> WARPED_STEMS = bind("warped_stems");
    public static final TagKey<Item> BAMBOO_BLOCKS = bind("bamboo_blocks");
    public static final TagKey<Item> WART_BLOCKS = bind("wart_blocks");
    public static final TagKey<Item> BANNERS = bind("banners");
    public static final TagKey<Item> SAND = bind("sand");
    public static final TagKey<Item> SMELTS_TO_GLASS = bind("smelts_to_glass");
    public static final TagKey<Item> STAIRS = bind("stairs");
    public static final TagKey<Item> SLABS = bind("slabs");
    public static final TagKey<Item> WALLS = bind("walls");
    public static final TagKey<Item> ANVIL = bind("anvil");
    public static final TagKey<Item> RAILS = bind("rails");
    public static final TagKey<Item> LEAVES = bind("leaves");
    public static final TagKey<Item> TRAPDOORS = bind("trapdoors");
    public static final TagKey<Item> SMALL_FLOWERS = bind("small_flowers");
    public static final TagKey<Item> BEDS = bind("beds");
    public static final TagKey<Item> FENCES = bind("fences");
    public static final TagKey<Item> TALL_FLOWERS = bind("tall_flowers");
    public static final TagKey<Item> FLOWERS = bind("flowers");
    public static final TagKey<Item> PIGLIN_REPELLENTS = bind("piglin_repellents");
    public static final TagKey<Item> PIGLIN_LOVED = bind("piglin_loved");
    public static final TagKey<Item> IGNORED_BY_PIGLIN_BABIES = bind("ignored_by_piglin_babies");
    public static final TagKey<Item> MEAT = bind("meat");
    public static final TagKey<Item> SNIFFER_FOOD = bind("sniffer_food");
    public static final TagKey<Item> PIGLIN_FOOD = bind("piglin_food");
    public static final TagKey<Item> FOX_FOOD = bind("fox_food");
    public static final TagKey<Item> COW_FOOD = bind("cow_food");
    public static final TagKey<Item> GOAT_FOOD = bind("goat_food");
    public static final TagKey<Item> SHEEP_FOOD = bind("sheep_food");
    public static final TagKey<Item> WOLF_FOOD = bind("wolf_food");
    public static final TagKey<Item> CAT_FOOD = bind("cat_food");
    public static final TagKey<Item> HORSE_FOOD = bind("horse_food");
    public static final TagKey<Item> HORSE_TEMPT_ITEMS = bind("horse_tempt_items");
    public static final TagKey<Item> CAMEL_FOOD = bind("camel_food");
    public static final TagKey<Item> ARMADILLO_FOOD = bind("armadillo_food");
    public static final TagKey<Item> BEE_FOOD = bind("bee_food");
    public static final TagKey<Item> CHICKEN_FOOD = bind("chicken_food");
    public static final TagKey<Item> FROG_FOOD = bind("frog_food");
    public static final TagKey<Item> HOGLIN_FOOD = bind("hoglin_food");
    public static final TagKey<Item> LLAMA_FOOD = bind("llama_food");
    public static final TagKey<Item> LLAMA_TEMPT_ITEMS = bind("llama_tempt_items");
    public static final TagKey<Item> OCELOT_FOOD = bind("ocelot_food");
    public static final TagKey<Item> PANDA_FOOD = bind("panda_food");
    public static final TagKey<Item> PIG_FOOD = bind("pig_food");
    public static final TagKey<Item> RABBIT_FOOD = bind("rabbit_food");
    public static final TagKey<Item> STRIDER_FOOD = bind("strider_food");
    public static final TagKey<Item> STRIDER_TEMPT_ITEMS = bind("strider_tempt_items");
    public static final TagKey<Item> TURTLE_FOOD = bind("turtle_food");
    public static final TagKey<Item> PARROT_FOOD = bind("parrot_food");
    public static final TagKey<Item> PARROT_POISONOUS_FOOD = bind("parrot_poisonous_food");
    public static final TagKey<Item> AXOLOTL_FOOD = bind("axolotl_food");
    public static final TagKey<Item> GOLD_ORES = bind("gold_ores");
    public static final TagKey<Item> IRON_ORES = bind("iron_ores");
    public static final TagKey<Item> DIAMOND_ORES = bind("diamond_ores");
    public static final TagKey<Item> REDSTONE_ORES = bind("redstone_ores");
    public static final TagKey<Item> LAPIS_ORES = bind("lapis_ores");
    public static final TagKey<Item> COAL_ORES = bind("coal_ores");
    public static final TagKey<Item> EMERALD_ORES = bind("emerald_ores");
    public static final TagKey<Item> COPPER_ORES = bind("copper_ores");
    public static final TagKey<Item> NON_FLAMMABLE_WOOD = bind("non_flammable_wood");
    public static final TagKey<Item> SOUL_FIRE_BASE_BLOCKS = bind("soul_fire_base_blocks");
    public static final TagKey<Item> CANDLES = bind("candles");
    public static final TagKey<Item> DIRT = bind("dirt");
    public static final TagKey<Item> TERRACOTTA = bind("terracotta");
    public static final TagKey<Item> COMPLETES_FIND_TREE_TUTORIAL = bind("completes_find_tree_tutorial");
    public static final TagKey<Item> BOATS = bind("boats");
    public static final TagKey<Item> CHEST_BOATS = bind("chest_boats");
    public static final TagKey<Item> FISHES = bind("fishes");
    public static final TagKey<Item> SIGNS = bind("signs");
    public static final TagKey<Item> CREEPER_DROP_MUSIC_DISCS = bind("creeper_drop_music_discs");
    public static final TagKey<Item> COALS = bind("coals");
    public static final TagKey<Item> ARROWS = bind("arrows");
    public static final TagKey<Item> LECTERN_BOOKS = bind("lectern_books");
    public static final TagKey<Item> BOOKSHELF_BOOKS = bind("bookshelf_books");
    public static final TagKey<Item> BEACON_PAYMENT_ITEMS = bind("beacon_payment_items");
    public static final TagKey<Item> STONE_TOOL_MATERIALS = bind("stone_tool_materials");
    public static final TagKey<Item> STONE_CRAFTING_MATERIALS = bind("stone_crafting_materials");
    public static final TagKey<Item> FREEZE_IMMUNE_WEARABLES = bind("freeze_immune_wearables");
    public static final TagKey<Item> DAMPENS_VIBRATIONS = bind("dampens_vibrations");
    public static final TagKey<Item> CLUSTER_MAX_HARVESTABLES = bind("cluster_max_harvestables");
    public static final TagKey<Item> COMPASSES = bind("compasses");
    public static final TagKey<Item> HANGING_SIGNS = bind("hanging_signs");
    public static final TagKey<Item> CREEPER_IGNITERS = bind("creeper_igniters");
    public static final TagKey<Item> NOTE_BLOCK_TOP_INSTRUMENTS = bind("noteblock_top_instruments");
    public static final TagKey<Item> FOOT_ARMOR = bind("foot_armor");
    public static final TagKey<Item> LEG_ARMOR = bind("leg_armor");
    public static final TagKey<Item> CHEST_ARMOR = bind("chest_armor");
    public static final TagKey<Item> HEAD_ARMOR = bind("head_armor");
    public static final TagKey<Item> SKULLS = bind("skulls");
    public static final TagKey<Item> TRIMMABLE_ARMOR = bind("trimmable_armor");
    public static final TagKey<Item> TRIM_MATERIALS = bind("trim_materials");
    public static final TagKey<Item> TRIM_TEMPLATES = bind("trim_templates");
    public static final TagKey<Item> DECORATED_POT_SHERDS = bind("decorated_pot_sherds");
    public static final TagKey<Item> DECORATED_POT_INGREDIENTS = bind("decorated_pot_ingredients");
    public static final TagKey<Item> SWORDS = bind("swords");
    public static final TagKey<Item> AXES = bind("axes");
    public static final TagKey<Item> HOES = bind("hoes");
    public static final TagKey<Item> PICKAXES = bind("pickaxes");
    public static final TagKey<Item> SHOVELS = bind("shovels");
    public static final TagKey<Item> BREAKS_DECORATED_POTS = bind("breaks_decorated_pots");
    public static final TagKey<Item> VILLAGER_PLANTABLE_SEEDS = bind("villager_plantable_seeds");
    public static final TagKey<Item> DYEABLE = bind("dyeable");
    public static final TagKey<Item> FOOT_ARMOR_ENCHANTABLE = bind("enchantable/foot_armor");
    public static final TagKey<Item> LEG_ARMOR_ENCHANTABLE = bind("enchantable/leg_armor");
    public static final TagKey<Item> CHEST_ARMOR_ENCHANTABLE = bind("enchantable/chest_armor");
    public static final TagKey<Item> HEAD_ARMOR_ENCHANTABLE = bind("enchantable/head_armor");
    public static final TagKey<Item> ARMOR_ENCHANTABLE = bind("enchantable/armor");
    public static final TagKey<Item> SWORD_ENCHANTABLE = bind("enchantable/sword");
    public static final TagKey<Item> FIRE_ASPECT_ENCHANTABLE = bind("enchantable/fire_aspect");
    public static final TagKey<Item> SHARP_WEAPON_ENCHANTABLE = bind("enchantable/sharp_weapon");
    public static final TagKey<Item> WEAPON_ENCHANTABLE = bind("enchantable/weapon");
    public static final TagKey<Item> MINING_ENCHANTABLE = bind("enchantable/mining");
    public static final TagKey<Item> MINING_LOOT_ENCHANTABLE = bind("enchantable/mining_loot");
    public static final TagKey<Item> FISHING_ENCHANTABLE = bind("enchantable/fishing");
    public static final TagKey<Item> TRIDENT_ENCHANTABLE = bind("enchantable/trident");
    public static final TagKey<Item> DURABILITY_ENCHANTABLE = bind("enchantable/durability");
    public static final TagKey<Item> BOW_ENCHANTABLE = bind("enchantable/bow");
    public static final TagKey<Item> EQUIPPABLE_ENCHANTABLE = bind("enchantable/equippable");
    public static final TagKey<Item> CROSSBOW_ENCHANTABLE = bind("enchantable/crossbow");
    public static final TagKey<Item> VANISHING_ENCHANTABLE = bind("enchantable/vanishing");
    public static final TagKey<Item> MACE_ENCHANTABLE = bind("enchantable/mace");

    private TagsItem() {}

    private static TagKey<Item> bind(String s) {
        return TagKey.create(Registries.ITEM, MinecraftKey.withDefaultNamespace(s));
    }
}
