package net.minecraft.world.damagesource;

import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;

public interface DamageTypes {

    ResourceKey<DamageType> IN_FIRE = ResourceKey.create(Registries.DAMAGE_TYPE, MinecraftKey.withDefaultNamespace("in_fire"));
    ResourceKey<DamageType> CAMPFIRE = ResourceKey.create(Registries.DAMAGE_TYPE, MinecraftKey.withDefaultNamespace("campfire"));
    ResourceKey<DamageType> LIGHTNING_BOLT = ResourceKey.create(Registries.DAMAGE_TYPE, MinecraftKey.withDefaultNamespace("lightning_bolt"));
    ResourceKey<DamageType> ON_FIRE = ResourceKey.create(Registries.DAMAGE_TYPE, MinecraftKey.withDefaultNamespace("on_fire"));
    ResourceKey<DamageType> LAVA = ResourceKey.create(Registries.DAMAGE_TYPE, MinecraftKey.withDefaultNamespace("lava"));
    ResourceKey<DamageType> HOT_FLOOR = ResourceKey.create(Registries.DAMAGE_TYPE, MinecraftKey.withDefaultNamespace("hot_floor"));
    ResourceKey<DamageType> IN_WALL = ResourceKey.create(Registries.DAMAGE_TYPE, MinecraftKey.withDefaultNamespace("in_wall"));
    ResourceKey<DamageType> CRAMMING = ResourceKey.create(Registries.DAMAGE_TYPE, MinecraftKey.withDefaultNamespace("cramming"));
    ResourceKey<DamageType> DROWN = ResourceKey.create(Registries.DAMAGE_TYPE, MinecraftKey.withDefaultNamespace("drown"));
    ResourceKey<DamageType> STARVE = ResourceKey.create(Registries.DAMAGE_TYPE, MinecraftKey.withDefaultNamespace("starve"));
    ResourceKey<DamageType> CACTUS = ResourceKey.create(Registries.DAMAGE_TYPE, MinecraftKey.withDefaultNamespace("cactus"));
    ResourceKey<DamageType> FALL = ResourceKey.create(Registries.DAMAGE_TYPE, MinecraftKey.withDefaultNamespace("fall"));
    ResourceKey<DamageType> FLY_INTO_WALL = ResourceKey.create(Registries.DAMAGE_TYPE, MinecraftKey.withDefaultNamespace("fly_into_wall"));
    ResourceKey<DamageType> FELL_OUT_OF_WORLD = ResourceKey.create(Registries.DAMAGE_TYPE, MinecraftKey.withDefaultNamespace("out_of_world"));
    ResourceKey<DamageType> GENERIC = ResourceKey.create(Registries.DAMAGE_TYPE, MinecraftKey.withDefaultNamespace("generic"));
    ResourceKey<DamageType> MAGIC = ResourceKey.create(Registries.DAMAGE_TYPE, MinecraftKey.withDefaultNamespace("magic"));
    ResourceKey<DamageType> WITHER = ResourceKey.create(Registries.DAMAGE_TYPE, MinecraftKey.withDefaultNamespace("wither"));
    ResourceKey<DamageType> DRAGON_BREATH = ResourceKey.create(Registries.DAMAGE_TYPE, MinecraftKey.withDefaultNamespace("dragon_breath"));
    ResourceKey<DamageType> DRY_OUT = ResourceKey.create(Registries.DAMAGE_TYPE, MinecraftKey.withDefaultNamespace("dry_out"));
    ResourceKey<DamageType> SWEET_BERRY_BUSH = ResourceKey.create(Registries.DAMAGE_TYPE, MinecraftKey.withDefaultNamespace("sweet_berry_bush"));
    ResourceKey<DamageType> FREEZE = ResourceKey.create(Registries.DAMAGE_TYPE, MinecraftKey.withDefaultNamespace("freeze"));
    ResourceKey<DamageType> STALAGMITE = ResourceKey.create(Registries.DAMAGE_TYPE, MinecraftKey.withDefaultNamespace("stalagmite"));
    ResourceKey<DamageType> FALLING_BLOCK = ResourceKey.create(Registries.DAMAGE_TYPE, MinecraftKey.withDefaultNamespace("falling_block"));
    ResourceKey<DamageType> FALLING_ANVIL = ResourceKey.create(Registries.DAMAGE_TYPE, MinecraftKey.withDefaultNamespace("falling_anvil"));
    ResourceKey<DamageType> FALLING_STALACTITE = ResourceKey.create(Registries.DAMAGE_TYPE, MinecraftKey.withDefaultNamespace("falling_stalactite"));
    ResourceKey<DamageType> STING = ResourceKey.create(Registries.DAMAGE_TYPE, MinecraftKey.withDefaultNamespace("sting"));
    ResourceKey<DamageType> MOB_ATTACK = ResourceKey.create(Registries.DAMAGE_TYPE, MinecraftKey.withDefaultNamespace("mob_attack"));
    ResourceKey<DamageType> MOB_ATTACK_NO_AGGRO = ResourceKey.create(Registries.DAMAGE_TYPE, MinecraftKey.withDefaultNamespace("mob_attack_no_aggro"));
    ResourceKey<DamageType> PLAYER_ATTACK = ResourceKey.create(Registries.DAMAGE_TYPE, MinecraftKey.withDefaultNamespace("player_attack"));
    ResourceKey<DamageType> ARROW = ResourceKey.create(Registries.DAMAGE_TYPE, MinecraftKey.withDefaultNamespace("arrow"));
    ResourceKey<DamageType> TRIDENT = ResourceKey.create(Registries.DAMAGE_TYPE, MinecraftKey.withDefaultNamespace("trident"));
    ResourceKey<DamageType> MOB_PROJECTILE = ResourceKey.create(Registries.DAMAGE_TYPE, MinecraftKey.withDefaultNamespace("mob_projectile"));
    ResourceKey<DamageType> SPIT = ResourceKey.create(Registries.DAMAGE_TYPE, MinecraftKey.withDefaultNamespace("spit"));
    ResourceKey<DamageType> WIND_CHARGE = ResourceKey.create(Registries.DAMAGE_TYPE, MinecraftKey.withDefaultNamespace("wind_charge"));
    ResourceKey<DamageType> FIREWORKS = ResourceKey.create(Registries.DAMAGE_TYPE, MinecraftKey.withDefaultNamespace("fireworks"));
    ResourceKey<DamageType> FIREBALL = ResourceKey.create(Registries.DAMAGE_TYPE, MinecraftKey.withDefaultNamespace("fireball"));
    ResourceKey<DamageType> UNATTRIBUTED_FIREBALL = ResourceKey.create(Registries.DAMAGE_TYPE, MinecraftKey.withDefaultNamespace("unattributed_fireball"));
    ResourceKey<DamageType> WITHER_SKULL = ResourceKey.create(Registries.DAMAGE_TYPE, MinecraftKey.withDefaultNamespace("wither_skull"));
    ResourceKey<DamageType> THROWN = ResourceKey.create(Registries.DAMAGE_TYPE, MinecraftKey.withDefaultNamespace("thrown"));
    ResourceKey<DamageType> INDIRECT_MAGIC = ResourceKey.create(Registries.DAMAGE_TYPE, MinecraftKey.withDefaultNamespace("indirect_magic"));
    ResourceKey<DamageType> THORNS = ResourceKey.create(Registries.DAMAGE_TYPE, MinecraftKey.withDefaultNamespace("thorns"));
    ResourceKey<DamageType> EXPLOSION = ResourceKey.create(Registries.DAMAGE_TYPE, MinecraftKey.withDefaultNamespace("explosion"));
    ResourceKey<DamageType> PLAYER_EXPLOSION = ResourceKey.create(Registries.DAMAGE_TYPE, MinecraftKey.withDefaultNamespace("player_explosion"));
    ResourceKey<DamageType> SONIC_BOOM = ResourceKey.create(Registries.DAMAGE_TYPE, MinecraftKey.withDefaultNamespace("sonic_boom"));
    ResourceKey<DamageType> BAD_RESPAWN_POINT = ResourceKey.create(Registries.DAMAGE_TYPE, MinecraftKey.withDefaultNamespace("bad_respawn_point"));
    ResourceKey<DamageType> OUTSIDE_BORDER = ResourceKey.create(Registries.DAMAGE_TYPE, MinecraftKey.withDefaultNamespace("outside_border"));
    ResourceKey<DamageType> GENERIC_KILL = ResourceKey.create(Registries.DAMAGE_TYPE, MinecraftKey.withDefaultNamespace("generic_kill"));

    static void bootstrap(BootstrapContext<DamageType> bootstrapcontext) {
        bootstrapcontext.register(DamageTypes.IN_FIRE, new DamageType("inFire", 0.1F, DamageEffects.BURNING));
        bootstrapcontext.register(DamageTypes.CAMPFIRE, new DamageType("inFire", 0.1F, DamageEffects.BURNING));
        bootstrapcontext.register(DamageTypes.LIGHTNING_BOLT, new DamageType("lightningBolt", 0.1F));
        bootstrapcontext.register(DamageTypes.ON_FIRE, new DamageType("onFire", 0.0F, DamageEffects.BURNING));
        bootstrapcontext.register(DamageTypes.LAVA, new DamageType("lava", 0.1F, DamageEffects.BURNING));
        bootstrapcontext.register(DamageTypes.HOT_FLOOR, new DamageType("hotFloor", 0.1F, DamageEffects.BURNING));
        bootstrapcontext.register(DamageTypes.IN_WALL, new DamageType("inWall", 0.0F));
        bootstrapcontext.register(DamageTypes.CRAMMING, new DamageType("cramming", 0.0F));
        bootstrapcontext.register(DamageTypes.DROWN, new DamageType("drown", 0.0F, DamageEffects.DROWNING));
        bootstrapcontext.register(DamageTypes.STARVE, new DamageType("starve", 0.0F));
        bootstrapcontext.register(DamageTypes.CACTUS, new DamageType("cactus", 0.1F));
        bootstrapcontext.register(DamageTypes.FALL, new DamageType("fall", DamageScaling.WHEN_CAUSED_BY_LIVING_NON_PLAYER, 0.0F, DamageEffects.HURT, DeathMessageType.FALL_VARIANTS));
        bootstrapcontext.register(DamageTypes.FLY_INTO_WALL, new DamageType("flyIntoWall", 0.0F));
        bootstrapcontext.register(DamageTypes.FELL_OUT_OF_WORLD, new DamageType("outOfWorld", 0.0F));
        bootstrapcontext.register(DamageTypes.GENERIC, new DamageType("generic", 0.0F));
        bootstrapcontext.register(DamageTypes.MAGIC, new DamageType("magic", 0.0F));
        bootstrapcontext.register(DamageTypes.WITHER, new DamageType("wither", 0.0F));
        bootstrapcontext.register(DamageTypes.DRAGON_BREATH, new DamageType("dragonBreath", 0.0F));
        bootstrapcontext.register(DamageTypes.DRY_OUT, new DamageType("dryout", 0.1F));
        bootstrapcontext.register(DamageTypes.SWEET_BERRY_BUSH, new DamageType("sweetBerryBush", 0.1F, DamageEffects.POKING));
        bootstrapcontext.register(DamageTypes.FREEZE, new DamageType("freeze", 0.0F, DamageEffects.FREEZING));
        bootstrapcontext.register(DamageTypes.STALAGMITE, new DamageType("stalagmite", 0.0F));
        bootstrapcontext.register(DamageTypes.FALLING_BLOCK, new DamageType("fallingBlock", 0.1F));
        bootstrapcontext.register(DamageTypes.FALLING_ANVIL, new DamageType("anvil", 0.1F));
        bootstrapcontext.register(DamageTypes.FALLING_STALACTITE, new DamageType("fallingStalactite", 0.1F));
        bootstrapcontext.register(DamageTypes.STING, new DamageType("sting", 0.1F));
        bootstrapcontext.register(DamageTypes.MOB_ATTACK, new DamageType("mob", 0.1F));
        bootstrapcontext.register(DamageTypes.MOB_ATTACK_NO_AGGRO, new DamageType("mob", 0.1F));
        bootstrapcontext.register(DamageTypes.PLAYER_ATTACK, new DamageType("player", 0.1F));
        bootstrapcontext.register(DamageTypes.ARROW, new DamageType("arrow", 0.1F));
        bootstrapcontext.register(DamageTypes.TRIDENT, new DamageType("trident", 0.1F));
        bootstrapcontext.register(DamageTypes.MOB_PROJECTILE, new DamageType("mob", 0.1F));
        bootstrapcontext.register(DamageTypes.SPIT, new DamageType("mob", 0.1F));
        bootstrapcontext.register(DamageTypes.FIREWORKS, new DamageType("fireworks", 0.1F));
        bootstrapcontext.register(DamageTypes.UNATTRIBUTED_FIREBALL, new DamageType("onFire", 0.1F, DamageEffects.BURNING));
        bootstrapcontext.register(DamageTypes.FIREBALL, new DamageType("fireball", 0.1F, DamageEffects.BURNING));
        bootstrapcontext.register(DamageTypes.WITHER_SKULL, new DamageType("witherSkull", 0.1F));
        bootstrapcontext.register(DamageTypes.THROWN, new DamageType("thrown", 0.1F));
        bootstrapcontext.register(DamageTypes.INDIRECT_MAGIC, new DamageType("indirectMagic", 0.0F));
        bootstrapcontext.register(DamageTypes.THORNS, new DamageType("thorns", 0.1F, DamageEffects.THORNS));
        bootstrapcontext.register(DamageTypes.EXPLOSION, new DamageType("explosion", DamageScaling.ALWAYS, 0.1F));
        bootstrapcontext.register(DamageTypes.PLAYER_EXPLOSION, new DamageType("explosion.player", DamageScaling.ALWAYS, 0.1F));
        bootstrapcontext.register(DamageTypes.SONIC_BOOM, new DamageType("sonic_boom", DamageScaling.ALWAYS, 0.0F));
        bootstrapcontext.register(DamageTypes.BAD_RESPAWN_POINT, new DamageType("badRespawnPoint", DamageScaling.ALWAYS, 0.1F, DamageEffects.HURT, DeathMessageType.INTENTIONAL_GAME_DESIGN));
        bootstrapcontext.register(DamageTypes.OUTSIDE_BORDER, new DamageType("outsideBorder", 0.0F));
        bootstrapcontext.register(DamageTypes.GENERIC_KILL, new DamageType("genericKill", 0.0F));
        bootstrapcontext.register(DamageTypes.WIND_CHARGE, new DamageType("mob", 0.1F));
    }
}
