package net.minecraft.world.item;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapEncoder;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.InstrumentTags;
import net.minecraft.tags.PaintingVariantTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.decoration.EntityPainting;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.PotionRegistry;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.Fireworks;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.WeightedRandomEnchant;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LightBlock;
import net.minecraft.world.level.block.SuspiciousEffectHolder;

public class CreativeModeTabs {

    private static final MinecraftKey INVENTORY_BACKGROUND = CreativeModeTab.createTextureLocation("inventory");
    private static final MinecraftKey SEARCH_BACKGROUND = CreativeModeTab.createTextureLocation("item_search");
    private static final ResourceKey<CreativeModeTab> BUILDING_BLOCKS = createKey("building_blocks");
    private static final ResourceKey<CreativeModeTab> COLORED_BLOCKS = createKey("colored_blocks");
    private static final ResourceKey<CreativeModeTab> NATURAL_BLOCKS = createKey("natural_blocks");
    private static final ResourceKey<CreativeModeTab> FUNCTIONAL_BLOCKS = createKey("functional_blocks");
    private static final ResourceKey<CreativeModeTab> REDSTONE_BLOCKS = createKey("redstone_blocks");
    private static final ResourceKey<CreativeModeTab> HOTBAR = createKey("hotbar");
    private static final ResourceKey<CreativeModeTab> SEARCH = createKey("search");
    private static final ResourceKey<CreativeModeTab> TOOLS_AND_UTILITIES = createKey("tools_and_utilities");
    private static final ResourceKey<CreativeModeTab> COMBAT = createKey("combat");
    private static final ResourceKey<CreativeModeTab> FOOD_AND_DRINKS = createKey("food_and_drinks");
    private static final ResourceKey<CreativeModeTab> INGREDIENTS = createKey("ingredients");
    private static final ResourceKey<CreativeModeTab> SPAWN_EGGS = createKey("spawn_eggs");
    private static final ResourceKey<CreativeModeTab> OP_BLOCKS = createKey("op_blocks");
    private static final ResourceKey<CreativeModeTab> INVENTORY = createKey("inventory");
    private static final Comparator<Holder<PaintingVariant>> PAINTING_COMPARATOR = Comparator.comparing(Holder::value, Comparator.comparingInt(PaintingVariant::area).thenComparing(PaintingVariant::width));
    @Nullable
    private static CreativeModeTab.d CACHED_PARAMETERS;

    public CreativeModeTabs() {}

    private static ResourceKey<CreativeModeTab> createKey(String s) {
        return ResourceKey.create(Registries.CREATIVE_MODE_TAB, MinecraftKey.withDefaultNamespace(s));
    }

    public static CreativeModeTab bootstrap(IRegistry<CreativeModeTab> iregistry) {
        IRegistry.register(iregistry, CreativeModeTabs.BUILDING_BLOCKS, CreativeModeTab.builder(CreativeModeTab.f.TOP, 0).title(IChatBaseComponent.translatable("itemGroup.buildingBlocks")).icon(() -> {
            return new ItemStack(Blocks.BRICKS);
        }).displayItems((creativemodetab_d, creativemodetab_e) -> {
            creativemodetab_e.accept((IMaterial) Items.OAK_LOG);
            creativemodetab_e.accept((IMaterial) Items.OAK_WOOD);
            creativemodetab_e.accept((IMaterial) Items.STRIPPED_OAK_LOG);
            creativemodetab_e.accept((IMaterial) Items.STRIPPED_OAK_WOOD);
            creativemodetab_e.accept((IMaterial) Items.OAK_PLANKS);
            creativemodetab_e.accept((IMaterial) Items.OAK_STAIRS);
            creativemodetab_e.accept((IMaterial) Items.OAK_SLAB);
            creativemodetab_e.accept((IMaterial) Items.OAK_FENCE);
            creativemodetab_e.accept((IMaterial) Items.OAK_FENCE_GATE);
            creativemodetab_e.accept((IMaterial) Items.OAK_DOOR);
            creativemodetab_e.accept((IMaterial) Items.OAK_TRAPDOOR);
            creativemodetab_e.accept((IMaterial) Items.OAK_PRESSURE_PLATE);
            creativemodetab_e.accept((IMaterial) Items.OAK_BUTTON);
            creativemodetab_e.accept((IMaterial) Items.SPRUCE_LOG);
            creativemodetab_e.accept((IMaterial) Items.SPRUCE_WOOD);
            creativemodetab_e.accept((IMaterial) Items.STRIPPED_SPRUCE_LOG);
            creativemodetab_e.accept((IMaterial) Items.STRIPPED_SPRUCE_WOOD);
            creativemodetab_e.accept((IMaterial) Items.SPRUCE_PLANKS);
            creativemodetab_e.accept((IMaterial) Items.SPRUCE_STAIRS);
            creativemodetab_e.accept((IMaterial) Items.SPRUCE_SLAB);
            creativemodetab_e.accept((IMaterial) Items.SPRUCE_FENCE);
            creativemodetab_e.accept((IMaterial) Items.SPRUCE_FENCE_GATE);
            creativemodetab_e.accept((IMaterial) Items.SPRUCE_DOOR);
            creativemodetab_e.accept((IMaterial) Items.SPRUCE_TRAPDOOR);
            creativemodetab_e.accept((IMaterial) Items.SPRUCE_PRESSURE_PLATE);
            creativemodetab_e.accept((IMaterial) Items.SPRUCE_BUTTON);
            creativemodetab_e.accept((IMaterial) Items.BIRCH_LOG);
            creativemodetab_e.accept((IMaterial) Items.BIRCH_WOOD);
            creativemodetab_e.accept((IMaterial) Items.STRIPPED_BIRCH_LOG);
            creativemodetab_e.accept((IMaterial) Items.STRIPPED_BIRCH_WOOD);
            creativemodetab_e.accept((IMaterial) Items.BIRCH_PLANKS);
            creativemodetab_e.accept((IMaterial) Items.BIRCH_STAIRS);
            creativemodetab_e.accept((IMaterial) Items.BIRCH_SLAB);
            creativemodetab_e.accept((IMaterial) Items.BIRCH_FENCE);
            creativemodetab_e.accept((IMaterial) Items.BIRCH_FENCE_GATE);
            creativemodetab_e.accept((IMaterial) Items.BIRCH_DOOR);
            creativemodetab_e.accept((IMaterial) Items.BIRCH_TRAPDOOR);
            creativemodetab_e.accept((IMaterial) Items.BIRCH_PRESSURE_PLATE);
            creativemodetab_e.accept((IMaterial) Items.BIRCH_BUTTON);
            creativemodetab_e.accept((IMaterial) Items.JUNGLE_LOG);
            creativemodetab_e.accept((IMaterial) Items.JUNGLE_WOOD);
            creativemodetab_e.accept((IMaterial) Items.STRIPPED_JUNGLE_LOG);
            creativemodetab_e.accept((IMaterial) Items.STRIPPED_JUNGLE_WOOD);
            creativemodetab_e.accept((IMaterial) Items.JUNGLE_PLANKS);
            creativemodetab_e.accept((IMaterial) Items.JUNGLE_STAIRS);
            creativemodetab_e.accept((IMaterial) Items.JUNGLE_SLAB);
            creativemodetab_e.accept((IMaterial) Items.JUNGLE_FENCE);
            creativemodetab_e.accept((IMaterial) Items.JUNGLE_FENCE_GATE);
            creativemodetab_e.accept((IMaterial) Items.JUNGLE_DOOR);
            creativemodetab_e.accept((IMaterial) Items.JUNGLE_TRAPDOOR);
            creativemodetab_e.accept((IMaterial) Items.JUNGLE_PRESSURE_PLATE);
            creativemodetab_e.accept((IMaterial) Items.JUNGLE_BUTTON);
            creativemodetab_e.accept((IMaterial) Items.ACACIA_LOG);
            creativemodetab_e.accept((IMaterial) Items.ACACIA_WOOD);
            creativemodetab_e.accept((IMaterial) Items.STRIPPED_ACACIA_LOG);
            creativemodetab_e.accept((IMaterial) Items.STRIPPED_ACACIA_WOOD);
            creativemodetab_e.accept((IMaterial) Items.ACACIA_PLANKS);
            creativemodetab_e.accept((IMaterial) Items.ACACIA_STAIRS);
            creativemodetab_e.accept((IMaterial) Items.ACACIA_SLAB);
            creativemodetab_e.accept((IMaterial) Items.ACACIA_FENCE);
            creativemodetab_e.accept((IMaterial) Items.ACACIA_FENCE_GATE);
            creativemodetab_e.accept((IMaterial) Items.ACACIA_DOOR);
            creativemodetab_e.accept((IMaterial) Items.ACACIA_TRAPDOOR);
            creativemodetab_e.accept((IMaterial) Items.ACACIA_PRESSURE_PLATE);
            creativemodetab_e.accept((IMaterial) Items.ACACIA_BUTTON);
            creativemodetab_e.accept((IMaterial) Items.DARK_OAK_LOG);
            creativemodetab_e.accept((IMaterial) Items.DARK_OAK_WOOD);
            creativemodetab_e.accept((IMaterial) Items.STRIPPED_DARK_OAK_LOG);
            creativemodetab_e.accept((IMaterial) Items.STRIPPED_DARK_OAK_WOOD);
            creativemodetab_e.accept((IMaterial) Items.DARK_OAK_PLANKS);
            creativemodetab_e.accept((IMaterial) Items.DARK_OAK_STAIRS);
            creativemodetab_e.accept((IMaterial) Items.DARK_OAK_SLAB);
            creativemodetab_e.accept((IMaterial) Items.DARK_OAK_FENCE);
            creativemodetab_e.accept((IMaterial) Items.DARK_OAK_FENCE_GATE);
            creativemodetab_e.accept((IMaterial) Items.DARK_OAK_DOOR);
            creativemodetab_e.accept((IMaterial) Items.DARK_OAK_TRAPDOOR);
            creativemodetab_e.accept((IMaterial) Items.DARK_OAK_PRESSURE_PLATE);
            creativemodetab_e.accept((IMaterial) Items.DARK_OAK_BUTTON);
            creativemodetab_e.accept((IMaterial) Items.MANGROVE_LOG);
            creativemodetab_e.accept((IMaterial) Items.MANGROVE_WOOD);
            creativemodetab_e.accept((IMaterial) Items.STRIPPED_MANGROVE_LOG);
            creativemodetab_e.accept((IMaterial) Items.STRIPPED_MANGROVE_WOOD);
            creativemodetab_e.accept((IMaterial) Items.MANGROVE_PLANKS);
            creativemodetab_e.accept((IMaterial) Items.MANGROVE_STAIRS);
            creativemodetab_e.accept((IMaterial) Items.MANGROVE_SLAB);
            creativemodetab_e.accept((IMaterial) Items.MANGROVE_FENCE);
            creativemodetab_e.accept((IMaterial) Items.MANGROVE_FENCE_GATE);
            creativemodetab_e.accept((IMaterial) Items.MANGROVE_DOOR);
            creativemodetab_e.accept((IMaterial) Items.MANGROVE_TRAPDOOR);
            creativemodetab_e.accept((IMaterial) Items.MANGROVE_PRESSURE_PLATE);
            creativemodetab_e.accept((IMaterial) Items.MANGROVE_BUTTON);
            creativemodetab_e.accept((IMaterial) Items.CHERRY_LOG);
            creativemodetab_e.accept((IMaterial) Items.CHERRY_WOOD);
            creativemodetab_e.accept((IMaterial) Items.STRIPPED_CHERRY_LOG);
            creativemodetab_e.accept((IMaterial) Items.STRIPPED_CHERRY_WOOD);
            creativemodetab_e.accept((IMaterial) Items.CHERRY_PLANKS);
            creativemodetab_e.accept((IMaterial) Items.CHERRY_STAIRS);
            creativemodetab_e.accept((IMaterial) Items.CHERRY_SLAB);
            creativemodetab_e.accept((IMaterial) Items.CHERRY_FENCE);
            creativemodetab_e.accept((IMaterial) Items.CHERRY_FENCE_GATE);
            creativemodetab_e.accept((IMaterial) Items.CHERRY_DOOR);
            creativemodetab_e.accept((IMaterial) Items.CHERRY_TRAPDOOR);
            creativemodetab_e.accept((IMaterial) Items.CHERRY_PRESSURE_PLATE);
            creativemodetab_e.accept((IMaterial) Items.CHERRY_BUTTON);
            creativemodetab_e.accept((IMaterial) Items.BAMBOO_BLOCK);
            creativemodetab_e.accept((IMaterial) Items.STRIPPED_BAMBOO_BLOCK);
            creativemodetab_e.accept((IMaterial) Items.BAMBOO_PLANKS);
            creativemodetab_e.accept((IMaterial) Items.BAMBOO_MOSAIC);
            creativemodetab_e.accept((IMaterial) Items.BAMBOO_STAIRS);
            creativemodetab_e.accept((IMaterial) Items.BAMBOO_MOSAIC_STAIRS);
            creativemodetab_e.accept((IMaterial) Items.BAMBOO_SLAB);
            creativemodetab_e.accept((IMaterial) Items.BAMBOO_MOSAIC_SLAB);
            creativemodetab_e.accept((IMaterial) Items.BAMBOO_FENCE);
            creativemodetab_e.accept((IMaterial) Items.BAMBOO_FENCE_GATE);
            creativemodetab_e.accept((IMaterial) Items.BAMBOO_DOOR);
            creativemodetab_e.accept((IMaterial) Items.BAMBOO_TRAPDOOR);
            creativemodetab_e.accept((IMaterial) Items.BAMBOO_PRESSURE_PLATE);
            creativemodetab_e.accept((IMaterial) Items.BAMBOO_BUTTON);
            creativemodetab_e.accept((IMaterial) Items.CRIMSON_STEM);
            creativemodetab_e.accept((IMaterial) Items.CRIMSON_HYPHAE);
            creativemodetab_e.accept((IMaterial) Items.STRIPPED_CRIMSON_STEM);
            creativemodetab_e.accept((IMaterial) Items.STRIPPED_CRIMSON_HYPHAE);
            creativemodetab_e.accept((IMaterial) Items.CRIMSON_PLANKS);
            creativemodetab_e.accept((IMaterial) Items.CRIMSON_STAIRS);
            creativemodetab_e.accept((IMaterial) Items.CRIMSON_SLAB);
            creativemodetab_e.accept((IMaterial) Items.CRIMSON_FENCE);
            creativemodetab_e.accept((IMaterial) Items.CRIMSON_FENCE_GATE);
            creativemodetab_e.accept((IMaterial) Items.CRIMSON_DOOR);
            creativemodetab_e.accept((IMaterial) Items.CRIMSON_TRAPDOOR);
            creativemodetab_e.accept((IMaterial) Items.CRIMSON_PRESSURE_PLATE);
            creativemodetab_e.accept((IMaterial) Items.CRIMSON_BUTTON);
            creativemodetab_e.accept((IMaterial) Items.WARPED_STEM);
            creativemodetab_e.accept((IMaterial) Items.WARPED_HYPHAE);
            creativemodetab_e.accept((IMaterial) Items.STRIPPED_WARPED_STEM);
            creativemodetab_e.accept((IMaterial) Items.STRIPPED_WARPED_HYPHAE);
            creativemodetab_e.accept((IMaterial) Items.WARPED_PLANKS);
            creativemodetab_e.accept((IMaterial) Items.WARPED_STAIRS);
            creativemodetab_e.accept((IMaterial) Items.WARPED_SLAB);
            creativemodetab_e.accept((IMaterial) Items.WARPED_FENCE);
            creativemodetab_e.accept((IMaterial) Items.WARPED_FENCE_GATE);
            creativemodetab_e.accept((IMaterial) Items.WARPED_DOOR);
            creativemodetab_e.accept((IMaterial) Items.WARPED_TRAPDOOR);
            creativemodetab_e.accept((IMaterial) Items.WARPED_PRESSURE_PLATE);
            creativemodetab_e.accept((IMaterial) Items.WARPED_BUTTON);
            creativemodetab_e.accept((IMaterial) Items.STONE);
            creativemodetab_e.accept((IMaterial) Items.STONE_STAIRS);
            creativemodetab_e.accept((IMaterial) Items.STONE_SLAB);
            creativemodetab_e.accept((IMaterial) Items.STONE_PRESSURE_PLATE);
            creativemodetab_e.accept((IMaterial) Items.STONE_BUTTON);
            creativemodetab_e.accept((IMaterial) Items.COBBLESTONE);
            creativemodetab_e.accept((IMaterial) Items.COBBLESTONE_STAIRS);
            creativemodetab_e.accept((IMaterial) Items.COBBLESTONE_SLAB);
            creativemodetab_e.accept((IMaterial) Items.COBBLESTONE_WALL);
            creativemodetab_e.accept((IMaterial) Items.MOSSY_COBBLESTONE);
            creativemodetab_e.accept((IMaterial) Items.MOSSY_COBBLESTONE_STAIRS);
            creativemodetab_e.accept((IMaterial) Items.MOSSY_COBBLESTONE_SLAB);
            creativemodetab_e.accept((IMaterial) Items.MOSSY_COBBLESTONE_WALL);
            creativemodetab_e.accept((IMaterial) Items.SMOOTH_STONE);
            creativemodetab_e.accept((IMaterial) Items.SMOOTH_STONE_SLAB);
            creativemodetab_e.accept((IMaterial) Items.STONE_BRICKS);
            creativemodetab_e.accept((IMaterial) Items.CRACKED_STONE_BRICKS);
            creativemodetab_e.accept((IMaterial) Items.STONE_BRICK_STAIRS);
            creativemodetab_e.accept((IMaterial) Items.STONE_BRICK_SLAB);
            creativemodetab_e.accept((IMaterial) Items.STONE_BRICK_WALL);
            creativemodetab_e.accept((IMaterial) Items.CHISELED_STONE_BRICKS);
            creativemodetab_e.accept((IMaterial) Items.MOSSY_STONE_BRICKS);
            creativemodetab_e.accept((IMaterial) Items.MOSSY_STONE_BRICK_STAIRS);
            creativemodetab_e.accept((IMaterial) Items.MOSSY_STONE_BRICK_SLAB);
            creativemodetab_e.accept((IMaterial) Items.MOSSY_STONE_BRICK_WALL);
            creativemodetab_e.accept((IMaterial) Items.GRANITE);
            creativemodetab_e.accept((IMaterial) Items.GRANITE_STAIRS);
            creativemodetab_e.accept((IMaterial) Items.GRANITE_SLAB);
            creativemodetab_e.accept((IMaterial) Items.GRANITE_WALL);
            creativemodetab_e.accept((IMaterial) Items.POLISHED_GRANITE);
            creativemodetab_e.accept((IMaterial) Items.POLISHED_GRANITE_STAIRS);
            creativemodetab_e.accept((IMaterial) Items.POLISHED_GRANITE_SLAB);
            creativemodetab_e.accept((IMaterial) Items.DIORITE);
            creativemodetab_e.accept((IMaterial) Items.DIORITE_STAIRS);
            creativemodetab_e.accept((IMaterial) Items.DIORITE_SLAB);
            creativemodetab_e.accept((IMaterial) Items.DIORITE_WALL);
            creativemodetab_e.accept((IMaterial) Items.POLISHED_DIORITE);
            creativemodetab_e.accept((IMaterial) Items.POLISHED_DIORITE_STAIRS);
            creativemodetab_e.accept((IMaterial) Items.POLISHED_DIORITE_SLAB);
            creativemodetab_e.accept((IMaterial) Items.ANDESITE);
            creativemodetab_e.accept((IMaterial) Items.ANDESITE_STAIRS);
            creativemodetab_e.accept((IMaterial) Items.ANDESITE_SLAB);
            creativemodetab_e.accept((IMaterial) Items.ANDESITE_WALL);
            creativemodetab_e.accept((IMaterial) Items.POLISHED_ANDESITE);
            creativemodetab_e.accept((IMaterial) Items.POLISHED_ANDESITE_STAIRS);
            creativemodetab_e.accept((IMaterial) Items.POLISHED_ANDESITE_SLAB);
            creativemodetab_e.accept((IMaterial) Items.DEEPSLATE);
            creativemodetab_e.accept((IMaterial) Items.COBBLED_DEEPSLATE);
            creativemodetab_e.accept((IMaterial) Items.COBBLED_DEEPSLATE_STAIRS);
            creativemodetab_e.accept((IMaterial) Items.COBBLED_DEEPSLATE_SLAB);
            creativemodetab_e.accept((IMaterial) Items.COBBLED_DEEPSLATE_WALL);
            creativemodetab_e.accept((IMaterial) Items.CHISELED_DEEPSLATE);
            creativemodetab_e.accept((IMaterial) Items.POLISHED_DEEPSLATE);
            creativemodetab_e.accept((IMaterial) Items.POLISHED_DEEPSLATE_STAIRS);
            creativemodetab_e.accept((IMaterial) Items.POLISHED_DEEPSLATE_SLAB);
            creativemodetab_e.accept((IMaterial) Items.POLISHED_DEEPSLATE_WALL);
            creativemodetab_e.accept((IMaterial) Items.DEEPSLATE_BRICKS);
            creativemodetab_e.accept((IMaterial) Items.CRACKED_DEEPSLATE_BRICKS);
            creativemodetab_e.accept((IMaterial) Items.DEEPSLATE_BRICK_STAIRS);
            creativemodetab_e.accept((IMaterial) Items.DEEPSLATE_BRICK_SLAB);
            creativemodetab_e.accept((IMaterial) Items.DEEPSLATE_BRICK_WALL);
            creativemodetab_e.accept((IMaterial) Items.DEEPSLATE_TILES);
            creativemodetab_e.accept((IMaterial) Items.CRACKED_DEEPSLATE_TILES);
            creativemodetab_e.accept((IMaterial) Items.DEEPSLATE_TILE_STAIRS);
            creativemodetab_e.accept((IMaterial) Items.DEEPSLATE_TILE_SLAB);
            creativemodetab_e.accept((IMaterial) Items.DEEPSLATE_TILE_WALL);
            creativemodetab_e.accept((IMaterial) Items.REINFORCED_DEEPSLATE);
            creativemodetab_e.accept((IMaterial) Items.TUFF);
            creativemodetab_e.accept((IMaterial) Items.TUFF_STAIRS);
            creativemodetab_e.accept((IMaterial) Items.TUFF_SLAB);
            creativemodetab_e.accept((IMaterial) Items.TUFF_WALL);
            creativemodetab_e.accept((IMaterial) Items.CHISELED_TUFF);
            creativemodetab_e.accept((IMaterial) Items.POLISHED_TUFF);
            creativemodetab_e.accept((IMaterial) Items.POLISHED_TUFF_STAIRS);
            creativemodetab_e.accept((IMaterial) Items.POLISHED_TUFF_SLAB);
            creativemodetab_e.accept((IMaterial) Items.POLISHED_TUFF_WALL);
            creativemodetab_e.accept((IMaterial) Items.TUFF_BRICKS);
            creativemodetab_e.accept((IMaterial) Items.TUFF_BRICK_STAIRS);
            creativemodetab_e.accept((IMaterial) Items.TUFF_BRICK_SLAB);
            creativemodetab_e.accept((IMaterial) Items.TUFF_BRICK_WALL);
            creativemodetab_e.accept((IMaterial) Items.CHISELED_TUFF_BRICKS);
            creativemodetab_e.accept((IMaterial) Items.BRICKS);
            creativemodetab_e.accept((IMaterial) Items.BRICK_STAIRS);
            creativemodetab_e.accept((IMaterial) Items.BRICK_SLAB);
            creativemodetab_e.accept((IMaterial) Items.BRICK_WALL);
            creativemodetab_e.accept((IMaterial) Items.PACKED_MUD);
            creativemodetab_e.accept((IMaterial) Items.MUD_BRICKS);
            creativemodetab_e.accept((IMaterial) Items.MUD_BRICK_STAIRS);
            creativemodetab_e.accept((IMaterial) Items.MUD_BRICK_SLAB);
            creativemodetab_e.accept((IMaterial) Items.MUD_BRICK_WALL);
            creativemodetab_e.accept((IMaterial) Items.SANDSTONE);
            creativemodetab_e.accept((IMaterial) Items.SANDSTONE_STAIRS);
            creativemodetab_e.accept((IMaterial) Items.SANDSTONE_SLAB);
            creativemodetab_e.accept((IMaterial) Items.SANDSTONE_WALL);
            creativemodetab_e.accept((IMaterial) Items.CHISELED_SANDSTONE);
            creativemodetab_e.accept((IMaterial) Items.SMOOTH_SANDSTONE);
            creativemodetab_e.accept((IMaterial) Items.SMOOTH_SANDSTONE_STAIRS);
            creativemodetab_e.accept((IMaterial) Items.SMOOTH_SANDSTONE_SLAB);
            creativemodetab_e.accept((IMaterial) Items.CUT_SANDSTONE);
            creativemodetab_e.accept((IMaterial) Items.CUT_STANDSTONE_SLAB);
            creativemodetab_e.accept((IMaterial) Items.RED_SANDSTONE);
            creativemodetab_e.accept((IMaterial) Items.RED_SANDSTONE_STAIRS);
            creativemodetab_e.accept((IMaterial) Items.RED_SANDSTONE_SLAB);
            creativemodetab_e.accept((IMaterial) Items.RED_SANDSTONE_WALL);
            creativemodetab_e.accept((IMaterial) Items.CHISELED_RED_SANDSTONE);
            creativemodetab_e.accept((IMaterial) Items.SMOOTH_RED_SANDSTONE);
            creativemodetab_e.accept((IMaterial) Items.SMOOTH_RED_SANDSTONE_STAIRS);
            creativemodetab_e.accept((IMaterial) Items.SMOOTH_RED_SANDSTONE_SLAB);
            creativemodetab_e.accept((IMaterial) Items.CUT_RED_SANDSTONE);
            creativemodetab_e.accept((IMaterial) Items.CUT_RED_SANDSTONE_SLAB);
            creativemodetab_e.accept((IMaterial) Items.SEA_LANTERN);
            creativemodetab_e.accept((IMaterial) Items.PRISMARINE);
            creativemodetab_e.accept((IMaterial) Items.PRISMARINE_STAIRS);
            creativemodetab_e.accept((IMaterial) Items.PRISMARINE_SLAB);
            creativemodetab_e.accept((IMaterial) Items.PRISMARINE_WALL);
            creativemodetab_e.accept((IMaterial) Items.PRISMARINE_BRICKS);
            creativemodetab_e.accept((IMaterial) Items.PRISMARINE_BRICK_STAIRS);
            creativemodetab_e.accept((IMaterial) Items.PRISMARINE_BRICK_SLAB);
            creativemodetab_e.accept((IMaterial) Items.DARK_PRISMARINE);
            creativemodetab_e.accept((IMaterial) Items.DARK_PRISMARINE_STAIRS);
            creativemodetab_e.accept((IMaterial) Items.DARK_PRISMARINE_SLAB);
            creativemodetab_e.accept((IMaterial) Items.NETHERRACK);
            creativemodetab_e.accept((IMaterial) Items.NETHER_BRICKS);
            creativemodetab_e.accept((IMaterial) Items.CRACKED_NETHER_BRICKS);
            creativemodetab_e.accept((IMaterial) Items.NETHER_BRICK_STAIRS);
            creativemodetab_e.accept((IMaterial) Items.NETHER_BRICK_SLAB);
            creativemodetab_e.accept((IMaterial) Items.NETHER_BRICK_WALL);
            creativemodetab_e.accept((IMaterial) Items.NETHER_BRICK_FENCE);
            creativemodetab_e.accept((IMaterial) Items.CHISELED_NETHER_BRICKS);
            creativemodetab_e.accept((IMaterial) Items.RED_NETHER_BRICKS);
            creativemodetab_e.accept((IMaterial) Items.RED_NETHER_BRICK_STAIRS);
            creativemodetab_e.accept((IMaterial) Items.RED_NETHER_BRICK_SLAB);
            creativemodetab_e.accept((IMaterial) Items.RED_NETHER_BRICK_WALL);
            creativemodetab_e.accept((IMaterial) Items.BASALT);
            creativemodetab_e.accept((IMaterial) Items.SMOOTH_BASALT);
            creativemodetab_e.accept((IMaterial) Items.POLISHED_BASALT);
            creativemodetab_e.accept((IMaterial) Items.BLACKSTONE);
            creativemodetab_e.accept((IMaterial) Items.GILDED_BLACKSTONE);
            creativemodetab_e.accept((IMaterial) Items.BLACKSTONE_STAIRS);
            creativemodetab_e.accept((IMaterial) Items.BLACKSTONE_SLAB);
            creativemodetab_e.accept((IMaterial) Items.BLACKSTONE_WALL);
            creativemodetab_e.accept((IMaterial) Items.CHISELED_POLISHED_BLACKSTONE);
            creativemodetab_e.accept((IMaterial) Items.POLISHED_BLACKSTONE);
            creativemodetab_e.accept((IMaterial) Items.POLISHED_BLACKSTONE_STAIRS);
            creativemodetab_e.accept((IMaterial) Items.POLISHED_BLACKSTONE_SLAB);
            creativemodetab_e.accept((IMaterial) Items.POLISHED_BLACKSTONE_WALL);
            creativemodetab_e.accept((IMaterial) Items.POLISHED_BLACKSTONE_PRESSURE_PLATE);
            creativemodetab_e.accept((IMaterial) Items.POLISHED_BLACKSTONE_BUTTON);
            creativemodetab_e.accept((IMaterial) Items.POLISHED_BLACKSTONE_BRICKS);
            creativemodetab_e.accept((IMaterial) Items.CRACKED_POLISHED_BLACKSTONE_BRICKS);
            creativemodetab_e.accept((IMaterial) Items.POLISHED_BLACKSTONE_BRICK_STAIRS);
            creativemodetab_e.accept((IMaterial) Items.POLISHED_BLACKSTONE_BRICK_SLAB);
            creativemodetab_e.accept((IMaterial) Items.POLISHED_BLACKSTONE_BRICK_WALL);
            creativemodetab_e.accept((IMaterial) Items.END_STONE);
            creativemodetab_e.accept((IMaterial) Items.END_STONE_BRICKS);
            creativemodetab_e.accept((IMaterial) Items.END_STONE_BRICK_STAIRS);
            creativemodetab_e.accept((IMaterial) Items.END_STONE_BRICK_SLAB);
            creativemodetab_e.accept((IMaterial) Items.END_STONE_BRICK_WALL);
            creativemodetab_e.accept((IMaterial) Items.PURPUR_BLOCK);
            creativemodetab_e.accept((IMaterial) Items.PURPUR_PILLAR);
            creativemodetab_e.accept((IMaterial) Items.PURPUR_STAIRS);
            creativemodetab_e.accept((IMaterial) Items.PURPUR_SLAB);
            creativemodetab_e.accept((IMaterial) Items.COAL_BLOCK);
            creativemodetab_e.accept((IMaterial) Items.IRON_BLOCK);
            creativemodetab_e.accept((IMaterial) Items.IRON_BARS);
            creativemodetab_e.accept((IMaterial) Items.IRON_DOOR);
            creativemodetab_e.accept((IMaterial) Items.IRON_TRAPDOOR);
            creativemodetab_e.accept((IMaterial) Items.HEAVY_WEIGHTED_PRESSURE_PLATE);
            creativemodetab_e.accept((IMaterial) Items.CHAIN);
            creativemodetab_e.accept((IMaterial) Items.GOLD_BLOCK);
            creativemodetab_e.accept((IMaterial) Items.LIGHT_WEIGHTED_PRESSURE_PLATE);
            creativemodetab_e.accept((IMaterial) Items.REDSTONE_BLOCK);
            creativemodetab_e.accept((IMaterial) Items.EMERALD_BLOCK);
            creativemodetab_e.accept((IMaterial) Items.LAPIS_BLOCK);
            creativemodetab_e.accept((IMaterial) Items.DIAMOND_BLOCK);
            creativemodetab_e.accept((IMaterial) Items.NETHERITE_BLOCK);
            creativemodetab_e.accept((IMaterial) Items.QUARTZ_BLOCK);
            creativemodetab_e.accept((IMaterial) Items.QUARTZ_STAIRS);
            creativemodetab_e.accept((IMaterial) Items.QUARTZ_SLAB);
            creativemodetab_e.accept((IMaterial) Items.CHISELED_QUARTZ_BLOCK);
            creativemodetab_e.accept((IMaterial) Items.QUARTZ_BRICKS);
            creativemodetab_e.accept((IMaterial) Items.QUARTZ_PILLAR);
            creativemodetab_e.accept((IMaterial) Items.SMOOTH_QUARTZ);
            creativemodetab_e.accept((IMaterial) Items.SMOOTH_QUARTZ_STAIRS);
            creativemodetab_e.accept((IMaterial) Items.SMOOTH_QUARTZ_SLAB);
            creativemodetab_e.accept((IMaterial) Items.AMETHYST_BLOCK);
            creativemodetab_e.accept((IMaterial) Items.COPPER_BLOCK);
            creativemodetab_e.accept((IMaterial) Items.CHISELED_COPPER);
            creativemodetab_e.accept((IMaterial) Items.COPPER_GRATE);
            creativemodetab_e.accept((IMaterial) Items.CUT_COPPER);
            creativemodetab_e.accept((IMaterial) Items.CUT_COPPER_STAIRS);
            creativemodetab_e.accept((IMaterial) Items.CUT_COPPER_SLAB);
            creativemodetab_e.accept((IMaterial) Items.COPPER_DOOR);
            creativemodetab_e.accept((IMaterial) Items.COPPER_TRAPDOOR);
            creativemodetab_e.accept((IMaterial) Items.COPPER_BULB);
            creativemodetab_e.accept((IMaterial) Items.EXPOSED_COPPER);
            creativemodetab_e.accept((IMaterial) Items.EXPOSED_CHISELED_COPPER);
            creativemodetab_e.accept((IMaterial) Items.EXPOSED_COPPER_GRATE);
            creativemodetab_e.accept((IMaterial) Items.EXPOSED_CUT_COPPER);
            creativemodetab_e.accept((IMaterial) Items.EXPOSED_CUT_COPPER_STAIRS);
            creativemodetab_e.accept((IMaterial) Items.EXPOSED_CUT_COPPER_SLAB);
            creativemodetab_e.accept((IMaterial) Items.EXPOSED_COPPER_DOOR);
            creativemodetab_e.accept((IMaterial) Items.EXPOSED_COPPER_TRAPDOOR);
            creativemodetab_e.accept((IMaterial) Items.EXPOSED_COPPER_BULB);
            creativemodetab_e.accept((IMaterial) Items.WEATHERED_COPPER);
            creativemodetab_e.accept((IMaterial) Items.WEATHERED_CHISELED_COPPER);
            creativemodetab_e.accept((IMaterial) Items.WEATHERED_COPPER_GRATE);
            creativemodetab_e.accept((IMaterial) Items.WEATHERED_CUT_COPPER);
            creativemodetab_e.accept((IMaterial) Items.WEATHERED_CUT_COPPER_STAIRS);
            creativemodetab_e.accept((IMaterial) Items.WEATHERED_CUT_COPPER_SLAB);
            creativemodetab_e.accept((IMaterial) Items.WEATHERED_COPPER_DOOR);
            creativemodetab_e.accept((IMaterial) Items.WEATHERED_COPPER_TRAPDOOR);
            creativemodetab_e.accept((IMaterial) Items.WEATHERED_COPPER_BULB);
            creativemodetab_e.accept((IMaterial) Items.OXIDIZED_COPPER);
            creativemodetab_e.accept((IMaterial) Items.OXIDIZED_CHISELED_COPPER);
            creativemodetab_e.accept((IMaterial) Items.OXIDIZED_COPPER_GRATE);
            creativemodetab_e.accept((IMaterial) Items.OXIDIZED_CUT_COPPER);
            creativemodetab_e.accept((IMaterial) Items.OXIDIZED_CUT_COPPER_STAIRS);
            creativemodetab_e.accept((IMaterial) Items.OXIDIZED_CUT_COPPER_SLAB);
            creativemodetab_e.accept((IMaterial) Items.OXIDIZED_COPPER_DOOR);
            creativemodetab_e.accept((IMaterial) Items.OXIDIZED_COPPER_TRAPDOOR);
            creativemodetab_e.accept((IMaterial) Items.OXIDIZED_COPPER_BULB);
            creativemodetab_e.accept((IMaterial) Items.WAXED_COPPER_BLOCK);
            creativemodetab_e.accept((IMaterial) Items.WAXED_CHISELED_COPPER);
            creativemodetab_e.accept((IMaterial) Items.WAXED_COPPER_GRATE);
            creativemodetab_e.accept((IMaterial) Items.WAXED_CUT_COPPER);
            creativemodetab_e.accept((IMaterial) Items.WAXED_CUT_COPPER_STAIRS);
            creativemodetab_e.accept((IMaterial) Items.WAXED_CUT_COPPER_SLAB);
            creativemodetab_e.accept((IMaterial) Items.WAXED_COPPER_DOOR);
            creativemodetab_e.accept((IMaterial) Items.WAXED_COPPER_TRAPDOOR);
            creativemodetab_e.accept((IMaterial) Items.WAXED_COPPER_BULB);
            creativemodetab_e.accept((IMaterial) Items.WAXED_EXPOSED_COPPER);
            creativemodetab_e.accept((IMaterial) Items.WAXED_EXPOSED_CHISELED_COPPER);
            creativemodetab_e.accept((IMaterial) Items.WAXED_EXPOSED_COPPER_GRATE);
            creativemodetab_e.accept((IMaterial) Items.WAXED_EXPOSED_CUT_COPPER);
            creativemodetab_e.accept((IMaterial) Items.WAXED_EXPOSED_CUT_COPPER_STAIRS);
            creativemodetab_e.accept((IMaterial) Items.WAXED_EXPOSED_CUT_COPPER_SLAB);
            creativemodetab_e.accept((IMaterial) Items.WAXED_EXPOSED_COPPER_DOOR);
            creativemodetab_e.accept((IMaterial) Items.WAXED_EXPOSED_COPPER_TRAPDOOR);
            creativemodetab_e.accept((IMaterial) Items.WAXED_EXPOSED_COPPER_BULB);
            creativemodetab_e.accept((IMaterial) Items.WAXED_WEATHERED_COPPER);
            creativemodetab_e.accept((IMaterial) Items.WAXED_WEATHERED_CHISELED_COPPER);
            creativemodetab_e.accept((IMaterial) Items.WAXED_WEATHERED_COPPER_GRATE);
            creativemodetab_e.accept((IMaterial) Items.WAXED_WEATHERED_CUT_COPPER);
            creativemodetab_e.accept((IMaterial) Items.WAXED_WEATHERED_CUT_COPPER_STAIRS);
            creativemodetab_e.accept((IMaterial) Items.WAXED_WEATHERED_CUT_COPPER_SLAB);
            creativemodetab_e.accept((IMaterial) Items.WAXED_WEATHERED_COPPER_DOOR);
            creativemodetab_e.accept((IMaterial) Items.WAXED_WEATHERED_COPPER_TRAPDOOR);
            creativemodetab_e.accept((IMaterial) Items.WAXED_WEATHERED_COPPER_BULB);
            creativemodetab_e.accept((IMaterial) Items.WAXED_OXIDIZED_COPPER);
            creativemodetab_e.accept((IMaterial) Items.WAXED_OXIDIZED_CHISELED_COPPER);
            creativemodetab_e.accept((IMaterial) Items.WAXED_OXIDIZED_COPPER_GRATE);
            creativemodetab_e.accept((IMaterial) Items.WAXED_OXIDIZED_CUT_COPPER);
            creativemodetab_e.accept((IMaterial) Items.WAXED_OXIDIZED_CUT_COPPER_STAIRS);
            creativemodetab_e.accept((IMaterial) Items.WAXED_OXIDIZED_CUT_COPPER_SLAB);
            creativemodetab_e.accept((IMaterial) Items.WAXED_OXIDIZED_COPPER_DOOR);
            creativemodetab_e.accept((IMaterial) Items.WAXED_OXIDIZED_COPPER_TRAPDOOR);
            creativemodetab_e.accept((IMaterial) Items.WAXED_OXIDIZED_COPPER_BULB);
        }).build());
        IRegistry.register(iregistry, CreativeModeTabs.COLORED_BLOCKS, CreativeModeTab.builder(CreativeModeTab.f.TOP, 1).title(IChatBaseComponent.translatable("itemGroup.coloredBlocks")).icon(() -> {
            return new ItemStack(Blocks.CYAN_WOOL);
        }).displayItems((creativemodetab_d, creativemodetab_e) -> {
            creativemodetab_e.accept((IMaterial) Items.WHITE_WOOL);
            creativemodetab_e.accept((IMaterial) Items.LIGHT_GRAY_WOOL);
            creativemodetab_e.accept((IMaterial) Items.GRAY_WOOL);
            creativemodetab_e.accept((IMaterial) Items.BLACK_WOOL);
            creativemodetab_e.accept((IMaterial) Items.BROWN_WOOL);
            creativemodetab_e.accept((IMaterial) Items.RED_WOOL);
            creativemodetab_e.accept((IMaterial) Items.ORANGE_WOOL);
            creativemodetab_e.accept((IMaterial) Items.YELLOW_WOOL);
            creativemodetab_e.accept((IMaterial) Items.LIME_WOOL);
            creativemodetab_e.accept((IMaterial) Items.GREEN_WOOL);
            creativemodetab_e.accept((IMaterial) Items.CYAN_WOOL);
            creativemodetab_e.accept((IMaterial) Items.LIGHT_BLUE_WOOL);
            creativemodetab_e.accept((IMaterial) Items.BLUE_WOOL);
            creativemodetab_e.accept((IMaterial) Items.PURPLE_WOOL);
            creativemodetab_e.accept((IMaterial) Items.MAGENTA_WOOL);
            creativemodetab_e.accept((IMaterial) Items.PINK_WOOL);
            creativemodetab_e.accept((IMaterial) Items.WHITE_CARPET);
            creativemodetab_e.accept((IMaterial) Items.LIGHT_GRAY_CARPET);
            creativemodetab_e.accept((IMaterial) Items.GRAY_CARPET);
            creativemodetab_e.accept((IMaterial) Items.BLACK_CARPET);
            creativemodetab_e.accept((IMaterial) Items.BROWN_CARPET);
            creativemodetab_e.accept((IMaterial) Items.RED_CARPET);
            creativemodetab_e.accept((IMaterial) Items.ORANGE_CARPET);
            creativemodetab_e.accept((IMaterial) Items.YELLOW_CARPET);
            creativemodetab_e.accept((IMaterial) Items.LIME_CARPET);
            creativemodetab_e.accept((IMaterial) Items.GREEN_CARPET);
            creativemodetab_e.accept((IMaterial) Items.CYAN_CARPET);
            creativemodetab_e.accept((IMaterial) Items.LIGHT_BLUE_CARPET);
            creativemodetab_e.accept((IMaterial) Items.BLUE_CARPET);
            creativemodetab_e.accept((IMaterial) Items.PURPLE_CARPET);
            creativemodetab_e.accept((IMaterial) Items.MAGENTA_CARPET);
            creativemodetab_e.accept((IMaterial) Items.PINK_CARPET);
            creativemodetab_e.accept((IMaterial) Items.TERRACOTTA);
            creativemodetab_e.accept((IMaterial) Items.WHITE_TERRACOTTA);
            creativemodetab_e.accept((IMaterial) Items.LIGHT_GRAY_TERRACOTTA);
            creativemodetab_e.accept((IMaterial) Items.GRAY_TERRACOTTA);
            creativemodetab_e.accept((IMaterial) Items.BLACK_TERRACOTTA);
            creativemodetab_e.accept((IMaterial) Items.BROWN_TERRACOTTA);
            creativemodetab_e.accept((IMaterial) Items.RED_TERRACOTTA);
            creativemodetab_e.accept((IMaterial) Items.ORANGE_TERRACOTTA);
            creativemodetab_e.accept((IMaterial) Items.YELLOW_TERRACOTTA);
            creativemodetab_e.accept((IMaterial) Items.LIME_TERRACOTTA);
            creativemodetab_e.accept((IMaterial) Items.GREEN_TERRACOTTA);
            creativemodetab_e.accept((IMaterial) Items.CYAN_TERRACOTTA);
            creativemodetab_e.accept((IMaterial) Items.LIGHT_BLUE_TERRACOTTA);
            creativemodetab_e.accept((IMaterial) Items.BLUE_TERRACOTTA);
            creativemodetab_e.accept((IMaterial) Items.PURPLE_TERRACOTTA);
            creativemodetab_e.accept((IMaterial) Items.MAGENTA_TERRACOTTA);
            creativemodetab_e.accept((IMaterial) Items.PINK_TERRACOTTA);
            creativemodetab_e.accept((IMaterial) Items.WHITE_CONCRETE);
            creativemodetab_e.accept((IMaterial) Items.LIGHT_GRAY_CONCRETE);
            creativemodetab_e.accept((IMaterial) Items.GRAY_CONCRETE);
            creativemodetab_e.accept((IMaterial) Items.BLACK_CONCRETE);
            creativemodetab_e.accept((IMaterial) Items.BROWN_CONCRETE);
            creativemodetab_e.accept((IMaterial) Items.RED_CONCRETE);
            creativemodetab_e.accept((IMaterial) Items.ORANGE_CONCRETE);
            creativemodetab_e.accept((IMaterial) Items.YELLOW_CONCRETE);
            creativemodetab_e.accept((IMaterial) Items.LIME_CONCRETE);
            creativemodetab_e.accept((IMaterial) Items.GREEN_CONCRETE);
            creativemodetab_e.accept((IMaterial) Items.CYAN_CONCRETE);
            creativemodetab_e.accept((IMaterial) Items.LIGHT_BLUE_CONCRETE);
            creativemodetab_e.accept((IMaterial) Items.BLUE_CONCRETE);
            creativemodetab_e.accept((IMaterial) Items.PURPLE_CONCRETE);
            creativemodetab_e.accept((IMaterial) Items.MAGENTA_CONCRETE);
            creativemodetab_e.accept((IMaterial) Items.PINK_CONCRETE);
            creativemodetab_e.accept((IMaterial) Items.WHITE_CONCRETE_POWDER);
            creativemodetab_e.accept((IMaterial) Items.LIGHT_GRAY_CONCRETE_POWDER);
            creativemodetab_e.accept((IMaterial) Items.GRAY_CONCRETE_POWDER);
            creativemodetab_e.accept((IMaterial) Items.BLACK_CONCRETE_POWDER);
            creativemodetab_e.accept((IMaterial) Items.BROWN_CONCRETE_POWDER);
            creativemodetab_e.accept((IMaterial) Items.RED_CONCRETE_POWDER);
            creativemodetab_e.accept((IMaterial) Items.ORANGE_CONCRETE_POWDER);
            creativemodetab_e.accept((IMaterial) Items.YELLOW_CONCRETE_POWDER);
            creativemodetab_e.accept((IMaterial) Items.LIME_CONCRETE_POWDER);
            creativemodetab_e.accept((IMaterial) Items.GREEN_CONCRETE_POWDER);
            creativemodetab_e.accept((IMaterial) Items.CYAN_CONCRETE_POWDER);
            creativemodetab_e.accept((IMaterial) Items.LIGHT_BLUE_CONCRETE_POWDER);
            creativemodetab_e.accept((IMaterial) Items.BLUE_CONCRETE_POWDER);
            creativemodetab_e.accept((IMaterial) Items.PURPLE_CONCRETE_POWDER);
            creativemodetab_e.accept((IMaterial) Items.MAGENTA_CONCRETE_POWDER);
            creativemodetab_e.accept((IMaterial) Items.PINK_CONCRETE_POWDER);
            creativemodetab_e.accept((IMaterial) Items.WHITE_GLAZED_TERRACOTTA);
            creativemodetab_e.accept((IMaterial) Items.LIGHT_GRAY_GLAZED_TERRACOTTA);
            creativemodetab_e.accept((IMaterial) Items.GRAY_GLAZED_TERRACOTTA);
            creativemodetab_e.accept((IMaterial) Items.BLACK_GLAZED_TERRACOTTA);
            creativemodetab_e.accept((IMaterial) Items.BROWN_GLAZED_TERRACOTTA);
            creativemodetab_e.accept((IMaterial) Items.RED_GLAZED_TERRACOTTA);
            creativemodetab_e.accept((IMaterial) Items.ORANGE_GLAZED_TERRACOTTA);
            creativemodetab_e.accept((IMaterial) Items.YELLOW_GLAZED_TERRACOTTA);
            creativemodetab_e.accept((IMaterial) Items.LIME_GLAZED_TERRACOTTA);
            creativemodetab_e.accept((IMaterial) Items.GREEN_GLAZED_TERRACOTTA);
            creativemodetab_e.accept((IMaterial) Items.CYAN_GLAZED_TERRACOTTA);
            creativemodetab_e.accept((IMaterial) Items.LIGHT_BLUE_GLAZED_TERRACOTTA);
            creativemodetab_e.accept((IMaterial) Items.BLUE_GLAZED_TERRACOTTA);
            creativemodetab_e.accept((IMaterial) Items.PURPLE_GLAZED_TERRACOTTA);
            creativemodetab_e.accept((IMaterial) Items.MAGENTA_GLAZED_TERRACOTTA);
            creativemodetab_e.accept((IMaterial) Items.PINK_GLAZED_TERRACOTTA);
            creativemodetab_e.accept((IMaterial) Items.GLASS);
            creativemodetab_e.accept((IMaterial) Items.TINTED_GLASS);
            creativemodetab_e.accept((IMaterial) Items.WHITE_STAINED_GLASS);
            creativemodetab_e.accept((IMaterial) Items.LIGHT_GRAY_STAINED_GLASS);
            creativemodetab_e.accept((IMaterial) Items.GRAY_STAINED_GLASS);
            creativemodetab_e.accept((IMaterial) Items.BLACK_STAINED_GLASS);
            creativemodetab_e.accept((IMaterial) Items.BROWN_STAINED_GLASS);
            creativemodetab_e.accept((IMaterial) Items.RED_STAINED_GLASS);
            creativemodetab_e.accept((IMaterial) Items.ORANGE_STAINED_GLASS);
            creativemodetab_e.accept((IMaterial) Items.YELLOW_STAINED_GLASS);
            creativemodetab_e.accept((IMaterial) Items.LIME_STAINED_GLASS);
            creativemodetab_e.accept((IMaterial) Items.GREEN_STAINED_GLASS);
            creativemodetab_e.accept((IMaterial) Items.CYAN_STAINED_GLASS);
            creativemodetab_e.accept((IMaterial) Items.LIGHT_BLUE_STAINED_GLASS);
            creativemodetab_e.accept((IMaterial) Items.BLUE_STAINED_GLASS);
            creativemodetab_e.accept((IMaterial) Items.PURPLE_STAINED_GLASS);
            creativemodetab_e.accept((IMaterial) Items.MAGENTA_STAINED_GLASS);
            creativemodetab_e.accept((IMaterial) Items.PINK_STAINED_GLASS);
            creativemodetab_e.accept((IMaterial) Items.GLASS_PANE);
            creativemodetab_e.accept((IMaterial) Items.WHITE_STAINED_GLASS_PANE);
            creativemodetab_e.accept((IMaterial) Items.LIGHT_GRAY_STAINED_GLASS_PANE);
            creativemodetab_e.accept((IMaterial) Items.GRAY_STAINED_GLASS_PANE);
            creativemodetab_e.accept((IMaterial) Items.BLACK_STAINED_GLASS_PANE);
            creativemodetab_e.accept((IMaterial) Items.BROWN_STAINED_GLASS_PANE);
            creativemodetab_e.accept((IMaterial) Items.RED_STAINED_GLASS_PANE);
            creativemodetab_e.accept((IMaterial) Items.ORANGE_STAINED_GLASS_PANE);
            creativemodetab_e.accept((IMaterial) Items.YELLOW_STAINED_GLASS_PANE);
            creativemodetab_e.accept((IMaterial) Items.LIME_STAINED_GLASS_PANE);
            creativemodetab_e.accept((IMaterial) Items.GREEN_STAINED_GLASS_PANE);
            creativemodetab_e.accept((IMaterial) Items.CYAN_STAINED_GLASS_PANE);
            creativemodetab_e.accept((IMaterial) Items.LIGHT_BLUE_STAINED_GLASS_PANE);
            creativemodetab_e.accept((IMaterial) Items.BLUE_STAINED_GLASS_PANE);
            creativemodetab_e.accept((IMaterial) Items.PURPLE_STAINED_GLASS_PANE);
            creativemodetab_e.accept((IMaterial) Items.MAGENTA_STAINED_GLASS_PANE);
            creativemodetab_e.accept((IMaterial) Items.PINK_STAINED_GLASS_PANE);
            creativemodetab_e.accept((IMaterial) Items.SHULKER_BOX);
            creativemodetab_e.accept((IMaterial) Items.WHITE_SHULKER_BOX);
            creativemodetab_e.accept((IMaterial) Items.LIGHT_GRAY_SHULKER_BOX);
            creativemodetab_e.accept((IMaterial) Items.GRAY_SHULKER_BOX);
            creativemodetab_e.accept((IMaterial) Items.BLACK_SHULKER_BOX);
            creativemodetab_e.accept((IMaterial) Items.BROWN_SHULKER_BOX);
            creativemodetab_e.accept((IMaterial) Items.RED_SHULKER_BOX);
            creativemodetab_e.accept((IMaterial) Items.ORANGE_SHULKER_BOX);
            creativemodetab_e.accept((IMaterial) Items.YELLOW_SHULKER_BOX);
            creativemodetab_e.accept((IMaterial) Items.LIME_SHULKER_BOX);
            creativemodetab_e.accept((IMaterial) Items.GREEN_SHULKER_BOX);
            creativemodetab_e.accept((IMaterial) Items.CYAN_SHULKER_BOX);
            creativemodetab_e.accept((IMaterial) Items.LIGHT_BLUE_SHULKER_BOX);
            creativemodetab_e.accept((IMaterial) Items.BLUE_SHULKER_BOX);
            creativemodetab_e.accept((IMaterial) Items.PURPLE_SHULKER_BOX);
            creativemodetab_e.accept((IMaterial) Items.MAGENTA_SHULKER_BOX);
            creativemodetab_e.accept((IMaterial) Items.PINK_SHULKER_BOX);
            creativemodetab_e.accept((IMaterial) Items.WHITE_BED);
            creativemodetab_e.accept((IMaterial) Items.LIGHT_GRAY_BED);
            creativemodetab_e.accept((IMaterial) Items.GRAY_BED);
            creativemodetab_e.accept((IMaterial) Items.BLACK_BED);
            creativemodetab_e.accept((IMaterial) Items.BROWN_BED);
            creativemodetab_e.accept((IMaterial) Items.RED_BED);
            creativemodetab_e.accept((IMaterial) Items.ORANGE_BED);
            creativemodetab_e.accept((IMaterial) Items.YELLOW_BED);
            creativemodetab_e.accept((IMaterial) Items.LIME_BED);
            creativemodetab_e.accept((IMaterial) Items.GREEN_BED);
            creativemodetab_e.accept((IMaterial) Items.CYAN_BED);
            creativemodetab_e.accept((IMaterial) Items.LIGHT_BLUE_BED);
            creativemodetab_e.accept((IMaterial) Items.BLUE_BED);
            creativemodetab_e.accept((IMaterial) Items.PURPLE_BED);
            creativemodetab_e.accept((IMaterial) Items.MAGENTA_BED);
            creativemodetab_e.accept((IMaterial) Items.PINK_BED);
            creativemodetab_e.accept((IMaterial) Items.CANDLE);
            creativemodetab_e.accept((IMaterial) Items.WHITE_CANDLE);
            creativemodetab_e.accept((IMaterial) Items.LIGHT_GRAY_CANDLE);
            creativemodetab_e.accept((IMaterial) Items.GRAY_CANDLE);
            creativemodetab_e.accept((IMaterial) Items.BLACK_CANDLE);
            creativemodetab_e.accept((IMaterial) Items.BROWN_CANDLE);
            creativemodetab_e.accept((IMaterial) Items.RED_CANDLE);
            creativemodetab_e.accept((IMaterial) Items.ORANGE_CANDLE);
            creativemodetab_e.accept((IMaterial) Items.YELLOW_CANDLE);
            creativemodetab_e.accept((IMaterial) Items.LIME_CANDLE);
            creativemodetab_e.accept((IMaterial) Items.GREEN_CANDLE);
            creativemodetab_e.accept((IMaterial) Items.CYAN_CANDLE);
            creativemodetab_e.accept((IMaterial) Items.LIGHT_BLUE_CANDLE);
            creativemodetab_e.accept((IMaterial) Items.BLUE_CANDLE);
            creativemodetab_e.accept((IMaterial) Items.PURPLE_CANDLE);
            creativemodetab_e.accept((IMaterial) Items.MAGENTA_CANDLE);
            creativemodetab_e.accept((IMaterial) Items.PINK_CANDLE);
            creativemodetab_e.accept((IMaterial) Items.WHITE_BANNER);
            creativemodetab_e.accept((IMaterial) Items.LIGHT_GRAY_BANNER);
            creativemodetab_e.accept((IMaterial) Items.GRAY_BANNER);
            creativemodetab_e.accept((IMaterial) Items.BLACK_BANNER);
            creativemodetab_e.accept((IMaterial) Items.BROWN_BANNER);
            creativemodetab_e.accept((IMaterial) Items.RED_BANNER);
            creativemodetab_e.accept((IMaterial) Items.ORANGE_BANNER);
            creativemodetab_e.accept((IMaterial) Items.YELLOW_BANNER);
            creativemodetab_e.accept((IMaterial) Items.LIME_BANNER);
            creativemodetab_e.accept((IMaterial) Items.GREEN_BANNER);
            creativemodetab_e.accept((IMaterial) Items.CYAN_BANNER);
            creativemodetab_e.accept((IMaterial) Items.LIGHT_BLUE_BANNER);
            creativemodetab_e.accept((IMaterial) Items.BLUE_BANNER);
            creativemodetab_e.accept((IMaterial) Items.PURPLE_BANNER);
            creativemodetab_e.accept((IMaterial) Items.MAGENTA_BANNER);
            creativemodetab_e.accept((IMaterial) Items.PINK_BANNER);
        }).build());
        IRegistry.register(iregistry, CreativeModeTabs.NATURAL_BLOCKS, CreativeModeTab.builder(CreativeModeTab.f.TOP, 2).title(IChatBaseComponent.translatable("itemGroup.natural")).icon(() -> {
            return new ItemStack(Blocks.GRASS_BLOCK);
        }).displayItems((creativemodetab_d, creativemodetab_e) -> {
            creativemodetab_e.accept((IMaterial) Items.GRASS_BLOCK);
            creativemodetab_e.accept((IMaterial) Items.PODZOL);
            creativemodetab_e.accept((IMaterial) Items.MYCELIUM);
            creativemodetab_e.accept((IMaterial) Items.DIRT_PATH);
            creativemodetab_e.accept((IMaterial) Items.DIRT);
            creativemodetab_e.accept((IMaterial) Items.COARSE_DIRT);
            creativemodetab_e.accept((IMaterial) Items.ROOTED_DIRT);
            creativemodetab_e.accept((IMaterial) Items.FARMLAND);
            creativemodetab_e.accept((IMaterial) Items.MUD);
            creativemodetab_e.accept((IMaterial) Items.CLAY);
            creativemodetab_e.accept((IMaterial) Items.GRAVEL);
            creativemodetab_e.accept((IMaterial) Items.SAND);
            creativemodetab_e.accept((IMaterial) Items.SANDSTONE);
            creativemodetab_e.accept((IMaterial) Items.RED_SAND);
            creativemodetab_e.accept((IMaterial) Items.RED_SANDSTONE);
            creativemodetab_e.accept((IMaterial) Items.ICE);
            creativemodetab_e.accept((IMaterial) Items.PACKED_ICE);
            creativemodetab_e.accept((IMaterial) Items.BLUE_ICE);
            creativemodetab_e.accept((IMaterial) Items.SNOW_BLOCK);
            creativemodetab_e.accept((IMaterial) Items.SNOW);
            creativemodetab_e.accept((IMaterial) Items.MOSS_BLOCK);
            creativemodetab_e.accept((IMaterial) Items.MOSS_CARPET);
            creativemodetab_e.accept((IMaterial) Items.STONE);
            creativemodetab_e.accept((IMaterial) Items.DEEPSLATE);
            creativemodetab_e.accept((IMaterial) Items.GRANITE);
            creativemodetab_e.accept((IMaterial) Items.DIORITE);
            creativemodetab_e.accept((IMaterial) Items.ANDESITE);
            creativemodetab_e.accept((IMaterial) Items.CALCITE);
            creativemodetab_e.accept((IMaterial) Items.TUFF);
            creativemodetab_e.accept((IMaterial) Items.DRIPSTONE_BLOCK);
            creativemodetab_e.accept((IMaterial) Items.POINTED_DRIPSTONE);
            creativemodetab_e.accept((IMaterial) Items.PRISMARINE);
            creativemodetab_e.accept((IMaterial) Items.MAGMA_BLOCK);
            creativemodetab_e.accept((IMaterial) Items.OBSIDIAN);
            creativemodetab_e.accept((IMaterial) Items.CRYING_OBSIDIAN);
            creativemodetab_e.accept((IMaterial) Items.NETHERRACK);
            creativemodetab_e.accept((IMaterial) Items.CRIMSON_NYLIUM);
            creativemodetab_e.accept((IMaterial) Items.WARPED_NYLIUM);
            creativemodetab_e.accept((IMaterial) Items.SOUL_SAND);
            creativemodetab_e.accept((IMaterial) Items.SOUL_SOIL);
            creativemodetab_e.accept((IMaterial) Items.BONE_BLOCK);
            creativemodetab_e.accept((IMaterial) Items.BLACKSTONE);
            creativemodetab_e.accept((IMaterial) Items.BASALT);
            creativemodetab_e.accept((IMaterial) Items.SMOOTH_BASALT);
            creativemodetab_e.accept((IMaterial) Items.END_STONE);
            creativemodetab_e.accept((IMaterial) Items.COAL_ORE);
            creativemodetab_e.accept((IMaterial) Items.DEEPSLATE_COAL_ORE);
            creativemodetab_e.accept((IMaterial) Items.IRON_ORE);
            creativemodetab_e.accept((IMaterial) Items.DEEPSLATE_IRON_ORE);
            creativemodetab_e.accept((IMaterial) Items.COPPER_ORE);
            creativemodetab_e.accept((IMaterial) Items.DEEPSLATE_COPPER_ORE);
            creativemodetab_e.accept((IMaterial) Items.GOLD_ORE);
            creativemodetab_e.accept((IMaterial) Items.DEEPSLATE_GOLD_ORE);
            creativemodetab_e.accept((IMaterial) Items.REDSTONE_ORE);
            creativemodetab_e.accept((IMaterial) Items.DEEPSLATE_REDSTONE_ORE);
            creativemodetab_e.accept((IMaterial) Items.EMERALD_ORE);
            creativemodetab_e.accept((IMaterial) Items.DEEPSLATE_EMERALD_ORE);
            creativemodetab_e.accept((IMaterial) Items.LAPIS_ORE);
            creativemodetab_e.accept((IMaterial) Items.DEEPSLATE_LAPIS_ORE);
            creativemodetab_e.accept((IMaterial) Items.DIAMOND_ORE);
            creativemodetab_e.accept((IMaterial) Items.DEEPSLATE_DIAMOND_ORE);
            creativemodetab_e.accept((IMaterial) Items.NETHER_GOLD_ORE);
            creativemodetab_e.accept((IMaterial) Items.NETHER_QUARTZ_ORE);
            creativemodetab_e.accept((IMaterial) Items.ANCIENT_DEBRIS);
            creativemodetab_e.accept((IMaterial) Items.RAW_IRON_BLOCK);
            creativemodetab_e.accept((IMaterial) Items.RAW_COPPER_BLOCK);
            creativemodetab_e.accept((IMaterial) Items.RAW_GOLD_BLOCK);
            creativemodetab_e.accept((IMaterial) Items.GLOWSTONE);
            creativemodetab_e.accept((IMaterial) Items.AMETHYST_BLOCK);
            creativemodetab_e.accept((IMaterial) Items.BUDDING_AMETHYST);
            creativemodetab_e.accept((IMaterial) Items.SMALL_AMETHYST_BUD);
            creativemodetab_e.accept((IMaterial) Items.MEDIUM_AMETHYST_BUD);
            creativemodetab_e.accept((IMaterial) Items.LARGE_AMETHYST_BUD);
            creativemodetab_e.accept((IMaterial) Items.AMETHYST_CLUSTER);
            creativemodetab_e.accept((IMaterial) Items.OAK_LOG);
            creativemodetab_e.accept((IMaterial) Items.SPRUCE_LOG);
            creativemodetab_e.accept((IMaterial) Items.BIRCH_LOG);
            creativemodetab_e.accept((IMaterial) Items.JUNGLE_LOG);
            creativemodetab_e.accept((IMaterial) Items.ACACIA_LOG);
            creativemodetab_e.accept((IMaterial) Items.DARK_OAK_LOG);
            creativemodetab_e.accept((IMaterial) Items.MANGROVE_LOG);
            creativemodetab_e.accept((IMaterial) Items.MANGROVE_ROOTS);
            creativemodetab_e.accept((IMaterial) Items.MUDDY_MANGROVE_ROOTS);
            creativemodetab_e.accept((IMaterial) Items.CHERRY_LOG);
            creativemodetab_e.accept((IMaterial) Items.MUSHROOM_STEM);
            creativemodetab_e.accept((IMaterial) Items.CRIMSON_STEM);
            creativemodetab_e.accept((IMaterial) Items.WARPED_STEM);
            creativemodetab_e.accept((IMaterial) Items.OAK_LEAVES);
            creativemodetab_e.accept((IMaterial) Items.SPRUCE_LEAVES);
            creativemodetab_e.accept((IMaterial) Items.BIRCH_LEAVES);
            creativemodetab_e.accept((IMaterial) Items.JUNGLE_LEAVES);
            creativemodetab_e.accept((IMaterial) Items.ACACIA_LEAVES);
            creativemodetab_e.accept((IMaterial) Items.DARK_OAK_LEAVES);
            creativemodetab_e.accept((IMaterial) Items.MANGROVE_LEAVES);
            creativemodetab_e.accept((IMaterial) Items.CHERRY_LEAVES);
            creativemodetab_e.accept((IMaterial) Items.AZALEA_LEAVES);
            creativemodetab_e.accept((IMaterial) Items.FLOWERING_AZALEA_LEAVES);
            creativemodetab_e.accept((IMaterial) Items.BROWN_MUSHROOM_BLOCK);
            creativemodetab_e.accept((IMaterial) Items.RED_MUSHROOM_BLOCK);
            creativemodetab_e.accept((IMaterial) Items.NETHER_WART_BLOCK);
            creativemodetab_e.accept((IMaterial) Items.WARPED_WART_BLOCK);
            creativemodetab_e.accept((IMaterial) Items.SHROOMLIGHT);
            creativemodetab_e.accept((IMaterial) Items.OAK_SAPLING);
            creativemodetab_e.accept((IMaterial) Items.SPRUCE_SAPLING);
            creativemodetab_e.accept((IMaterial) Items.BIRCH_SAPLING);
            creativemodetab_e.accept((IMaterial) Items.JUNGLE_SAPLING);
            creativemodetab_e.accept((IMaterial) Items.ACACIA_SAPLING);
            creativemodetab_e.accept((IMaterial) Items.DARK_OAK_SAPLING);
            creativemodetab_e.accept((IMaterial) Items.MANGROVE_PROPAGULE);
            creativemodetab_e.accept((IMaterial) Items.CHERRY_SAPLING);
            creativemodetab_e.accept((IMaterial) Items.AZALEA);
            creativemodetab_e.accept((IMaterial) Items.FLOWERING_AZALEA);
            creativemodetab_e.accept((IMaterial) Items.BROWN_MUSHROOM);
            creativemodetab_e.accept((IMaterial) Items.RED_MUSHROOM);
            creativemodetab_e.accept((IMaterial) Items.CRIMSON_FUNGUS);
            creativemodetab_e.accept((IMaterial) Items.WARPED_FUNGUS);
            creativemodetab_e.accept((IMaterial) Items.SHORT_GRASS);
            creativemodetab_e.accept((IMaterial) Items.FERN);
            creativemodetab_e.accept((IMaterial) Items.DEAD_BUSH);
            creativemodetab_e.accept((IMaterial) Items.DANDELION);
            creativemodetab_e.accept((IMaterial) Items.POPPY);
            creativemodetab_e.accept((IMaterial) Items.BLUE_ORCHID);
            creativemodetab_e.accept((IMaterial) Items.ALLIUM);
            creativemodetab_e.accept((IMaterial) Items.AZURE_BLUET);
            creativemodetab_e.accept((IMaterial) Items.RED_TULIP);
            creativemodetab_e.accept((IMaterial) Items.ORANGE_TULIP);
            creativemodetab_e.accept((IMaterial) Items.WHITE_TULIP);
            creativemodetab_e.accept((IMaterial) Items.PINK_TULIP);
            creativemodetab_e.accept((IMaterial) Items.OXEYE_DAISY);
            creativemodetab_e.accept((IMaterial) Items.CORNFLOWER);
            creativemodetab_e.accept((IMaterial) Items.LILY_OF_THE_VALLEY);
            creativemodetab_e.accept((IMaterial) Items.TORCHFLOWER);
            creativemodetab_e.accept((IMaterial) Items.WITHER_ROSE);
            creativemodetab_e.accept((IMaterial) Items.PINK_PETALS);
            creativemodetab_e.accept((IMaterial) Items.SPORE_BLOSSOM);
            creativemodetab_e.accept((IMaterial) Items.BAMBOO);
            creativemodetab_e.accept((IMaterial) Items.SUGAR_CANE);
            creativemodetab_e.accept((IMaterial) Items.CACTUS);
            creativemodetab_e.accept((IMaterial) Items.CRIMSON_ROOTS);
            creativemodetab_e.accept((IMaterial) Items.WARPED_ROOTS);
            creativemodetab_e.accept((IMaterial) Items.NETHER_SPROUTS);
            creativemodetab_e.accept((IMaterial) Items.WEEPING_VINES);
            creativemodetab_e.accept((IMaterial) Items.TWISTING_VINES);
            creativemodetab_e.accept((IMaterial) Items.VINE);
            creativemodetab_e.accept((IMaterial) Items.TALL_GRASS);
            creativemodetab_e.accept((IMaterial) Items.LARGE_FERN);
            creativemodetab_e.accept((IMaterial) Items.SUNFLOWER);
            creativemodetab_e.accept((IMaterial) Items.LILAC);
            creativemodetab_e.accept((IMaterial) Items.ROSE_BUSH);
            creativemodetab_e.accept((IMaterial) Items.PEONY);
            creativemodetab_e.accept((IMaterial) Items.PITCHER_PLANT);
            creativemodetab_e.accept((IMaterial) Items.BIG_DRIPLEAF);
            creativemodetab_e.accept((IMaterial) Items.SMALL_DRIPLEAF);
            creativemodetab_e.accept((IMaterial) Items.CHORUS_PLANT);
            creativemodetab_e.accept((IMaterial) Items.CHORUS_FLOWER);
            creativemodetab_e.accept((IMaterial) Items.GLOW_LICHEN);
            creativemodetab_e.accept((IMaterial) Items.HANGING_ROOTS);
            creativemodetab_e.accept((IMaterial) Items.FROGSPAWN);
            creativemodetab_e.accept((IMaterial) Items.TURTLE_EGG);
            creativemodetab_e.accept((IMaterial) Items.SNIFFER_EGG);
            creativemodetab_e.accept((IMaterial) Items.WHEAT_SEEDS);
            creativemodetab_e.accept((IMaterial) Items.COCOA_BEANS);
            creativemodetab_e.accept((IMaterial) Items.PUMPKIN_SEEDS);
            creativemodetab_e.accept((IMaterial) Items.MELON_SEEDS);
            creativemodetab_e.accept((IMaterial) Items.BEETROOT_SEEDS);
            creativemodetab_e.accept((IMaterial) Items.TORCHFLOWER_SEEDS);
            creativemodetab_e.accept((IMaterial) Items.PITCHER_POD);
            creativemodetab_e.accept((IMaterial) Items.GLOW_BERRIES);
            creativemodetab_e.accept((IMaterial) Items.SWEET_BERRIES);
            creativemodetab_e.accept((IMaterial) Items.NETHER_WART);
            creativemodetab_e.accept((IMaterial) Items.LILY_PAD);
            creativemodetab_e.accept((IMaterial) Items.SEAGRASS);
            creativemodetab_e.accept((IMaterial) Items.SEA_PICKLE);
            creativemodetab_e.accept((IMaterial) Items.KELP);
            creativemodetab_e.accept((IMaterial) Items.DRIED_KELP_BLOCK);
            creativemodetab_e.accept((IMaterial) Items.TUBE_CORAL_BLOCK);
            creativemodetab_e.accept((IMaterial) Items.BRAIN_CORAL_BLOCK);
            creativemodetab_e.accept((IMaterial) Items.BUBBLE_CORAL_BLOCK);
            creativemodetab_e.accept((IMaterial) Items.FIRE_CORAL_BLOCK);
            creativemodetab_e.accept((IMaterial) Items.HORN_CORAL_BLOCK);
            creativemodetab_e.accept((IMaterial) Items.DEAD_TUBE_CORAL_BLOCK);
            creativemodetab_e.accept((IMaterial) Items.DEAD_BRAIN_CORAL_BLOCK);
            creativemodetab_e.accept((IMaterial) Items.DEAD_BUBBLE_CORAL_BLOCK);
            creativemodetab_e.accept((IMaterial) Items.DEAD_FIRE_CORAL_BLOCK);
            creativemodetab_e.accept((IMaterial) Items.DEAD_HORN_CORAL_BLOCK);
            creativemodetab_e.accept((IMaterial) Items.TUBE_CORAL);
            creativemodetab_e.accept((IMaterial) Items.BRAIN_CORAL);
            creativemodetab_e.accept((IMaterial) Items.BUBBLE_CORAL);
            creativemodetab_e.accept((IMaterial) Items.FIRE_CORAL);
            creativemodetab_e.accept((IMaterial) Items.HORN_CORAL);
            creativemodetab_e.accept((IMaterial) Items.DEAD_TUBE_CORAL);
            creativemodetab_e.accept((IMaterial) Items.DEAD_BRAIN_CORAL);
            creativemodetab_e.accept((IMaterial) Items.DEAD_BUBBLE_CORAL);
            creativemodetab_e.accept((IMaterial) Items.DEAD_FIRE_CORAL);
            creativemodetab_e.accept((IMaterial) Items.DEAD_HORN_CORAL);
            creativemodetab_e.accept((IMaterial) Items.TUBE_CORAL_FAN);
            creativemodetab_e.accept((IMaterial) Items.BRAIN_CORAL_FAN);
            creativemodetab_e.accept((IMaterial) Items.BUBBLE_CORAL_FAN);
            creativemodetab_e.accept((IMaterial) Items.FIRE_CORAL_FAN);
            creativemodetab_e.accept((IMaterial) Items.HORN_CORAL_FAN);
            creativemodetab_e.accept((IMaterial) Items.DEAD_TUBE_CORAL_FAN);
            creativemodetab_e.accept((IMaterial) Items.DEAD_BRAIN_CORAL_FAN);
            creativemodetab_e.accept((IMaterial) Items.DEAD_BUBBLE_CORAL_FAN);
            creativemodetab_e.accept((IMaterial) Items.DEAD_FIRE_CORAL_FAN);
            creativemodetab_e.accept((IMaterial) Items.DEAD_HORN_CORAL_FAN);
            creativemodetab_e.accept((IMaterial) Items.SPONGE);
            creativemodetab_e.accept((IMaterial) Items.WET_SPONGE);
            creativemodetab_e.accept((IMaterial) Items.MELON);
            creativemodetab_e.accept((IMaterial) Items.PUMPKIN);
            creativemodetab_e.accept((IMaterial) Items.CARVED_PUMPKIN);
            creativemodetab_e.accept((IMaterial) Items.JACK_O_LANTERN);
            creativemodetab_e.accept((IMaterial) Items.HAY_BLOCK);
            creativemodetab_e.accept((IMaterial) Items.BEE_NEST);
            creativemodetab_e.accept((IMaterial) Items.HONEYCOMB_BLOCK);
            creativemodetab_e.accept((IMaterial) Items.SLIME_BLOCK);
            creativemodetab_e.accept((IMaterial) Items.HONEY_BLOCK);
            creativemodetab_e.accept((IMaterial) Items.OCHRE_FROGLIGHT);
            creativemodetab_e.accept((IMaterial) Items.VERDANT_FROGLIGHT);
            creativemodetab_e.accept((IMaterial) Items.PEARLESCENT_FROGLIGHT);
            creativemodetab_e.accept((IMaterial) Items.SCULK);
            creativemodetab_e.accept((IMaterial) Items.SCULK_VEIN);
            creativemodetab_e.accept((IMaterial) Items.SCULK_CATALYST);
            creativemodetab_e.accept((IMaterial) Items.SCULK_SHRIEKER);
            creativemodetab_e.accept((IMaterial) Items.SCULK_SENSOR);
            creativemodetab_e.accept((IMaterial) Items.COBWEB);
            creativemodetab_e.accept((IMaterial) Items.BEDROCK);
        }).build());
        IRegistry.register(iregistry, CreativeModeTabs.FUNCTIONAL_BLOCKS, CreativeModeTab.builder(CreativeModeTab.f.TOP, 3).title(IChatBaseComponent.translatable("itemGroup.functional")).icon(() -> {
            return new ItemStack(Items.OAK_SIGN);
        }).displayItems((creativemodetab_d, creativemodetab_e) -> {
            creativemodetab_e.accept((IMaterial) Items.TORCH);
            creativemodetab_e.accept((IMaterial) Items.SOUL_TORCH);
            creativemodetab_e.accept((IMaterial) Items.REDSTONE_TORCH);
            creativemodetab_e.accept((IMaterial) Items.LANTERN);
            creativemodetab_e.accept((IMaterial) Items.SOUL_LANTERN);
            creativemodetab_e.accept((IMaterial) Items.CHAIN);
            creativemodetab_e.accept((IMaterial) Items.END_ROD);
            creativemodetab_e.accept((IMaterial) Items.SEA_LANTERN);
            creativemodetab_e.accept((IMaterial) Items.REDSTONE_LAMP);
            creativemodetab_e.accept((IMaterial) Items.COPPER_BULB);
            creativemodetab_e.accept((IMaterial) Items.EXPOSED_COPPER_BULB);
            creativemodetab_e.accept((IMaterial) Items.WEATHERED_COPPER_BULB);
            creativemodetab_e.accept((IMaterial) Items.OXIDIZED_COPPER_BULB);
            creativemodetab_e.accept((IMaterial) Items.WAXED_COPPER_BULB);
            creativemodetab_e.accept((IMaterial) Items.WAXED_EXPOSED_COPPER_BULB);
            creativemodetab_e.accept((IMaterial) Items.WAXED_WEATHERED_COPPER_BULB);
            creativemodetab_e.accept((IMaterial) Items.WAXED_OXIDIZED_COPPER_BULB);
            creativemodetab_e.accept((IMaterial) Items.GLOWSTONE);
            creativemodetab_e.accept((IMaterial) Items.SHROOMLIGHT);
            creativemodetab_e.accept((IMaterial) Items.OCHRE_FROGLIGHT);
            creativemodetab_e.accept((IMaterial) Items.VERDANT_FROGLIGHT);
            creativemodetab_e.accept((IMaterial) Items.PEARLESCENT_FROGLIGHT);
            creativemodetab_e.accept((IMaterial) Items.CRYING_OBSIDIAN);
            creativemodetab_e.accept((IMaterial) Items.GLOW_LICHEN);
            creativemodetab_e.accept((IMaterial) Items.MAGMA_BLOCK);
            creativemodetab_e.accept((IMaterial) Items.CRAFTING_TABLE);
            creativemodetab_e.accept((IMaterial) Items.STONECUTTER);
            creativemodetab_e.accept((IMaterial) Items.CARTOGRAPHY_TABLE);
            creativemodetab_e.accept((IMaterial) Items.FLETCHING_TABLE);
            creativemodetab_e.accept((IMaterial) Items.SMITHING_TABLE);
            creativemodetab_e.accept((IMaterial) Items.GRINDSTONE);
            creativemodetab_e.accept((IMaterial) Items.LOOM);
            creativemodetab_e.accept((IMaterial) Items.FURNACE);
            creativemodetab_e.accept((IMaterial) Items.SMOKER);
            creativemodetab_e.accept((IMaterial) Items.BLAST_FURNACE);
            creativemodetab_e.accept((IMaterial) Items.CAMPFIRE);
            creativemodetab_e.accept((IMaterial) Items.SOUL_CAMPFIRE);
            creativemodetab_e.accept((IMaterial) Items.ANVIL);
            creativemodetab_e.accept((IMaterial) Items.CHIPPED_ANVIL);
            creativemodetab_e.accept((IMaterial) Items.DAMAGED_ANVIL);
            creativemodetab_e.accept((IMaterial) Items.COMPOSTER);
            creativemodetab_e.accept((IMaterial) Items.NOTE_BLOCK);
            creativemodetab_e.accept((IMaterial) Items.JUKEBOX);
            creativemodetab_e.accept((IMaterial) Items.ENCHANTING_TABLE);
            creativemodetab_e.accept((IMaterial) Items.END_CRYSTAL);
            creativemodetab_e.accept((IMaterial) Items.BREWING_STAND);
            creativemodetab_e.accept((IMaterial) Items.CAULDRON);
            creativemodetab_e.accept((IMaterial) Items.BELL);
            creativemodetab_e.accept((IMaterial) Items.BEACON);
            creativemodetab_e.accept((IMaterial) Items.CONDUIT);
            creativemodetab_e.accept((IMaterial) Items.LODESTONE);
            creativemodetab_e.accept((IMaterial) Items.LADDER);
            creativemodetab_e.accept((IMaterial) Items.SCAFFOLDING);
            creativemodetab_e.accept((IMaterial) Items.BEE_NEST);
            creativemodetab_e.accept((IMaterial) Items.BEEHIVE);
            creativemodetab_e.accept((IMaterial) Items.SUSPICIOUS_SAND);
            creativemodetab_e.accept((IMaterial) Items.SUSPICIOUS_GRAVEL);
            creativemodetab_e.accept((IMaterial) Items.LIGHTNING_ROD);
            creativemodetab_e.accept((IMaterial) Items.FLOWER_POT);
            creativemodetab_e.accept((IMaterial) Items.DECORATED_POT);
            creativemodetab_e.accept((IMaterial) Items.ARMOR_STAND);
            creativemodetab_e.accept((IMaterial) Items.ITEM_FRAME);
            creativemodetab_e.accept((IMaterial) Items.GLOW_ITEM_FRAME);
            creativemodetab_e.accept((IMaterial) Items.PAINTING);
            creativemodetab_d.holders().lookup(Registries.PAINTING_VARIANT).ifPresent((holderlookup_b) -> {
                generatePresetPaintings(creativemodetab_e, creativemodetab_d.holders(), holderlookup_b, (holder) -> {
                    return holder.is(PaintingVariantTags.PLACEABLE);
                }, CreativeModeTab.g.PARENT_AND_SEARCH_TABS);
            });
            creativemodetab_e.accept((IMaterial) Items.BOOKSHELF);
            creativemodetab_e.accept((IMaterial) Items.CHISELED_BOOKSHELF);
            creativemodetab_e.accept((IMaterial) Items.LECTERN);
            creativemodetab_e.accept((IMaterial) Items.TINTED_GLASS);
            creativemodetab_e.accept((IMaterial) Items.OAK_SIGN);
            creativemodetab_e.accept((IMaterial) Items.OAK_HANGING_SIGN);
            creativemodetab_e.accept((IMaterial) Items.SPRUCE_SIGN);
            creativemodetab_e.accept((IMaterial) Items.SPRUCE_HANGING_SIGN);
            creativemodetab_e.accept((IMaterial) Items.BIRCH_SIGN);
            creativemodetab_e.accept((IMaterial) Items.BIRCH_HANGING_SIGN);
            creativemodetab_e.accept((IMaterial) Items.JUNGLE_SIGN);
            creativemodetab_e.accept((IMaterial) Items.JUNGLE_HANGING_SIGN);
            creativemodetab_e.accept((IMaterial) Items.ACACIA_SIGN);
            creativemodetab_e.accept((IMaterial) Items.ACACIA_HANGING_SIGN);
            creativemodetab_e.accept((IMaterial) Items.DARK_OAK_SIGN);
            creativemodetab_e.accept((IMaterial) Items.DARK_OAK_HANGING_SIGN);
            creativemodetab_e.accept((IMaterial) Items.MANGROVE_SIGN);
            creativemodetab_e.accept((IMaterial) Items.MANGROVE_HANGING_SIGN);
            creativemodetab_e.accept((IMaterial) Items.CHERRY_SIGN);
            creativemodetab_e.accept((IMaterial) Items.CHERRY_HANGING_SIGN);
            creativemodetab_e.accept((IMaterial) Items.BAMBOO_SIGN);
            creativemodetab_e.accept((IMaterial) Items.BAMBOO_HANGING_SIGN);
            creativemodetab_e.accept((IMaterial) Items.CRIMSON_SIGN);
            creativemodetab_e.accept((IMaterial) Items.CRIMSON_HANGING_SIGN);
            creativemodetab_e.accept((IMaterial) Items.WARPED_SIGN);
            creativemodetab_e.accept((IMaterial) Items.WARPED_HANGING_SIGN);
            creativemodetab_e.accept((IMaterial) Items.CHEST);
            creativemodetab_e.accept((IMaterial) Items.BARREL);
            creativemodetab_e.accept((IMaterial) Items.ENDER_CHEST);
            creativemodetab_e.accept((IMaterial) Items.SHULKER_BOX);
            creativemodetab_e.accept((IMaterial) Items.WHITE_SHULKER_BOX);
            creativemodetab_e.accept((IMaterial) Items.LIGHT_GRAY_SHULKER_BOX);
            creativemodetab_e.accept((IMaterial) Items.GRAY_SHULKER_BOX);
            creativemodetab_e.accept((IMaterial) Items.BLACK_SHULKER_BOX);
            creativemodetab_e.accept((IMaterial) Items.BROWN_SHULKER_BOX);
            creativemodetab_e.accept((IMaterial) Items.RED_SHULKER_BOX);
            creativemodetab_e.accept((IMaterial) Items.ORANGE_SHULKER_BOX);
            creativemodetab_e.accept((IMaterial) Items.YELLOW_SHULKER_BOX);
            creativemodetab_e.accept((IMaterial) Items.LIME_SHULKER_BOX);
            creativemodetab_e.accept((IMaterial) Items.GREEN_SHULKER_BOX);
            creativemodetab_e.accept((IMaterial) Items.CYAN_SHULKER_BOX);
            creativemodetab_e.accept((IMaterial) Items.LIGHT_BLUE_SHULKER_BOX);
            creativemodetab_e.accept((IMaterial) Items.BLUE_SHULKER_BOX);
            creativemodetab_e.accept((IMaterial) Items.PURPLE_SHULKER_BOX);
            creativemodetab_e.accept((IMaterial) Items.MAGENTA_SHULKER_BOX);
            creativemodetab_e.accept((IMaterial) Items.PINK_SHULKER_BOX);
            creativemodetab_e.accept((IMaterial) Items.RESPAWN_ANCHOR);
            creativemodetab_e.accept((IMaterial) Items.WHITE_BED);
            creativemodetab_e.accept((IMaterial) Items.LIGHT_GRAY_BED);
            creativemodetab_e.accept((IMaterial) Items.GRAY_BED);
            creativemodetab_e.accept((IMaterial) Items.BLACK_BED);
            creativemodetab_e.accept((IMaterial) Items.BROWN_BED);
            creativemodetab_e.accept((IMaterial) Items.RED_BED);
            creativemodetab_e.accept((IMaterial) Items.ORANGE_BED);
            creativemodetab_e.accept((IMaterial) Items.YELLOW_BED);
            creativemodetab_e.accept((IMaterial) Items.LIME_BED);
            creativemodetab_e.accept((IMaterial) Items.GREEN_BED);
            creativemodetab_e.accept((IMaterial) Items.CYAN_BED);
            creativemodetab_e.accept((IMaterial) Items.LIGHT_BLUE_BED);
            creativemodetab_e.accept((IMaterial) Items.BLUE_BED);
            creativemodetab_e.accept((IMaterial) Items.PURPLE_BED);
            creativemodetab_e.accept((IMaterial) Items.MAGENTA_BED);
            creativemodetab_e.accept((IMaterial) Items.PINK_BED);
            creativemodetab_e.accept((IMaterial) Items.CANDLE);
            creativemodetab_e.accept((IMaterial) Items.WHITE_CANDLE);
            creativemodetab_e.accept((IMaterial) Items.LIGHT_GRAY_CANDLE);
            creativemodetab_e.accept((IMaterial) Items.GRAY_CANDLE);
            creativemodetab_e.accept((IMaterial) Items.BLACK_CANDLE);
            creativemodetab_e.accept((IMaterial) Items.BROWN_CANDLE);
            creativemodetab_e.accept((IMaterial) Items.RED_CANDLE);
            creativemodetab_e.accept((IMaterial) Items.ORANGE_CANDLE);
            creativemodetab_e.accept((IMaterial) Items.YELLOW_CANDLE);
            creativemodetab_e.accept((IMaterial) Items.LIME_CANDLE);
            creativemodetab_e.accept((IMaterial) Items.GREEN_CANDLE);
            creativemodetab_e.accept((IMaterial) Items.CYAN_CANDLE);
            creativemodetab_e.accept((IMaterial) Items.LIGHT_BLUE_CANDLE);
            creativemodetab_e.accept((IMaterial) Items.BLUE_CANDLE);
            creativemodetab_e.accept((IMaterial) Items.PURPLE_CANDLE);
            creativemodetab_e.accept((IMaterial) Items.MAGENTA_CANDLE);
            creativemodetab_e.accept((IMaterial) Items.PINK_CANDLE);
            creativemodetab_e.accept((IMaterial) Items.WHITE_BANNER);
            creativemodetab_e.accept((IMaterial) Items.LIGHT_GRAY_BANNER);
            creativemodetab_e.accept((IMaterial) Items.GRAY_BANNER);
            creativemodetab_e.accept((IMaterial) Items.BLACK_BANNER);
            creativemodetab_e.accept((IMaterial) Items.BROWN_BANNER);
            creativemodetab_e.accept((IMaterial) Items.RED_BANNER);
            creativemodetab_e.accept((IMaterial) Items.ORANGE_BANNER);
            creativemodetab_e.accept((IMaterial) Items.YELLOW_BANNER);
            creativemodetab_e.accept((IMaterial) Items.LIME_BANNER);
            creativemodetab_e.accept((IMaterial) Items.GREEN_BANNER);
            creativemodetab_e.accept((IMaterial) Items.CYAN_BANNER);
            creativemodetab_e.accept((IMaterial) Items.LIGHT_BLUE_BANNER);
            creativemodetab_e.accept((IMaterial) Items.BLUE_BANNER);
            creativemodetab_e.accept((IMaterial) Items.PURPLE_BANNER);
            creativemodetab_e.accept((IMaterial) Items.MAGENTA_BANNER);
            creativemodetab_e.accept((IMaterial) Items.PINK_BANNER);
            creativemodetab_e.accept(Raid.getLeaderBannerInstance(creativemodetab_d.holders().lookupOrThrow(Registries.BANNER_PATTERN)));
            creativemodetab_e.accept((IMaterial) Items.SKELETON_SKULL);
            creativemodetab_e.accept((IMaterial) Items.WITHER_SKELETON_SKULL);
            creativemodetab_e.accept((IMaterial) Items.PLAYER_HEAD);
            creativemodetab_e.accept((IMaterial) Items.ZOMBIE_HEAD);
            creativemodetab_e.accept((IMaterial) Items.CREEPER_HEAD);
            creativemodetab_e.accept((IMaterial) Items.PIGLIN_HEAD);
            creativemodetab_e.accept((IMaterial) Items.DRAGON_HEAD);
            creativemodetab_e.accept((IMaterial) Items.DRAGON_EGG);
            creativemodetab_e.accept((IMaterial) Items.END_PORTAL_FRAME);
            creativemodetab_e.accept((IMaterial) Items.ENDER_EYE);
            creativemodetab_e.accept((IMaterial) Items.VAULT);
            creativemodetab_e.accept((IMaterial) Items.INFESTED_STONE);
            creativemodetab_e.accept((IMaterial) Items.INFESTED_COBBLESTONE);
            creativemodetab_e.accept((IMaterial) Items.INFESTED_STONE_BRICKS);
            creativemodetab_e.accept((IMaterial) Items.INFESTED_MOSSY_STONE_BRICKS);
            creativemodetab_e.accept((IMaterial) Items.INFESTED_CRACKED_STONE_BRICKS);
            creativemodetab_e.accept((IMaterial) Items.INFESTED_CHISELED_STONE_BRICKS);
            creativemodetab_e.accept((IMaterial) Items.INFESTED_DEEPSLATE);
        }).build());
        IRegistry.register(iregistry, CreativeModeTabs.REDSTONE_BLOCKS, CreativeModeTab.builder(CreativeModeTab.f.TOP, 4).title(IChatBaseComponent.translatable("itemGroup.redstone")).icon(() -> {
            return new ItemStack(Items.REDSTONE);
        }).displayItems((creativemodetab_d, creativemodetab_e) -> {
            creativemodetab_e.accept((IMaterial) Items.REDSTONE);
            creativemodetab_e.accept((IMaterial) Items.REDSTONE_TORCH);
            creativemodetab_e.accept((IMaterial) Items.REDSTONE_BLOCK);
            creativemodetab_e.accept((IMaterial) Items.REPEATER);
            creativemodetab_e.accept((IMaterial) Items.COMPARATOR);
            creativemodetab_e.accept((IMaterial) Items.TARGET);
            creativemodetab_e.accept((IMaterial) Items.WAXED_COPPER_BULB);
            creativemodetab_e.accept((IMaterial) Items.WAXED_EXPOSED_COPPER_BULB);
            creativemodetab_e.accept((IMaterial) Items.WAXED_WEATHERED_COPPER_BULB);
            creativemodetab_e.accept((IMaterial) Items.WAXED_OXIDIZED_COPPER_BULB);
            creativemodetab_e.accept((IMaterial) Items.LEVER);
            creativemodetab_e.accept((IMaterial) Items.OAK_BUTTON);
            creativemodetab_e.accept((IMaterial) Items.STONE_BUTTON);
            creativemodetab_e.accept((IMaterial) Items.OAK_PRESSURE_PLATE);
            creativemodetab_e.accept((IMaterial) Items.STONE_PRESSURE_PLATE);
            creativemodetab_e.accept((IMaterial) Items.LIGHT_WEIGHTED_PRESSURE_PLATE);
            creativemodetab_e.accept((IMaterial) Items.HEAVY_WEIGHTED_PRESSURE_PLATE);
            creativemodetab_e.accept((IMaterial) Items.SCULK_SENSOR);
            creativemodetab_e.accept((IMaterial) Items.CALIBRATED_SCULK_SENSOR);
            creativemodetab_e.accept((IMaterial) Items.SCULK_SHRIEKER);
            creativemodetab_e.accept((IMaterial) Items.AMETHYST_BLOCK);
            creativemodetab_e.accept((IMaterial) Items.WHITE_WOOL);
            creativemodetab_e.accept((IMaterial) Items.TRIPWIRE_HOOK);
            creativemodetab_e.accept((IMaterial) Items.STRING);
            creativemodetab_e.accept((IMaterial) Items.LECTERN);
            creativemodetab_e.accept((IMaterial) Items.DAYLIGHT_DETECTOR);
            creativemodetab_e.accept((IMaterial) Items.LIGHTNING_ROD);
            creativemodetab_e.accept((IMaterial) Items.PISTON);
            creativemodetab_e.accept((IMaterial) Items.STICKY_PISTON);
            creativemodetab_e.accept((IMaterial) Items.SLIME_BLOCK);
            creativemodetab_e.accept((IMaterial) Items.HONEY_BLOCK);
            creativemodetab_e.accept((IMaterial) Items.DISPENSER);
            creativemodetab_e.accept((IMaterial) Items.DROPPER);
            creativemodetab_e.accept((IMaterial) Items.CRAFTER);
            creativemodetab_e.accept((IMaterial) Items.HOPPER);
            creativemodetab_e.accept((IMaterial) Items.CHEST);
            creativemodetab_e.accept((IMaterial) Items.BARREL);
            creativemodetab_e.accept((IMaterial) Items.CHISELED_BOOKSHELF);
            creativemodetab_e.accept((IMaterial) Items.FURNACE);
            creativemodetab_e.accept((IMaterial) Items.TRAPPED_CHEST);
            creativemodetab_e.accept((IMaterial) Items.JUKEBOX);
            creativemodetab_e.accept((IMaterial) Items.DECORATED_POT);
            creativemodetab_e.accept((IMaterial) Items.OBSERVER);
            creativemodetab_e.accept((IMaterial) Items.NOTE_BLOCK);
            creativemodetab_e.accept((IMaterial) Items.COMPOSTER);
            creativemodetab_e.accept((IMaterial) Items.CAULDRON);
            creativemodetab_e.accept((IMaterial) Items.RAIL);
            creativemodetab_e.accept((IMaterial) Items.POWERED_RAIL);
            creativemodetab_e.accept((IMaterial) Items.DETECTOR_RAIL);
            creativemodetab_e.accept((IMaterial) Items.ACTIVATOR_RAIL);
            creativemodetab_e.accept((IMaterial) Items.MINECART);
            creativemodetab_e.accept((IMaterial) Items.HOPPER_MINECART);
            creativemodetab_e.accept((IMaterial) Items.CHEST_MINECART);
            creativemodetab_e.accept((IMaterial) Items.FURNACE_MINECART);
            creativemodetab_e.accept((IMaterial) Items.TNT_MINECART);
            creativemodetab_e.accept((IMaterial) Items.OAK_CHEST_BOAT);
            creativemodetab_e.accept((IMaterial) Items.BAMBOO_CHEST_RAFT);
            creativemodetab_e.accept((IMaterial) Items.OAK_DOOR);
            creativemodetab_e.accept((IMaterial) Items.IRON_DOOR);
            creativemodetab_e.accept((IMaterial) Items.OAK_FENCE_GATE);
            creativemodetab_e.accept((IMaterial) Items.OAK_TRAPDOOR);
            creativemodetab_e.accept((IMaterial) Items.IRON_TRAPDOOR);
            creativemodetab_e.accept((IMaterial) Items.TNT);
            creativemodetab_e.accept((IMaterial) Items.REDSTONE_LAMP);
            creativemodetab_e.accept((IMaterial) Items.BELL);
            creativemodetab_e.accept((IMaterial) Items.BIG_DRIPLEAF);
            creativemodetab_e.accept((IMaterial) Items.ARMOR_STAND);
            creativemodetab_e.accept((IMaterial) Items.REDSTONE_ORE);
        }).build());
        IRegistry.register(iregistry, CreativeModeTabs.HOTBAR, CreativeModeTab.builder(CreativeModeTab.f.TOP, 5).title(IChatBaseComponent.translatable("itemGroup.hotbar")).icon(() -> {
            return new ItemStack(Blocks.BOOKSHELF);
        }).alignedRight().type(CreativeModeTab.h.HOTBAR).build());
        IRegistry.register(iregistry, CreativeModeTabs.SEARCH, CreativeModeTab.builder(CreativeModeTab.f.TOP, 6).title(IChatBaseComponent.translatable("itemGroup.search")).icon(() -> {
            return new ItemStack(Items.COMPASS);
        }).displayItems((creativemodetab_d, creativemodetab_e) -> {
            Set<ItemStack> set = ItemStackLinkedSet.createTypeAndComponentsSet();
            Iterator iterator = iregistry.iterator();

            while (iterator.hasNext()) {
                CreativeModeTab creativemodetab = (CreativeModeTab) iterator.next();

                if (creativemodetab.getType() != CreativeModeTab.h.SEARCH) {
                    set.addAll(creativemodetab.getSearchTabDisplayItems());
                }
            }

            creativemodetab_e.acceptAll(set);
        }).backgroundTexture(CreativeModeTabs.SEARCH_BACKGROUND).alignedRight().type(CreativeModeTab.h.SEARCH).build());
        IRegistry.register(iregistry, CreativeModeTabs.TOOLS_AND_UTILITIES, CreativeModeTab.builder(CreativeModeTab.f.BOTTOM, 0).title(IChatBaseComponent.translatable("itemGroup.tools")).icon(() -> {
            return new ItemStack(Items.DIAMOND_PICKAXE);
        }).displayItems((creativemodetab_d, creativemodetab_e) -> {
            creativemodetab_e.accept((IMaterial) Items.WOODEN_SHOVEL);
            creativemodetab_e.accept((IMaterial) Items.WOODEN_PICKAXE);
            creativemodetab_e.accept((IMaterial) Items.WOODEN_AXE);
            creativemodetab_e.accept((IMaterial) Items.WOODEN_HOE);
            creativemodetab_e.accept((IMaterial) Items.STONE_SHOVEL);
            creativemodetab_e.accept((IMaterial) Items.STONE_PICKAXE);
            creativemodetab_e.accept((IMaterial) Items.STONE_AXE);
            creativemodetab_e.accept((IMaterial) Items.STONE_HOE);
            creativemodetab_e.accept((IMaterial) Items.IRON_SHOVEL);
            creativemodetab_e.accept((IMaterial) Items.IRON_PICKAXE);
            creativemodetab_e.accept((IMaterial) Items.IRON_AXE);
            creativemodetab_e.accept((IMaterial) Items.IRON_HOE);
            creativemodetab_e.accept((IMaterial) Items.GOLDEN_SHOVEL);
            creativemodetab_e.accept((IMaterial) Items.GOLDEN_PICKAXE);
            creativemodetab_e.accept((IMaterial) Items.GOLDEN_AXE);
            creativemodetab_e.accept((IMaterial) Items.GOLDEN_HOE);
            creativemodetab_e.accept((IMaterial) Items.DIAMOND_SHOVEL);
            creativemodetab_e.accept((IMaterial) Items.DIAMOND_PICKAXE);
            creativemodetab_e.accept((IMaterial) Items.DIAMOND_AXE);
            creativemodetab_e.accept((IMaterial) Items.DIAMOND_HOE);
            creativemodetab_e.accept((IMaterial) Items.NETHERITE_SHOVEL);
            creativemodetab_e.accept((IMaterial) Items.NETHERITE_PICKAXE);
            creativemodetab_e.accept((IMaterial) Items.NETHERITE_AXE);
            creativemodetab_e.accept((IMaterial) Items.NETHERITE_HOE);
            creativemodetab_e.accept((IMaterial) Items.BUCKET);
            creativemodetab_e.accept((IMaterial) Items.WATER_BUCKET);
            creativemodetab_e.accept((IMaterial) Items.COD_BUCKET);
            creativemodetab_e.accept((IMaterial) Items.SALMON_BUCKET);
            creativemodetab_e.accept((IMaterial) Items.TROPICAL_FISH_BUCKET);
            creativemodetab_e.accept((IMaterial) Items.PUFFERFISH_BUCKET);
            creativemodetab_e.accept((IMaterial) Items.AXOLOTL_BUCKET);
            creativemodetab_e.accept((IMaterial) Items.TADPOLE_BUCKET);
            creativemodetab_e.accept((IMaterial) Items.LAVA_BUCKET);
            creativemodetab_e.accept((IMaterial) Items.POWDER_SNOW_BUCKET);
            creativemodetab_e.accept((IMaterial) Items.MILK_BUCKET);
            creativemodetab_e.accept((IMaterial) Items.FISHING_ROD);
            creativemodetab_e.accept((IMaterial) Items.FLINT_AND_STEEL);
            creativemodetab_e.accept((IMaterial) Items.FIRE_CHARGE);
            creativemodetab_e.accept((IMaterial) Items.BONE_MEAL);
            creativemodetab_e.accept((IMaterial) Items.SHEARS);
            creativemodetab_e.accept((IMaterial) Items.BRUSH);
            creativemodetab_e.accept((IMaterial) Items.NAME_TAG);
            creativemodetab_e.accept((IMaterial) Items.LEAD);
            if (creativemodetab_d.enabledFeatures().contains(FeatureFlags.BUNDLE)) {
                creativemodetab_e.accept((IMaterial) Items.BUNDLE);
            }

            creativemodetab_e.accept((IMaterial) Items.COMPASS);
            creativemodetab_e.accept((IMaterial) Items.RECOVERY_COMPASS);
            creativemodetab_e.accept((IMaterial) Items.CLOCK);
            creativemodetab_e.accept((IMaterial) Items.SPYGLASS);
            creativemodetab_e.accept((IMaterial) Items.MAP);
            creativemodetab_e.accept((IMaterial) Items.WRITABLE_BOOK);
            creativemodetab_e.accept((IMaterial) Items.WIND_CHARGE);
            creativemodetab_e.accept((IMaterial) Items.ENDER_PEARL);
            creativemodetab_e.accept((IMaterial) Items.ENDER_EYE);
            creativemodetab_e.accept((IMaterial) Items.ELYTRA);
            generateFireworksAllDurations(creativemodetab_e, CreativeModeTab.g.PARENT_AND_SEARCH_TABS);
            creativemodetab_e.accept((IMaterial) Items.SADDLE);
            creativemodetab_e.accept((IMaterial) Items.CARROT_ON_A_STICK);
            creativemodetab_e.accept((IMaterial) Items.WARPED_FUNGUS_ON_A_STICK);
            creativemodetab_e.accept((IMaterial) Items.OAK_BOAT);
            creativemodetab_e.accept((IMaterial) Items.OAK_CHEST_BOAT);
            creativemodetab_e.accept((IMaterial) Items.SPRUCE_BOAT);
            creativemodetab_e.accept((IMaterial) Items.SPRUCE_CHEST_BOAT);
            creativemodetab_e.accept((IMaterial) Items.BIRCH_BOAT);
            creativemodetab_e.accept((IMaterial) Items.BIRCH_CHEST_BOAT);
            creativemodetab_e.accept((IMaterial) Items.JUNGLE_BOAT);
            creativemodetab_e.accept((IMaterial) Items.JUNGLE_CHEST_BOAT);
            creativemodetab_e.accept((IMaterial) Items.ACACIA_BOAT);
            creativemodetab_e.accept((IMaterial) Items.ACACIA_CHEST_BOAT);
            creativemodetab_e.accept((IMaterial) Items.DARK_OAK_BOAT);
            creativemodetab_e.accept((IMaterial) Items.DARK_OAK_CHEST_BOAT);
            creativemodetab_e.accept((IMaterial) Items.MANGROVE_BOAT);
            creativemodetab_e.accept((IMaterial) Items.MANGROVE_CHEST_BOAT);
            creativemodetab_e.accept((IMaterial) Items.CHERRY_BOAT);
            creativemodetab_e.accept((IMaterial) Items.CHERRY_CHEST_BOAT);
            creativemodetab_e.accept((IMaterial) Items.BAMBOO_RAFT);
            creativemodetab_e.accept((IMaterial) Items.BAMBOO_CHEST_RAFT);
            creativemodetab_e.accept((IMaterial) Items.RAIL);
            creativemodetab_e.accept((IMaterial) Items.POWERED_RAIL);
            creativemodetab_e.accept((IMaterial) Items.DETECTOR_RAIL);
            creativemodetab_e.accept((IMaterial) Items.ACTIVATOR_RAIL);
            creativemodetab_e.accept((IMaterial) Items.MINECART);
            creativemodetab_e.accept((IMaterial) Items.HOPPER_MINECART);
            creativemodetab_e.accept((IMaterial) Items.CHEST_MINECART);
            creativemodetab_e.accept((IMaterial) Items.FURNACE_MINECART);
            creativemodetab_e.accept((IMaterial) Items.TNT_MINECART);
            creativemodetab_d.holders().lookup(Registries.INSTRUMENT).ifPresent((holderlookup_b) -> {
                generateInstrumentTypes(creativemodetab_e, holderlookup_b, Items.GOAT_HORN, InstrumentTags.GOAT_HORNS, CreativeModeTab.g.PARENT_AND_SEARCH_TABS);
            });
            creativemodetab_e.accept((IMaterial) Items.MUSIC_DISC_13);
            creativemodetab_e.accept((IMaterial) Items.MUSIC_DISC_CAT);
            creativemodetab_e.accept((IMaterial) Items.MUSIC_DISC_BLOCKS);
            creativemodetab_e.accept((IMaterial) Items.MUSIC_DISC_CHIRP);
            creativemodetab_e.accept((IMaterial) Items.MUSIC_DISC_FAR);
            creativemodetab_e.accept((IMaterial) Items.MUSIC_DISC_MALL);
            creativemodetab_e.accept((IMaterial) Items.MUSIC_DISC_MELLOHI);
            creativemodetab_e.accept((IMaterial) Items.MUSIC_DISC_STAL);
            creativemodetab_e.accept((IMaterial) Items.MUSIC_DISC_STRAD);
            creativemodetab_e.accept((IMaterial) Items.MUSIC_DISC_WARD);
            creativemodetab_e.accept((IMaterial) Items.MUSIC_DISC_11);
            creativemodetab_e.accept((IMaterial) Items.MUSIC_DISC_CREATOR_MUSIC_BOX);
            creativemodetab_e.accept((IMaterial) Items.MUSIC_DISC_WAIT);
            creativemodetab_e.accept((IMaterial) Items.MUSIC_DISC_CREATOR);
            creativemodetab_e.accept((IMaterial) Items.MUSIC_DISC_PRECIPICE);
            creativemodetab_e.accept((IMaterial) Items.MUSIC_DISC_OTHERSIDE);
            creativemodetab_e.accept((IMaterial) Items.MUSIC_DISC_RELIC);
            creativemodetab_e.accept((IMaterial) Items.MUSIC_DISC_5);
            creativemodetab_e.accept((IMaterial) Items.MUSIC_DISC_PIGSTEP);
        }).build());
        IRegistry.register(iregistry, CreativeModeTabs.COMBAT, CreativeModeTab.builder(CreativeModeTab.f.BOTTOM, 1).title(IChatBaseComponent.translatable("itemGroup.combat")).icon(() -> {
            return new ItemStack(Items.NETHERITE_SWORD);
        }).displayItems((creativemodetab_d, creativemodetab_e) -> {
            creativemodetab_e.accept((IMaterial) Items.WOODEN_SWORD);
            creativemodetab_e.accept((IMaterial) Items.STONE_SWORD);
            creativemodetab_e.accept((IMaterial) Items.IRON_SWORD);
            creativemodetab_e.accept((IMaterial) Items.GOLDEN_SWORD);
            creativemodetab_e.accept((IMaterial) Items.DIAMOND_SWORD);
            creativemodetab_e.accept((IMaterial) Items.NETHERITE_SWORD);
            creativemodetab_e.accept((IMaterial) Items.WOODEN_AXE);
            creativemodetab_e.accept((IMaterial) Items.STONE_AXE);
            creativemodetab_e.accept((IMaterial) Items.IRON_AXE);
            creativemodetab_e.accept((IMaterial) Items.GOLDEN_AXE);
            creativemodetab_e.accept((IMaterial) Items.DIAMOND_AXE);
            creativemodetab_e.accept((IMaterial) Items.NETHERITE_AXE);
            creativemodetab_e.accept((IMaterial) Items.TRIDENT);
            creativemodetab_e.accept((IMaterial) Items.MACE);
            creativemodetab_e.accept((IMaterial) Items.SHIELD);
            creativemodetab_e.accept((IMaterial) Items.LEATHER_HELMET);
            creativemodetab_e.accept((IMaterial) Items.LEATHER_CHESTPLATE);
            creativemodetab_e.accept((IMaterial) Items.LEATHER_LEGGINGS);
            creativemodetab_e.accept((IMaterial) Items.LEATHER_BOOTS);
            creativemodetab_e.accept((IMaterial) Items.CHAINMAIL_HELMET);
            creativemodetab_e.accept((IMaterial) Items.CHAINMAIL_CHESTPLATE);
            creativemodetab_e.accept((IMaterial) Items.CHAINMAIL_LEGGINGS);
            creativemodetab_e.accept((IMaterial) Items.CHAINMAIL_BOOTS);
            creativemodetab_e.accept((IMaterial) Items.IRON_HELMET);
            creativemodetab_e.accept((IMaterial) Items.IRON_CHESTPLATE);
            creativemodetab_e.accept((IMaterial) Items.IRON_LEGGINGS);
            creativemodetab_e.accept((IMaterial) Items.IRON_BOOTS);
            creativemodetab_e.accept((IMaterial) Items.GOLDEN_HELMET);
            creativemodetab_e.accept((IMaterial) Items.GOLDEN_CHESTPLATE);
            creativemodetab_e.accept((IMaterial) Items.GOLDEN_LEGGINGS);
            creativemodetab_e.accept((IMaterial) Items.GOLDEN_BOOTS);
            creativemodetab_e.accept((IMaterial) Items.DIAMOND_HELMET);
            creativemodetab_e.accept((IMaterial) Items.DIAMOND_CHESTPLATE);
            creativemodetab_e.accept((IMaterial) Items.DIAMOND_LEGGINGS);
            creativemodetab_e.accept((IMaterial) Items.DIAMOND_BOOTS);
            creativemodetab_e.accept((IMaterial) Items.NETHERITE_HELMET);
            creativemodetab_e.accept((IMaterial) Items.NETHERITE_CHESTPLATE);
            creativemodetab_e.accept((IMaterial) Items.NETHERITE_LEGGINGS);
            creativemodetab_e.accept((IMaterial) Items.NETHERITE_BOOTS);
            creativemodetab_e.accept((IMaterial) Items.TURTLE_HELMET);
            creativemodetab_e.accept((IMaterial) Items.LEATHER_HORSE_ARMOR);
            creativemodetab_e.accept((IMaterial) Items.IRON_HORSE_ARMOR);
            creativemodetab_e.accept((IMaterial) Items.GOLDEN_HORSE_ARMOR);
            creativemodetab_e.accept((IMaterial) Items.DIAMOND_HORSE_ARMOR);
            creativemodetab_e.accept((IMaterial) Items.WOLF_ARMOR);
            creativemodetab_e.accept((IMaterial) Items.TOTEM_OF_UNDYING);
            creativemodetab_e.accept((IMaterial) Items.TNT);
            creativemodetab_e.accept((IMaterial) Items.END_CRYSTAL);
            creativemodetab_e.accept((IMaterial) Items.SNOWBALL);
            creativemodetab_e.accept((IMaterial) Items.EGG);
            creativemodetab_e.accept((IMaterial) Items.WIND_CHARGE);
            creativemodetab_e.accept((IMaterial) Items.BOW);
            creativemodetab_e.accept((IMaterial) Items.CROSSBOW);
            generateFireworksAllDurations(creativemodetab_e, CreativeModeTab.g.PARENT_AND_SEARCH_TABS);
            creativemodetab_e.accept((IMaterial) Items.ARROW);
            creativemodetab_e.accept((IMaterial) Items.SPECTRAL_ARROW);
            creativemodetab_d.holders().lookup(Registries.POTION).ifPresent((holderlookup_b) -> {
                generatePotionEffectTypes(creativemodetab_e, holderlookup_b, Items.TIPPED_ARROW, CreativeModeTab.g.PARENT_AND_SEARCH_TABS, creativemodetab_d.enabledFeatures());
            });
        }).build());
        IRegistry.register(iregistry, CreativeModeTabs.FOOD_AND_DRINKS, CreativeModeTab.builder(CreativeModeTab.f.BOTTOM, 2).title(IChatBaseComponent.translatable("itemGroup.foodAndDrink")).icon(() -> {
            return new ItemStack(Items.GOLDEN_APPLE);
        }).displayItems((creativemodetab_d, creativemodetab_e) -> {
            creativemodetab_e.accept((IMaterial) Items.APPLE);
            creativemodetab_e.accept((IMaterial) Items.GOLDEN_APPLE);
            creativemodetab_e.accept((IMaterial) Items.ENCHANTED_GOLDEN_APPLE);
            creativemodetab_e.accept((IMaterial) Items.MELON_SLICE);
            creativemodetab_e.accept((IMaterial) Items.SWEET_BERRIES);
            creativemodetab_e.accept((IMaterial) Items.GLOW_BERRIES);
            creativemodetab_e.accept((IMaterial) Items.CHORUS_FRUIT);
            creativemodetab_e.accept((IMaterial) Items.CARROT);
            creativemodetab_e.accept((IMaterial) Items.GOLDEN_CARROT);
            creativemodetab_e.accept((IMaterial) Items.POTATO);
            creativemodetab_e.accept((IMaterial) Items.BAKED_POTATO);
            creativemodetab_e.accept((IMaterial) Items.POISONOUS_POTATO);
            creativemodetab_e.accept((IMaterial) Items.BEETROOT);
            creativemodetab_e.accept((IMaterial) Items.DRIED_KELP);
            creativemodetab_e.accept((IMaterial) Items.BEEF);
            creativemodetab_e.accept((IMaterial) Items.COOKED_BEEF);
            creativemodetab_e.accept((IMaterial) Items.PORKCHOP);
            creativemodetab_e.accept((IMaterial) Items.COOKED_PORKCHOP);
            creativemodetab_e.accept((IMaterial) Items.MUTTON);
            creativemodetab_e.accept((IMaterial) Items.COOKED_MUTTON);
            creativemodetab_e.accept((IMaterial) Items.CHICKEN);
            creativemodetab_e.accept((IMaterial) Items.COOKED_CHICKEN);
            creativemodetab_e.accept((IMaterial) Items.RABBIT);
            creativemodetab_e.accept((IMaterial) Items.COOKED_RABBIT);
            creativemodetab_e.accept((IMaterial) Items.COD);
            creativemodetab_e.accept((IMaterial) Items.COOKED_COD);
            creativemodetab_e.accept((IMaterial) Items.SALMON);
            creativemodetab_e.accept((IMaterial) Items.COOKED_SALMON);
            creativemodetab_e.accept((IMaterial) Items.TROPICAL_FISH);
            creativemodetab_e.accept((IMaterial) Items.PUFFERFISH);
            creativemodetab_e.accept((IMaterial) Items.BREAD);
            creativemodetab_e.accept((IMaterial) Items.COOKIE);
            creativemodetab_e.accept((IMaterial) Items.CAKE);
            creativemodetab_e.accept((IMaterial) Items.PUMPKIN_PIE);
            creativemodetab_e.accept((IMaterial) Items.ROTTEN_FLESH);
            creativemodetab_e.accept((IMaterial) Items.SPIDER_EYE);
            creativemodetab_e.accept((IMaterial) Items.MUSHROOM_STEW);
            creativemodetab_e.accept((IMaterial) Items.BEETROOT_SOUP);
            creativemodetab_e.accept((IMaterial) Items.RABBIT_STEW);
            generateSuspiciousStews(creativemodetab_e, CreativeModeTab.g.PARENT_AND_SEARCH_TABS);
            creativemodetab_e.accept((IMaterial) Items.MILK_BUCKET);
            creativemodetab_e.accept((IMaterial) Items.HONEY_BOTTLE);
            generateOminousVials(creativemodetab_e, CreativeModeTab.g.PARENT_AND_SEARCH_TABS);
            creativemodetab_d.holders().lookup(Registries.POTION).ifPresent((holderlookup_b) -> {
                generatePotionEffectTypes(creativemodetab_e, holderlookup_b, Items.POTION, CreativeModeTab.g.PARENT_AND_SEARCH_TABS, creativemodetab_d.enabledFeatures());
                generatePotionEffectTypes(creativemodetab_e, holderlookup_b, Items.SPLASH_POTION, CreativeModeTab.g.PARENT_AND_SEARCH_TABS, creativemodetab_d.enabledFeatures());
                generatePotionEffectTypes(creativemodetab_e, holderlookup_b, Items.LINGERING_POTION, CreativeModeTab.g.PARENT_AND_SEARCH_TABS, creativemodetab_d.enabledFeatures());
            });
        }).build());
        IRegistry.register(iregistry, CreativeModeTabs.INGREDIENTS, CreativeModeTab.builder(CreativeModeTab.f.BOTTOM, 3).title(IChatBaseComponent.translatable("itemGroup.ingredients")).icon(() -> {
            return new ItemStack(Items.IRON_INGOT);
        }).displayItems((creativemodetab_d, creativemodetab_e) -> {
            creativemodetab_e.accept((IMaterial) Items.COAL);
            creativemodetab_e.accept((IMaterial) Items.CHARCOAL);
            creativemodetab_e.accept((IMaterial) Items.RAW_IRON);
            creativemodetab_e.accept((IMaterial) Items.RAW_COPPER);
            creativemodetab_e.accept((IMaterial) Items.RAW_GOLD);
            creativemodetab_e.accept((IMaterial) Items.EMERALD);
            creativemodetab_e.accept((IMaterial) Items.LAPIS_LAZULI);
            creativemodetab_e.accept((IMaterial) Items.DIAMOND);
            creativemodetab_e.accept((IMaterial) Items.ANCIENT_DEBRIS);
            creativemodetab_e.accept((IMaterial) Items.QUARTZ);
            creativemodetab_e.accept((IMaterial) Items.AMETHYST_SHARD);
            creativemodetab_e.accept((IMaterial) Items.IRON_NUGGET);
            creativemodetab_e.accept((IMaterial) Items.GOLD_NUGGET);
            creativemodetab_e.accept((IMaterial) Items.IRON_INGOT);
            creativemodetab_e.accept((IMaterial) Items.COPPER_INGOT);
            creativemodetab_e.accept((IMaterial) Items.GOLD_INGOT);
            creativemodetab_e.accept((IMaterial) Items.NETHERITE_SCRAP);
            creativemodetab_e.accept((IMaterial) Items.NETHERITE_INGOT);
            creativemodetab_e.accept((IMaterial) Items.STICK);
            creativemodetab_e.accept((IMaterial) Items.FLINT);
            creativemodetab_e.accept((IMaterial) Items.WHEAT);
            creativemodetab_e.accept((IMaterial) Items.BONE);
            creativemodetab_e.accept((IMaterial) Items.BONE_MEAL);
            creativemodetab_e.accept((IMaterial) Items.STRING);
            creativemodetab_e.accept((IMaterial) Items.FEATHER);
            creativemodetab_e.accept((IMaterial) Items.SNOWBALL);
            creativemodetab_e.accept((IMaterial) Items.EGG);
            creativemodetab_e.accept((IMaterial) Items.LEATHER);
            creativemodetab_e.accept((IMaterial) Items.RABBIT_HIDE);
            creativemodetab_e.accept((IMaterial) Items.HONEYCOMB);
            creativemodetab_e.accept((IMaterial) Items.INK_SAC);
            creativemodetab_e.accept((IMaterial) Items.GLOW_INK_SAC);
            creativemodetab_e.accept((IMaterial) Items.TURTLE_SCUTE);
            creativemodetab_e.accept((IMaterial) Items.ARMADILLO_SCUTE);
            creativemodetab_e.accept((IMaterial) Items.SLIME_BALL);
            creativemodetab_e.accept((IMaterial) Items.CLAY_BALL);
            creativemodetab_e.accept((IMaterial) Items.PRISMARINE_SHARD);
            creativemodetab_e.accept((IMaterial) Items.PRISMARINE_CRYSTALS);
            creativemodetab_e.accept((IMaterial) Items.NAUTILUS_SHELL);
            creativemodetab_e.accept((IMaterial) Items.HEART_OF_THE_SEA);
            creativemodetab_e.accept((IMaterial) Items.FIRE_CHARGE);
            creativemodetab_e.accept((IMaterial) Items.BLAZE_ROD);
            creativemodetab_e.accept((IMaterial) Items.BREEZE_ROD);
            creativemodetab_e.accept((IMaterial) Items.HEAVY_CORE);
            creativemodetab_e.accept((IMaterial) Items.NETHER_STAR);
            creativemodetab_e.accept((IMaterial) Items.ENDER_PEARL);
            creativemodetab_e.accept((IMaterial) Items.ENDER_EYE);
            creativemodetab_e.accept((IMaterial) Items.SHULKER_SHELL);
            creativemodetab_e.accept((IMaterial) Items.POPPED_CHORUS_FRUIT);
            creativemodetab_e.accept((IMaterial) Items.ECHO_SHARD);
            creativemodetab_e.accept((IMaterial) Items.DISC_FRAGMENT_5);
            creativemodetab_e.accept((IMaterial) Items.WHITE_DYE);
            creativemodetab_e.accept((IMaterial) Items.LIGHT_GRAY_DYE);
            creativemodetab_e.accept((IMaterial) Items.GRAY_DYE);
            creativemodetab_e.accept((IMaterial) Items.BLACK_DYE);
            creativemodetab_e.accept((IMaterial) Items.BROWN_DYE);
            creativemodetab_e.accept((IMaterial) Items.RED_DYE);
            creativemodetab_e.accept((IMaterial) Items.ORANGE_DYE);
            creativemodetab_e.accept((IMaterial) Items.YELLOW_DYE);
            creativemodetab_e.accept((IMaterial) Items.LIME_DYE);
            creativemodetab_e.accept((IMaterial) Items.GREEN_DYE);
            creativemodetab_e.accept((IMaterial) Items.CYAN_DYE);
            creativemodetab_e.accept((IMaterial) Items.LIGHT_BLUE_DYE);
            creativemodetab_e.accept((IMaterial) Items.BLUE_DYE);
            creativemodetab_e.accept((IMaterial) Items.PURPLE_DYE);
            creativemodetab_e.accept((IMaterial) Items.MAGENTA_DYE);
            creativemodetab_e.accept((IMaterial) Items.PINK_DYE);
            creativemodetab_e.accept((IMaterial) Items.BOWL);
            creativemodetab_e.accept((IMaterial) Items.BRICK);
            creativemodetab_e.accept((IMaterial) Items.NETHER_BRICK);
            creativemodetab_e.accept((IMaterial) Items.PAPER);
            creativemodetab_e.accept((IMaterial) Items.BOOK);
            creativemodetab_e.accept((IMaterial) Items.FIREWORK_STAR);
            creativemodetab_e.accept((IMaterial) Items.GLASS_BOTTLE);
            creativemodetab_e.accept((IMaterial) Items.NETHER_WART);
            creativemodetab_e.accept((IMaterial) Items.REDSTONE);
            creativemodetab_e.accept((IMaterial) Items.GLOWSTONE_DUST);
            creativemodetab_e.accept((IMaterial) Items.GUNPOWDER);
            creativemodetab_e.accept((IMaterial) Items.DRAGON_BREATH);
            creativemodetab_e.accept((IMaterial) Items.FERMENTED_SPIDER_EYE);
            creativemodetab_e.accept((IMaterial) Items.BLAZE_POWDER);
            creativemodetab_e.accept((IMaterial) Items.SUGAR);
            creativemodetab_e.accept((IMaterial) Items.RABBIT_FOOT);
            creativemodetab_e.accept((IMaterial) Items.GLISTERING_MELON_SLICE);
            creativemodetab_e.accept((IMaterial) Items.SPIDER_EYE);
            creativemodetab_e.accept((IMaterial) Items.PUFFERFISH);
            creativemodetab_e.accept((IMaterial) Items.MAGMA_CREAM);
            creativemodetab_e.accept((IMaterial) Items.GOLDEN_CARROT);
            creativemodetab_e.accept((IMaterial) Items.GHAST_TEAR);
            creativemodetab_e.accept((IMaterial) Items.TURTLE_HELMET);
            creativemodetab_e.accept((IMaterial) Items.PHANTOM_MEMBRANE);
            creativemodetab_e.accept((IMaterial) Items.FLOWER_BANNER_PATTERN);
            creativemodetab_e.accept((IMaterial) Items.CREEPER_BANNER_PATTERN);
            creativemodetab_e.accept((IMaterial) Items.SKULL_BANNER_PATTERN);
            creativemodetab_e.accept((IMaterial) Items.MOJANG_BANNER_PATTERN);
            creativemodetab_e.accept((IMaterial) Items.GLOBE_BANNER_PATTERN);
            creativemodetab_e.accept((IMaterial) Items.PIGLIN_BANNER_PATTERN);
            creativemodetab_e.accept((IMaterial) Items.FLOW_BANNER_PATTERN);
            creativemodetab_e.accept((IMaterial) Items.GUSTER_BANNER_PATTERN);
            creativemodetab_e.accept((IMaterial) Items.ANGLER_POTTERY_SHERD);
            creativemodetab_e.accept((IMaterial) Items.ARCHER_POTTERY_SHERD);
            creativemodetab_e.accept((IMaterial) Items.ARMS_UP_POTTERY_SHERD);
            creativemodetab_e.accept((IMaterial) Items.BLADE_POTTERY_SHERD);
            creativemodetab_e.accept((IMaterial) Items.BREWER_POTTERY_SHERD);
            creativemodetab_e.accept((IMaterial) Items.BURN_POTTERY_SHERD);
            creativemodetab_e.accept((IMaterial) Items.DANGER_POTTERY_SHERD);
            creativemodetab_e.accept((IMaterial) Items.FLOW_POTTERY_SHERD);
            creativemodetab_e.accept((IMaterial) Items.EXPLORER_POTTERY_SHERD);
            creativemodetab_e.accept((IMaterial) Items.FRIEND_POTTERY_SHERD);
            creativemodetab_e.accept((IMaterial) Items.GUSTER_POTTERY_SHERD);
            creativemodetab_e.accept((IMaterial) Items.HEART_POTTERY_SHERD);
            creativemodetab_e.accept((IMaterial) Items.HEARTBREAK_POTTERY_SHERD);
            creativemodetab_e.accept((IMaterial) Items.HOWL_POTTERY_SHERD);
            creativemodetab_e.accept((IMaterial) Items.MINER_POTTERY_SHERD);
            creativemodetab_e.accept((IMaterial) Items.MOURNER_POTTERY_SHERD);
            creativemodetab_e.accept((IMaterial) Items.PLENTY_POTTERY_SHERD);
            creativemodetab_e.accept((IMaterial) Items.PRIZE_POTTERY_SHERD);
            creativemodetab_e.accept((IMaterial) Items.SCRAPE_POTTERY_SHERD);
            creativemodetab_e.accept((IMaterial) Items.SHEAF_POTTERY_SHERD);
            creativemodetab_e.accept((IMaterial) Items.SHELTER_POTTERY_SHERD);
            creativemodetab_e.accept((IMaterial) Items.SKULL_POTTERY_SHERD);
            creativemodetab_e.accept((IMaterial) Items.SNORT_POTTERY_SHERD);
            creativemodetab_e.accept((IMaterial) Items.NETHERITE_UPGRADE_SMITHING_TEMPLATE);
            creativemodetab_e.accept((IMaterial) Items.SENTRY_ARMOR_TRIM_SMITHING_TEMPLATE);
            creativemodetab_e.accept((IMaterial) Items.VEX_ARMOR_TRIM_SMITHING_TEMPLATE);
            creativemodetab_e.accept((IMaterial) Items.WILD_ARMOR_TRIM_SMITHING_TEMPLATE);
            creativemodetab_e.accept((IMaterial) Items.COAST_ARMOR_TRIM_SMITHING_TEMPLATE);
            creativemodetab_e.accept((IMaterial) Items.DUNE_ARMOR_TRIM_SMITHING_TEMPLATE);
            creativemodetab_e.accept((IMaterial) Items.WAYFINDER_ARMOR_TRIM_SMITHING_TEMPLATE);
            creativemodetab_e.accept((IMaterial) Items.RAISER_ARMOR_TRIM_SMITHING_TEMPLATE);
            creativemodetab_e.accept((IMaterial) Items.SHAPER_ARMOR_TRIM_SMITHING_TEMPLATE);
            creativemodetab_e.accept((IMaterial) Items.HOST_ARMOR_TRIM_SMITHING_TEMPLATE);
            creativemodetab_e.accept((IMaterial) Items.WARD_ARMOR_TRIM_SMITHING_TEMPLATE);
            creativemodetab_e.accept((IMaterial) Items.SILENCE_ARMOR_TRIM_SMITHING_TEMPLATE);
            creativemodetab_e.accept((IMaterial) Items.TIDE_ARMOR_TRIM_SMITHING_TEMPLATE);
            creativemodetab_e.accept((IMaterial) Items.SNOUT_ARMOR_TRIM_SMITHING_TEMPLATE);
            creativemodetab_e.accept((IMaterial) Items.RIB_ARMOR_TRIM_SMITHING_TEMPLATE);
            creativemodetab_e.accept((IMaterial) Items.EYE_ARMOR_TRIM_SMITHING_TEMPLATE);
            creativemodetab_e.accept((IMaterial) Items.SPIRE_ARMOR_TRIM_SMITHING_TEMPLATE);
            creativemodetab_e.accept((IMaterial) Items.FLOW_ARMOR_TRIM_SMITHING_TEMPLATE);
            creativemodetab_e.accept((IMaterial) Items.BOLT_ARMOR_TRIM_SMITHING_TEMPLATE);
            creativemodetab_e.accept((IMaterial) Items.EXPERIENCE_BOTTLE);
            creativemodetab_e.accept((IMaterial) Items.TRIAL_KEY);
            creativemodetab_e.accept((IMaterial) Items.OMINOUS_TRIAL_KEY);
            creativemodetab_d.holders().lookup(Registries.ENCHANTMENT).ifPresent((holderlookup_b) -> {
                generateEnchantmentBookTypesOnlyMaxLevel(creativemodetab_e, holderlookup_b, CreativeModeTab.g.PARENT_TAB_ONLY);
                generateEnchantmentBookTypesAllLevels(creativemodetab_e, holderlookup_b, CreativeModeTab.g.SEARCH_TAB_ONLY);
            });
        }).build());
        IRegistry.register(iregistry, CreativeModeTabs.SPAWN_EGGS, CreativeModeTab.builder(CreativeModeTab.f.BOTTOM, 4).title(IChatBaseComponent.translatable("itemGroup.spawnEggs")).icon(() -> {
            return new ItemStack(Items.PIG_SPAWN_EGG);
        }).displayItems((creativemodetab_d, creativemodetab_e) -> {
            creativemodetab_e.accept((IMaterial) Items.SPAWNER);
            creativemodetab_e.accept((IMaterial) Items.TRIAL_SPAWNER);
            creativemodetab_e.accept((IMaterial) Items.ALLAY_SPAWN_EGG);
            creativemodetab_e.accept((IMaterial) Items.ARMADILLO_SPAWN_EGG);
            creativemodetab_e.accept((IMaterial) Items.AXOLOTL_SPAWN_EGG);
            creativemodetab_e.accept((IMaterial) Items.BAT_SPAWN_EGG);
            creativemodetab_e.accept((IMaterial) Items.BEE_SPAWN_EGG);
            creativemodetab_e.accept((IMaterial) Items.BLAZE_SPAWN_EGG);
            creativemodetab_e.accept((IMaterial) Items.BOGGED_SPAWN_EGG);
            creativemodetab_e.accept((IMaterial) Items.BREEZE_SPAWN_EGG);
            creativemodetab_e.accept((IMaterial) Items.CAMEL_SPAWN_EGG);
            creativemodetab_e.accept((IMaterial) Items.CAT_SPAWN_EGG);
            creativemodetab_e.accept((IMaterial) Items.CAVE_SPIDER_SPAWN_EGG);
            creativemodetab_e.accept((IMaterial) Items.CHICKEN_SPAWN_EGG);
            creativemodetab_e.accept((IMaterial) Items.COD_SPAWN_EGG);
            creativemodetab_e.accept((IMaterial) Items.COW_SPAWN_EGG);
            creativemodetab_e.accept((IMaterial) Items.CREEPER_SPAWN_EGG);
            creativemodetab_e.accept((IMaterial) Items.DOLPHIN_SPAWN_EGG);
            creativemodetab_e.accept((IMaterial) Items.DONKEY_SPAWN_EGG);
            creativemodetab_e.accept((IMaterial) Items.DROWNED_SPAWN_EGG);
            creativemodetab_e.accept((IMaterial) Items.ELDER_GUARDIAN_SPAWN_EGG);
            creativemodetab_e.accept((IMaterial) Items.ENDERMAN_SPAWN_EGG);
            creativemodetab_e.accept((IMaterial) Items.ENDERMITE_SPAWN_EGG);
            creativemodetab_e.accept((IMaterial) Items.EVOKER_SPAWN_EGG);
            creativemodetab_e.accept((IMaterial) Items.FOX_SPAWN_EGG);
            creativemodetab_e.accept((IMaterial) Items.FROG_SPAWN_EGG);
            creativemodetab_e.accept((IMaterial) Items.GHAST_SPAWN_EGG);
            creativemodetab_e.accept((IMaterial) Items.GLOW_SQUID_SPAWN_EGG);
            creativemodetab_e.accept((IMaterial) Items.GOAT_SPAWN_EGG);
            creativemodetab_e.accept((IMaterial) Items.GUARDIAN_SPAWN_EGG);
            creativemodetab_e.accept((IMaterial) Items.HOGLIN_SPAWN_EGG);
            creativemodetab_e.accept((IMaterial) Items.HORSE_SPAWN_EGG);
            creativemodetab_e.accept((IMaterial) Items.HUSK_SPAWN_EGG);
            creativemodetab_e.accept((IMaterial) Items.IRON_GOLEM_SPAWN_EGG);
            creativemodetab_e.accept((IMaterial) Items.LLAMA_SPAWN_EGG);
            creativemodetab_e.accept((IMaterial) Items.MAGMA_CUBE_SPAWN_EGG);
            creativemodetab_e.accept((IMaterial) Items.MOOSHROOM_SPAWN_EGG);
            creativemodetab_e.accept((IMaterial) Items.MULE_SPAWN_EGG);
            creativemodetab_e.accept((IMaterial) Items.OCELOT_SPAWN_EGG);
            creativemodetab_e.accept((IMaterial) Items.PANDA_SPAWN_EGG);
            creativemodetab_e.accept((IMaterial) Items.PARROT_SPAWN_EGG);
            creativemodetab_e.accept((IMaterial) Items.PHANTOM_SPAWN_EGG);
            creativemodetab_e.accept((IMaterial) Items.PIG_SPAWN_EGG);
            creativemodetab_e.accept((IMaterial) Items.PIGLIN_SPAWN_EGG);
            creativemodetab_e.accept((IMaterial) Items.PIGLIN_BRUTE_SPAWN_EGG);
            creativemodetab_e.accept((IMaterial) Items.PILLAGER_SPAWN_EGG);
            creativemodetab_e.accept((IMaterial) Items.POLAR_BEAR_SPAWN_EGG);
            creativemodetab_e.accept((IMaterial) Items.PUFFERFISH_SPAWN_EGG);
            creativemodetab_e.accept((IMaterial) Items.RABBIT_SPAWN_EGG);
            creativemodetab_e.accept((IMaterial) Items.RAVAGER_SPAWN_EGG);
            creativemodetab_e.accept((IMaterial) Items.SALMON_SPAWN_EGG);
            creativemodetab_e.accept((IMaterial) Items.SHEEP_SPAWN_EGG);
            creativemodetab_e.accept((IMaterial) Items.SHULKER_SPAWN_EGG);
            creativemodetab_e.accept((IMaterial) Items.SILVERFISH_SPAWN_EGG);
            creativemodetab_e.accept((IMaterial) Items.SKELETON_SPAWN_EGG);
            creativemodetab_e.accept((IMaterial) Items.SKELETON_HORSE_SPAWN_EGG);
            creativemodetab_e.accept((IMaterial) Items.SLIME_SPAWN_EGG);
            creativemodetab_e.accept((IMaterial) Items.SNIFFER_SPAWN_EGG);
            creativemodetab_e.accept((IMaterial) Items.SNOW_GOLEM_SPAWN_EGG);
            creativemodetab_e.accept((IMaterial) Items.SPIDER_SPAWN_EGG);
            creativemodetab_e.accept((IMaterial) Items.SQUID_SPAWN_EGG);
            creativemodetab_e.accept((IMaterial) Items.STRAY_SPAWN_EGG);
            creativemodetab_e.accept((IMaterial) Items.STRIDER_SPAWN_EGG);
            creativemodetab_e.accept((IMaterial) Items.TADPOLE_SPAWN_EGG);
            creativemodetab_e.accept((IMaterial) Items.TRADER_LLAMA_SPAWN_EGG);
            creativemodetab_e.accept((IMaterial) Items.TROPICAL_FISH_SPAWN_EGG);
            creativemodetab_e.accept((IMaterial) Items.TURTLE_SPAWN_EGG);
            creativemodetab_e.accept((IMaterial) Items.VEX_SPAWN_EGG);
            creativemodetab_e.accept((IMaterial) Items.VILLAGER_SPAWN_EGG);
            creativemodetab_e.accept((IMaterial) Items.VINDICATOR_SPAWN_EGG);
            creativemodetab_e.accept((IMaterial) Items.WANDERING_TRADER_SPAWN_EGG);
            creativemodetab_e.accept((IMaterial) Items.WARDEN_SPAWN_EGG);
            creativemodetab_e.accept((IMaterial) Items.WITCH_SPAWN_EGG);
            creativemodetab_e.accept((IMaterial) Items.WITHER_SKELETON_SPAWN_EGG);
            creativemodetab_e.accept((IMaterial) Items.WOLF_SPAWN_EGG);
            creativemodetab_e.accept((IMaterial) Items.ZOGLIN_SPAWN_EGG);
            creativemodetab_e.accept((IMaterial) Items.ZOMBIE_SPAWN_EGG);
            creativemodetab_e.accept((IMaterial) Items.ZOMBIE_HORSE_SPAWN_EGG);
            creativemodetab_e.accept((IMaterial) Items.ZOMBIE_VILLAGER_SPAWN_EGG);
            creativemodetab_e.accept((IMaterial) Items.ZOMBIFIED_PIGLIN_SPAWN_EGG);
        }).build());
        IRegistry.register(iregistry, CreativeModeTabs.OP_BLOCKS, CreativeModeTab.builder(CreativeModeTab.f.BOTTOM, 5).title(IChatBaseComponent.translatable("itemGroup.op")).icon(() -> {
            return new ItemStack(Items.COMMAND_BLOCK);
        }).alignedRight().displayItems((creativemodetab_d, creativemodetab_e) -> {
            if (creativemodetab_d.hasPermissions()) {
                creativemodetab_e.accept((IMaterial) Items.COMMAND_BLOCK);
                creativemodetab_e.accept((IMaterial) Items.CHAIN_COMMAND_BLOCK);
                creativemodetab_e.accept((IMaterial) Items.REPEATING_COMMAND_BLOCK);
                creativemodetab_e.accept((IMaterial) Items.COMMAND_BLOCK_MINECART);
                creativemodetab_e.accept((IMaterial) Items.JIGSAW);
                creativemodetab_e.accept((IMaterial) Items.STRUCTURE_BLOCK);
                creativemodetab_e.accept((IMaterial) Items.STRUCTURE_VOID);
                creativemodetab_e.accept((IMaterial) Items.BARRIER);
                creativemodetab_e.accept((IMaterial) Items.DEBUG_STICK);

                for (int i = 15; i >= 0; --i) {
                    creativemodetab_e.accept(LightBlock.setLightOnStack(new ItemStack(Items.LIGHT), i));
                }

                creativemodetab_d.holders().lookup(Registries.PAINTING_VARIANT).ifPresent((holderlookup_b) -> {
                    generatePresetPaintings(creativemodetab_e, creativemodetab_d.holders(), holderlookup_b, (holder) -> {
                        return !holder.is(PaintingVariantTags.PLACEABLE);
                    }, CreativeModeTab.g.PARENT_AND_SEARCH_TABS);
                });
            }

        }).build());
        return (CreativeModeTab) IRegistry.register(iregistry, CreativeModeTabs.INVENTORY, CreativeModeTab.builder(CreativeModeTab.f.BOTTOM, 6).title(IChatBaseComponent.translatable("itemGroup.inventory")).icon(() -> {
            return new ItemStack(Blocks.CHEST);
        }).backgroundTexture(CreativeModeTabs.INVENTORY_BACKGROUND).hideTitle().alignedRight().type(CreativeModeTab.h.INVENTORY).noScrollBar().build());
    }

    public static void validate() {
        Map<Pair<CreativeModeTab.f, Integer>, String> map = new HashMap();
        Iterator iterator = BuiltInRegistries.CREATIVE_MODE_TAB.registryKeySet().iterator();

        String s;
        String s1;

        do {
            if (!iterator.hasNext()) {
                return;
            }

            ResourceKey<CreativeModeTab> resourcekey = (ResourceKey) iterator.next();
            CreativeModeTab creativemodetab = (CreativeModeTab) BuiltInRegistries.CREATIVE_MODE_TAB.getOrThrow(resourcekey);

            s = creativemodetab.getDisplayName().getString();
            s1 = (String) map.put(Pair.of(creativemodetab.row(), creativemodetab.column()), s);
        } while (s1 == null);

        throw new IllegalArgumentException("Duplicate position: " + s + " vs. " + s1);
    }

    public static CreativeModeTab getDefaultTab() {
        return (CreativeModeTab) BuiltInRegistries.CREATIVE_MODE_TAB.getOrThrow(CreativeModeTabs.BUILDING_BLOCKS);
    }

    private static void generatePotionEffectTypes(CreativeModeTab.e creativemodetab_e, HolderLookup<PotionRegistry> holderlookup, Item item, CreativeModeTab.g creativemodetab_g, FeatureFlagSet featureflagset) {
        holderlookup.listElements().filter((holder_c) -> {
            return ((PotionRegistry) holder_c.value()).isEnabled(featureflagset);
        }).map((holder_c) -> {
            return PotionContents.createItemStack(item, holder_c);
        }).forEach((itemstack) -> {
            creativemodetab_e.accept(itemstack, creativemodetab_g);
        });
    }

    private static void generateEnchantmentBookTypesOnlyMaxLevel(CreativeModeTab.e creativemodetab_e, HolderLookup<Enchantment> holderlookup, CreativeModeTab.g creativemodetab_g) {
        holderlookup.listElements().map((holder_c) -> {
            return ItemEnchantedBook.createForEnchantment(new WeightedRandomEnchant(holder_c, ((Enchantment) holder_c.value()).getMaxLevel()));
        }).forEach((itemstack) -> {
            creativemodetab_e.accept(itemstack, creativemodetab_g);
        });
    }

    private static void generateEnchantmentBookTypesAllLevels(CreativeModeTab.e creativemodetab_e, HolderLookup<Enchantment> holderlookup, CreativeModeTab.g creativemodetab_g) {
        holderlookup.listElements().flatMap((holder_c) -> {
            return IntStream.rangeClosed(((Enchantment) holder_c.value()).getMinLevel(), ((Enchantment) holder_c.value()).getMaxLevel()).mapToObj((i) -> {
                return ItemEnchantedBook.createForEnchantment(new WeightedRandomEnchant(holder_c, i));
            });
        }).forEach((itemstack) -> {
            creativemodetab_e.accept(itemstack, creativemodetab_g);
        });
    }

    private static void generateInstrumentTypes(CreativeModeTab.e creativemodetab_e, HolderLookup<Instrument> holderlookup, Item item, TagKey<Instrument> tagkey, CreativeModeTab.g creativemodetab_g) {
        holderlookup.get(tagkey).ifPresent((holderset_named) -> {
            holderset_named.stream().map((holder) -> {
                return InstrumentItem.create(item, holder);
            }).forEach((itemstack) -> {
                creativemodetab_e.accept(itemstack, creativemodetab_g);
            });
        });
    }

    private static void generateSuspiciousStews(CreativeModeTab.e creativemodetab_e, CreativeModeTab.g creativemodetab_g) {
        List<SuspiciousEffectHolder> list = SuspiciousEffectHolder.getAllEffectHolders();
        Set<ItemStack> set = ItemStackLinkedSet.createTypeAndComponentsSet();
        Iterator iterator = list.iterator();

        while (iterator.hasNext()) {
            SuspiciousEffectHolder suspiciouseffectholder = (SuspiciousEffectHolder) iterator.next();
            ItemStack itemstack = new ItemStack(Items.SUSPICIOUS_STEW);

            itemstack.set(DataComponents.SUSPICIOUS_STEW_EFFECTS, suspiciouseffectholder.getSuspiciousEffects());
            set.add(itemstack);
        }

        creativemodetab_e.acceptAll(set, creativemodetab_g);
    }

    private static void generateOminousVials(CreativeModeTab.e creativemodetab_e, CreativeModeTab.g creativemodetab_g) {
        for (int i = 0; i <= 4; ++i) {
            ItemStack itemstack = new ItemStack(Items.OMINOUS_BOTTLE);

            itemstack.set(DataComponents.OMINOUS_BOTTLE_AMPLIFIER, i);
            creativemodetab_e.accept(itemstack, creativemodetab_g);
        }

    }

    private static void generateFireworksAllDurations(CreativeModeTab.e creativemodetab_e, CreativeModeTab.g creativemodetab_g) {
        byte[] abyte = ItemFireworks.CRAFTABLE_DURATIONS;
        int i = abyte.length;

        for (int j = 0; j < i; ++j) {
            byte b0 = abyte[j];
            ItemStack itemstack = new ItemStack(Items.FIREWORK_ROCKET);

            itemstack.set(DataComponents.FIREWORKS, new Fireworks(b0, List.of()));
            creativemodetab_e.accept(itemstack, creativemodetab_g);
        }

    }

    private static void generatePresetPaintings(CreativeModeTab.e creativemodetab_e, HolderLookup.a holderlookup_a, HolderLookup.b<PaintingVariant> holderlookup_b, Predicate<Holder<PaintingVariant>> predicate, CreativeModeTab.g creativemodetab_g) {
        RegistryOps<NBTBase> registryops = holderlookup_a.createSerializationContext(DynamicOpsNBT.INSTANCE);

        holderlookup_b.listElements().filter(predicate).sorted(CreativeModeTabs.PAINTING_COMPARATOR).forEach((holder_c) -> {
            CustomData customdata = ((CustomData) CustomData.EMPTY.update((DynamicOps) registryops, (MapEncoder) EntityPainting.VARIANT_MAP_CODEC, (Object) holder_c).getOrThrow()).update((nbttagcompound) -> {
                nbttagcompound.putString("id", "minecraft:painting");
            });
            ItemStack itemstack = new ItemStack(Items.PAINTING);

            itemstack.set(DataComponents.ENTITY_DATA, customdata);
            creativemodetab_e.accept(itemstack, creativemodetab_g);
        });
    }

    public static List<CreativeModeTab> tabs() {
        return streamAllTabs().filter(CreativeModeTab::shouldDisplay).toList();
    }

    public static List<CreativeModeTab> allTabs() {
        return streamAllTabs().toList();
    }

    private static Stream<CreativeModeTab> streamAllTabs() {
        return BuiltInRegistries.CREATIVE_MODE_TAB.stream();
    }

    public static CreativeModeTab searchTab() {
        return (CreativeModeTab) BuiltInRegistries.CREATIVE_MODE_TAB.getOrThrow(CreativeModeTabs.SEARCH);
    }

    private static void buildAllTabContents(CreativeModeTab.d creativemodetab_d) {
        streamAllTabs().filter((creativemodetab) -> {
            return creativemodetab.getType() == CreativeModeTab.h.CATEGORY;
        }).forEach((creativemodetab) -> {
            creativemodetab.buildContents(creativemodetab_d);
        });
        streamAllTabs().filter((creativemodetab) -> {
            return creativemodetab.getType() != CreativeModeTab.h.CATEGORY;
        }).forEach((creativemodetab) -> {
            creativemodetab.buildContents(creativemodetab_d);
        });
    }

    public static boolean tryRebuildTabContents(FeatureFlagSet featureflagset, boolean flag, HolderLookup.a holderlookup_a) {
        if (CreativeModeTabs.CACHED_PARAMETERS != null && !CreativeModeTabs.CACHED_PARAMETERS.needsUpdate(featureflagset, flag, holderlookup_a)) {
            return false;
        } else {
            CreativeModeTabs.CACHED_PARAMETERS = new CreativeModeTab.d(featureflagset, flag, holderlookup_a);
            buildAllTabContents(CreativeModeTabs.CACHED_PARAMETERS);
            return true;
        }
    }
}
