package net.minecraft.data.worldgen;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.placement.CavePlacements;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolStructure;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProcessorList;

public class AncientCityStructurePools {

    public AncientCityStructurePools() {}

    public static void bootstrap(BootstrapContext<WorldGenFeatureDefinedStructurePoolTemplate> bootstrapcontext) {
        HolderGetter<PlacedFeature> holdergetter = bootstrapcontext.lookup(Registries.PLACED_FEATURE);
        Holder<PlacedFeature> holder = holdergetter.getOrThrow(CavePlacements.SCULK_PATCH_ANCIENT_CITY);
        HolderGetter<ProcessorList> holdergetter1 = bootstrapcontext.lookup(Registries.PROCESSOR_LIST);
        Holder<ProcessorList> holder1 = holdergetter1.getOrThrow(ProcessorLists.ANCIENT_CITY_GENERIC_DEGRADATION);
        Holder<ProcessorList> holder2 = holdergetter1.getOrThrow(ProcessorLists.ANCIENT_CITY_WALLS_DEGRADATION);
        HolderGetter<WorldGenFeatureDefinedStructurePoolTemplate> holdergetter2 = bootstrapcontext.lookup(Registries.TEMPLATE_POOL);
        Holder<WorldGenFeatureDefinedStructurePoolTemplate> holder3 = holdergetter2.getOrThrow(WorldGenFeaturePieces.EMPTY);

        WorldGenFeaturePieces.register(bootstrapcontext, "ancient_city/structures", new WorldGenFeatureDefinedStructurePoolTemplate(holder3, ImmutableList.of(Pair.of(WorldGenFeatureDefinedStructurePoolStructure.empty(), 7), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("ancient_city/structures/barracks", (Holder) holder1), 4), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("ancient_city/structures/chamber_1", (Holder) holder1), 4), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("ancient_city/structures/chamber_2", (Holder) holder1), 4), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("ancient_city/structures/chamber_3", (Holder) holder1), 4), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("ancient_city/structures/sauna_1", (Holder) holder1), 4), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("ancient_city/structures/small_statue", (Holder) holder1), 4), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("ancient_city/structures/large_ruin_1", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("ancient_city/structures/tall_ruin_1", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("ancient_city/structures/tall_ruin_2", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("ancient_city/structures/tall_ruin_3", (Holder) holder1), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("ancient_city/structures/tall_ruin_4", (Holder) holder1), 2), new Pair[]{Pair.of(WorldGenFeatureDefinedStructurePoolStructure.list(ImmutableList.of(WorldGenFeatureDefinedStructurePoolStructure.single("ancient_city/structures/camp_1", (Holder) holder1), WorldGenFeatureDefinedStructurePoolStructure.single("ancient_city/structures/camp_2", (Holder) holder1), WorldGenFeatureDefinedStructurePoolStructure.single("ancient_city/structures/camp_3", (Holder) holder1))), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("ancient_city/structures/medium_ruin_1", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("ancient_city/structures/medium_ruin_2", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("ancient_city/structures/small_ruin_1", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("ancient_city/structures/small_ruin_2", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("ancient_city/structures/large_pillar_1", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("ancient_city/structures/medium_pillar_1", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.list(ImmutableList.of(WorldGenFeatureDefinedStructurePoolStructure.single("ancient_city/structures/ice_box_1"))), 1)}), WorldGenFeatureDefinedStructurePoolTemplate.Matching.RIGID));
        WorldGenFeaturePieces.register(bootstrapcontext, "ancient_city/sculk", new WorldGenFeatureDefinedStructurePoolTemplate(holder3, ImmutableList.of(Pair.of(WorldGenFeatureDefinedStructurePoolStructure.feature(holder), 6), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.empty(), 1)), WorldGenFeatureDefinedStructurePoolTemplate.Matching.RIGID));
        WorldGenFeaturePieces.register(bootstrapcontext, "ancient_city/walls", new WorldGenFeatureDefinedStructurePoolTemplate(holder3, ImmutableList.of(Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("ancient_city/walls/intact_corner_wall_1", (Holder) holder2), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("ancient_city/walls/intact_intersection_wall_1", (Holder) holder2), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("ancient_city/walls/intact_lshape_wall_1", (Holder) holder2), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("ancient_city/walls/intact_horizontal_wall_1", (Holder) holder2), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("ancient_city/walls/intact_horizontal_wall_2", (Holder) holder2), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("ancient_city/walls/intact_horizontal_wall_stairs_1", (Holder) holder2), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("ancient_city/walls/intact_horizontal_wall_stairs_2", (Holder) holder2), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("ancient_city/walls/intact_horizontal_wall_stairs_3", (Holder) holder2), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("ancient_city/walls/intact_horizontal_wall_stairs_4", (Holder) holder2), 4), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("ancient_city/walls/intact_horizontal_wall_passage_1", (Holder) holder2), 3), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("ancient_city/walls/ruined_corner_wall_1", (Holder) holder2), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("ancient_city/walls/ruined_corner_wall_2", (Holder) holder2), 1), new Pair[]{Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("ancient_city/walls/ruined_horizontal_wall_stairs_1", (Holder) holder2), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("ancient_city/walls/ruined_horizontal_wall_stairs_2", (Holder) holder2), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("ancient_city/walls/ruined_horizontal_wall_stairs_3", (Holder) holder2), 3), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("ancient_city/walls/ruined_horizontal_wall_stairs_4", (Holder) holder2), 3)}), WorldGenFeatureDefinedStructurePoolTemplate.Matching.RIGID));
        WorldGenFeaturePieces.register(bootstrapcontext, "ancient_city/walls/no_corners", new WorldGenFeatureDefinedStructurePoolTemplate(holder3, ImmutableList.of(Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("ancient_city/walls/intact_horizontal_wall_1", (Holder) holder2), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("ancient_city/walls/intact_horizontal_wall_2", (Holder) holder2), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("ancient_city/walls/intact_horizontal_wall_stairs_1", (Holder) holder2), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("ancient_city/walls/intact_horizontal_wall_stairs_2", (Holder) holder2), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("ancient_city/walls/intact_horizontal_wall_stairs_3", (Holder) holder2), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("ancient_city/walls/intact_horizontal_wall_stairs_4", (Holder) holder2), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("ancient_city/walls/intact_horizontal_wall_stairs_5", (Holder) holder2), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("ancient_city/walls/intact_horizontal_wall_bridge", (Holder) holder2), 1)), WorldGenFeatureDefinedStructurePoolTemplate.Matching.RIGID));
        WorldGenFeaturePieces.register(bootstrapcontext, "ancient_city/city_center/walls", new WorldGenFeatureDefinedStructurePoolTemplate(holder3, ImmutableList.of(Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("ancient_city/city_center/walls/bottom_1", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("ancient_city/city_center/walls/bottom_2", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("ancient_city/city_center/walls/bottom_left_corner", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("ancient_city/city_center/walls/bottom_right_corner_1", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("ancient_city/city_center/walls/bottom_right_corner_2", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("ancient_city/city_center/walls/left", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("ancient_city/city_center/walls/right", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("ancient_city/city_center/walls/top", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("ancient_city/city_center/walls/top_right_corner", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("ancient_city/city_center/walls/top_left_corner", (Holder) holder1), 1)), WorldGenFeatureDefinedStructurePoolTemplate.Matching.RIGID));
        WorldGenFeaturePieces.register(bootstrapcontext, "ancient_city/city/entrance", new WorldGenFeatureDefinedStructurePoolTemplate(holder3, ImmutableList.of(Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("ancient_city/city/entrance/entrance_connector", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("ancient_city/city/entrance/entrance_path_1", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("ancient_city/city/entrance/entrance_path_2", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("ancient_city/city/entrance/entrance_path_3", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("ancient_city/city/entrance/entrance_path_4", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("ancient_city/city/entrance/entrance_path_5", (Holder) holder1), 1)), WorldGenFeatureDefinedStructurePoolTemplate.Matching.RIGID));
    }
}
