package net.minecraft.data.worldgen;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeSettingsMobs;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.WorldGenStage;
import net.minecraft.world.level.levelgen.heightproviders.ConstantHeight;
import net.minecraft.world.level.levelgen.heightproviders.UniformHeight;
import net.minecraft.world.level.levelgen.structure.BuiltinStructures;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.pools.DimensionPadding;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolTemplate;
import net.minecraft.world.level.levelgen.structure.structures.BuriedTreasureStructure;
import net.minecraft.world.level.levelgen.structure.structures.DesertPyramidStructure;
import net.minecraft.world.level.levelgen.structure.structures.EndCityStructure;
import net.minecraft.world.level.levelgen.structure.structures.IglooStructure;
import net.minecraft.world.level.levelgen.structure.structures.JigsawStructure;
import net.minecraft.world.level.levelgen.structure.structures.JungleTempleStructure;
import net.minecraft.world.level.levelgen.structure.structures.MineshaftStructure;
import net.minecraft.world.level.levelgen.structure.structures.NetherFortressStructure;
import net.minecraft.world.level.levelgen.structure.structures.NetherFossilStructure;
import net.minecraft.world.level.levelgen.structure.structures.OceanMonumentStructure;
import net.minecraft.world.level.levelgen.structure.structures.OceanRuinStructure;
import net.minecraft.world.level.levelgen.structure.structures.RuinedPortalPiece;
import net.minecraft.world.level.levelgen.structure.structures.RuinedPortalStructure;
import net.minecraft.world.level.levelgen.structure.structures.ShipwreckStructure;
import net.minecraft.world.level.levelgen.structure.structures.StrongholdStructure;
import net.minecraft.world.level.levelgen.structure.structures.SwampHutStructure;
import net.minecraft.world.level.levelgen.structure.structures.WoodlandMansionStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;

public class Structures {

    public Structures() {}

    public static void bootstrap(BootstrapContext<Structure> bootstrapcontext) {
        HolderGetter<BiomeBase> holdergetter = bootstrapcontext.lookup(Registries.BIOME);
        HolderGetter<WorldGenFeatureDefinedStructurePoolTemplate> holdergetter1 = bootstrapcontext.lookup(Registries.TEMPLATE_POOL);

        bootstrapcontext.register(BuiltinStructures.PILLAGER_OUTPOST, new JigsawStructure((new Structure.c.a(holdergetter.getOrThrow(BiomeTags.HAS_PILLAGER_OUTPOST))).spawnOverrides(Map.of(EnumCreatureType.MONSTER, new StructureSpawnOverride(StructureSpawnOverride.a.STRUCTURE, WeightedRandomList.create((WeightedEntry[]) (new BiomeSettingsMobs.c(EntityTypes.PILLAGER, 1, 1, 1)))))).terrainAdapation(TerrainAdjustment.BEARD_THIN).build(), holdergetter1.getOrThrow(WorldGenFeaturePillagerOutpostPieces.START), 7, ConstantHeight.of(VerticalAnchor.absolute(0)), true, HeightMap.Type.WORLD_SURFACE_WG));
        bootstrapcontext.register(BuiltinStructures.MINESHAFT, new MineshaftStructure((new Structure.c.a(holdergetter.getOrThrow(BiomeTags.HAS_MINESHAFT))).generationStep(WorldGenStage.Decoration.UNDERGROUND_STRUCTURES).build(), MineshaftStructure.a.NORMAL));
        bootstrapcontext.register(BuiltinStructures.MINESHAFT_MESA, new MineshaftStructure((new Structure.c.a(holdergetter.getOrThrow(BiomeTags.HAS_MINESHAFT_MESA))).generationStep(WorldGenStage.Decoration.UNDERGROUND_STRUCTURES).build(), MineshaftStructure.a.MESA));
        bootstrapcontext.register(BuiltinStructures.WOODLAND_MANSION, new WoodlandMansionStructure(new Structure.c(holdergetter.getOrThrow(BiomeTags.HAS_WOODLAND_MANSION))));
        bootstrapcontext.register(BuiltinStructures.JUNGLE_TEMPLE, new JungleTempleStructure(new Structure.c(holdergetter.getOrThrow(BiomeTags.HAS_JUNGLE_TEMPLE))));
        bootstrapcontext.register(BuiltinStructures.DESERT_PYRAMID, new DesertPyramidStructure(new Structure.c(holdergetter.getOrThrow(BiomeTags.HAS_DESERT_PYRAMID))));
        bootstrapcontext.register(BuiltinStructures.IGLOO, new IglooStructure(new Structure.c(holdergetter.getOrThrow(BiomeTags.HAS_IGLOO))));
        bootstrapcontext.register(BuiltinStructures.SHIPWRECK, new ShipwreckStructure(new Structure.c(holdergetter.getOrThrow(BiomeTags.HAS_SHIPWRECK)), false));
        bootstrapcontext.register(BuiltinStructures.SHIPWRECK_BEACHED, new ShipwreckStructure(new Structure.c(holdergetter.getOrThrow(BiomeTags.HAS_SHIPWRECK_BEACHED)), true));
        bootstrapcontext.register(BuiltinStructures.SWAMP_HUT, new SwampHutStructure((new Structure.c.a(holdergetter.getOrThrow(BiomeTags.HAS_SWAMP_HUT))).spawnOverrides(Map.of(EnumCreatureType.MONSTER, new StructureSpawnOverride(StructureSpawnOverride.a.PIECE, WeightedRandomList.create((WeightedEntry[]) (new BiomeSettingsMobs.c(EntityTypes.WITCH, 1, 1, 1)))), EnumCreatureType.CREATURE, new StructureSpawnOverride(StructureSpawnOverride.a.PIECE, WeightedRandomList.create((WeightedEntry[]) (new BiomeSettingsMobs.c(EntityTypes.CAT, 1, 1, 1)))))).build()));
        bootstrapcontext.register(BuiltinStructures.STRONGHOLD, new StrongholdStructure((new Structure.c.a(holdergetter.getOrThrow(BiomeTags.HAS_STRONGHOLD))).terrainAdapation(TerrainAdjustment.BURY).build()));
        bootstrapcontext.register(BuiltinStructures.OCEAN_MONUMENT, new OceanMonumentStructure((new Structure.c.a(holdergetter.getOrThrow(BiomeTags.HAS_OCEAN_MONUMENT))).spawnOverrides(Map.of(EnumCreatureType.MONSTER, new StructureSpawnOverride(StructureSpawnOverride.a.STRUCTURE, WeightedRandomList.create((WeightedEntry[]) (new BiomeSettingsMobs.c(EntityTypes.GUARDIAN, 1, 2, 4)))), EnumCreatureType.UNDERGROUND_WATER_CREATURE, new StructureSpawnOverride(StructureSpawnOverride.a.STRUCTURE, BiomeSettingsMobs.EMPTY_MOB_LIST), EnumCreatureType.AXOLOTLS, new StructureSpawnOverride(StructureSpawnOverride.a.STRUCTURE, BiomeSettingsMobs.EMPTY_MOB_LIST))).build()));
        bootstrapcontext.register(BuiltinStructures.OCEAN_RUIN_COLD, new OceanRuinStructure(new Structure.c(holdergetter.getOrThrow(BiomeTags.HAS_OCEAN_RUIN_COLD)), OceanRuinStructure.a.COLD, 0.3F, 0.9F));
        bootstrapcontext.register(BuiltinStructures.OCEAN_RUIN_WARM, new OceanRuinStructure(new Structure.c(holdergetter.getOrThrow(BiomeTags.HAS_OCEAN_RUIN_WARM)), OceanRuinStructure.a.WARM, 0.3F, 0.9F));
        bootstrapcontext.register(BuiltinStructures.FORTRESS, new NetherFortressStructure((new Structure.c.a(holdergetter.getOrThrow(BiomeTags.HAS_NETHER_FORTRESS))).spawnOverrides(Map.of(EnumCreatureType.MONSTER, new StructureSpawnOverride(StructureSpawnOverride.a.PIECE, NetherFortressStructure.FORTRESS_ENEMIES))).generationStep(WorldGenStage.Decoration.UNDERGROUND_DECORATION).build()));
        bootstrapcontext.register(BuiltinStructures.NETHER_FOSSIL, new NetherFossilStructure((new Structure.c.a(holdergetter.getOrThrow(BiomeTags.HAS_NETHER_FOSSIL))).generationStep(WorldGenStage.Decoration.UNDERGROUND_DECORATION).terrainAdapation(TerrainAdjustment.BEARD_THIN).build(), UniformHeight.of(VerticalAnchor.absolute(32), VerticalAnchor.belowTop(2))));
        bootstrapcontext.register(BuiltinStructures.END_CITY, new EndCityStructure(new Structure.c(holdergetter.getOrThrow(BiomeTags.HAS_END_CITY))));
        bootstrapcontext.register(BuiltinStructures.BURIED_TREASURE, new BuriedTreasureStructure((new Structure.c.a(holdergetter.getOrThrow(BiomeTags.HAS_BURIED_TREASURE))).generationStep(WorldGenStage.Decoration.UNDERGROUND_STRUCTURES).build()));
        bootstrapcontext.register(BuiltinStructures.BASTION_REMNANT, new JigsawStructure(new Structure.c(holdergetter.getOrThrow(BiomeTags.HAS_BASTION_REMNANT)), holdergetter1.getOrThrow(WorldGenFeatureBastionPieces.START), 6, ConstantHeight.of(VerticalAnchor.absolute(33)), false));
        bootstrapcontext.register(BuiltinStructures.VILLAGE_PLAINS, new JigsawStructure((new Structure.c.a(holdergetter.getOrThrow(BiomeTags.HAS_VILLAGE_PLAINS))).terrainAdapation(TerrainAdjustment.BEARD_THIN).build(), holdergetter1.getOrThrow(WorldGenFeatureVillagePlain.START), 6, ConstantHeight.of(VerticalAnchor.absolute(0)), true, HeightMap.Type.WORLD_SURFACE_WG));
        bootstrapcontext.register(BuiltinStructures.VILLAGE_DESERT, new JigsawStructure((new Structure.c.a(holdergetter.getOrThrow(BiomeTags.HAS_VILLAGE_DESERT))).terrainAdapation(TerrainAdjustment.BEARD_THIN).build(), holdergetter1.getOrThrow(WorldGenFeatureDesertVillage.START), 6, ConstantHeight.of(VerticalAnchor.absolute(0)), true, HeightMap.Type.WORLD_SURFACE_WG));
        bootstrapcontext.register(BuiltinStructures.VILLAGE_SAVANNA, new JigsawStructure((new Structure.c.a(holdergetter.getOrThrow(BiomeTags.HAS_VILLAGE_SAVANNA))).terrainAdapation(TerrainAdjustment.BEARD_THIN).build(), holdergetter1.getOrThrow(WorldGenFeatureVillageSavanna.START), 6, ConstantHeight.of(VerticalAnchor.absolute(0)), true, HeightMap.Type.WORLD_SURFACE_WG));
        bootstrapcontext.register(BuiltinStructures.VILLAGE_SNOWY, new JigsawStructure((new Structure.c.a(holdergetter.getOrThrow(BiomeTags.HAS_VILLAGE_SNOWY))).terrainAdapation(TerrainAdjustment.BEARD_THIN).build(), holdergetter1.getOrThrow(WorldGenFeatureVillageSnowy.START), 6, ConstantHeight.of(VerticalAnchor.absolute(0)), true, HeightMap.Type.WORLD_SURFACE_WG));
        bootstrapcontext.register(BuiltinStructures.VILLAGE_TAIGA, new JigsawStructure((new Structure.c.a(holdergetter.getOrThrow(BiomeTags.HAS_VILLAGE_TAIGA))).terrainAdapation(TerrainAdjustment.BEARD_THIN).build(), holdergetter1.getOrThrow(WorldGenFeatureVillageTaiga.START), 6, ConstantHeight.of(VerticalAnchor.absolute(0)), true, HeightMap.Type.WORLD_SURFACE_WG));
        bootstrapcontext.register(BuiltinStructures.RUINED_PORTAL_STANDARD, new RuinedPortalStructure(new Structure.c(holdergetter.getOrThrow(BiomeTags.HAS_RUINED_PORTAL_STANDARD)), List.of(new RuinedPortalStructure.a(RuinedPortalPiece.b.UNDERGROUND, 1.0F, 0.2F, false, false, true, false, 0.5F), new RuinedPortalStructure.a(RuinedPortalPiece.b.ON_LAND_SURFACE, 0.5F, 0.2F, false, false, true, false, 0.5F))));
        bootstrapcontext.register(BuiltinStructures.RUINED_PORTAL_DESERT, new RuinedPortalStructure(new Structure.c(holdergetter.getOrThrow(BiomeTags.HAS_RUINED_PORTAL_DESERT)), new RuinedPortalStructure.a(RuinedPortalPiece.b.PARTLY_BURIED, 0.0F, 0.0F, false, false, false, false, 1.0F)));
        bootstrapcontext.register(BuiltinStructures.RUINED_PORTAL_JUNGLE, new RuinedPortalStructure(new Structure.c(holdergetter.getOrThrow(BiomeTags.HAS_RUINED_PORTAL_JUNGLE)), new RuinedPortalStructure.a(RuinedPortalPiece.b.ON_LAND_SURFACE, 0.5F, 0.8F, true, true, false, false, 1.0F)));
        bootstrapcontext.register(BuiltinStructures.RUINED_PORTAL_SWAMP, new RuinedPortalStructure(new Structure.c(holdergetter.getOrThrow(BiomeTags.HAS_RUINED_PORTAL_SWAMP)), new RuinedPortalStructure.a(RuinedPortalPiece.b.ON_OCEAN_FLOOR, 0.0F, 0.5F, false, true, false, false, 1.0F)));
        bootstrapcontext.register(BuiltinStructures.RUINED_PORTAL_MOUNTAIN, new RuinedPortalStructure(new Structure.c(holdergetter.getOrThrow(BiomeTags.HAS_RUINED_PORTAL_MOUNTAIN)), List.of(new RuinedPortalStructure.a(RuinedPortalPiece.b.IN_MOUNTAIN, 1.0F, 0.2F, false, false, true, false, 0.5F), new RuinedPortalStructure.a(RuinedPortalPiece.b.ON_LAND_SURFACE, 0.5F, 0.2F, false, false, true, false, 0.5F))));
        bootstrapcontext.register(BuiltinStructures.RUINED_PORTAL_OCEAN, new RuinedPortalStructure(new Structure.c(holdergetter.getOrThrow(BiomeTags.HAS_RUINED_PORTAL_OCEAN)), new RuinedPortalStructure.a(RuinedPortalPiece.b.ON_OCEAN_FLOOR, 0.0F, 0.8F, false, false, true, false, 1.0F)));
        bootstrapcontext.register(BuiltinStructures.RUINED_PORTAL_NETHER, new RuinedPortalStructure(new Structure.c(holdergetter.getOrThrow(BiomeTags.HAS_RUINED_PORTAL_NETHER)), new RuinedPortalStructure.a(RuinedPortalPiece.b.IN_NETHER, 0.5F, 0.0F, false, false, false, true, 1.0F)));
        bootstrapcontext.register(BuiltinStructures.ANCIENT_CITY, new JigsawStructure((new Structure.c.a(holdergetter.getOrThrow(BiomeTags.HAS_ANCIENT_CITY))).spawnOverrides((Map) Arrays.stream(EnumCreatureType.values()).collect(Collectors.toMap((enumcreaturetype) -> {
            return enumcreaturetype;
        }, (enumcreaturetype) -> {
            return new StructureSpawnOverride(StructureSpawnOverride.a.STRUCTURE, WeightedRandomList.create());
        }))).generationStep(WorldGenStage.Decoration.UNDERGROUND_DECORATION).terrainAdapation(TerrainAdjustment.BEARD_BOX).build(), holdergetter1.getOrThrow(AncientCityStructurePieces.START), Optional.of(MinecraftKey.withDefaultNamespace("city_anchor")), 7, ConstantHeight.of(VerticalAnchor.absolute(-27)), false, Optional.empty(), 116, List.of(), JigsawStructure.DEFAULT_DIMENSION_PADDING, JigsawStructure.DEFAULT_LIQUID_SETTINGS));
        bootstrapcontext.register(BuiltinStructures.TRAIL_RUINS, new JigsawStructure((new Structure.c.a(holdergetter.getOrThrow(BiomeTags.HAS_TRAIL_RUINS))).generationStep(WorldGenStage.Decoration.UNDERGROUND_STRUCTURES).terrainAdapation(TerrainAdjustment.BURY).build(), holdergetter1.getOrThrow(TrailRuinsStructurePools.START), 7, ConstantHeight.of(VerticalAnchor.absolute(-15)), false, HeightMap.Type.WORLD_SURFACE_WG));
        bootstrapcontext.register(BuiltinStructures.TRIAL_CHAMBERS, new JigsawStructure((new Structure.c.a(holdergetter.getOrThrow(BiomeTags.HAS_TRIAL_CHAMBERS))).generationStep(WorldGenStage.Decoration.UNDERGROUND_STRUCTURES).terrainAdapation(TerrainAdjustment.ENCAPSULATE).spawnOverrides((Map) Arrays.stream(EnumCreatureType.values()).collect(Collectors.toMap((enumcreaturetype) -> {
            return enumcreaturetype;
        }, (enumcreaturetype) -> {
            return new StructureSpawnOverride(StructureSpawnOverride.a.PIECE, WeightedRandomList.create());
        }))).build(), holdergetter1.getOrThrow(TrialChambersStructurePools.START), Optional.empty(), 20, UniformHeight.of(VerticalAnchor.absolute(-40), VerticalAnchor.absolute(-20)), false, Optional.empty(), 116, TrialChambersStructurePools.ALIAS_BINDINGS, new DimensionPadding(10), LiquidSettings.IGNORE_WATERLOGGING));
    }
}
