package net.minecraft.data.worldgen;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolStructure;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProcessorList;

public class TrailRuinsStructurePools {

    public static final ResourceKey<WorldGenFeatureDefinedStructurePoolTemplate> START = WorldGenFeaturePieces.createKey("trail_ruins/tower");

    public TrailRuinsStructurePools() {}

    public static void bootstrap(BootstrapContext<WorldGenFeatureDefinedStructurePoolTemplate> bootstrapcontext) {
        HolderGetter<WorldGenFeatureDefinedStructurePoolTemplate> holdergetter = bootstrapcontext.lookup(Registries.TEMPLATE_POOL);
        Holder<WorldGenFeatureDefinedStructurePoolTemplate> holder = holdergetter.getOrThrow(WorldGenFeaturePieces.EMPTY);
        HolderGetter<ProcessorList> holdergetter1 = bootstrapcontext.lookup(Registries.PROCESSOR_LIST);
        Holder<ProcessorList> holder1 = holdergetter1.getOrThrow(ProcessorLists.TRAIL_RUINS_HOUSES_ARCHAEOLOGY);
        Holder<ProcessorList> holder2 = holdergetter1.getOrThrow(ProcessorLists.TRAIL_RUINS_ROADS_ARCHAEOLOGY);
        Holder<ProcessorList> holder3 = holdergetter1.getOrThrow(ProcessorLists.TRAIL_RUINS_TOWER_TOP_ARCHAEOLOGY);

        bootstrapcontext.register(TrailRuinsStructurePools.START, new WorldGenFeatureDefinedStructurePoolTemplate(holder, List.of(Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("trail_ruins/tower/tower_1", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("trail_ruins/tower/tower_2", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("trail_ruins/tower/tower_3", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("trail_ruins/tower/tower_4", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("trail_ruins/tower/tower_5", (Holder) holder1), 1)), WorldGenFeatureDefinedStructurePoolTemplate.Matching.RIGID));
        WorldGenFeaturePieces.register(bootstrapcontext, "trail_ruins/tower/tower_top", new WorldGenFeatureDefinedStructurePoolTemplate(holder, List.of(Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("trail_ruins/tower/tower_top_1", (Holder) holder3), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("trail_ruins/tower/tower_top_2", (Holder) holder3), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("trail_ruins/tower/tower_top_3", (Holder) holder3), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("trail_ruins/tower/tower_top_4", (Holder) holder3), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("trail_ruins/tower/tower_top_5", (Holder) holder3), 1)), WorldGenFeatureDefinedStructurePoolTemplate.Matching.RIGID));
        WorldGenFeaturePieces.register(bootstrapcontext, "trail_ruins/tower/additions", new WorldGenFeatureDefinedStructurePoolTemplate(holder, List.of(Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("trail_ruins/tower/hall_1", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("trail_ruins/tower/hall_2", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("trail_ruins/tower/hall_3", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("trail_ruins/tower/hall_4", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("trail_ruins/tower/hall_5", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("trail_ruins/tower/large_hall_1", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("trail_ruins/tower/large_hall_2", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("trail_ruins/tower/large_hall_3", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("trail_ruins/tower/large_hall_4", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("trail_ruins/tower/large_hall_5", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("trail_ruins/tower/one_room_1", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("trail_ruins/tower/one_room_2", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("trail_ruins/tower/one_room_3", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("trail_ruins/tower/one_room_4", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("trail_ruins/tower/one_room_5", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("trail_ruins/tower/platform_1", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("trail_ruins/tower/platform_2", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("trail_ruins/tower/platform_3", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("trail_ruins/tower/platform_4", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("trail_ruins/tower/platform_5", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("trail_ruins/tower/stable_1", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("trail_ruins/tower/stable_2", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("trail_ruins/tower/stable_3", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("trail_ruins/tower/stable_4", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("trail_ruins/tower/stable_5", (Holder) holder1), 1)), WorldGenFeatureDefinedStructurePoolTemplate.Matching.RIGID));
        WorldGenFeaturePieces.register(bootstrapcontext, "trail_ruins/roads", new WorldGenFeatureDefinedStructurePoolTemplate(holder, List.of(Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("trail_ruins/roads/long_road_end", (Holder) holder2), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("trail_ruins/roads/road_end_1", (Holder) holder2), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("trail_ruins/roads/road_section_1", (Holder) holder2), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("trail_ruins/roads/road_section_2", (Holder) holder2), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("trail_ruins/roads/road_section_3", (Holder) holder2), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("trail_ruins/roads/road_section_4", (Holder) holder2), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("trail_ruins/roads/road_spacer_1", (Holder) holder2), 1)), WorldGenFeatureDefinedStructurePoolTemplate.Matching.RIGID));
        WorldGenFeaturePieces.register(bootstrapcontext, "trail_ruins/buildings", new WorldGenFeatureDefinedStructurePoolTemplate(holder, List.of(Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("trail_ruins/buildings/group_hall_1", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("trail_ruins/buildings/group_hall_2", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("trail_ruins/buildings/group_hall_3", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("trail_ruins/buildings/group_hall_4", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("trail_ruins/buildings/group_hall_5", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("trail_ruins/buildings/large_room_1", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("trail_ruins/buildings/large_room_2", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("trail_ruins/buildings/large_room_3", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("trail_ruins/buildings/large_room_4", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("trail_ruins/buildings/large_room_5", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("trail_ruins/buildings/one_room_1", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("trail_ruins/buildings/one_room_2", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("trail_ruins/buildings/one_room_3", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("trail_ruins/buildings/one_room_4", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("trail_ruins/buildings/one_room_5", (Holder) holder1), 1)), WorldGenFeatureDefinedStructurePoolTemplate.Matching.RIGID));
        WorldGenFeaturePieces.register(bootstrapcontext, "trail_ruins/buildings/grouped", new WorldGenFeatureDefinedStructurePoolTemplate(holder, List.of(Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("trail_ruins/buildings/group_full_1", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("trail_ruins/buildings/group_full_2", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("trail_ruins/buildings/group_full_3", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("trail_ruins/buildings/group_full_4", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("trail_ruins/buildings/group_full_5", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("trail_ruins/buildings/group_lower_1", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("trail_ruins/buildings/group_lower_2", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("trail_ruins/buildings/group_lower_3", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("trail_ruins/buildings/group_lower_4", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("trail_ruins/buildings/group_lower_5", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("trail_ruins/buildings/group_upper_1", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("trail_ruins/buildings/group_upper_2", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("trail_ruins/buildings/group_upper_3", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("trail_ruins/buildings/group_upper_4", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("trail_ruins/buildings/group_upper_5", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("trail_ruins/buildings/group_room_1", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("trail_ruins/buildings/group_room_2", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("trail_ruins/buildings/group_room_3", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("trail_ruins/buildings/group_room_4", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("trail_ruins/buildings/group_room_5", (Holder) holder1), 1)), WorldGenFeatureDefinedStructurePoolTemplate.Matching.RIGID));
        WorldGenFeaturePieces.register(bootstrapcontext, "trail_ruins/decor", new WorldGenFeatureDefinedStructurePoolTemplate(holder, List.of(Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("trail_ruins/decor/decor_1", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("trail_ruins/decor/decor_2", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("trail_ruins/decor/decor_3", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("trail_ruins/decor/decor_4", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("trail_ruins/decor/decor_5", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("trail_ruins/decor/decor_6", (Holder) holder1), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.single("trail_ruins/decor/decor_7", (Holder) holder1), 1)), WorldGenFeatureDefinedStructurePoolTemplate.Matching.RIGID));
    }
}
