package net.minecraft.data.worldgen;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.placement.VillagePlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolStructure;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProcessorList;

public class WorldGenFeatureVillageSavanna {

    public static final ResourceKey<WorldGenFeatureDefinedStructurePoolTemplate> START = WorldGenFeaturePieces.createKey("village/savanna/town_centers");
    private static final ResourceKey<WorldGenFeatureDefinedStructurePoolTemplate> TERMINATORS_KEY = WorldGenFeaturePieces.createKey("village/savanna/terminators");
    private static final ResourceKey<WorldGenFeatureDefinedStructurePoolTemplate> ZOMBIE_TERMINATORS_KEY = WorldGenFeaturePieces.createKey("village/savanna/zombie/terminators");

    public WorldGenFeatureVillageSavanna() {}

    public static void bootstrap(BootstrapContext<WorldGenFeatureDefinedStructurePoolTemplate> bootstrapcontext) {
        HolderGetter<PlacedFeature> holdergetter = bootstrapcontext.lookup(Registries.PLACED_FEATURE);
        Holder<PlacedFeature> holder = holdergetter.getOrThrow(VillagePlacements.ACACIA_VILLAGE);
        Holder<PlacedFeature> holder1 = holdergetter.getOrThrow(VillagePlacements.PILE_HAY_VILLAGE);
        Holder<PlacedFeature> holder2 = holdergetter.getOrThrow(VillagePlacements.PILE_MELON_VILLAGE);
        HolderGetter<ProcessorList> holdergetter1 = bootstrapcontext.lookup(Registries.PROCESSOR_LIST);
        Holder<ProcessorList> holder3 = holdergetter1.getOrThrow(ProcessorLists.ZOMBIE_SAVANNA);
        Holder<ProcessorList> holder4 = holdergetter1.getOrThrow(ProcessorLists.STREET_SAVANNA);
        Holder<ProcessorList> holder5 = holdergetter1.getOrThrow(ProcessorLists.FARM_SAVANNA);
        HolderGetter<WorldGenFeatureDefinedStructurePoolTemplate> holdergetter2 = bootstrapcontext.lookup(Registries.TEMPLATE_POOL);
        Holder<WorldGenFeatureDefinedStructurePoolTemplate> holder6 = holdergetter2.getOrThrow(WorldGenFeaturePieces.EMPTY);
        Holder<WorldGenFeatureDefinedStructurePoolTemplate> holder7 = holdergetter2.getOrThrow(WorldGenFeatureVillageSavanna.TERMINATORS_KEY);
        Holder<WorldGenFeatureDefinedStructurePoolTemplate> holder8 = holdergetter2.getOrThrow(WorldGenFeatureVillageSavanna.ZOMBIE_TERMINATORS_KEY);

        bootstrapcontext.register(WorldGenFeatureVillageSavanna.START, new WorldGenFeatureDefinedStructurePoolTemplate(holder6, ImmutableList.of(Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/town_centers/savanna_meeting_point_1"), 100), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/town_centers/savanna_meeting_point_2"), 50), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/town_centers/savanna_meeting_point_3"), 150), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/town_centers/savanna_meeting_point_4"), 150), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/zombie/town_centers/savanna_meeting_point_1", holder3), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/zombie/town_centers/savanna_meeting_point_2", holder3), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/zombie/town_centers/savanna_meeting_point_3", holder3), 3), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/zombie/town_centers/savanna_meeting_point_4", holder3), 3)), WorldGenFeatureDefinedStructurePoolTemplate.Matching.RIGID));
        WorldGenFeaturePieces.register(bootstrapcontext, "village/savanna/streets", new WorldGenFeatureDefinedStructurePoolTemplate(holder7, ImmutableList.of(Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/streets/corner_01", holder4), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/streets/corner_03", holder4), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/streets/straight_02", holder4), 4), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/streets/straight_04", holder4), 7), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/streets/straight_05", holder4), 3), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/streets/straight_06", holder4), 4), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/streets/straight_08", holder4), 4), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/streets/straight_09", holder4), 4), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/streets/straight_10", holder4), 4), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/streets/straight_11", holder4), 4), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/streets/crossroad_02", holder4), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/streets/crossroad_03", holder4), 2), new Pair[]{Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/streets/crossroad_04", holder4), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/streets/crossroad_05", holder4), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/streets/crossroad_06", holder4), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/streets/crossroad_07", holder4), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/streets/split_01", holder4), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/streets/split_02", holder4), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/streets/turn_01", holder4), 3)}), WorldGenFeatureDefinedStructurePoolTemplate.Matching.TERRAIN_MATCHING));
        WorldGenFeaturePieces.register(bootstrapcontext, "village/savanna/zombie/streets", new WorldGenFeatureDefinedStructurePoolTemplate(holder8, ImmutableList.of(Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/zombie/streets/corner_01", holder4), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/zombie/streets/corner_03", holder4), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/zombie/streets/straight_02", holder4), 4), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/zombie/streets/straight_04", holder4), 7), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/zombie/streets/straight_05", holder4), 3), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/zombie/streets/straight_06", holder4), 4), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/zombie/streets/straight_08", holder4), 4), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/zombie/streets/straight_09", holder4), 4), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/zombie/streets/straight_10", holder4), 4), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/zombie/streets/straight_11", holder4), 4), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/zombie/streets/crossroad_02", holder4), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/zombie/streets/crossroad_03", holder4), 2), new Pair[]{Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/zombie/streets/crossroad_04", holder4), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/zombie/streets/crossroad_05", holder4), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/zombie/streets/crossroad_06", holder4), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/zombie/streets/crossroad_07", holder4), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/zombie/streets/split_01", holder4), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/zombie/streets/split_02", holder4), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/zombie/streets/turn_01", holder4), 3)}), WorldGenFeatureDefinedStructurePoolTemplate.Matching.TERRAIN_MATCHING));
        WorldGenFeaturePieces.register(bootstrapcontext, "village/savanna/houses", new WorldGenFeatureDefinedStructurePoolTemplate(holder7, ImmutableList.of(Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/houses/savanna_small_house_1"), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/houses/savanna_small_house_2"), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/houses/savanna_small_house_3"), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/houses/savanna_small_house_4"), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/houses/savanna_small_house_5"), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/houses/savanna_small_house_6"), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/houses/savanna_small_house_7"), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/houses/savanna_small_house_8"), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/houses/savanna_medium_house_1"), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/houses/savanna_medium_house_2"), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/houses/savanna_butchers_shop_1"), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/houses/savanna_butchers_shop_2"), 2), new Pair[]{Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/houses/savanna_tool_smith_1"), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/houses/savanna_fletcher_house_1"), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/houses/savanna_shepherd_1"), 7), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/houses/savanna_armorer_1"), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/houses/savanna_fisher_cottage_1"), 3), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/houses/savanna_tannery_1"), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/houses/savanna_cartographer_1"), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/houses/savanna_library_1"), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/houses/savanna_mason_1"), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/houses/savanna_weaponsmith_1"), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/houses/savanna_weaponsmith_2"), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/houses/savanna_temple_1"), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/houses/savanna_temple_2"), 3), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/houses/savanna_large_farm_1", holder5), 4), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/houses/savanna_large_farm_2", holder5), 6), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/houses/savanna_small_farm", holder5), 4), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/houses/savanna_animal_pen_1"), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/houses/savanna_animal_pen_2"), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/houses/savanna_animal_pen_3"), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.empty(), 5)}), WorldGenFeatureDefinedStructurePoolTemplate.Matching.RIGID));
        WorldGenFeaturePieces.register(bootstrapcontext, "village/savanna/zombie/houses", new WorldGenFeatureDefinedStructurePoolTemplate(holder8, ImmutableList.of(Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/zombie/houses/savanna_small_house_1", holder3), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/zombie/houses/savanna_small_house_2", holder3), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/zombie/houses/savanna_small_house_3", holder3), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/zombie/houses/savanna_small_house_4", holder3), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/zombie/houses/savanna_small_house_5", holder3), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/zombie/houses/savanna_small_house_6", holder3), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/zombie/houses/savanna_small_house_7", holder3), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/zombie/houses/savanna_small_house_8", holder3), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/zombie/houses/savanna_medium_house_1", holder3), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/zombie/houses/savanna_medium_house_2", holder3), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/houses/savanna_butchers_shop_1", holder3), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/houses/savanna_butchers_shop_2", holder3), 2), new Pair[]{Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/houses/savanna_tool_smith_1", holder3), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/houses/savanna_fletcher_house_1", holder3), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/houses/savanna_shepherd_1", holder3), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/houses/savanna_armorer_1", holder3), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/houses/savanna_fisher_cottage_1", holder3), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/houses/savanna_tannery_1", holder3), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/houses/savanna_cartographer_1", holder3), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/houses/savanna_library_1", holder3), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/houses/savanna_mason_1", holder3), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/houses/savanna_weaponsmith_1", holder3), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/houses/savanna_weaponsmith_2", holder3), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/houses/savanna_temple_1", holder3), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/houses/savanna_temple_2", holder3), 3), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/houses/savanna_large_farm_1", holder3), 4), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/zombie/houses/savanna_large_farm_2", holder3), 4), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/houses/savanna_small_farm", holder3), 4), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/houses/savanna_animal_pen_1", holder3), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/zombie/houses/savanna_animal_pen_2", holder3), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/zombie/houses/savanna_animal_pen_3", holder3), 2), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.empty(), 5)}), WorldGenFeatureDefinedStructurePoolTemplate.Matching.RIGID));
        bootstrapcontext.register(WorldGenFeatureVillageSavanna.TERMINATORS_KEY, new WorldGenFeatureDefinedStructurePoolTemplate(holder6, ImmutableList.of(Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/plains/terminators/terminator_01", holder4), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/plains/terminators/terminator_02", holder4), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/plains/terminators/terminator_03", holder4), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/plains/terminators/terminator_04", holder4), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/terminators/terminator_05", holder4), 1)), WorldGenFeatureDefinedStructurePoolTemplate.Matching.TERRAIN_MATCHING));
        bootstrapcontext.register(WorldGenFeatureVillageSavanna.ZOMBIE_TERMINATORS_KEY, new WorldGenFeatureDefinedStructurePoolTemplate(holder6, ImmutableList.of(Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/plains/terminators/terminator_01", holder4), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/plains/terminators/terminator_02", holder4), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/plains/terminators/terminator_03", holder4), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/plains/terminators/terminator_04", holder4), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/zombie/terminators/terminator_05", holder4), 1)), WorldGenFeatureDefinedStructurePoolTemplate.Matching.TERRAIN_MATCHING));
        WorldGenFeaturePieces.register(bootstrapcontext, "village/savanna/trees", new WorldGenFeatureDefinedStructurePoolTemplate(holder6, ImmutableList.of(Pair.of(WorldGenFeatureDefinedStructurePoolStructure.feature(holder), 1)), WorldGenFeatureDefinedStructurePoolTemplate.Matching.RIGID));
        WorldGenFeaturePieces.register(bootstrapcontext, "village/savanna/decor", new WorldGenFeatureDefinedStructurePoolTemplate(holder6, ImmutableList.of(Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/savanna_lamp_post_01"), 4), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.feature(holder), 4), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.feature(holder1), 4), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.feature(holder2), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.empty(), 4)), WorldGenFeatureDefinedStructurePoolTemplate.Matching.RIGID));
        WorldGenFeaturePieces.register(bootstrapcontext, "village/savanna/zombie/decor", new WorldGenFeatureDefinedStructurePoolTemplate(holder6, ImmutableList.of(Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/savanna_lamp_post_01", holder3), 4), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.feature(holder), 4), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.feature(holder1), 4), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.feature(holder2), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.empty(), 4)), WorldGenFeatureDefinedStructurePoolTemplate.Matching.RIGID));
        WorldGenFeaturePieces.register(bootstrapcontext, "village/savanna/villagers", new WorldGenFeatureDefinedStructurePoolTemplate(holder6, ImmutableList.of(Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/villagers/nitwit"), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/villagers/baby"), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/villagers/unemployed"), 10)), WorldGenFeatureDefinedStructurePoolTemplate.Matching.RIGID));
        WorldGenFeaturePieces.register(bootstrapcontext, "village/savanna/zombie/villagers", new WorldGenFeatureDefinedStructurePoolTemplate(holder6, ImmutableList.of(Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/zombie/villagers/nitwit"), 1), Pair.of(WorldGenFeatureDefinedStructurePoolStructure.legacy("village/savanna/zombie/villagers/unemployed"), 10)), WorldGenFeatureDefinedStructurePoolTemplate.Matching.RIGID));
    }
}
