package net.minecraft.network.protocol.game;

import net.minecraft.network.EnumProtocol;
import net.minecraft.network.ProtocolInfo;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.ProtocolInfoBuilder;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.ClientboundCustomReportDetailsPacket;
import net.minecraft.network.protocol.common.ClientboundDisconnectPacket;
import net.minecraft.network.protocol.common.ClientboundKeepAlivePacket;
import net.minecraft.network.protocol.common.ClientboundPingPacket;
import net.minecraft.network.protocol.common.ClientboundResourcePackPopPacket;
import net.minecraft.network.protocol.common.ClientboundResourcePackPushPacket;
import net.minecraft.network.protocol.common.ClientboundServerLinksPacket;
import net.minecraft.network.protocol.common.ClientboundStoreCookiePacket;
import net.minecraft.network.protocol.common.ClientboundTransferPacket;
import net.minecraft.network.protocol.common.ClientboundUpdateTagsPacket;
import net.minecraft.network.protocol.common.CommonPacketTypes;
import net.minecraft.network.protocol.common.ServerboundClientInformationPacket;
import net.minecraft.network.protocol.common.ServerboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.ServerboundKeepAlivePacket;
import net.minecraft.network.protocol.common.ServerboundPongPacket;
import net.minecraft.network.protocol.common.ServerboundResourcePackPacket;
import net.minecraft.network.protocol.cookie.ClientboundCookieRequestPacket;
import net.minecraft.network.protocol.cookie.CookiePacketTypes;
import net.minecraft.network.protocol.cookie.ServerboundCookieResponsePacket;
import net.minecraft.network.protocol.ping.ClientboundPongResponsePacket;
import net.minecraft.network.protocol.ping.PingPacketTypes;
import net.minecraft.network.protocol.ping.ServerboundPingRequestPacket;

public class GameProtocols {

    public static final ProtocolInfo.a<PacketListenerPlayIn, RegistryFriendlyByteBuf> SERVERBOUND_TEMPLATE = ProtocolInfoBuilder.serverboundProtocol(EnumProtocol.PLAY, (protocolinfobuilder) -> {
        protocolinfobuilder.addPacket(GamePacketTypes.SERVERBOUND_ACCEPT_TELEPORTATION, PacketPlayInTeleportAccept.STREAM_CODEC).addPacket(GamePacketTypes.SERVERBOUND_BLOCK_ENTITY_TAG_QUERY, PacketPlayInTileNBTQuery.STREAM_CODEC).addPacket(GamePacketTypes.SERVERBOUND_CHANGE_DIFFICULTY, PacketPlayInDifficultyChange.STREAM_CODEC).addPacket(GamePacketTypes.SERVERBOUND_CHAT_ACK, ServerboundChatAckPacket.STREAM_CODEC).addPacket(GamePacketTypes.SERVERBOUND_CHAT_COMMAND, ServerboundChatCommandPacket.STREAM_CODEC).addPacket(GamePacketTypes.SERVERBOUND_CHAT_COMMAND_SIGNED, ServerboundChatCommandSignedPacket.STREAM_CODEC).addPacket(GamePacketTypes.SERVERBOUND_CHAT, PacketPlayInChat.STREAM_CODEC).addPacket(GamePacketTypes.SERVERBOUND_CHAT_SESSION_UPDATE, ServerboundChatSessionUpdatePacket.STREAM_CODEC).addPacket(GamePacketTypes.SERVERBOUND_CHUNK_BATCH_RECEIVED, ServerboundChunkBatchReceivedPacket.STREAM_CODEC).addPacket(GamePacketTypes.SERVERBOUND_CLIENT_COMMAND, PacketPlayInClientCommand.STREAM_CODEC).addPacket(CommonPacketTypes.SERVERBOUND_CLIENT_INFORMATION, ServerboundClientInformationPacket.STREAM_CODEC).addPacket(GamePacketTypes.SERVERBOUND_COMMAND_SUGGESTION, PacketPlayInTabComplete.STREAM_CODEC).addPacket(GamePacketTypes.SERVERBOUND_CONFIGURATION_ACKNOWLEDGED, ServerboundConfigurationAcknowledgedPacket.STREAM_CODEC).addPacket(GamePacketTypes.SERVERBOUND_CONTAINER_BUTTON_CLICK, PacketPlayInEnchantItem.STREAM_CODEC).addPacket(GamePacketTypes.SERVERBOUND_CONTAINER_CLICK, PacketPlayInWindowClick.STREAM_CODEC).addPacket(GamePacketTypes.SERVERBOUND_CONTAINER_CLOSE, PacketPlayInCloseWindow.STREAM_CODEC).addPacket(GamePacketTypes.SERVERBOUND_CONTAINER_SLOT_STATE_CHANGED, ServerboundContainerSlotStateChangedPacket.STREAM_CODEC).addPacket(CookiePacketTypes.SERVERBOUND_COOKIE_RESPONSE, ServerboundCookieResponsePacket.STREAM_CODEC).addPacket(CommonPacketTypes.SERVERBOUND_CUSTOM_PAYLOAD, ServerboundCustomPayloadPacket.STREAM_CODEC).addPacket(GamePacketTypes.SERVERBOUND_DEBUG_SAMPLE_SUBSCRIPTION, ServerboundDebugSampleSubscriptionPacket.STREAM_CODEC).addPacket(GamePacketTypes.SERVERBOUND_EDIT_BOOK, PacketPlayInBEdit.STREAM_CODEC).addPacket(GamePacketTypes.SERVERBOUND_ENTITY_TAG_QUERY, PacketPlayInEntityNBTQuery.STREAM_CODEC).addPacket(GamePacketTypes.SERVERBOUND_INTERACT, PacketPlayInUseEntity.STREAM_CODEC).addPacket(GamePacketTypes.SERVERBOUND_JIGSAW_GENERATE, PacketPlayInJigsawGenerate.STREAM_CODEC).addPacket(CommonPacketTypes.SERVERBOUND_KEEP_ALIVE, ServerboundKeepAlivePacket.STREAM_CODEC).addPacket(GamePacketTypes.SERVERBOUND_LOCK_DIFFICULTY, PacketPlayInDifficultyLock.STREAM_CODEC).addPacket(GamePacketTypes.SERVERBOUND_MOVE_PLAYER_POS, PacketPlayInFlying.PacketPlayInPosition.STREAM_CODEC).addPacket(GamePacketTypes.SERVERBOUND_MOVE_PLAYER_POS_ROT, PacketPlayInFlying.PacketPlayInPositionLook.STREAM_CODEC).addPacket(GamePacketTypes.SERVERBOUND_MOVE_PLAYER_ROT, PacketPlayInFlying.PacketPlayInLook.STREAM_CODEC).addPacket(GamePacketTypes.SERVERBOUND_MOVE_PLAYER_STATUS_ONLY, PacketPlayInFlying.d.STREAM_CODEC).addPacket(GamePacketTypes.SERVERBOUND_MOVE_VEHICLE, PacketPlayInVehicleMove.STREAM_CODEC).addPacket(GamePacketTypes.SERVERBOUND_PADDLE_BOAT, PacketPlayInBoatMove.STREAM_CODEC).addPacket(GamePacketTypes.SERVERBOUND_PICK_ITEM, PacketPlayInPickItem.STREAM_CODEC).addPacket(PingPacketTypes.SERVERBOUND_PING_REQUEST, ServerboundPingRequestPacket.STREAM_CODEC).addPacket(GamePacketTypes.SERVERBOUND_PLACE_RECIPE, PacketPlayInAutoRecipe.STREAM_CODEC).addPacket(GamePacketTypes.SERVERBOUND_PLAYER_ABILITIES, PacketPlayInAbilities.STREAM_CODEC).addPacket(GamePacketTypes.SERVERBOUND_PLAYER_ACTION, PacketPlayInBlockDig.STREAM_CODEC).addPacket(GamePacketTypes.SERVERBOUND_PLAYER_COMMAND, PacketPlayInEntityAction.STREAM_CODEC).addPacket(GamePacketTypes.SERVERBOUND_PLAYER_INPUT, PacketPlayInSteerVehicle.STREAM_CODEC).addPacket(CommonPacketTypes.SERVERBOUND_PONG, ServerboundPongPacket.STREAM_CODEC).addPacket(GamePacketTypes.SERVERBOUND_RECIPE_BOOK_CHANGE_SETTINGS, PacketPlayInRecipeSettings.STREAM_CODEC).addPacket(GamePacketTypes.SERVERBOUND_RECIPE_BOOK_SEEN_RECIPE, PacketPlayInRecipeDisplayed.STREAM_CODEC).addPacket(GamePacketTypes.SERVERBOUND_RENAME_ITEM, PacketPlayInItemName.STREAM_CODEC).addPacket(CommonPacketTypes.SERVERBOUND_RESOURCE_PACK, ServerboundResourcePackPacket.STREAM_CODEC).addPacket(GamePacketTypes.SERVERBOUND_SEEN_ADVANCEMENTS, PacketPlayInAdvancements.STREAM_CODEC).addPacket(GamePacketTypes.SERVERBOUND_SELECT_TRADE, PacketPlayInTrSel.STREAM_CODEC).addPacket(GamePacketTypes.SERVERBOUND_SET_BEACON, PacketPlayInBeacon.STREAM_CODEC).addPacket(GamePacketTypes.SERVERBOUND_SET_CARRIED_ITEM, PacketPlayInHeldItemSlot.STREAM_CODEC).addPacket(GamePacketTypes.SERVERBOUND_SET_COMMAND_BLOCK, PacketPlayInSetCommandBlock.STREAM_CODEC).addPacket(GamePacketTypes.SERVERBOUND_SET_COMMAND_MINECART, PacketPlayInSetCommandMinecart.STREAM_CODEC).addPacket(GamePacketTypes.SERVERBOUND_SET_CREATIVE_MODE_SLOT, PacketPlayInSetCreativeSlot.STREAM_CODEC).addPacket(GamePacketTypes.SERVERBOUND_SET_JIGSAW_BLOCK, PacketPlayInSetJigsaw.STREAM_CODEC).addPacket(GamePacketTypes.SERVERBOUND_SET_STRUCTURE_BLOCK, PacketPlayInStruct.STREAM_CODEC).addPacket(GamePacketTypes.SERVERBOUND_SIGN_UPDATE, PacketPlayInUpdateSign.STREAM_CODEC).addPacket(GamePacketTypes.SERVERBOUND_SWING, PacketPlayInArmAnimation.STREAM_CODEC).addPacket(GamePacketTypes.SERVERBOUND_TELEPORT_TO_ENTITY, PacketPlayInSpectate.STREAM_CODEC).addPacket(GamePacketTypes.SERVERBOUND_USE_ITEM_ON, PacketPlayInUseItem.STREAM_CODEC).addPacket(GamePacketTypes.SERVERBOUND_USE_ITEM, PacketPlayInBlockPlace.STREAM_CODEC);
    });
    public static final ProtocolInfo.a<PacketListenerPlayOut, RegistryFriendlyByteBuf> CLIENTBOUND_TEMPLATE = ProtocolInfoBuilder.clientboundProtocol(EnumProtocol.PLAY, (protocolinfobuilder) -> {
        protocolinfobuilder.withBundlePacket(GamePacketTypes.CLIENTBOUND_BUNDLE, ClientboundBundlePacket::new, new ClientboundBundleDelimiterPacket()).addPacket(GamePacketTypes.CLIENTBOUND_ADD_ENTITY, PacketPlayOutSpawnEntity.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_ADD_EXPERIENCE_ORB, PacketPlayOutSpawnEntityExperienceOrb.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_ANIMATE, PacketPlayOutAnimation.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_AWARD_STATS, PacketPlayOutStatistic.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_BLOCK_CHANGED_ACK, ClientboundBlockChangedAckPacket.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_BLOCK_DESTRUCTION, PacketPlayOutBlockBreakAnimation.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_BLOCK_ENTITY_DATA, PacketPlayOutTileEntityData.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_BLOCK_EVENT, PacketPlayOutBlockAction.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_BLOCK_UPDATE, PacketPlayOutBlockChange.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_BOSS_EVENT, PacketPlayOutBoss.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_CHANGE_DIFFICULTY, PacketPlayOutServerDifficulty.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_CHUNK_BATCH_FINISHED, ClientboundChunkBatchFinishedPacket.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_CHUNK_BATCH_START, ClientboundChunkBatchStartPacket.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_CHUNKS_BIOMES, ClientboundChunksBiomesPacket.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_CLEAR_TITLES, ClientboundClearTitlesPacket.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_COMMAND_SUGGESTIONS, PacketPlayOutTabComplete.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_COMMANDS, PacketPlayOutCommands.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_CONTAINER_CLOSE, PacketPlayOutCloseWindow.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_CONTAINER_SET_CONTENT, PacketPlayOutWindowItems.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_CONTAINER_SET_DATA, PacketPlayOutWindowData.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_CONTAINER_SET_SLOT, PacketPlayOutSetSlot.STREAM_CODEC).addPacket(CookiePacketTypes.CLIENTBOUND_COOKIE_REQUEST, ClientboundCookieRequestPacket.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_COOLDOWN, PacketPlayOutSetCooldown.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_CUSTOM_CHAT_COMPLETIONS, ClientboundCustomChatCompletionsPacket.STREAM_CODEC).addPacket(CommonPacketTypes.CLIENTBOUND_CUSTOM_PAYLOAD, ClientboundCustomPayloadPacket.GAMEPLAY_STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_DAMAGE_EVENT, ClientboundDamageEventPacket.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_DEBUG_SAMPLE, ClientboundDebugSamplePacket.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_DELETE_CHAT, ClientboundDeleteChatPacket.STREAM_CODEC).addPacket(CommonPacketTypes.CLIENTBOUND_DISCONNECT, ClientboundDisconnectPacket.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_DISGUISED_CHAT, ClientboundDisguisedChatPacket.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_ENTITY_EVENT, PacketPlayOutEntityStatus.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_EXPLODE, PacketPlayOutExplosion.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_FORGET_LEVEL_CHUNK, PacketPlayOutUnloadChunk.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_GAME_EVENT, PacketPlayOutGameStateChange.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_HORSE_SCREEN_OPEN, PacketPlayOutOpenWindowHorse.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_HURT_ANIMATION, ClientboundHurtAnimationPacket.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_INITIALIZE_BORDER, ClientboundInitializeBorderPacket.STREAM_CODEC).addPacket(CommonPacketTypes.CLIENTBOUND_KEEP_ALIVE, ClientboundKeepAlivePacket.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_LEVEL_CHUNK_WITH_LIGHT, ClientboundLevelChunkWithLightPacket.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_LEVEL_EVENT, PacketPlayOutWorldEvent.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_LEVEL_PARTICLES, PacketPlayOutWorldParticles.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_LIGHT_UPDATE, PacketPlayOutLightUpdate.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_LOGIN, PacketPlayOutLogin.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_MAP_ITEM_DATA, PacketPlayOutMap.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_MERCHANT_OFFERS, PacketPlayOutOpenWindowMerchant.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_MOVE_ENTITY_POS, PacketPlayOutEntity.PacketPlayOutRelEntityMove.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_MOVE_ENTITY_POS_ROT, PacketPlayOutEntity.PacketPlayOutRelEntityMoveLook.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_MOVE_ENTITY_ROT, PacketPlayOutEntity.PacketPlayOutEntityLook.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_MOVE_VEHICLE, PacketPlayOutVehicleMove.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_OPEN_BOOK, PacketPlayOutOpenBook.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_OPEN_SCREEN, PacketPlayOutOpenWindow.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_OPEN_SIGN_EDITOR, PacketPlayOutOpenSignEditor.STREAM_CODEC).addPacket(CommonPacketTypes.CLIENTBOUND_PING, ClientboundPingPacket.STREAM_CODEC).addPacket(PingPacketTypes.CLIENTBOUND_PONG_RESPONSE, ClientboundPongResponsePacket.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_PLACE_GHOST_RECIPE, PacketPlayOutAutoRecipe.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_PLAYER_ABILITIES, PacketPlayOutAbilities.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_PLAYER_CHAT, ClientboundPlayerChatPacket.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_PLAYER_COMBAT_END, ClientboundPlayerCombatEndPacket.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_PLAYER_COMBAT_ENTER, ClientboundPlayerCombatEnterPacket.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_PLAYER_COMBAT_KILL, ClientboundPlayerCombatKillPacket.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_PLAYER_INFO_REMOVE, ClientboundPlayerInfoRemovePacket.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_PLAYER_INFO_UPDATE, ClientboundPlayerInfoUpdatePacket.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_PLAYER_LOOK_AT, PacketPlayOutLookAt.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_PLAYER_POSITION, PacketPlayOutPosition.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_RECIPE, PacketPlayOutRecipes.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_REMOVE_ENTITIES, PacketPlayOutEntityDestroy.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_REMOVE_MOB_EFFECT, PacketPlayOutRemoveEntityEffect.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_RESET_SCORE, ClientboundResetScorePacket.STREAM_CODEC).addPacket(CommonPacketTypes.CLIENTBOUND_RESOURCE_PACK_POP, ClientboundResourcePackPopPacket.STREAM_CODEC).addPacket(CommonPacketTypes.CLIENTBOUND_RESOURCE_PACK_PUSH, ClientboundResourcePackPushPacket.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_RESPAWN, PacketPlayOutRespawn.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_ROTATE_HEAD, PacketPlayOutEntityHeadRotation.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_SECTION_BLOCKS_UPDATE, PacketPlayOutMultiBlockChange.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_SELECT_ADVANCEMENTS_TAB, PacketPlayOutSelectAdvancementTab.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_SERVER_DATA, ClientboundServerDataPacket.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_SET_ACTION_BAR_TEXT, ClientboundSetActionBarTextPacket.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_SET_BORDER_CENTER, ClientboundSetBorderCenterPacket.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_SET_BORDER_LERP_SIZE, ClientboundSetBorderLerpSizePacket.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_SET_BORDER_SIZE, ClientboundSetBorderSizePacket.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_SET_BORDER_WARNING_DELAY, ClientboundSetBorderWarningDelayPacket.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_SET_BORDER_WARNING_DISTANCE, ClientboundSetBorderWarningDistancePacket.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_SET_CAMERA, PacketPlayOutCamera.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_SET_CARRIED_ITEM, PacketPlayOutHeldItemSlot.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_SET_CHUNK_CACHE_CENTER, PacketPlayOutViewCentre.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_SET_CHUNK_CACHE_RADIUS, PacketPlayOutViewDistance.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_SET_DEFAULT_SPAWN_POSITION, PacketPlayOutSpawnPosition.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_SET_DISPLAY_OBJECTIVE, PacketPlayOutScoreboardDisplayObjective.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_SET_ENTITY_DATA, PacketPlayOutEntityMetadata.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_SET_ENTITY_LINK, PacketPlayOutAttachEntity.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_SET_ENTITY_MOTION, PacketPlayOutEntityVelocity.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_SET_EQUIPMENT, PacketPlayOutEntityEquipment.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_SET_EXPERIENCE, PacketPlayOutExperience.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_SET_HEALTH, PacketPlayOutUpdateHealth.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_SET_OBJECTIVE, PacketPlayOutScoreboardObjective.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_SET_PASSENGERS, PacketPlayOutMount.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_SET_PLAYER_TEAM, PacketPlayOutScoreboardTeam.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_SET_SCORE, PacketPlayOutScoreboardScore.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_SET_SIMULATION_DISTANCE, ClientboundSetSimulationDistancePacket.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_SET_SUBTITLE_TEXT, ClientboundSetSubtitleTextPacket.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_SET_TIME, PacketPlayOutUpdateTime.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_SET_TITLE_TEXT, ClientboundSetTitleTextPacket.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_SET_TITLES_ANIMATION, ClientboundSetTitlesAnimationPacket.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_SOUND_ENTITY, PacketPlayOutEntitySound.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_SOUND, PacketPlayOutNamedSoundEffect.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_START_CONFIGURATION, ClientboundStartConfigurationPacket.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_STOP_SOUND, PacketPlayOutStopSound.STREAM_CODEC).addPacket(CommonPacketTypes.CLIENTBOUND_STORE_COOKIE, ClientboundStoreCookiePacket.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_SYSTEM_CHAT, ClientboundSystemChatPacket.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_TAB_LIST, PacketPlayOutPlayerListHeaderFooter.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_TAG_QUERY, PacketPlayOutNBTQuery.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_TAKE_ITEM_ENTITY, PacketPlayOutCollect.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_TELEPORT_ENTITY, PacketPlayOutEntityTeleport.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_TICKING_STATE, ClientboundTickingStatePacket.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_TICKING_STEP, ClientboundTickingStepPacket.STREAM_CODEC).addPacket(CommonPacketTypes.CLIENTBOUND_TRANSFER, ClientboundTransferPacket.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_UPDATE_ADVANCEMENTS, PacketPlayOutAdvancements.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_UPDATE_ATTRIBUTES, PacketPlayOutUpdateAttributes.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_UPDATE_MOB_EFFECT, PacketPlayOutEntityEffect.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_UPDATE_RECIPES, PacketPlayOutRecipeUpdate.STREAM_CODEC).addPacket(CommonPacketTypes.CLIENTBOUND_UPDATE_TAGS, ClientboundUpdateTagsPacket.STREAM_CODEC).addPacket(GamePacketTypes.CLIENTBOUND_PROJECTILE_POWER, ClientboundProjectilePowerPacket.STREAM_CODEC).addPacket(CommonPacketTypes.CLIENTBOUND_CUSTOM_REPORT_DETAILS, ClientboundCustomReportDetailsPacket.STREAM_CODEC).addPacket(CommonPacketTypes.CLIENTBOUND_SERVER_LINKS, ClientboundServerLinksPacket.STREAM_CODEC);
    });

    public GameProtocols() {}
}
