package net.minecraft.util;

public class ColorUtil {

    public ColorUtil() {}

    public static int as8BitChannel(float f) {
        return MathHelper.floor(f * 255.0F);
    }

    public static class a {

        public a() {}

        public static int alpha(int i) {
            return i >>> 24;
        }

        public static int red(int i) {
            return i & 255;
        }

        public static int green(int i) {
            return i >> 8 & 255;
        }

        public static int blue(int i) {
            return i >> 16 & 255;
        }

        public static int transparent(int i) {
            return i & 16777215;
        }

        public static int opaque(int i) {
            return i | -16777216;
        }

        public static int color(int i, int j, int k, int l) {
            return i << 24 | j << 16 | k << 8 | l;
        }

        public static int color(int i, int j) {
            return i << 24 | j & 16777215;
        }

        public static int fromArgb32(int i) {
            return i & -16711936 | (i & 16711680) >> 16 | (i & 255) << 16;
        }
    }

    public static class b {

        public b() {}

        public static int alpha(int i) {
            return i >>> 24;
        }

        public static int red(int i) {
            return i >> 16 & 255;
        }

        public static int green(int i) {
            return i >> 8 & 255;
        }

        public static int blue(int i) {
            return i & 255;
        }

        public static int color(int i, int j, int k, int l) {
            return i << 24 | j << 16 | k << 8 | l;
        }

        public static int color(int i, int j, int k) {
            return color(255, i, j, k);
        }

        public static int multiply(int i, int j) {
            return color(alpha(i) * alpha(j) / 255, red(i) * red(j) / 255, green(i) * green(j) / 255, blue(i) * blue(j) / 255);
        }

        public static int lerp(float f, int i, int j) {
            int k = MathHelper.lerpInt(f, alpha(i), alpha(j));
            int l = MathHelper.lerpInt(f, red(i), red(j));
            int i1 = MathHelper.lerpInt(f, green(i), green(j));
            int j1 = MathHelper.lerpInt(f, blue(i), blue(j));

            return color(k, l, i1, j1);
        }

        public static int opaque(int i) {
            return i | -16777216;
        }

        public static int color(int i, int j) {
            return i << 24 | j & 16777215;
        }

        public static int colorFromFloat(float f, float f1, float f2, float f3) {
            return color(ColorUtil.as8BitChannel(f), ColorUtil.as8BitChannel(f1), ColorUtil.as8BitChannel(f2), ColorUtil.as8BitChannel(f3));
        }

        public static int average(int i, int j) {
            return color((alpha(i) + alpha(j)) / 2, (red(i) + red(j)) / 2, (green(i) + green(j)) / 2, (blue(i) + blue(j)) / 2);
        }
    }
}
