package net.minecraft.world.item.enchantment;

import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.advancements.critereon.CriterionConditionBlock;
import net.minecraft.advancements.critereon.CriterionConditionDamageSource;
import net.minecraft.advancements.critereon.CriterionConditionEntity;
import net.minecraft.advancements.critereon.CriterionConditionEntityFlags;
import net.minecraft.advancements.critereon.CriterionConditionEntityType;
import net.minecraft.advancements.critereon.CriterionConditionItem;
import net.minecraft.advancements.critereon.CriterionConditionLocation;
import net.minecraft.advancements.critereon.CriterionConditionValue;
import net.minecraft.advancements.critereon.MovementPredicate;
import net.minecraft.advancements.critereon.TagPredicate;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsEntity;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.valueproviders.ConstantFloat;
import net.minecraft.util.valueproviders.UniformFloat;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemCrossbow;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.effects.AddValue;
import net.minecraft.world.item.enchantment.effects.AllOf;
import net.minecraft.world.item.enchantment.effects.ApplyMobEffect;
import net.minecraft.world.item.enchantment.effects.DamageEntity;
import net.minecraft.world.item.enchantment.effects.DamageImmunity;
import net.minecraft.world.item.enchantment.effects.DamageItem;
import net.minecraft.world.item.enchantment.effects.EnchantmentAttributeEffect;
import net.minecraft.world.item.enchantment.effects.ExplodeEffect;
import net.minecraft.world.item.enchantment.effects.Ignite;
import net.minecraft.world.item.enchantment.effects.MultiplyValue;
import net.minecraft.world.item.enchantment.effects.PlaySoundEffect;
import net.minecraft.world.item.enchantment.effects.RemoveBinomial;
import net.minecraft.world.item.enchantment.effects.ReplaceDisk;
import net.minecraft.world.item.enchantment.effects.SetValue;
import net.minecraft.world.item.enchantment.effects.SpawnParticlesEffect;
import net.minecraft.world.item.enchantment.effects.SummonEntityEffect;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.stateproviders.WorldGenFeatureStateProvider;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.predicates.AllOfCondition;
import net.minecraft.world.level.storage.loot.predicates.AnyOfCondition;
import net.minecraft.world.level.storage.loot.predicates.EnchantmentActiveCheck;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionBlockStateProperty;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionDamageSourceProperties;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionEntityProperty;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionInverted;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionLocationCheck;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionMatchTool;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionRandomChance;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionWeatherCheck;
import net.minecraft.world.level.storage.loot.providers.number.EnchantmentLevelProvider;
import net.minecraft.world.phys.Vec3D;

public class Enchantments {

    public static final ResourceKey<Enchantment> PROTECTION = key("protection");
    public static final ResourceKey<Enchantment> FIRE_PROTECTION = key("fire_protection");
    public static final ResourceKey<Enchantment> FEATHER_FALLING = key("feather_falling");
    public static final ResourceKey<Enchantment> BLAST_PROTECTION = key("blast_protection");
    public static final ResourceKey<Enchantment> PROJECTILE_PROTECTION = key("projectile_protection");
    public static final ResourceKey<Enchantment> RESPIRATION = key("respiration");
    public static final ResourceKey<Enchantment> AQUA_AFFINITY = key("aqua_affinity");
    public static final ResourceKey<Enchantment> THORNS = key("thorns");
    public static final ResourceKey<Enchantment> DEPTH_STRIDER = key("depth_strider");
    public static final ResourceKey<Enchantment> FROST_WALKER = key("frost_walker");
    public static final ResourceKey<Enchantment> BINDING_CURSE = key("binding_curse");
    public static final ResourceKey<Enchantment> SOUL_SPEED = key("soul_speed");
    public static final ResourceKey<Enchantment> SWIFT_SNEAK = key("swift_sneak");
    public static final ResourceKey<Enchantment> SHARPNESS = key("sharpness");
    public static final ResourceKey<Enchantment> SMITE = key("smite");
    public static final ResourceKey<Enchantment> BANE_OF_ARTHROPODS = key("bane_of_arthropods");
    public static final ResourceKey<Enchantment> KNOCKBACK = key("knockback");
    public static final ResourceKey<Enchantment> FIRE_ASPECT = key("fire_aspect");
    public static final ResourceKey<Enchantment> LOOTING = key("looting");
    public static final ResourceKey<Enchantment> SWEEPING_EDGE = key("sweeping_edge");
    public static final ResourceKey<Enchantment> EFFICIENCY = key("efficiency");
    public static final ResourceKey<Enchantment> SILK_TOUCH = key("silk_touch");
    public static final ResourceKey<Enchantment> UNBREAKING = key("unbreaking");
    public static final ResourceKey<Enchantment> FORTUNE = key("fortune");
    public static final ResourceKey<Enchantment> POWER = key("power");
    public static final ResourceKey<Enchantment> PUNCH = key("punch");
    public static final ResourceKey<Enchantment> FLAME = key("flame");
    public static final ResourceKey<Enchantment> INFINITY = key("infinity");
    public static final ResourceKey<Enchantment> LUCK_OF_THE_SEA = key("luck_of_the_sea");
    public static final ResourceKey<Enchantment> LURE = key("lure");
    public static final ResourceKey<Enchantment> LOYALTY = key("loyalty");
    public static final ResourceKey<Enchantment> IMPALING = key("impaling");
    public static final ResourceKey<Enchantment> RIPTIDE = key("riptide");
    public static final ResourceKey<Enchantment> CHANNELING = key("channeling");
    public static final ResourceKey<Enchantment> MULTISHOT = key("multishot");
    public static final ResourceKey<Enchantment> QUICK_CHARGE = key("quick_charge");
    public static final ResourceKey<Enchantment> PIERCING = key("piercing");
    public static final ResourceKey<Enchantment> DENSITY = key("density");
    public static final ResourceKey<Enchantment> BREACH = key("breach");
    public static final ResourceKey<Enchantment> WIND_BURST = key("wind_burst");
    public static final ResourceKey<Enchantment> MENDING = key("mending");
    public static final ResourceKey<Enchantment> VANISHING_CURSE = key("vanishing_curse");

    public Enchantments() {}

    public static void bootstrap(BootstrapContext<Enchantment> bootstrapcontext) {
        HolderGetter<DamageType> holdergetter = bootstrapcontext.lookup(Registries.DAMAGE_TYPE);
        HolderGetter<Enchantment> holdergetter1 = bootstrapcontext.lookup(Registries.ENCHANTMENT);
        HolderGetter<Item> holdergetter2 = bootstrapcontext.lookup(Registries.ITEM);
        HolderGetter<Block> holdergetter3 = bootstrapcontext.lookup(Registries.BLOCK);

        register(bootstrapcontext, Enchantments.PROTECTION, Enchantment.enchantment(Enchantment.definition(holdergetter2.getOrThrow(TagsItem.ARMOR_ENCHANTABLE), 10, 4, Enchantment.dynamicCost(1, 11), Enchantment.dynamicCost(12, 11), 1, EquipmentSlotGroup.ARMOR)).exclusiveWith(holdergetter1.getOrThrow(EnchantmentTags.ARMOR_EXCLUSIVE)).withEffect(EnchantmentEffectComponents.DAMAGE_PROTECTION, new AddValue(LevelBasedValue.perLevel(1.0F)), LootItemConditionDamageSourceProperties.hasDamageSource(CriterionConditionDamageSource.a.damageType().tag(TagPredicate.isNot(DamageTypeTags.BYPASSES_INVULNERABILITY)))));
        register(bootstrapcontext, Enchantments.FIRE_PROTECTION, Enchantment.enchantment(Enchantment.definition(holdergetter2.getOrThrow(TagsItem.ARMOR_ENCHANTABLE), 5, 4, Enchantment.dynamicCost(10, 8), Enchantment.dynamicCost(18, 8), 2, EquipmentSlotGroup.ARMOR)).exclusiveWith(holdergetter1.getOrThrow(EnchantmentTags.ARMOR_EXCLUSIVE)).withEffect(EnchantmentEffectComponents.DAMAGE_PROTECTION, new AddValue(LevelBasedValue.perLevel(2.0F)), AllOfCondition.allOf(LootItemConditionDamageSourceProperties.hasDamageSource(CriterionConditionDamageSource.a.damageType().tag(TagPredicate.is(DamageTypeTags.IS_FIRE)).tag(TagPredicate.isNot(DamageTypeTags.BYPASSES_INVULNERABILITY))))).withEffect(EnchantmentEffectComponents.ATTRIBUTES, new EnchantmentAttributeEffect(MinecraftKey.withDefaultNamespace("enchantment.fire_protection"), GenericAttributes.BURNING_TIME, LevelBasedValue.perLevel(-0.15F), AttributeModifier.Operation.ADD_MULTIPLIED_BASE)));
        register(bootstrapcontext, Enchantments.FEATHER_FALLING, Enchantment.enchantment(Enchantment.definition(holdergetter2.getOrThrow(TagsItem.FOOT_ARMOR_ENCHANTABLE), 5, 4, Enchantment.dynamicCost(5, 6), Enchantment.dynamicCost(11, 6), 2, EquipmentSlotGroup.ARMOR)).withEffect(EnchantmentEffectComponents.DAMAGE_PROTECTION, new AddValue(LevelBasedValue.perLevel(3.0F)), LootItemConditionDamageSourceProperties.hasDamageSource(CriterionConditionDamageSource.a.damageType().tag(TagPredicate.is(DamageTypeTags.IS_FALL)).tag(TagPredicate.isNot(DamageTypeTags.BYPASSES_INVULNERABILITY)))));
        register(bootstrapcontext, Enchantments.BLAST_PROTECTION, Enchantment.enchantment(Enchantment.definition(holdergetter2.getOrThrow(TagsItem.ARMOR_ENCHANTABLE), 2, 4, Enchantment.dynamicCost(5, 8), Enchantment.dynamicCost(13, 8), 4, EquipmentSlotGroup.ARMOR)).exclusiveWith(holdergetter1.getOrThrow(EnchantmentTags.ARMOR_EXCLUSIVE)).withEffect(EnchantmentEffectComponents.DAMAGE_PROTECTION, new AddValue(LevelBasedValue.perLevel(2.0F)), LootItemConditionDamageSourceProperties.hasDamageSource(CriterionConditionDamageSource.a.damageType().tag(TagPredicate.is(DamageTypeTags.IS_EXPLOSION)).tag(TagPredicate.isNot(DamageTypeTags.BYPASSES_INVULNERABILITY)))).withEffect(EnchantmentEffectComponents.ATTRIBUTES, new EnchantmentAttributeEffect(MinecraftKey.withDefaultNamespace("enchantment.blast_protection"), GenericAttributes.EXPLOSION_KNOCKBACK_RESISTANCE, LevelBasedValue.perLevel(0.15F), AttributeModifier.Operation.ADD_VALUE)));
        register(bootstrapcontext, Enchantments.PROJECTILE_PROTECTION, Enchantment.enchantment(Enchantment.definition(holdergetter2.getOrThrow(TagsItem.ARMOR_ENCHANTABLE), 5, 4, Enchantment.dynamicCost(3, 6), Enchantment.dynamicCost(9, 6), 2, EquipmentSlotGroup.ARMOR)).exclusiveWith(holdergetter1.getOrThrow(EnchantmentTags.ARMOR_EXCLUSIVE)).withEffect(EnchantmentEffectComponents.DAMAGE_PROTECTION, new AddValue(LevelBasedValue.perLevel(2.0F)), LootItemConditionDamageSourceProperties.hasDamageSource(CriterionConditionDamageSource.a.damageType().tag(TagPredicate.is(DamageTypeTags.IS_PROJECTILE)).tag(TagPredicate.isNot(DamageTypeTags.BYPASSES_INVULNERABILITY)))));
        register(bootstrapcontext, Enchantments.RESPIRATION, Enchantment.enchantment(Enchantment.definition(holdergetter2.getOrThrow(TagsItem.HEAD_ARMOR_ENCHANTABLE), 2, 3, Enchantment.dynamicCost(10, 10), Enchantment.dynamicCost(40, 10), 4, EquipmentSlotGroup.HEAD)).withEffect(EnchantmentEffectComponents.ATTRIBUTES, new EnchantmentAttributeEffect(MinecraftKey.withDefaultNamespace("enchantment.respiration"), GenericAttributes.OXYGEN_BONUS, LevelBasedValue.perLevel(1.0F), AttributeModifier.Operation.ADD_VALUE)));
        register(bootstrapcontext, Enchantments.AQUA_AFFINITY, Enchantment.enchantment(Enchantment.definition(holdergetter2.getOrThrow(TagsItem.HEAD_ARMOR_ENCHANTABLE), 2, 1, Enchantment.constantCost(1), Enchantment.constantCost(41), 4, EquipmentSlotGroup.HEAD)).withEffect(EnchantmentEffectComponents.ATTRIBUTES, new EnchantmentAttributeEffect(MinecraftKey.withDefaultNamespace("enchantment.aqua_affinity"), GenericAttributes.SUBMERGED_MINING_SPEED, LevelBasedValue.perLevel(4.0F), AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL)));
        register(bootstrapcontext, Enchantments.THORNS, Enchantment.enchantment(Enchantment.definition(holdergetter2.getOrThrow(TagsItem.ARMOR_ENCHANTABLE), holdergetter2.getOrThrow(TagsItem.CHEST_ARMOR_ENCHANTABLE), 1, 3, Enchantment.dynamicCost(10, 20), Enchantment.dynamicCost(60, 20), 8, EquipmentSlotGroup.ANY)).withEffect(EnchantmentEffectComponents.POST_ATTACK, EnchantmentTarget.VICTIM, EnchantmentTarget.ATTACKER, AllOf.entityEffects(new DamageEntity(LevelBasedValue.constant(1.0F), LevelBasedValue.constant(5.0F), holdergetter.getOrThrow(DamageTypes.THORNS)), new DamageItem(LevelBasedValue.constant(2.0F))), LootItemConditionRandomChance.randomChance(EnchantmentLevelProvider.forEnchantmentLevel(LevelBasedValue.perLevel(0.15F)))));
        register(bootstrapcontext, Enchantments.DEPTH_STRIDER, Enchantment.enchantment(Enchantment.definition(holdergetter2.getOrThrow(TagsItem.FOOT_ARMOR_ENCHANTABLE), 2, 3, Enchantment.dynamicCost(10, 10), Enchantment.dynamicCost(25, 10), 4, EquipmentSlotGroup.FEET)).exclusiveWith(holdergetter1.getOrThrow(EnchantmentTags.BOOTS_EXCLUSIVE)).withEffect(EnchantmentEffectComponents.ATTRIBUTES, new EnchantmentAttributeEffect(MinecraftKey.withDefaultNamespace("enchantment.depth_strider"), GenericAttributes.WATER_MOVEMENT_EFFICIENCY, LevelBasedValue.perLevel(0.33333334F), AttributeModifier.Operation.ADD_VALUE)));
        register(bootstrapcontext, Enchantments.FROST_WALKER, Enchantment.enchantment(Enchantment.definition(holdergetter2.getOrThrow(TagsItem.FOOT_ARMOR_ENCHANTABLE), 2, 2, Enchantment.dynamicCost(10, 10), Enchantment.dynamicCost(25, 10), 4, EquipmentSlotGroup.FEET)).exclusiveWith(holdergetter1.getOrThrow(EnchantmentTags.BOOTS_EXCLUSIVE)).withEffect(EnchantmentEffectComponents.DAMAGE_IMMUNITY, DamageImmunity.INSTANCE, LootItemConditionDamageSourceProperties.hasDamageSource(CriterionConditionDamageSource.a.damageType().tag(TagPredicate.is(DamageTypeTags.BURN_FROM_STEPPING)).tag(TagPredicate.isNot(DamageTypeTags.BYPASSES_INVULNERABILITY)))).withEffect(EnchantmentEffectComponents.LOCATION_CHANGED, new ReplaceDisk(new LevelBasedValue.a(LevelBasedValue.perLevel(3.0F, 1.0F), 0.0F, 16.0F), LevelBasedValue.constant(1.0F), new BaseBlockPosition(0, -1, 0), Optional.of(BlockPredicate.allOf(BlockPredicate.matchesTag(new BaseBlockPosition(0, 1, 0), TagsBlock.AIR), BlockPredicate.matchesBlocks(Blocks.WATER), BlockPredicate.matchesFluids(FluidTypes.WATER), BlockPredicate.unobstructed())), WorldGenFeatureStateProvider.simple(Blocks.FROSTED_ICE), Optional.of(GameEvent.BLOCK_PLACE)), LootItemConditionEntityProperty.hasProperties(LootTableInfo.EntityTarget.THIS, CriterionConditionEntity.a.entity().flags(CriterionConditionEntityFlags.a.flags().setOnGround(true)))));
        register(bootstrapcontext, Enchantments.BINDING_CURSE, Enchantment.enchantment(Enchantment.definition(holdergetter2.getOrThrow(TagsItem.EQUIPPABLE_ENCHANTABLE), 1, 1, Enchantment.constantCost(25), Enchantment.constantCost(50), 8, EquipmentSlotGroup.ARMOR)).withEffect(EnchantmentEffectComponents.PREVENT_ARMOR_CHANGE));
        CriterionConditionEntity.a criterionconditionentity_a = CriterionConditionEntity.a.entity().periodicTick(5).flags(CriterionConditionEntityFlags.a.flags().setIsFlying(false).setOnGround(true)).moving(MovementPredicate.horizontalSpeed(CriterionConditionValue.DoubleRange.atLeast(9.999999747378752E-6D))).movementAffectedBy(CriterionConditionLocation.a.location().setBlock(CriterionConditionBlock.a.block().of(TagsBlock.SOUL_SPEED_BLOCKS)));

        register(bootstrapcontext, Enchantments.SOUL_SPEED, Enchantment.enchantment(Enchantment.definition(holdergetter2.getOrThrow(TagsItem.FOOT_ARMOR_ENCHANTABLE), 1, 3, Enchantment.dynamicCost(10, 10), Enchantment.dynamicCost(25, 10), 8, EquipmentSlotGroup.FEET)).withEffect(EnchantmentEffectComponents.LOCATION_CHANGED, new EnchantmentAttributeEffect(MinecraftKey.withDefaultNamespace("enchantment.soul_speed"), GenericAttributes.MOVEMENT_SPEED, LevelBasedValue.perLevel(0.0405F, 0.0105F), AttributeModifier.Operation.ADD_VALUE), AllOfCondition.allOf(LootItemConditionInverted.invert(LootItemConditionEntityProperty.hasProperties(LootTableInfo.EntityTarget.THIS, CriterionConditionEntity.a.entity().vehicle(CriterionConditionEntity.a.entity()))), AnyOfCondition.anyOf(AllOfCondition.allOf(EnchantmentActiveCheck.enchantmentActiveCheck(), LootItemConditionEntityProperty.hasProperties(LootTableInfo.EntityTarget.THIS, CriterionConditionEntity.a.entity().flags(CriterionConditionEntityFlags.a.flags().setIsFlying(false))), AnyOfCondition.anyOf(LootItemConditionEntityProperty.hasProperties(LootTableInfo.EntityTarget.THIS, CriterionConditionEntity.a.entity().movementAffectedBy(CriterionConditionLocation.a.location().setBlock(CriterionConditionBlock.a.block().of(TagsBlock.SOUL_SPEED_BLOCKS)))), LootItemConditionEntityProperty.hasProperties(LootTableInfo.EntityTarget.THIS, CriterionConditionEntity.a.entity().flags(CriterionConditionEntityFlags.a.flags().setOnGround(false)).build()))), AllOfCondition.allOf(EnchantmentActiveCheck.enchantmentInactiveCheck(), LootItemConditionEntityProperty.hasProperties(LootTableInfo.EntityTarget.THIS, CriterionConditionEntity.a.entity().movementAffectedBy(CriterionConditionLocation.a.location().setBlock(CriterionConditionBlock.a.block().of(TagsBlock.SOUL_SPEED_BLOCKS))).flags(CriterionConditionEntityFlags.a.flags().setIsFlying(false))))))).withEffect(EnchantmentEffectComponents.LOCATION_CHANGED, new EnchantmentAttributeEffect(MinecraftKey.withDefaultNamespace("enchantment.soul_speed"), GenericAttributes.MOVEMENT_EFFICIENCY, LevelBasedValue.constant(1.0F), AttributeModifier.Operation.ADD_VALUE), LootItemConditionEntityProperty.hasProperties(LootTableInfo.EntityTarget.THIS, CriterionConditionEntity.a.entity().movementAffectedBy(CriterionConditionLocation.a.location().setBlock(CriterionConditionBlock.a.block().of(TagsBlock.SOUL_SPEED_BLOCKS))))).withEffect(EnchantmentEffectComponents.LOCATION_CHANGED, new DamageItem(LevelBasedValue.constant(1.0F)), AllOfCondition.allOf(LootItemConditionRandomChance.randomChance(EnchantmentLevelProvider.forEnchantmentLevel(LevelBasedValue.constant(0.04F))), LootItemConditionEntityProperty.hasProperties(LootTableInfo.EntityTarget.THIS, CriterionConditionEntity.a.entity().flags(CriterionConditionEntityFlags.a.flags().setOnGround(true)).movementAffectedBy(CriterionConditionLocation.a.location().setBlock(CriterionConditionBlock.a.block().of(TagsBlock.SOUL_SPEED_BLOCKS)))))).withEffect(EnchantmentEffectComponents.TICK, new SpawnParticlesEffect(Particles.SOUL, SpawnParticlesEffect.inBoundingBox(), SpawnParticlesEffect.offsetFromEntityPosition(0.1F), SpawnParticlesEffect.movementScaled(-0.2F), SpawnParticlesEffect.fixedVelocity(ConstantFloat.of(0.1F)), ConstantFloat.of(1.0F)), LootItemConditionEntityProperty.hasProperties(LootTableInfo.EntityTarget.THIS, criterionconditionentity_a)).withEffect(EnchantmentEffectComponents.TICK, new PlaySoundEffect(SoundEffects.SOUL_ESCAPE, ConstantFloat.of(0.6F), UniformFloat.of(0.6F, 1.0F)), AllOfCondition.allOf(LootItemConditionRandomChance.randomChance(0.35F), LootItemConditionEntityProperty.hasProperties(LootTableInfo.EntityTarget.THIS, criterionconditionentity_a))));
        register(bootstrapcontext, Enchantments.SWIFT_SNEAK, Enchantment.enchantment(Enchantment.definition(holdergetter2.getOrThrow(TagsItem.LEG_ARMOR_ENCHANTABLE), 1, 3, Enchantment.dynamicCost(25, 25), Enchantment.dynamicCost(75, 25), 8, EquipmentSlotGroup.LEGS)).withEffect(EnchantmentEffectComponents.ATTRIBUTES, new EnchantmentAttributeEffect(MinecraftKey.withDefaultNamespace("enchantment.swift_sneak"), GenericAttributes.SNEAKING_SPEED, LevelBasedValue.perLevel(0.15F), AttributeModifier.Operation.ADD_VALUE)));
        register(bootstrapcontext, Enchantments.SHARPNESS, Enchantment.enchantment(Enchantment.definition(holdergetter2.getOrThrow(TagsItem.SHARP_WEAPON_ENCHANTABLE), holdergetter2.getOrThrow(TagsItem.SWORD_ENCHANTABLE), 10, 5, Enchantment.dynamicCost(1, 11), Enchantment.dynamicCost(21, 11), 1, EquipmentSlotGroup.MAINHAND)).exclusiveWith(holdergetter1.getOrThrow(EnchantmentTags.DAMAGE_EXCLUSIVE)).withEffect(EnchantmentEffectComponents.DAMAGE, (Object) (new AddValue(LevelBasedValue.perLevel(1.0F, 0.5F)))));
        register(bootstrapcontext, Enchantments.SMITE, Enchantment.enchantment(Enchantment.definition(holdergetter2.getOrThrow(TagsItem.WEAPON_ENCHANTABLE), holdergetter2.getOrThrow(TagsItem.SWORD_ENCHANTABLE), 5, 5, Enchantment.dynamicCost(5, 8), Enchantment.dynamicCost(25, 8), 2, EquipmentSlotGroup.MAINHAND)).exclusiveWith(holdergetter1.getOrThrow(EnchantmentTags.DAMAGE_EXCLUSIVE)).withEffect(EnchantmentEffectComponents.DAMAGE, new AddValue(LevelBasedValue.perLevel(2.5F)), LootItemConditionEntityProperty.hasProperties(LootTableInfo.EntityTarget.THIS, CriterionConditionEntity.a.entity().entityType(CriterionConditionEntityType.of(TagsEntity.SENSITIVE_TO_SMITE)))));
        register(bootstrapcontext, Enchantments.BANE_OF_ARTHROPODS, Enchantment.enchantment(Enchantment.definition(holdergetter2.getOrThrow(TagsItem.WEAPON_ENCHANTABLE), holdergetter2.getOrThrow(TagsItem.SWORD_ENCHANTABLE), 5, 5, Enchantment.dynamicCost(5, 8), Enchantment.dynamicCost(25, 8), 2, EquipmentSlotGroup.MAINHAND)).exclusiveWith(holdergetter1.getOrThrow(EnchantmentTags.DAMAGE_EXCLUSIVE)).withEffect(EnchantmentEffectComponents.DAMAGE, new AddValue(LevelBasedValue.perLevel(2.5F)), LootItemConditionEntityProperty.hasProperties(LootTableInfo.EntityTarget.THIS, CriterionConditionEntity.a.entity().entityType(CriterionConditionEntityType.of(TagsEntity.SENSITIVE_TO_BANE_OF_ARTHROPODS)))).withEffect(EnchantmentEffectComponents.POST_ATTACK, EnchantmentTarget.ATTACKER, EnchantmentTarget.VICTIM, new ApplyMobEffect(HolderSet.direct(MobEffects.MOVEMENT_SLOWDOWN), LevelBasedValue.constant(1.5F), LevelBasedValue.perLevel(1.5F, 0.5F), LevelBasedValue.constant(3.0F), LevelBasedValue.constant(3.0F)), LootItemConditionEntityProperty.hasProperties(LootTableInfo.EntityTarget.THIS, CriterionConditionEntity.a.entity().entityType(CriterionConditionEntityType.of(TagsEntity.SENSITIVE_TO_BANE_OF_ARTHROPODS))).and(LootItemConditionDamageSourceProperties.hasDamageSource(CriterionConditionDamageSource.a.damageType().isDirect(true)))));
        register(bootstrapcontext, Enchantments.KNOCKBACK, Enchantment.enchantment(Enchantment.definition(holdergetter2.getOrThrow(TagsItem.SWORD_ENCHANTABLE), 5, 2, Enchantment.dynamicCost(5, 20), Enchantment.dynamicCost(55, 20), 2, EquipmentSlotGroup.MAINHAND)).withEffect(EnchantmentEffectComponents.KNOCKBACK, (Object) (new AddValue(LevelBasedValue.perLevel(1.0F)))));
        register(bootstrapcontext, Enchantments.FIRE_ASPECT, Enchantment.enchantment(Enchantment.definition(holdergetter2.getOrThrow(TagsItem.FIRE_ASPECT_ENCHANTABLE), holdergetter2.getOrThrow(TagsItem.SWORD_ENCHANTABLE), 2, 2, Enchantment.dynamicCost(10, 20), Enchantment.dynamicCost(60, 20), 4, EquipmentSlotGroup.MAINHAND)).withEffect(EnchantmentEffectComponents.POST_ATTACK, EnchantmentTarget.ATTACKER, EnchantmentTarget.VICTIM, new Ignite(LevelBasedValue.perLevel(4.0F)), LootItemConditionDamageSourceProperties.hasDamageSource(CriterionConditionDamageSource.a.damageType().isDirect(true))));
        register(bootstrapcontext, Enchantments.LOOTING, Enchantment.enchantment(Enchantment.definition(holdergetter2.getOrThrow(TagsItem.SWORD_ENCHANTABLE), 2, 3, Enchantment.dynamicCost(15, 9), Enchantment.dynamicCost(65, 9), 4, EquipmentSlotGroup.MAINHAND)).withEffect(EnchantmentEffectComponents.EQUIPMENT_DROPS, EnchantmentTarget.ATTACKER, EnchantmentTarget.VICTIM, new AddValue(LevelBasedValue.perLevel(0.01F)), LootItemConditionEntityProperty.hasProperties(LootTableInfo.EntityTarget.ATTACKER, CriterionConditionEntity.a.entity().entityType(CriterionConditionEntityType.of(EntityTypes.PLAYER)))));
        register(bootstrapcontext, Enchantments.SWEEPING_EDGE, Enchantment.enchantment(Enchantment.definition(holdergetter2.getOrThrow(TagsItem.SWORD_ENCHANTABLE), 2, 3, Enchantment.dynamicCost(5, 9), Enchantment.dynamicCost(20, 9), 4, EquipmentSlotGroup.MAINHAND)).withEffect(EnchantmentEffectComponents.ATTRIBUTES, new EnchantmentAttributeEffect(MinecraftKey.withDefaultNamespace("enchantment.sweeping_edge"), GenericAttributes.SWEEPING_DAMAGE_RATIO, new LevelBasedValue.c(LevelBasedValue.perLevel(1.0F), LevelBasedValue.perLevel(2.0F, 1.0F)), AttributeModifier.Operation.ADD_VALUE)));
        register(bootstrapcontext, Enchantments.EFFICIENCY, Enchantment.enchantment(Enchantment.definition(holdergetter2.getOrThrow(TagsItem.MINING_ENCHANTABLE), 10, 5, Enchantment.dynamicCost(1, 10), Enchantment.dynamicCost(51, 10), 1, EquipmentSlotGroup.MAINHAND)).withEffect(EnchantmentEffectComponents.ATTRIBUTES, new EnchantmentAttributeEffect(MinecraftKey.withDefaultNamespace("enchantment.efficiency"), GenericAttributes.MINING_EFFICIENCY, new LevelBasedValue.d(1.0F), AttributeModifier.Operation.ADD_VALUE)));
        register(bootstrapcontext, Enchantments.SILK_TOUCH, Enchantment.enchantment(Enchantment.definition(holdergetter2.getOrThrow(TagsItem.MINING_LOOT_ENCHANTABLE), 1, 1, Enchantment.constantCost(15), Enchantment.constantCost(65), 8, EquipmentSlotGroup.MAINHAND)).exclusiveWith(holdergetter1.getOrThrow(EnchantmentTags.MINING_EXCLUSIVE)).withEffect(EnchantmentEffectComponents.BLOCK_EXPERIENCE, (Object) (new SetValue(LevelBasedValue.constant(0.0F)))));
        register(bootstrapcontext, Enchantments.UNBREAKING, Enchantment.enchantment(Enchantment.definition(holdergetter2.getOrThrow(TagsItem.DURABILITY_ENCHANTABLE), 5, 3, Enchantment.dynamicCost(5, 8), Enchantment.dynamicCost(55, 8), 2, EquipmentSlotGroup.ANY)).withEffect(EnchantmentEffectComponents.ITEM_DAMAGE, new RemoveBinomial(new LevelBasedValue.c(LevelBasedValue.perLevel(2.0F), LevelBasedValue.perLevel(10.0F, 5.0F))), LootItemConditionMatchTool.toolMatches(CriterionConditionItem.a.item().of(TagsItem.ARMOR_ENCHANTABLE))).withEffect(EnchantmentEffectComponents.ITEM_DAMAGE, new RemoveBinomial(new LevelBasedValue.c(LevelBasedValue.perLevel(1.0F), LevelBasedValue.perLevel(2.0F, 1.0F))), LootItemConditionInverted.invert(LootItemConditionMatchTool.toolMatches(CriterionConditionItem.a.item().of(TagsItem.ARMOR_ENCHANTABLE)))));
        register(bootstrapcontext, Enchantments.FORTUNE, Enchantment.enchantment(Enchantment.definition(holdergetter2.getOrThrow(TagsItem.MINING_LOOT_ENCHANTABLE), 2, 3, Enchantment.dynamicCost(15, 9), Enchantment.dynamicCost(65, 9), 4, EquipmentSlotGroup.MAINHAND)).exclusiveWith(holdergetter1.getOrThrow(EnchantmentTags.MINING_EXCLUSIVE)));
        register(bootstrapcontext, Enchantments.POWER, Enchantment.enchantment(Enchantment.definition(holdergetter2.getOrThrow(TagsItem.BOW_ENCHANTABLE), 10, 5, Enchantment.dynamicCost(1, 10), Enchantment.dynamicCost(16, 10), 1, EquipmentSlotGroup.MAINHAND)).withEffect(EnchantmentEffectComponents.DAMAGE, new AddValue(LevelBasedValue.perLevel(0.5F)), LootItemConditionEntityProperty.hasProperties(LootTableInfo.EntityTarget.DIRECT_ATTACKER, CriterionConditionEntity.a.entity().of(TagsEntity.ARROWS).build())));
        register(bootstrapcontext, Enchantments.PUNCH, Enchantment.enchantment(Enchantment.definition(holdergetter2.getOrThrow(TagsItem.BOW_ENCHANTABLE), 2, 2, Enchantment.dynamicCost(12, 20), Enchantment.dynamicCost(37, 20), 4, EquipmentSlotGroup.MAINHAND)).withEffect(EnchantmentEffectComponents.KNOCKBACK, new AddValue(LevelBasedValue.perLevel(1.0F)), LootItemConditionEntityProperty.hasProperties(LootTableInfo.EntityTarget.DIRECT_ATTACKER, CriterionConditionEntity.a.entity().of(TagsEntity.ARROWS).build())));
        register(bootstrapcontext, Enchantments.FLAME, Enchantment.enchantment(Enchantment.definition(holdergetter2.getOrThrow(TagsItem.BOW_ENCHANTABLE), 2, 1, Enchantment.constantCost(20), Enchantment.constantCost(50), 4, EquipmentSlotGroup.MAINHAND)).withEffect(EnchantmentEffectComponents.PROJECTILE_SPAWNED, (Object) (new Ignite(LevelBasedValue.constant(100.0F)))));
        register(bootstrapcontext, Enchantments.INFINITY, Enchantment.enchantment(Enchantment.definition(holdergetter2.getOrThrow(TagsItem.BOW_ENCHANTABLE), 1, 1, Enchantment.constantCost(20), Enchantment.constantCost(50), 8, EquipmentSlotGroup.MAINHAND)).exclusiveWith(holdergetter1.getOrThrow(EnchantmentTags.BOW_EXCLUSIVE)).withEffect(EnchantmentEffectComponents.AMMO_USE, new SetValue(LevelBasedValue.constant(0.0F)), LootItemConditionMatchTool.toolMatches(CriterionConditionItem.a.item().of(Items.ARROW))));
        register(bootstrapcontext, Enchantments.LUCK_OF_THE_SEA, Enchantment.enchantment(Enchantment.definition(holdergetter2.getOrThrow(TagsItem.FISHING_ENCHANTABLE), 2, 3, Enchantment.dynamicCost(15, 9), Enchantment.dynamicCost(65, 9), 4, EquipmentSlotGroup.MAINHAND)).withEffect(EnchantmentEffectComponents.FISHING_LUCK_BONUS, (Object) (new AddValue(LevelBasedValue.perLevel(1.0F)))));
        register(bootstrapcontext, Enchantments.LURE, Enchantment.enchantment(Enchantment.definition(holdergetter2.getOrThrow(TagsItem.FISHING_ENCHANTABLE), 2, 3, Enchantment.dynamicCost(15, 9), Enchantment.dynamicCost(65, 9), 4, EquipmentSlotGroup.MAINHAND)).withEffect(EnchantmentEffectComponents.FISHING_TIME_REDUCTION, (Object) (new AddValue(LevelBasedValue.perLevel(5.0F)))));
        register(bootstrapcontext, Enchantments.LOYALTY, Enchantment.enchantment(Enchantment.definition(holdergetter2.getOrThrow(TagsItem.TRIDENT_ENCHANTABLE), 5, 3, Enchantment.dynamicCost(12, 7), Enchantment.constantCost(50), 2, EquipmentSlotGroup.MAINHAND)).withEffect(EnchantmentEffectComponents.TRIDENT_RETURN_ACCELERATION, (Object) (new AddValue(LevelBasedValue.perLevel(1.0F)))));
        register(bootstrapcontext, Enchantments.IMPALING, Enchantment.enchantment(Enchantment.definition(holdergetter2.getOrThrow(TagsItem.TRIDENT_ENCHANTABLE), 2, 5, Enchantment.dynamicCost(1, 8), Enchantment.dynamicCost(21, 8), 4, EquipmentSlotGroup.MAINHAND)).exclusiveWith(holdergetter1.getOrThrow(EnchantmentTags.DAMAGE_EXCLUSIVE)).withEffect(EnchantmentEffectComponents.DAMAGE, new AddValue(LevelBasedValue.perLevel(2.5F)), LootItemConditionEntityProperty.hasProperties(LootTableInfo.EntityTarget.THIS, CriterionConditionEntity.a.entity().entityType(CriterionConditionEntityType.of(TagsEntity.SENSITIVE_TO_IMPALING)).build())));
        register(bootstrapcontext, Enchantments.RIPTIDE, Enchantment.enchantment(Enchantment.definition(holdergetter2.getOrThrow(TagsItem.TRIDENT_ENCHANTABLE), 2, 3, Enchantment.dynamicCost(17, 7), Enchantment.constantCost(50), 4, EquipmentSlotGroup.HAND)).exclusiveWith(holdergetter1.getOrThrow(EnchantmentTags.RIPTIDE_EXCLUSIVE)).withSpecialEffect(EnchantmentEffectComponents.TRIDENT_SPIN_ATTACK_STRENGTH, new AddValue(LevelBasedValue.perLevel(1.5F, 0.75F))).withSpecialEffect(EnchantmentEffectComponents.TRIDENT_SOUND, List.of(SoundEffects.TRIDENT_RIPTIDE_1, SoundEffects.TRIDENT_RIPTIDE_2, SoundEffects.TRIDENT_RIPTIDE_3)));
        register(bootstrapcontext, Enchantments.CHANNELING, Enchantment.enchantment(Enchantment.definition(holdergetter2.getOrThrow(TagsItem.TRIDENT_ENCHANTABLE), 1, 1, Enchantment.constantCost(25), Enchantment.constantCost(50), 8, EquipmentSlotGroup.MAINHAND)).withEffect(EnchantmentEffectComponents.POST_ATTACK, EnchantmentTarget.ATTACKER, EnchantmentTarget.VICTIM, AllOf.entityEffects(new SummonEntityEffect(HolderSet.direct(EntityTypes.LIGHTNING_BOLT.builtInRegistryHolder()), false), new PlaySoundEffect(SoundEffects.TRIDENT_THUNDER, ConstantFloat.of(5.0F), ConstantFloat.of(1.0F))), AllOfCondition.allOf(LootItemConditionWeatherCheck.weather().setThundering(true), LootItemConditionEntityProperty.hasProperties(LootTableInfo.EntityTarget.THIS, CriterionConditionEntity.a.entity().located(CriterionConditionLocation.a.location().setCanSeeSky(true))), LootItemConditionEntityProperty.hasProperties(LootTableInfo.EntityTarget.DIRECT_ATTACKER, CriterionConditionEntity.a.entity().of(EntityTypes.TRIDENT)))).withEffect(EnchantmentEffectComponents.HIT_BLOCK, AllOf.entityEffects(new SummonEntityEffect(HolderSet.direct(EntityTypes.LIGHTNING_BOLT.builtInRegistryHolder()), false), new PlaySoundEffect(SoundEffects.TRIDENT_THUNDER, ConstantFloat.of(5.0F), ConstantFloat.of(1.0F))), AllOfCondition.allOf(LootItemConditionWeatherCheck.weather().setThundering(true), LootItemConditionEntityProperty.hasProperties(LootTableInfo.EntityTarget.THIS, CriterionConditionEntity.a.entity().of(EntityTypes.TRIDENT)), LootItemConditionLocationCheck.checkLocation(CriterionConditionLocation.a.location().setCanSeeSky(true)), LootItemConditionBlockStateProperty.hasBlockStateProperties(Blocks.LIGHTNING_ROD))));
        register(bootstrapcontext, Enchantments.MULTISHOT, Enchantment.enchantment(Enchantment.definition(holdergetter2.getOrThrow(TagsItem.CROSSBOW_ENCHANTABLE), 2, 1, Enchantment.constantCost(20), Enchantment.constantCost(50), 4, EquipmentSlotGroup.MAINHAND)).exclusiveWith(holdergetter1.getOrThrow(EnchantmentTags.CROSSBOW_EXCLUSIVE)).withEffect(EnchantmentEffectComponents.PROJECTILE_COUNT, (Object) (new AddValue(LevelBasedValue.perLevel(2.0F)))).withEffect(EnchantmentEffectComponents.PROJECTILE_SPREAD, (Object) (new AddValue(LevelBasedValue.perLevel(10.0F)))));
        register(bootstrapcontext, Enchantments.QUICK_CHARGE, Enchantment.enchantment(Enchantment.definition(holdergetter2.getOrThrow(TagsItem.CROSSBOW_ENCHANTABLE), 5, 3, Enchantment.dynamicCost(12, 20), Enchantment.constantCost(50), 2, EquipmentSlotGroup.MAINHAND, EquipmentSlotGroup.OFFHAND)).withSpecialEffect(EnchantmentEffectComponents.CROSSBOW_CHARGE_TIME, new AddValue(LevelBasedValue.perLevel(-0.25F))).withSpecialEffect(EnchantmentEffectComponents.CROSSBOW_CHARGING_SOUNDS, List.of(new ItemCrossbow.a(Optional.of(SoundEffects.CROSSBOW_QUICK_CHARGE_1), Optional.empty(), Optional.of(SoundEffects.CROSSBOW_LOADING_END)), new ItemCrossbow.a(Optional.of(SoundEffects.CROSSBOW_QUICK_CHARGE_2), Optional.empty(), Optional.of(SoundEffects.CROSSBOW_LOADING_END)), new ItemCrossbow.a(Optional.of(SoundEffects.CROSSBOW_QUICK_CHARGE_3), Optional.empty(), Optional.of(SoundEffects.CROSSBOW_LOADING_END)))));
        register(bootstrapcontext, Enchantments.PIERCING, Enchantment.enchantment(Enchantment.definition(holdergetter2.getOrThrow(TagsItem.CROSSBOW_ENCHANTABLE), 10, 4, Enchantment.dynamicCost(1, 10), Enchantment.constantCost(50), 1, EquipmentSlotGroup.MAINHAND)).exclusiveWith(holdergetter1.getOrThrow(EnchantmentTags.CROSSBOW_EXCLUSIVE)).withEffect(EnchantmentEffectComponents.PROJECTILE_PIERCING, (Object) (new AddValue(LevelBasedValue.perLevel(1.0F)))));
        register(bootstrapcontext, Enchantments.DENSITY, Enchantment.enchantment(Enchantment.definition(holdergetter2.getOrThrow(TagsItem.MACE_ENCHANTABLE), 5, 5, Enchantment.dynamicCost(5, 8), Enchantment.dynamicCost(25, 8), 2, EquipmentSlotGroup.MAINHAND)).exclusiveWith(holdergetter1.getOrThrow(EnchantmentTags.DAMAGE_EXCLUSIVE)).withEffect(EnchantmentEffectComponents.SMASH_DAMAGE_PER_FALLEN_BLOCK, (Object) (new AddValue(LevelBasedValue.perLevel(0.5F)))));
        register(bootstrapcontext, Enchantments.BREACH, Enchantment.enchantment(Enchantment.definition(holdergetter2.getOrThrow(TagsItem.MACE_ENCHANTABLE), 2, 4, Enchantment.dynamicCost(15, 9), Enchantment.dynamicCost(65, 9), 4, EquipmentSlotGroup.MAINHAND)).exclusiveWith(holdergetter1.getOrThrow(EnchantmentTags.DAMAGE_EXCLUSIVE)).withEffect(EnchantmentEffectComponents.ARMOR_EFFECTIVENESS, (Object) (new AddValue(LevelBasedValue.perLevel(-0.15F)))));
        register(bootstrapcontext, Enchantments.WIND_BURST, Enchantment.enchantment(Enchantment.definition(holdergetter2.getOrThrow(TagsItem.MACE_ENCHANTABLE), 2, 3, Enchantment.dynamicCost(15, 9), Enchantment.dynamicCost(65, 9), 4, EquipmentSlotGroup.MAINHAND)).withEffect(EnchantmentEffectComponents.POST_ATTACK, EnchantmentTarget.ATTACKER, EnchantmentTarget.ATTACKER, new ExplodeEffect(false, Optional.empty(), Optional.of(LevelBasedValue.lookup(List.of(1.2F, 1.75F, 2.2F), LevelBasedValue.perLevel(1.5F, 0.35F))), holdergetter3.get(TagsBlock.BLOCKS_WIND_CHARGE_EXPLOSIONS).map(Function.identity()), Vec3D.ZERO, LevelBasedValue.constant(3.5F), false, World.a.TRIGGER, Particles.GUST_EMITTER_SMALL, Particles.GUST_EMITTER_LARGE, SoundEffects.WIND_CHARGE_BURST), LootItemConditionEntityProperty.hasProperties(LootTableInfo.EntityTarget.DIRECT_ATTACKER, CriterionConditionEntity.a.entity().flags(CriterionConditionEntityFlags.a.flags().setIsFlying(false)).moving(MovementPredicate.fallDistance(CriterionConditionValue.DoubleRange.atLeast(1.5D))))));
        register(bootstrapcontext, Enchantments.MENDING, Enchantment.enchantment(Enchantment.definition(holdergetter2.getOrThrow(TagsItem.DURABILITY_ENCHANTABLE), 2, 1, Enchantment.dynamicCost(25, 25), Enchantment.dynamicCost(75, 25), 4, EquipmentSlotGroup.ANY)).withEffect(EnchantmentEffectComponents.REPAIR_WITH_XP, (Object) (new MultiplyValue(LevelBasedValue.constant(2.0F)))));
        register(bootstrapcontext, Enchantments.VANISHING_CURSE, Enchantment.enchantment(Enchantment.definition(holdergetter2.getOrThrow(TagsItem.VANISHING_ENCHANTABLE), 1, 1, Enchantment.constantCost(25), Enchantment.constantCost(50), 8, EquipmentSlotGroup.ANY)).withEffect(EnchantmentEffectComponents.PREVENT_EQUIPMENT_DROP));
    }

    private static void register(BootstrapContext<Enchantment> bootstrapcontext, ResourceKey<Enchantment> resourcekey, Enchantment.a enchantment_a) {
        bootstrapcontext.register(resourcekey, enchantment_a.build(resourcekey.location()));
    }

    private static ResourceKey<Enchantment> key(String s) {
        return ResourceKey.create(Registries.ENCHANTMENT, MinecraftKey.withDefaultNamespace(s));
    }
}
