package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.function.Function;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.block.piston.BlockPiston;
import net.minecraft.world.level.block.piston.BlockPistonExtension;
import net.minecraft.world.level.block.piston.BlockPistonMoving;

public class BlockTypes {

    public static final MapCodec<Block> CODEC = BuiltInRegistries.BLOCK_TYPE.byNameCodec().dispatchMap(Block::codec, Function.identity());

    public BlockTypes() {}

    public static MapCodec<? extends Block> bootstrap(IRegistry<MapCodec<? extends Block>> iregistry) {
        IRegistry.register(iregistry, "block", Block.CODEC);
        IRegistry.register(iregistry, "air", BlockAir.CODEC);
        IRegistry.register(iregistry, "amethyst", AmethystBlock.CODEC);
        IRegistry.register(iregistry, "amethyst_cluster", AmethystClusterBlock.CODEC);
        IRegistry.register(iregistry, "anvil", BlockAnvil.CODEC);
        IRegistry.register(iregistry, "attached_stem", BlockStemAttached.CODEC);
        IRegistry.register(iregistry, "azalea", AzaleaBlock.CODEC);
        IRegistry.register(iregistry, "bamboo_sapling", BlockBambooSapling.CODEC);
        IRegistry.register(iregistry, "bamboo_stalk", BlockBamboo.CODEC);
        IRegistry.register(iregistry, "banner", BlockBanner.CODEC);
        IRegistry.register(iregistry, "barrel", BlockBarrel.CODEC);
        IRegistry.register(iregistry, "barrier", BlockBarrier.CODEC);
        IRegistry.register(iregistry, "base_coral_fan", BlockCoralFanAbstract.CODEC);
        IRegistry.register(iregistry, "base_coral_plant", BlockCoralDead.CODEC);
        IRegistry.register(iregistry, "base_coral_wall_fan", BlockCoralFanWallAbstract.CODEC);
        IRegistry.register(iregistry, "beacon", BlockBeacon.CODEC);
        IRegistry.register(iregistry, "bed", BlockBed.CODEC);
        IRegistry.register(iregistry, "beehive", BlockBeehive.CODEC);
        IRegistry.register(iregistry, "beetroot", BlockBeetroot.CODEC);
        IRegistry.register(iregistry, "bell", BlockBell.CODEC);
        IRegistry.register(iregistry, "big_dripleaf", BigDripleafBlock.CODEC);
        IRegistry.register(iregistry, "big_dripleaf_stem", BigDripleafStemBlock.CODEC);
        IRegistry.register(iregistry, "blast_furnace", BlockBlastFurnace.CODEC);
        IRegistry.register(iregistry, "brewing_stand", BlockBrewingStand.CODEC);
        IRegistry.register(iregistry, "brushable", BrushableBlock.CODEC);
        IRegistry.register(iregistry, "bubble_column", BlockBubbleColumn.CODEC);
        IRegistry.register(iregistry, "budding_amethyst", BuddingAmethystBlock.CODEC);
        IRegistry.register(iregistry, "button", BlockButtonAbstract.CODEC);
        IRegistry.register(iregistry, "cactus", BlockCactus.CODEC);
        IRegistry.register(iregistry, "cake", BlockCake.CODEC);
        IRegistry.register(iregistry, "calibrated_sculk_sensor", CalibratedSculkSensorBlock.CODEC);
        IRegistry.register(iregistry, "campfire", BlockCampfire.CODEC);
        IRegistry.register(iregistry, "candle_cake", CandleCakeBlock.CODEC);
        IRegistry.register(iregistry, "candle", CandleBlock.CODEC);
        IRegistry.register(iregistry, "carpet", CarpetBlock.CODEC);
        IRegistry.register(iregistry, "carrot", BlockCarrots.CODEC);
        IRegistry.register(iregistry, "cartography_table", BlockCartographyTable.CODEC);
        IRegistry.register(iregistry, "carved_pumpkin", EquipableCarvedPumpkinBlock.CODEC);
        IRegistry.register(iregistry, "cauldron", BlockCauldron.CODEC);
        IRegistry.register(iregistry, "cave_vines", CaveVinesBlock.CODEC);
        IRegistry.register(iregistry, "cave_vines_plant", CaveVinesPlantBlock.CODEC);
        IRegistry.register(iregistry, "ceiling_hanging_sign", CeilingHangingSignBlock.CODEC);
        IRegistry.register(iregistry, "chain", BlockChain.CODEC);
        IRegistry.register(iregistry, "cherry_leaves", CherryLeavesBlock.CODEC);
        IRegistry.register(iregistry, "chest", BlockChest.CODEC);
        IRegistry.register(iregistry, "chiseled_book_shelf", ChiseledBookShelfBlock.CODEC);
        IRegistry.register(iregistry, "chorus_flower", BlockChorusFlower.CODEC);
        IRegistry.register(iregistry, "chorus_plant", BlockChorusFruit.CODEC);
        IRegistry.register(iregistry, "cocoa", BlockCocoa.CODEC);
        IRegistry.register(iregistry, "colored_falling", ColoredFallingBlock.CODEC);
        IRegistry.register(iregistry, "command", BlockCommand.CODEC);
        IRegistry.register(iregistry, "comparator", BlockRedstoneComparator.CODEC);
        IRegistry.register(iregistry, "composter", BlockComposter.CODEC);
        IRegistry.register(iregistry, "concrete_powder", BlockConcretePowder.CODEC);
        IRegistry.register(iregistry, "conduit", BlockConduit.CODEC);
        IRegistry.register(iregistry, "copper_bulb_block", CopperBulbBlock.CODEC);
        IRegistry.register(iregistry, "coral", BlockCoral.CODEC);
        IRegistry.register(iregistry, "coral_fan", BlockCoralFan.CODEC);
        IRegistry.register(iregistry, "coral_plant", BlockCoralPlant.CODEC);
        IRegistry.register(iregistry, "coral_wall_fan", BlockCoralFanWall.CODEC);
        IRegistry.register(iregistry, "crafter", CrafterBlock.CODEC);
        IRegistry.register(iregistry, "crafting_table", BlockWorkbench.CODEC);
        IRegistry.register(iregistry, "crop", BlockCrops.CODEC);
        IRegistry.register(iregistry, "crying_obsidian", BlockCryingObsidian.CODEC);
        IRegistry.register(iregistry, "daylight_detector", BlockDaylightDetector.CODEC);
        IRegistry.register(iregistry, "dead_bush", BlockDeadBush.CODEC);
        IRegistry.register(iregistry, "decorated_pot", DecoratedPotBlock.CODEC);
        IRegistry.register(iregistry, "detector_rail", BlockMinecartDetector.CODEC);
        IRegistry.register(iregistry, "dirt_path", BlockGrassPath.CODEC);
        IRegistry.register(iregistry, "dispenser", BlockDispenser.CODEC);
        IRegistry.register(iregistry, "door", BlockDoor.CODEC);
        IRegistry.register(iregistry, "double_plant", BlockTallPlant.CODEC);
        IRegistry.register(iregistry, "dragon_egg", BlockDragonEgg.CODEC);
        IRegistry.register(iregistry, "drop_experience", DropExperienceBlock.CODEC);
        IRegistry.register(iregistry, "dropper", BlockDropper.CODEC);
        IRegistry.register(iregistry, "enchantment_table", BlockEnchantmentTable.CODEC);
        IRegistry.register(iregistry, "ender_chest", BlockEnderChest.CODEC);
        IRegistry.register(iregistry, "end_gateway", BlockEndGateway.CODEC);
        IRegistry.register(iregistry, "end_portal", BlockEnderPortal.CODEC);
        IRegistry.register(iregistry, "end_portal_frame", BlockEnderPortalFrame.CODEC);
        IRegistry.register(iregistry, "end_rod", BlockEndRod.CODEC);
        IRegistry.register(iregistry, "farm", BlockSoil.CODEC);
        IRegistry.register(iregistry, "fence", BlockFence.CODEC);
        IRegistry.register(iregistry, "fence_gate", BlockFenceGate.CODEC);
        IRegistry.register(iregistry, "fire", BlockFire.CODEC);
        IRegistry.register(iregistry, "fletching_table", BlockFletchingTable.CODEC);
        IRegistry.register(iregistry, "flower", BlockFlowers.CODEC);
        IRegistry.register(iregistry, "flower_pot", BlockFlowerPot.CODEC);
        IRegistry.register(iregistry, "frogspawn", FrogspawnBlock.CODEC);
        IRegistry.register(iregistry, "frosted_ice", BlockIceFrost.CODEC);
        IRegistry.register(iregistry, "fungus", BlockFungi.CODEC);
        IRegistry.register(iregistry, "furnace", BlockFurnaceFurace.CODEC);
        IRegistry.register(iregistry, "glazed_terracotta", BlockGlazedTerracotta.CODEC);
        IRegistry.register(iregistry, "glow_lichen", GlowLichenBlock.CODEC);
        IRegistry.register(iregistry, "grass", BlockGrass.CODEC);
        IRegistry.register(iregistry, "grindstone", BlockGrindstone.CODEC);
        IRegistry.register(iregistry, "half_transparent", BlockHalfTransparent.CODEC);
        IRegistry.register(iregistry, "hanging_roots", HangingRootsBlock.CODEC);
        IRegistry.register(iregistry, "hay", BlockHay.CODEC);
        IRegistry.register(iregistry, "heavy_core", HeavyCoreBlock.CODEC);
        IRegistry.register(iregistry, "honey", BlockHoney.CODEC);
        IRegistry.register(iregistry, "hopper", BlockHopper.CODEC);
        IRegistry.register(iregistry, "huge_mushroom", BlockHugeMushroom.CODEC);
        IRegistry.register(iregistry, "ice", BlockIce.CODEC);
        IRegistry.register(iregistry, "infested", BlockMonsterEggs.CODEC);
        IRegistry.register(iregistry, "infested_rotated_pillar", InfestedRotatedPillarBlock.CODEC);
        IRegistry.register(iregistry, "iron_bars", BlockIronBars.CODEC);
        IRegistry.register(iregistry, "jack_o_lantern", BlockPumpkinCarved.CODEC);
        IRegistry.register(iregistry, "jigsaw", BlockJigsaw.CODEC);
        IRegistry.register(iregistry, "jukebox", BlockJukeBox.CODEC);
        IRegistry.register(iregistry, "kelp", BlockKelp.CODEC);
        IRegistry.register(iregistry, "kelp_plant", BlockKelpPlant.CODEC);
        IRegistry.register(iregistry, "ladder", BlockLadder.CODEC);
        IRegistry.register(iregistry, "lantern", BlockLantern.CODEC);
        IRegistry.register(iregistry, "lava_cauldron", LavaCauldronBlock.CODEC);
        IRegistry.register(iregistry, "layered_cauldron", LayeredCauldronBlock.CODEC);
        IRegistry.register(iregistry, "leaves", BlockLeaves.CODEC);
        IRegistry.register(iregistry, "lectern", BlockLectern.CODEC);
        IRegistry.register(iregistry, "lever", BlockLever.CODEC);
        IRegistry.register(iregistry, "light", LightBlock.CODEC);
        IRegistry.register(iregistry, "lightning_rod", LightningRodBlock.CODEC);
        IRegistry.register(iregistry, "liquid", BlockFluids.CODEC);
        IRegistry.register(iregistry, "loom", BlockLoom.CODEC);
        IRegistry.register(iregistry, "magma", BlockMagma.CODEC);
        IRegistry.register(iregistry, "mangrove_leaves", MangroveLeavesBlock.CODEC);
        IRegistry.register(iregistry, "mangrove_propagule", MangrovePropaguleBlock.CODEC);
        IRegistry.register(iregistry, "mangrove_roots", MangroveRootsBlock.CODEC);
        IRegistry.register(iregistry, "moss", MossBlock.CODEC);
        IRegistry.register(iregistry, "moving_piston", BlockPistonMoving.CODEC);
        IRegistry.register(iregistry, "mud", MudBlock.CODEC);
        IRegistry.register(iregistry, "mushroom", BlockMushroom.CODEC);
        IRegistry.register(iregistry, "mycelium", BlockMycel.CODEC);
        IRegistry.register(iregistry, "nether_portal", BlockPortal.CODEC);
        IRegistry.register(iregistry, "netherrack", BlockNetherrack.CODEC);
        IRegistry.register(iregistry, "nether_sprouts", BlockNetherSprouts.CODEC);
        IRegistry.register(iregistry, "nether_wart", BlockNetherWart.CODEC);
        IRegistry.register(iregistry, "note", BlockNote.CODEC);
        IRegistry.register(iregistry, "nylium", BlockNylium.CODEC);
        IRegistry.register(iregistry, "observer", BlockObserver.CODEC);
        IRegistry.register(iregistry, "piglinwallskull", PiglinWallSkullBlock.CODEC);
        IRegistry.register(iregistry, "pink_petals", PinkPetalsBlock.CODEC);
        IRegistry.register(iregistry, "piston_base", BlockPiston.CODEC);
        IRegistry.register(iregistry, "piston_head", BlockPistonExtension.CODEC);
        IRegistry.register(iregistry, "pitcher_crop", PitcherCropBlock.CODEC);
        IRegistry.register(iregistry, "player_head", BlockSkullPlayer.CODEC);
        IRegistry.register(iregistry, "player_wall_head", BlockSkullPlayerWall.CODEC);
        IRegistry.register(iregistry, "pointed_dripstone", PointedDripstoneBlock.CODEC);
        IRegistry.register(iregistry, "potato", BlockPotatoes.CODEC);
        IRegistry.register(iregistry, "powder_snow", PowderSnowBlock.CODEC);
        IRegistry.register(iregistry, "powered", BlockPowered.CODEC);
        IRegistry.register(iregistry, "powered_rail", BlockPoweredRail.CODEC);
        IRegistry.register(iregistry, "pressure_plate", BlockPressurePlateBinary.CODEC);
        IRegistry.register(iregistry, "pumpkin", BlockPumpkin.CODEC);
        IRegistry.register(iregistry, "rail", BlockMinecartTrack.CODEC);
        IRegistry.register(iregistry, "redstone_lamp", BlockRedstoneLamp.CODEC);
        IRegistry.register(iregistry, "redstone_ore", BlockRedstoneOre.CODEC);
        IRegistry.register(iregistry, "redstone_torch", BlockRedstoneTorch.CODEC);
        IRegistry.register(iregistry, "redstone_wall_torch", BlockRedstoneTorchWall.CODEC);
        IRegistry.register(iregistry, "redstone_wire", BlockRedstoneWire.CODEC);
        IRegistry.register(iregistry, "repeater", BlockRepeater.CODEC);
        IRegistry.register(iregistry, "respawn_anchor", BlockRespawnAnchor.CODEC);
        IRegistry.register(iregistry, "rooted_dirt", RootedDirtBlock.CODEC);
        IRegistry.register(iregistry, "roots", BlockRoots.CODEC);
        IRegistry.register(iregistry, "rotated_pillar", BlockRotatable.CODEC);
        IRegistry.register(iregistry, "sapling", BlockSapling.CODEC);
        IRegistry.register(iregistry, "scaffolding", BlockScaffolding.CODEC);
        IRegistry.register(iregistry, "sculk_catalyst", SculkCatalystBlock.CODEC);
        IRegistry.register(iregistry, "sculk", SculkBlock.CODEC);
        IRegistry.register(iregistry, "sculk_sensor", SculkSensorBlock.CODEC);
        IRegistry.register(iregistry, "sculk_shrieker", SculkShriekerBlock.CODEC);
        IRegistry.register(iregistry, "sculk_vein", SculkVeinBlock.CODEC);
        IRegistry.register(iregistry, "seagrass", SeagrassBlock.CODEC);
        IRegistry.register(iregistry, "sea_pickle", BlockSeaPickle.CODEC);
        IRegistry.register(iregistry, "shulker_box", BlockShulkerBox.CODEC);
        IRegistry.register(iregistry, "skull", BlockSkull.CODEC);
        IRegistry.register(iregistry, "slab", BlockStepAbstract.CODEC);
        IRegistry.register(iregistry, "slime", BlockSlime.CODEC);
        IRegistry.register(iregistry, "small_dripleaf", SmallDripleafBlock.CODEC);
        IRegistry.register(iregistry, "smithing_table", BlockSmithingTable.CODEC);
        IRegistry.register(iregistry, "smoker", BlockSmoker.CODEC);
        IRegistry.register(iregistry, "sniffer_egg", SnifferEggBlock.CODEC);
        IRegistry.register(iregistry, "snow_layer", BlockSnow.CODEC);
        IRegistry.register(iregistry, "snowy_dirt", BlockDirtSnow.CODEC);
        IRegistry.register(iregistry, "soul_fire", BlockSoulFire.CODEC);
        IRegistry.register(iregistry, "soul_sand", BlockSlowSand.CODEC);
        IRegistry.register(iregistry, "spawner", BlockMobSpawner.CODEC);
        IRegistry.register(iregistry, "sponge", BlockSponge.CODEC);
        IRegistry.register(iregistry, "spore_blossom", SporeBlossomBlock.CODEC);
        IRegistry.register(iregistry, "stained_glass_pane", BlockStainedGlassPane.CODEC);
        IRegistry.register(iregistry, "stained_glass", BlockStainedGlass.CODEC);
        IRegistry.register(iregistry, "stair", BlockStairs.CODEC);
        IRegistry.register(iregistry, "standing_sign", BlockFloorSign.CODEC);
        IRegistry.register(iregistry, "stem", BlockStem.CODEC);
        IRegistry.register(iregistry, "stonecutter", BlockStonecutter.CODEC);
        IRegistry.register(iregistry, "structure", BlockStructure.CODEC);
        IRegistry.register(iregistry, "structure_void", BlockStructureVoid.CODEC);
        IRegistry.register(iregistry, "sugar_cane", BlockReed.CODEC);
        IRegistry.register(iregistry, "sweet_berry_bush", BlockSweetBerryBush.CODEC);
        IRegistry.register(iregistry, "tall_flower", BlockTallPlantFlower.CODEC);
        IRegistry.register(iregistry, "tall_grass", BlockLongGrass.CODEC);
        IRegistry.register(iregistry, "tall_seagrass", TallSeagrassBlock.CODEC);
        IRegistry.register(iregistry, "target", BlockTarget.CODEC);
        IRegistry.register(iregistry, "tinted_glass", TintedGlassBlock.CODEC);
        IRegistry.register(iregistry, "tnt", BlockTNT.CODEC);
        IRegistry.register(iregistry, "torchflower_crop", TorchflowerCropBlock.CODEC);
        IRegistry.register(iregistry, "torch", BlockTorch.CODEC);
        IRegistry.register(iregistry, "transparent", BlockGlassAbstract.CODEC);
        IRegistry.register(iregistry, "trapdoor", BlockTrapdoor.CODEC);
        IRegistry.register(iregistry, "trapped_chest", BlockChestTrapped.CODEC);
        IRegistry.register(iregistry, "trial_spawner", TrialSpawnerBlock.CODEC);
        IRegistry.register(iregistry, "trip_wire_hook", BlockTripwireHook.CODEC);
        IRegistry.register(iregistry, "tripwire", BlockTripwire.CODEC);
        IRegistry.register(iregistry, "turtle_egg", BlockTurtleEgg.CODEC);
        IRegistry.register(iregistry, "twisting_vines_plant", BlockTwistingVinesPlant.CODEC);
        IRegistry.register(iregistry, "twisting_vines", BlockTwistingVines.CODEC);
        IRegistry.register(iregistry, "vault", VaultBlock.CODEC);
        IRegistry.register(iregistry, "vine", BlockVine.CODEC);
        IRegistry.register(iregistry, "wall_banner", BlockBannerWall.CODEC);
        IRegistry.register(iregistry, "wall_hanging_sign", WallHangingSignBlock.CODEC);
        IRegistry.register(iregistry, "wall_sign", BlockWallSign.CODEC);
        IRegistry.register(iregistry, "wall_skull", BlockSkullWall.CODEC);
        IRegistry.register(iregistry, "wall_torch", BlockTorchWall.CODEC);
        IRegistry.register(iregistry, "wall", BlockCobbleWall.CODEC);
        IRegistry.register(iregistry, "waterlily", BlockWaterLily.CODEC);
        IRegistry.register(iregistry, "waterlogged_transparent", WaterloggedTransparentBlock.CODEC);
        IRegistry.register(iregistry, "weathering_copper_bulb", WeatheringCopperBulbBlock.CODEC);
        IRegistry.register(iregistry, "weathering_copper_door", WeatheringCopperDoorBlock.CODEC);
        IRegistry.register(iregistry, "weathering_copper_full", WeatheringCopperFullBlock.CODEC);
        IRegistry.register(iregistry, "weathering_copper_grate", WeatheringCopperGrateBlock.CODEC);
        IRegistry.register(iregistry, "weathering_copper_slab", WeatheringCopperSlabBlock.CODEC);
        IRegistry.register(iregistry, "weathering_copper_stair", WeatheringCopperStairBlock.CODEC);
        IRegistry.register(iregistry, "weathering_copper_trap_door", WeatheringCopperTrapDoorBlock.CODEC);
        IRegistry.register(iregistry, "web", BlockWeb.CODEC);
        IRegistry.register(iregistry, "weeping_vines_plant", BlockWeepingVinesPlant.CODEC);
        IRegistry.register(iregistry, "weeping_vines", BlockWeepingVines.CODEC);
        IRegistry.register(iregistry, "weighted_pressure_plate", BlockPressurePlateWeighted.CODEC);
        IRegistry.register(iregistry, "wet_sponge", BlockWetSponge.CODEC);
        IRegistry.register(iregistry, "wither_rose", BlockWitherRose.CODEC);
        IRegistry.register(iregistry, "wither_skull", BlockWitherSkull.CODEC);
        IRegistry.register(iregistry, "wither_wall_skull", BlockWitherSkullWall.CODEC);
        return (MapCodec) IRegistry.register(iregistry, "wool_carpet", BlockCarpet.CODEC);
    }
}
